### 19 Feb 2017 I'm removing the DCC EOR-1 b/c it is not a trusted data source


# this program takes the files generated by:
# /Users/acd13/Desktop/ATAC/Analysis/nucleosomeCalls/nucDiffSignalInTF100bpSummits.sh
# and generates rough plots
# it will be worthwhile to come back and make these prettier

#=========================================================================================
# set up functions
#=========================================================================================
# I'll use some functions from a previous program 
source('/Users/acd13/Desktop/ATAC/Analysis/tfs/plottingAtacInsertSizesAndEnrichmentInTfPeaks_supportFunctions.R')

#=========================================================================================
# Begin processing
#=========================================================================================
# parameter setting
stageOfInterest <- 'L3'

args <- commandArgs(trailingOnly = TRUE)
stageOfInterest = args[1]
#toAvoidZero <- 0.1 # gets added to values before dividing, to avoid infinities in Log2

allSamples <- allStages

setwd(paste0("/Users/acd13/Desktop/ATAC/Analysis/nucleosomeCalls/nucleosomeSignalInTFPeaks/", stageOfInterest, "TF100bpSummits/EEL3_H3DiffSignal"))

allStageSignalListFile <- "perTFSummitAllStageH3NucSignal.list.rds"
allStageSummitPortionListFile <- "perTFSummitAllStagePotionSummitsWithH3NucSignal.list.rds"

if(file.exists(allStageSignalListFile)){
  print("Using pre-saved data")
  allStageSignalList <- readRDS(allStageSignalListFile)
}else{
  print("Loading and processing data")
  
  nucleosomeSignalDataList <- list()
  
  print("Loading nucleosome signal data for EEL3_H3DiffSignal...")
  allFiles <- list.files(pattern = "*.narrowPeak")
  ### See 19 Feb 2017 note above
  allFiles <- allFiles[-1*grep("DCC3160_EOR-1", allFiles, fixed=T)]
  allNames <- unlist(lapply(strsplit(allFiles, ".narrowPeak"), `[[`, 1))
  justNames <- unlist(lapply(strsplit(allNames, "_"), `[[`, 2))
  for (j in 1:length(allFiles)){
    allData <- read.table(allFiles[j], header=FALSE, sep="\t", stringsAsFactors=FALSE, na.strings=".")
    nucleosomeSignalDataList[[j]] <- allData[,ncol(allData)]
  }
  names(nucleosomeSignalDataList) <- allNames
  print("plotting basic data")
  pdf(paste0("EEL3_H3DiffSignal_In", stageOfInterest, "TFSummits_boxplots.pdf"), width=length(nucleosomeSignalDataList)/3)
    boxplot(nucleosomeSignalDataList
            , notch = T
            , outline = T
            , ylab="EEL3_H3DiffSignal"
            , xlab=paste0(stageOfInterest, "TFSummits")
           )
  boxplot(nucleosomeSignalDataList
        , notch = T
        , outline = F
        , ylab="EEL3_H3DiffSignal"
        , xlab=paste0(stageOfInterest, "TFSummits")
       )
  dev.off()
  
  print("Saving data...")
  # now that we have everything we want, let's save things
  saveRDS(nucleosomeSignalDataList, file = allStageSignalListFile)  

}

#pdf(paste0("EEL3_H3DiffSignal_In", stageOfInterest, "TFSummits_boxplots.pdf"), width=length(nucleosomeSignalDataList)/3)
pdf(paste0("~/Dropbox/EEL3_H3DiffSignal_In", stageOfInterest, "TFSummits_boxplots.pdf"), width=length(nucleosomeSignalDataList)/5.5, height=4.5)

par(mar = c(7, 4, 4, 2) + 0.1)
  plotOrder <- rev(order( 
                    unlist(lapply(nucleosomeSignalDataList, function(x){median(unlist(x))})), 
                    unlist(lapply(nucleosomeSignalDataList, function(x){quantile(unlist(x), 0.75)}))
                    ))
  boxplot(nucleosomeSignalDataList[plotOrder]
          , notch = T
          , outline = F
          , ylab="Change in H3 nucleosome occupancy:\nEarly embryo - Larval stage 3 (a.u.)"
          , xaxt = "n"
          , col='goldenrod2'
          , las = 1
         )
  ## Set up x axis with tick marks alone
  axis(1, at=1:length(nucleosomeSignalDataList), labels = FALSE)
  ## Plot x axis labels at default tick marks
  text(1:length(nucleosomeSignalDataList)
     , par("usr")[3] - 10
     , srt = 45
     , adj = 1
     , labels = justNames[plotOrder]
     , xpd = TRUE
  )
  ## Plot x axis label at line 6 (of 7)
  mtext(1, text = paste0(stageOfInterest, ' TF ChIP-seq Summits'), line = 6)
  # When plotting the x axis labels, we use srt = 45 for text rotation angle, 
  # adj = 1 to place the right end of text at the tick marks, 
  # and xpd = TRUE to allow for text outside the plot region. 
  # You can adjust the value of the 0.25 offset as required to move the 
  # axis labels up or down relative to the x axis

dev.off()

