package iptgxdb.utils;


import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Permission;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;

// General purpose utiliy class by Ulrich Omasits.
public class Utils {
	public final static String nl = System.getProperty("line.separator");
	
	public final static Splitter tabSplitter = Splitter.on('\t');
	public final static Joiner tabJoiner = Joiner.on('\t');
	
	public final static List<Color> colors = Lists.newArrayList(
			new Color(0,0,0), 		// black
			new Color(230,159,0),	// orange
			new Color(86,180,233),	// skyblue
			new Color(0,158,115),	// bluish green
			new Color(240,228,66),	// yellow
			new Color(0,114,178),	// blue
			new Color(213,94,0),	// vermillion
			new Color(204,121,167)	// reddish purple
	); 
	
	public static List<String> tabSplit2List(CharSequence line) {
		return Lists.newArrayList(tabSplitter.split(line));
	}
	
	public static List<String> split2List(CharSequence line, char separator) {
		return Lists.newArrayList(Splitter.on(separator).split(line));
	}
	
	public static String[] tabSplit2Array(CharSequence line) {
		return Iterables.toArray(tabSplitter.split(line), String.class);
	}
	
	public static String[] split2Array(CharSequence line, char separator) {
		return Iterables.toArray(Splitter.on(separator).split(line), String.class);
	}
	
	public static String tabJoin(Object... values) {
		return tabJoiner.join(values);
	}
	
	public static String substringAfter(String string, String pre) {
		int begin = string.indexOf(pre)+pre.length();
		return string.substring(begin);
	}
	public static String substringBetween(String string, String pre, String post) {
		int begin = string.indexOf(pre)+pre.length();
		int end = string.indexOf(post,begin);
		return string.substring(begin, end);
	}
	public static String getXMLattribute(String string, String attribute) {
		int begin;
		if ((begin = string.indexOf(attribute+"=\"")) != -1)
			return string.substring(begin+attribute.length()+2, string.indexOf("\"",begin+attribute.length()+2));
		else if ((begin = string.indexOf(attribute+"='")) != -1)
			return string.substring(begin+attribute.length()+2, string.indexOf("'",begin+attribute.length()+2));
		else if ((begin = string.indexOf(attribute+" = \"")) != -1)
			return string.substring(begin+attribute.length()+4, string.indexOf("\"",begin+attribute.length()+4));
		else if ((begin = string.indexOf(attribute+" = '")) != -1)
			return string.substring(begin+attribute.length()+4, string.indexOf("'",begin+attribute.length()+4));
		else if ((begin = string.indexOf(attribute+" =\"")) != -1)
			return string.substring(begin+attribute.length()+3, string.indexOf("\"",begin+attribute.length()+3));
		else if ((begin = string.indexOf(attribute+" ='")) != -1)
			return string.substring(begin+attribute.length()+3, string.indexOf("'",begin+attribute.length()+3));
		else if ((begin = string.indexOf(attribute+"= \"")) != -1)
			return string.substring(begin+attribute.length()+3, string.indexOf("\"",begin+attribute.length()+3));
		else if ((begin = string.indexOf(attribute+"= '")) != -1)
			return string.substring(begin+attribute.length()+3, string.indexOf("'",begin+attribute.length()+3));
		else
			return null;
	}
	
	public static String replaceXMLattribute(String string, String attribute, String value) throws Exception {
		int begin;
		int end;
		if ((begin = string.indexOf(attribute+"=\"")) != -1) {
			begin = begin+attribute.length()+2;
			end = string.indexOf("\"",begin);
		} else if ((begin = string.indexOf(attribute+"='")) != -1) {
			begin = begin+attribute.length()+2;
			end = string.indexOf("'",begin);
		} else if ((begin = string.indexOf(attribute+" = \"")) != -1) {
			begin = begin+attribute.length()+4;
			end = string.indexOf("\"",begin);
		} else if ((begin = string.indexOf(attribute+" = '")) != -1) {
			begin = begin+attribute.length()+4;
			end = string.indexOf("'",begin);
		} else if ((begin = string.indexOf(attribute+" =\"")) != -1) {
			begin = begin+attribute.length()+3;
			end = string.indexOf("\"",begin);
		} else if ((begin = string.indexOf(attribute+" ='")) != -1) {
			begin = begin+attribute.length()+3;
			end = string.indexOf("'",begin);
		} else if ((begin = string.indexOf(attribute+"= \"")) != -1) {
			begin = begin+attribute.length()+3;
			end = string.indexOf("\"",begin);
		} else if ((begin = string.indexOf(attribute+"= '")) != -1) {
			begin = begin+attribute.length()+3;
			end = string.indexOf("'",begin);
		} else {
			throw new Exception("xml attribute '"+attribute+"' not found in '"+string+"'");
		}
		return string.substring(0,begin) + value + string.substring(end);
	}
	
	public static String path2filename(String path) {
		if (path.lastIndexOf('/')!=-1) 
			return path.substring(path.lastIndexOf('/')+1);
		else if (path.lastIndexOf('\\')!=-1) 
			return path.substring(path.lastIndexOf('\\')+1);
		else
			return path;
	}
	
	public static String[] splitString(String str, String delim) {
		int strLen = str.length();
		int delimLen = delim.length();
		String[] result = new String[strLen+1]; // define result array with maximum possible size#
		int offset=0;
		int token=0;
		
		while (offset<=strLen) {
			int end = str.indexOf(delim, offset);
			if (end<0) end=strLen;
			result[token]=str.substring(offset, end);
			token++;
			offset = end+delimLen;
		}
		return Arrays.copyOf(result, token);
	}
	
	public static <E> String join(Iterable<E> iterable, String separator) {
		if (iterable == null) return null;
		Iterator<E> iterator = iterable.iterator();
		StringBuffer buf = new StringBuffer(256);
		while (iterator.hasNext()) {
			E elem = iterator.next();
			if (elem != null)
				buf.append(elem);
			if (iterator.hasNext())
				buf.append(separator);
		}
		return buf.toString();
	}
	
	public static <E> String join(String separator, E[] elements) {
		if (elements==null) return null;
		StringBuffer buf = new StringBuffer(256);
		for (int i=0; i<elements.length; i++) {
			if (elements[i]!=null)
				buf.append(elements[i]);
			if (i+1<elements.length)
				buf.append(separator);
		}
		return buf.toString();
	}
	
	public static int max(int... values) {
		if (values.length == 0)
			throw new IllegalArgumentException("No values supplied.");
		int max = Integer.MIN_VALUE;
		for (int i : values) {
			if (i > max)
				max = i;
		}
		return max;
	}
	
	// count occurrence of a specific char in a given string 
	public static int countChar(CharSequence haystack, char needle) {
		int count = 0;
		for (int i=0; i < haystack.length(); i++)
			if (haystack.charAt(i) == needle) count++;
	    return count;
	}
	
	public static enum OS {
		WINDOWS, LINUX, MACOSX;
		public static OS getOS() {
			String osName = System.getProperty("os.name");
			if (osName.startsWith("Windows"))
				return WINDOWS;
			else if (osName.equals("Mac OS X"))
				return MACOSX;
			return LINUX;
		}
	}
	
	public static BufferedReader reader(File file) throws FileNotFoundException, IOException {
		if (file.getName().endsWith(".gz") || file.getName().endsWith(".tgz"))
			return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
		else
			return new BufferedReader(new FileReader(file));
	}
	public static BufferedReader reader(String file) throws FileNotFoundException, IOException {
		return reader(new File(file));
	}
	
	// a static regExp matcher and a matching function
	public static Matcher rxMatcher;
	public static boolean rx(CharSequence string, String regex) {
		rxMatcher = Pattern.compile(regex).matcher(string);
		return rxMatcher.find();
	}
	public static boolean rxMatch(CharSequence string, String regex) {
		rxMatcher = Pattern.compile(regex).matcher(string);
		return rxMatcher.matches();
	}
	
	// join several collections (iterables) columnwise
	public static <E extends Object,C extends Iterable<E>> String joinToColumns(Collection<C> iterables, String separator, String nullValue) {
		StringBuilder out = new StringBuilder();
		
		List<Iterator<E>> iterators = new ArrayList<Iterator<E>>();
		for (C iterable : iterables)
			iterators.add(iterable.iterator());
		
		boolean hasNextRow;
		do {
			hasNextRow = false;
			for (Iterator<Iterator<E>> ii = iterators.iterator(); ii.hasNext(); ) {
				Iterator<E> iterator = ii.next();
				if (iterator.hasNext()) {
					E element = iterator.next();
					if (element==null)
						out.append(nullValue);
					else
						out.append(element.toString());
					if (iterator.hasNext())
						hasNextRow = true;
				}
				if (ii.hasNext())
					out.append(separator);
			}
			out.append(nl);
		} while (hasNextRow==true);
		
		return out.toString();
	}
	
	public static List<String> stringList(String nullValue, Object... objects) {
		List<String> lst = new ArrayList<String>();
		for (Object o : objects) {
			if (o==null)
				lst.add(nullValue);
			else
				lst.add(o.toString());
		}
		return lst;
	}
	
	public static <E> List<E> concatList(Collection<E>... collections) {
		List<E> l = new ArrayList<E>();
		for (Collection<E> c : collections)
			l.addAll(c);
		return l;
	}
	
	public static String formatValAndPercent(Number part, Number total) {
		String percent = formatPercent(part, total);
		if (percent==null) 
			return null;
		else
			return part + " (" + percent + ")";
	}
	
	public static String formatPercent(Number part, Number total) {
		if (part==null || total==null)
			return null;
		else if (total.doubleValue()==0)
			return null; //part.toString();
		else
			return new DecimalFormat("#.##").format(part.doubleValue()/total.doubleValue() * 100.0) + "%";
	}
	
	public static String format(Double number, String decimalFormat) {
		if (number==null) return null;
		return new DecimalFormat(decimalFormat).format(number);
	}
	
	public static <T> Set<T> uniqueSet(T... t) {
		return uniqueSet(Arrays.asList(t));
	}
	
	public static <T> Set<T> uniqueSet(Collection<T> c) {
		return new HashSet<T>(c);
	}
	
	public static <K, V> CharSequence joinMap(Map<K,V> map, String sepKeyValue, String sepEntries) {
		StringBuilder sb = new StringBuilder();
		for (Entry<K,V> e : map.entrySet()) {
			if (sb.length()>0)
				sb.append(sepEntries);
			sb.append(e.getKey().toString());
			sb.append(sepKeyValue);
			sb.append(e.getValue()==null ? "" : e.getValue().toString());
		}
		return sb;
	}
	
	public static <K,V> ListMultimap<K,V> invertMapUsingLists(Map<V,K> map) {
		ListMultimap<K,V> mm = ArrayListMultimap.create();
	    return Multimaps.invertFrom(Multimaps.forMap(map), mm);
	}
	
	public static <K,V> SetMultimap<K,V> invertMapUsingSets(Map<V,K> map) {
		SetMultimap<K,V> mm = HashMultimap.create();
	    return Multimaps.invertFrom(Multimaps.forMap(map), mm);
	}
	
	public static String substringUpTo(String str, String separator) {
		return StringUtils.substringBefore(str, separator);
	}
	
	public static String substringUpTo(String str, CharMatcher matcher) {
		int i = matcher.indexIn(Preconditions.checkNotNull(str));
		if (i<0)
			return str;
		else
			return str.substring(0, i);
	}
	
	public static String[] splitToArray(String str, Splitter splitter) {
		Preconditions.checkNotNull(str);
		Preconditions.checkNotNull(splitter);
		return Iterables.toArray(splitter.split(str), String.class);
	}
	
	public static Map<Integer, String> getStringMatches(String target, String pattern, int maxMismatch) {
		Map<Integer, String> result = new HashMap<Integer, String>();
		for (int i = 0; i <= target.length()-pattern.length(); i++) {
			int j = 0;
			int h = i;
			int count = 0;
			int n = pattern.length();
			while (true) {
				int lce = longestCommonExtension(pattern, j, target, h);
				if (j + 1 + lce == n + 1) {
				    result.put(i, target.substring(i, i + n));
				    break;
				} else if (count < maxMismatch) {
				    count++;
				    j = j + lce + 1;
				    h = h + lce + 1;
				} else if (count == maxMismatch) {
				    break;
				}
			}
		}
		return result;
	}

	public static int longestCommonExtension(String t1, int i1, String t2, int i2) {
		int res = 0;
		for (int i = i1; i < t1.length() && i2 < t2.length(); i++, i2++) {
			if (t1.charAt(i) == t2.charAt(i2))
				res++;
			else
				return res;
		}
		return res;
	}
	
	public static Function<String,String> funcUrlEncode = new Function<String,String>() {
		public String apply(String in) {
			try {
				return URLEncoder.encode(in, "UTF-8");
			} catch (UnsupportedEncodingException e) {
				return null;
			}
		}
	};
	
	public static InputStream post(URL url, Map<String,String> args) throws Exception {
		// set up the connection
		HttpURLConnection con = (HttpURLConnection) url.openConnection();
		con.setDoInput(true);
		con.setDoOutput(true);
		con.setUseCaches(false);
		con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
		con.setRequestMethod("POST");
		
		// prepare arguments
		Map<String,String> argsEncoded = Maps.transformValues(args, funcUrlEncode);
		String data = Joiner.on('&').withKeyValueSeparator("=").join(argsEncoded);
		
		DataOutputStream send = new DataOutputStream(con.getOutputStream());
	    send.writeBytes(data);
	    send.flush();
	    send.close();
	    
	    // return response stream, or (redirected) URL on error 
	    try {
	    	return con.getInputStream();
	    } catch (IOException e) {
	    	e.printStackTrace();
	    	throw new Exception(con.getURL().toString());
	    }
	}
	
	public static InputStream postMultipartData(URL url, Map<String,String> dataMap) throws Exception {
		return postMultipartData(url, dataMap, null);
	}
	public static InputStream postMultipartData(URL url, Map<String,String> dataMap, Map<String,String> fileMap) throws Exception {
		// TODO: warning! overriding default newline character here, unix newlines did not work with chemgenome...
		String nl = "\r\n";
		
		String boundary = "---------------------------41184676334";
		// set up the connection
		HttpURLConnection con = (HttpURLConnection) url.openConnection();
		con.setDoInput(true);
		con.setDoOutput(true);
		con.setUseCaches(false);
		con.setRequestProperty("Content-Type", "multipart/form-data; boundary="+boundary);
		con.setRequestMethod("POST");
		
		// prepare arguments
		StringBuilder data = new StringBuilder();
		for (Entry<String, String> e : dataMap.entrySet()) {
			data.append("--").append(boundary).append(nl);
			data.append("Content-Disposition: form-data; name=\"").append(e.getKey()).append("\"").append(nl);
			data.append(nl);
			data.append(e.getValue());
			data.append(nl);
		}
		if (fileMap != null) {
			for (Entry<String, String> e : fileMap.entrySet()) {
				data.append("--").append(boundary).append(nl);
				data.append("Content-Disposition: form-data; name=\"").append(e.getKey()).append("\"; filename=\"").append(UUID.randomUUID().toString()).append("\"").append(nl);
				data.append(nl);
				data.append(e.getValue());
				data.append(nl);
			}
		}
		data.append("--").append(boundary).append("--").append(nl); // final boundary
		con.setRequestProperty("Content-Length", ""+data.length());
		
		DataOutputStream send = new DataOutputStream(con.getOutputStream());
	    send.writeBytes(data.toString());
	    send.flush();
	    send.close();
	    
	    // return response stream, or (redirected) URL on error 
	    try {
	    	return con.getInputStream();
	    } catch (IOException e) {
	    	throw new Exception(con.getURL().toString());
	    }
	}
	
	public static String readStreamAtOnce(InputStream is) throws IOException {
		BufferedReader in = new BufferedReader(new InputStreamReader(is));
		StringBuilder result = new StringBuilder();
		String line;
		while ((line = in.readLine()) != null) {
			result.append(line).append(Utils.nl);
		}
		in.close();
		return result.toString();
	}
	public static String readFileAtOnce(File file) throws IOException {
		return readStreamAtOnce(new FileInputStream(file));
	}
	public static String readFileAtOnce(String path) throws IOException {
		return readFileAtOnce(new File(path));
	}
	
	public static List<String> readStreamToList(InputStream is) throws IOException {
		BufferedReader in = new BufferedReader(new InputStreamReader(is));
		List<String> lines = new ArrayList<String>();
		String line;
		while ((line = in.readLine()) != null) {
			lines.add(line);
		}
		in.close();
		return lines;
	}
	public static List<String> readFileToList(File file) throws IOException {
		return readStreamToList(new FileInputStream(file));
	}
	public static List<String> readFileToList(String path) throws IOException {
		return readFileToList(new File(path));
	}
	
	public static Map<String,String> readStreamToMap(InputStream is, Splitter s) throws IOException {
		BufferedReader in = new BufferedReader(new InputStreamReader(is));
		Map<String,String> m = new LinkedHashMap<String, String>();
		String line;
		while ((line = in.readLine()) != null) {
			List<String> elems = Lists.newArrayList(s.split(line));
			m.put(elems.get(0), elems.get(1));
		}
		in.close();
		return m;
	}
	public static Map<String,String> readFileToMap(File file, Splitter s) throws IOException {
		return readStreamToMap(new FileInputStream(file), s);
	}
	public static Map<String,String> readFileToMap(String path, Splitter s) throws IOException {
		return readFileToMap(new File(path), s);
	}
	
	public static BufferedReader readUrl(String strUrl) throws MalformedURLException, IOException {
		if (strUrl.endsWith(".gz"))
			return new BufferedReader(new InputStreamReader(new GZIPInputStream(new URL(strUrl).openStream())));
		else
			return new BufferedReader(new InputStreamReader(new URL(strUrl).openStream()));
	}
	
	// convert an integer to a string always including + or - sign
	public static String signedString(int i) {
		return (i<0) ? (String.valueOf(i)) : ("+" + String.valueOf(i));
	}
	
	// randomly select a subset
	public static <E> Set<E> sample(List<E> l, int size) {
		Set<E> subset = new HashSet<E>(size);
		while (subset.size() < size) {
			//subset.add(l.get(Math.random() .random()))
		}
		return subset;
	}
	
	public static int randomInt (int min, int max) {
		if (max==min) return min;
		Preconditions.checkArgument( max > min );
		return (int) Math.floor(min + Math.random()*(max-min+1));
	}
	public static int randomInt (int max) {
		return randomInt(0, max);
	}
	public static int randomIndex (int size) {
		return randomInt(0, size-1);
	}
	
	public static class TarReader {
		LineProcessor lineProcessor;
		Splitter splitter = Splitter.on('\u0000').omitEmptyStrings();
		int newfileEntries;
		
		public static void read(File tarFile, LineProcessor lineProcessor) throws Exception {
			new TarReader(lineProcessor).process(tarFile);
		}
		protected TarReader(LineProcessor lineProcessor) {
			this.lineProcessor = lineProcessor;
		}
		protected void process(File tarFile) throws Exception {
			
			//TODO:
			/// file header always 512 bytes, first filename
			/// the file contents up to next NUL
			
			BufferedReader in = Utils.reader(tarFile);
			String line;
			String currentFile = null;
			String previousFile = null;
			while((line = in.readLine()) != null) {
				if (currentFile == null) { // first line: fileName NUL NUL NUL NUL firstLine LF
					LinkedList<String> elems = Lists.newLinkedList(splitter.split(line));
					System.out.println(elems);
					if (elems.size()>8 && elems.get(8).trim().equals("ustar"))
						newfileEntries = 10; // unix mode
					else
						newfileEntries = 5; // windows mode
					
					currentFile = elems.getFirst();
					if (currentFile.endsWith("/")) {
						System.err.println("file is within a subfolder");
						//currentFile = elems.get(elems.size()/2); // file is within a subfolder...
					}
					if (line.lastIndexOf(0) == line.length()-1)
						lineProcessor.processLine("", currentFile, previousFile, true, false); // empty first line
					else
						lineProcessor.processLine(elems.getLast(), currentFile, previousFile, true, false);
					
				} else if (line.indexOf(0) >= 0) { // between files: lastLine NUL NUL NUL newFileName NUL NUL NUL firstLine LF
					LinkedList<String> elems = Lists.newLinkedList(splitter.split(line));
					System.out.println(elems);
					if (line.indexOf(0) == 0) // empty last line 
						lineProcessor.processLine("", currentFile, previousFile, false, true);
					else // non-empty last line
						lineProcessor.processLine(elems.removeFirst(), currentFile, previousFile, false, true);
					
					
					if (elems.size()>1) { // start next file...
						currentFile = elems.getFirst();
						if (line.lastIndexOf(0) == line.length()-1)
							lineProcessor.processLine("", currentFile, previousFile, true, false); // empty first line
						else
							lineProcessor.processLine(elems.getLast(), currentFile, previousFile, true, false);
					}
				} else {
					lineProcessor.processLine(line, currentFile, previousFile, false, false);
				}
				previousFile = currentFile;
			}
			//lineProcessor.processLine(null, null, previousFile, false);
			in.close();
		}
		
		public interface LineProcessor {
			public void processLine(String line, String file, String previousFile, boolean isFilesFirstLine, boolean isFilesLastLine) throws Exception;
		}
	}
	
	public static String longestCommonSubstring(String s1, String s2) {
		int start = 0;
		int max = 0;
		for (int i = 0; i < s1.length(); i++) {
			for (int j = 0; j < s2.length(); j++) {
				int x = 0;
				while (s1.charAt(i + x) == s2.charAt(j + x)) {
					x++;
					if (((i + x) >= s1.length()) || ((j + x) >= s2.length())) break;
				}
				if (x > max) {
					max = x;
					start = i;
				}
			}
		}
		return s1.substring(start, (start + max));
	}
	
	public static Multimap<String,String> longestComnmonSubstrings(String[] strings) {
		Multimap<String,String> m = HashMultimap.create();
		for (String s : strings) {
			m.put(s,s);
		}
		for (String s : strings) {
			for (String key : m.keySet()) {
				String lcs = Utils.longestCommonSubstring(s, key);
				if (lcs.length()>0) {
					List<String> hits = new ArrayList<String>(m.get(key));
					hits.addAll(m.get(s));
					m.removeAll(s);
					m.removeAll(key);
					m.putAll(lcs, hits);
					break;
				}
			}
		}
		return m;
	}
	
	public static Multimap<String,String> shortestSubstrings(String[] strings) {
		Multimap<String,String> m = HashMultimap.create();
		for (String s : strings) {
			m.put(s,s);
		}
		for (String s : strings) {
			for (String key : m.keySet()) {
				if (key.equals(s)) continue;
				if (s.indexOf(key) >= 0 || key.indexOf(s) >= 0) {
					m.putAll(key, m.get(s));
					m.removeAll(s);
					break;
				}
			}
		}
		return m;
	}
	
	public static SecurityManager exitTrappingSecurityManager = new SecurityManager() {
		@Override
		public void checkExit(int status) {
			throw( new ExitTrappedException("Program tried to exit but is not allowed!", status) );
		}
		@Override
		public void checkPermission(Permission perm) {
			// allow everything else
		}
	};
	public static class ExitTrappedException extends SecurityException {
		private static final long serialVersionUID = 7194185325210102452L;
		int exitCode;
		public ExitTrappedException(String s, int exitCode) {
			super(s);
			this.exitCode = exitCode;
		}
		public int getExitCode() {
			return exitCode;
		}
	}
	
	
	public static File fileDialogOpen(String title, String defaultFileName) {
		return fileDialog(title, defaultFileName, FileDialog.LOAD);
	}
	public static File fileDialogSave(String title, String defaultFileName) {
		return fileDialog(title, defaultFileName, FileDialog.SAVE);
	}
	protected static File fileDialog(String title, String defaultFileName, int flags) {
		FileDialog dialog = new FileDialog(new Frame(), title, flags);
		dialog.setFile(defaultFileName);
		dialog.setVisible(true);
		if (dialog.getFile() == null)
			return null;
		else
			return new File(dialog.getDirectory() + dialog.getFile());
	}
	public static File[] fileDialogOpenMulti(String title, String defaultFileName) {
		FileDialog dialog = new FileDialog(new Frame(), title, FileDialog.LOAD);
		dialog.setMultipleMode(true);
		dialog.setFile(defaultFileName);
		dialog.setVisible(true);
		return dialog.getFiles();
	}
	
	
	public static String toJSON(Map<String,Object> m) {
		return "{" + Joiner.on(',').join( Iterables.transform( m.entrySet() , new Function<Entry<String,Object>, String> () {
			@Override
			public String apply(Entry<String,Object> arg) {
				return "\""
						+ arg.getKey().replace('\"','\'').replace('\\','/')
						+ "\":\""
						+ arg.getValue().toString().replace('\"','\'').replace('\\','/')
						+ "\"";
			}
		})) + "}";
	}
	
	public static String jsonObjectArray(Iterable<? extends Object> it) {
		if (it==null)
			return "[]";
		else
			return "["+Joiner.on(",\n").join(it)+"]";
	}
	
	public static <T extends Comparable<T>> Double[] getRanks(Collection<T> c) {
		Double[] ranks = new Double[c.size()];
		int size = 0;
		
		SortedMap<Comparable<T>,List<Integer>> m = new TreeMap<Comparable<T>,List<Integer>>();
		
		Iterator<T> it = c.iterator();
		for(int ind=0; it.hasNext(); ind++) {
			 Comparable<T> value = it.next();
			 if (value != null) {
				 if (!m.containsKey(value))
					 m.put(value, new ArrayList<Integer>());
				 m.get(value).add(ind);
				 size++;
			 }
		}
		
		int rank = size;
		for (List<Integer> indices : m.values() ) {
			for (int ind : indices) {
				ranks[ind] = 1.0 * rank - (indices.size()-1)/2.0;
			}
			rank -= indices.size();
		}
		
		return ranks;
	}
	
	// concatenates a number of lists
	public static <T> List<T> concatLists(List<T>... lists) {
		List<T> concat = new ArrayList<T>();
		for (List<T> list : lists)
			concat.addAll(list);
		return concat;
	}
}
