package iptgxdb.utils;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

import com.google.common.base.Joiner;

/**
 * UOBufferedWriter extends the standard BufferedWriter
 * by a writeLine function.  
 * 
 * @author Ulrich Omasits
 * @date 10.11.2011
 */
public class UOBufferedWriter extends BufferedWriter {
	// the string for a system specific newLine
	private final static String defaultNewLine = System.getProperty("line.separator"); 
	public final String newLine;
	private final static Joiner defaultTabJoiner = Joiner.on('\t').useForNull("");
	public final Joiner tabJoiner;
	
	public final File file;
	public int linesWritten = 0;

	private UOBufferedWriter(Writer out, File file, String newLine, Joiner tabJoiner) {
		super(out);
		this.file = file;
		this.newLine = newLine;
		this.tabJoiner = tabJoiner;
	}
	
	public UOBufferedWriter(Writer out) {
		this(out, null, defaultNewLine, defaultTabJoiner);
	}
	
	public UOBufferedWriter(String file) throws IOException {
		this(new File(file));
	}
	public UOBufferedWriter(String file, String newLine) throws IOException {
		this(new File(file), newLine);
	}
	public UOBufferedWriter(File file) throws IOException {
		//super(new FileWriter(file));
		this(new FileWriter(file), file, defaultNewLine, defaultTabJoiner);
	}
	public UOBufferedWriter(File file, String newLine) throws IOException {
		this(new FileWriter(file), file, newLine, defaultTabJoiner);
	}
	public UOBufferedWriter(File file, Joiner tabJoiner) throws IOException {
		this(new FileWriter(file), file, defaultNewLine, tabJoiner);
	}
	public UOBufferedWriter(File file, String newLine, Joiner tabJoiner) throws IOException {
		this(new FileWriter(file), file, newLine, tabJoiner);
	}
	
	public void writeLine(String str) throws IOException {
		super.write(str);
		super.write(newLine);
		linesWritten++;
	}
	
	public void writeLines(Iterable<?> lines) throws IOException {
		for (Object line : lines)
			writeLine(line.toString());
	}
	
	public void writeTsvLine(Object... values) throws IOException {
		writeLine(tabJoiner.join(values));
	}
	
	public void writeTsvLine(Iterable<?> values) throws IOException {
		writeLine(tabJoiner.join(values));
	}
}
