package iptgxdb.converter;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.GenomeLocation.Strand;
import iptgxdb.utils.Utils;

/**
 * Genoscope2GFF parses a tab-separated tabular text file from Genoscope/MAGE 
 * (https://www.genoscope.cns.fr/agc/microscope/home/index.php)
 * and converts it to a GFF file.
 * 
 * @author Ulrich Omasits
 * @date 11.11.2011
 */
public class Genoscope2GFF extends AConverter {
	@Override
	protected void convert_internal(File inputFile) throws Exception {
		BufferedReader in = Utils.reader(inputFile);
		final List<String> consideredTypes = Arrays.asList("CDS","fCDS"); // Arrays.asList();
		
		// do a quick check on the redundancy of the identifiers (important for differentiating fCDS entries)
		List<String> totalTags = new ArrayList<String>();
		String line = in.readLine(); // skip header line
		while ((line = in.readLine()) != null)
			totalTags.add(line.split("\\t")[0]);
		in.close();
		in = Utils.reader(inputFile);
		
		List<String> tags = new ArrayList<String>();
		line = in.readLine(); // skip header line
		while ((line = in.readLine()) != null) {
			String[] arr = line.split("\\t");
			
			String tag = arr[0];
			tags.add(tag);
			
			String type = arr[1];
			
			if (consideredTypes.contains(type) || consideredTypes.size()==0) {
			
				int start = Integer.valueOf(arr[3]);
				int end = Integer.valueOf(arr[4]);
				Strand strand = (arr[2].startsWith("-")) ? Strand.MINUS : Strand.PLUS; 
				GenomeLocation loc = new GenomeLocation(start, end, strand, null);
				
				boolean pseudo = arr[7].equals("pseudo");
				
				GenomeFeature gff = new GenomeFeature(seqId, source, type, loc, tag, pseudo);
				if (Collections.frequency(totalTags, tag) > 1)
					gff.setAtt("idRedundancy", Collections.frequency(tags, tag) + "of" + Collections.frequency(totalTags, tag));
				addGenomeFeature(gff);
			}
		}
		in.close();
	}
	
	@Override
	protected Color getColor() {
		return Color.GREEN;
	}
}
