package iptgxdb.converter;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;

import org.apache.commons.lang3.StringUtils;

import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.Utils;

/**
 * ChemGenome2GFF parses a plain-text result file from ChemGenome 
 * (http://www.scfbio-iitd.res.in/chemgenome/chemgenomenew.jsp)
 * and converts it to a GFF file.
 * 
 * @author Ulrich Omasits
 * @date 16.11.2011
 */
public class ChemGenome2GFF extends AConverter {
	@Override
	protected void convert_internal(File inputFile) throws Exception {
		BufferedReader in = Utils.reader(inputFile);
		String line;
		String currSeqId = (seqId!=null) ? seqId : StringUtils.substringBeforeLast(inputFile.getName(), "."); 
		while ((line = in.readLine()) != null) {
			if (line.equals("> -strand gene; start: 0 , end: 0")) {
				// empty entry, ignored...
			} else if (line.startsWith(">")) {
				if (Utils.rx(line, "> ([+-])strand (\\w+); start: (\\d+) , end: (\\d+)")) {
					String type = Utils.rxMatcher.group(2);	
					GenomeLocation loc = new GenomeLocation(Integer.valueOf(Utils.rxMatcher.group(3)), Integer.valueOf(Utils.rxMatcher.group(4)), currSeqId);
					addGenomeFeature(new GenomeFeature(currSeqId, source, type, loc, loc.toString(), false));
				} else
					System.err.println("WARN: ignored non matching header line: " + line);
			}
		}
		in.close();
	}

	@Override
	protected Color getColor() {
		return Color.YELLOW;
	}
}
