package iptgxdb.converter;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;

import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.Utils;

/**
 * CMR2GFF parses a tab-separated tabular text file from CMR
 * (http://cmr.jcvi.org/tigr-scripts/CMR/CmrHomePage.cgi)
 * and converts it to a GFF file.
 * 
 * @author Ulrich Omasits
 * @date 10.11.2011
 */
public class CMR2GFF extends AConverter {
	@Override
	protected void convert_internal(File inputFile) throws Exception {
		BufferedReader in = Utils.reader(inputFile);
		String line = in.readLine(); // skip header line
		while ((line = in.readLine()) != null) {
			String[] arr = line.split("\\t");
			String tag = arr[0];
			int start = Integer.valueOf(arr[4]);
			int end = Integer.valueOf(arr[5]);
			GenomeLocation loc = new GenomeLocation(start, end, null);
			
			addGenomeFeature(new GenomeFeature(seqId, source, "CDS", loc, tag, false));
		}
		in.close();
	}
	
	@Override
	protected Color getColor() {
		return Color.RED;
	}
}
