/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Permission;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static final String nl = System.getProperty("line.separator");
    public static final Splitter tabSplitter = Splitter.on((char)'\t');
    public static final Joiner tabJoiner = Joiner.on((char)'\t');
    public static final List<Color> colors = Lists.newArrayList((Object[])new Color[]{new Color(0, 0, 0), new Color(230, 159, 0), new Color(86, 180, 233), new Color(0, 158, 115), new Color(240, 228, 66), new Color(0, 114, 178), new Color(213, 94, 0), new Color(204, 121, 167)});
    public static Matcher rxMatcher;
    public static Function<String, String> funcUrlEncode;
    public static SecurityManager exitTrappingSecurityManager;

    static {
        funcUrlEncode = new Function<String, String>(){

            public String apply(String in) {
                try {
                    return URLEncoder.encode(in, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
        };
        exitTrappingSecurityManager = new SecurityManager(){

            @Override
            public void checkExit(int status) {
                throw new ExitTrappedException("Program tried to exit but is not allowed!", status);
            }

            @Override
            public void checkPermission(Permission perm) {
            }
        };
    }

    public static List<String> tabSplit2List(CharSequence line) {
        return Lists.newArrayList((Iterable)tabSplitter.split(line));
    }

    public static List<String> split2List(CharSequence line, char separator) {
        return Lists.newArrayList((Iterable)Splitter.on((char)separator).split(line));
    }

    public static String[] tabSplit2Array(CharSequence line) {
        return (String[])Iterables.toArray((Iterable)tabSplitter.split(line), String.class);
    }

    public static String[] split2Array(CharSequence line, char separator) {
        return (String[])Iterables.toArray((Iterable)Splitter.on((char)separator).split(line), String.class);
    }

    public static String tabJoin(Object ... values) {
        return tabJoiner.join(values);
    }

    public static String substringAfter(String string, String pre) {
        int begin = string.indexOf(pre) + pre.length();
        return string.substring(begin);
    }

    public static String substringBetween(String string, String pre, String post) {
        int begin = string.indexOf(pre) + pre.length();
        int end = string.indexOf(post, begin);
        return string.substring(begin, end);
    }

    public static String getXMLattribute(String string, String attribute) {
        int begin = string.indexOf(String.valueOf(attribute) + "=\"");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 2, string.indexOf("\"", begin + attribute.length() + 2));
        }
        begin = string.indexOf(String.valueOf(attribute) + "='");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 2, string.indexOf("'", begin + attribute.length() + 2));
        }
        begin = string.indexOf(String.valueOf(attribute) + " = \"");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 4, string.indexOf("\"", begin + attribute.length() + 4));
        }
        begin = string.indexOf(String.valueOf(attribute) + " = '");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 4, string.indexOf("'", begin + attribute.length() + 4));
        }
        begin = string.indexOf(String.valueOf(attribute) + " =\"");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 3, string.indexOf("\"", begin + attribute.length() + 3));
        }
        begin = string.indexOf(String.valueOf(attribute) + " ='");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 3, string.indexOf("'", begin + attribute.length() + 3));
        }
        begin = string.indexOf(String.valueOf(attribute) + "= \"");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 3, string.indexOf("\"", begin + attribute.length() + 3));
        }
        begin = string.indexOf(String.valueOf(attribute) + "= '");
        if (begin != -1) {
            return string.substring(begin + attribute.length() + 3, string.indexOf("'", begin + attribute.length() + 3));
        }
        return null;
    }

    public static String replaceXMLattribute(String string, String attribute, String value) throws Exception {
        int end;
        int begin = string.indexOf(String.valueOf(attribute) + "=\"");
        if (begin != -1) {
            begin = begin + attribute.length() + 2;
            end = string.indexOf("\"", begin);
        } else {
            begin = string.indexOf(String.valueOf(attribute) + "='");
            if (begin != -1) {
                begin = begin + attribute.length() + 2;
                end = string.indexOf("'", begin);
            } else {
                begin = string.indexOf(String.valueOf(attribute) + " = \"");
                if (begin != -1) {
                    begin = begin + attribute.length() + 4;
                    end = string.indexOf("\"", begin);
                } else {
                    begin = string.indexOf(String.valueOf(attribute) + " = '");
                    if (begin != -1) {
                        begin = begin + attribute.length() + 4;
                        end = string.indexOf("'", begin);
                    } else {
                        begin = string.indexOf(String.valueOf(attribute) + " =\"");
                        if (begin != -1) {
                            begin = begin + attribute.length() + 3;
                            end = string.indexOf("\"", begin);
                        } else {
                            begin = string.indexOf(String.valueOf(attribute) + " ='");
                            if (begin != -1) {
                                begin = begin + attribute.length() + 3;
                                end = string.indexOf("'", begin);
                            } else {
                                begin = string.indexOf(String.valueOf(attribute) + "= \"");
                                if (begin != -1) {
                                    begin = begin + attribute.length() + 3;
                                    end = string.indexOf("\"", begin);
                                } else {
                                    begin = string.indexOf(String.valueOf(attribute) + "= '");
                                    if (begin != -1) {
                                        begin = begin + attribute.length() + 3;
                                        end = string.indexOf("'", begin);
                                    } else {
                                        throw new Exception("xml attribute '" + attribute + "' not found in '" + string + "'");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return String.valueOf(string.substring(0, begin)) + value + string.substring(end);
    }

    public static String path2filename(String path) {
        if (path.lastIndexOf(47) != -1) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        if (path.lastIndexOf(92) != -1) {
            return path.substring(path.lastIndexOf(92) + 1);
        }
        return path;
    }

    public static String[] splitString(String str, String delim) {
        int strLen = str.length();
        int delimLen = delim.length();
        String[] result = new String[strLen + 1];
        int offset = 0;
        int token = 0;
        while (offset <= strLen) {
            int end = str.indexOf(delim, offset);
            if (end < 0) {
                end = strLen;
            }
            result[token] = str.substring(offset, end);
            ++token;
            offset = end + delimLen;
        }
        return Arrays.copyOf(result, token);
    }

    public static <E> String join(Iterable<E> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        Iterator<E> iterator = iterable.iterator();
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            E elem = iterator.next();
            if (elem != null) {
                buf.append(elem);
            }
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static <E> String join(String separator, E[] elements) {
        if (elements == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] != null) {
                buf.append(elements[i]);
            }
            if (i + 1 < elements.length) {
                buf.append(separator);
            }
            ++i;
        }
        return buf.toString();
    }

    public static int max(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("No values supplied.");
        }
        int max = Integer.MIN_VALUE;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i > max) {
                max = i;
            }
            ++n2;
        }
        return max;
    }

    public static int countChar(CharSequence haystack, char needle) {
        int count = 0;
        int i = 0;
        while (i < haystack.length()) {
            if (haystack.charAt(i) == needle) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static BufferedReader reader(File file) throws FileNotFoundException, IOException {
        if (file.getName().endsWith(".gz") || file.getName().endsWith(".tgz")) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
        }
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedReader reader(String file) throws FileNotFoundException, IOException {
        return Utils.reader(new File(file));
    }

    public static boolean rx(CharSequence string, String regex) {
        rxMatcher = Pattern.compile(regex).matcher(string);
        return rxMatcher.find();
    }

    public static boolean rxMatch(CharSequence string, String regex) {
        rxMatcher = Pattern.compile(regex).matcher(string);
        return rxMatcher.matches();
    }

    public static <E, C extends Iterable<E>> String joinToColumns(Collection<C> iterables, String separator, String nullValue) {
        boolean hasNextRow;
        StringBuilder out = new StringBuilder();
        ArrayList iterators = new ArrayList();
        for (Iterable iterable : iterables) {
            iterators.add(iterable.iterator());
        }
        do {
            hasNextRow = false;
            Iterator ii = iterators.iterator();
            while (ii.hasNext()) {
                Iterator iterator = (Iterator)ii.next();
                if (iterator.hasNext()) {
                    Object element = iterator.next();
                    if (element == null) {
                        out.append(nullValue);
                    } else {
                        out.append(element.toString());
                    }
                    if (iterator.hasNext()) {
                        hasNextRow = true;
                    }
                }
                if (!ii.hasNext()) continue;
                out.append(separator);
            }
            out.append(nl);
        } while (hasNextRow);
        return out.toString();
    }

    public static List<String> stringList(String nullValue, Object ... objects) {
        ArrayList<String> lst = new ArrayList<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) {
                lst.add(nullValue);
            } else {
                lst.add(o.toString());
            }
            ++n2;
        }
        return lst;
    }

    public static <E> List<E> concatList(Collection<E> ... collections) {
        ArrayList<E> l = new ArrayList<E>();
        Collection<E>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<E> c = collectionArray[n2];
            l.addAll(c);
            ++n2;
        }
        return l;
    }

    public static String formatValAndPercent(Number part, Number total) {
        String percent = Utils.formatPercent(part, total);
        if (percent == null) {
            return null;
        }
        return part + " (" + percent + ")";
    }

    public static String formatPercent(Number part, Number total) {
        if (part == null || total == null) {
            return null;
        }
        if (total.doubleValue() == 0.0) {
            return null;
        }
        return String.valueOf(new DecimalFormat("#.##").format(part.doubleValue() / total.doubleValue() * 100.0)) + "%";
    }

    public static String format(Double number, String decimalFormat) {
        if (number == null) {
            return null;
        }
        return new DecimalFormat(decimalFormat).format(number);
    }

    public static <T> Set<T> uniqueSet(T ... t) {
        return Utils.uniqueSet(Arrays.asList(t));
    }

    public static <T> Set<T> uniqueSet(Collection<T> c) {
        return new HashSet<T>(c);
    }

    public static <K, V> CharSequence joinMap(Map<K, V> map, String sepKeyValue, String sepEntries) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<K, V> e : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(sepEntries);
            }
            sb.append(e.getKey().toString());
            sb.append(sepKeyValue);
            sb.append(e.getValue() == null ? "" : e.getValue().toString());
        }
        return sb;
    }

    public static <K, V> ListMultimap<K, V> invertMapUsingLists(Map<V, K> map) {
        ArrayListMultimap mm = ArrayListMultimap.create();
        return (ListMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(map), (Multimap)mm);
    }

    public static <K, V> SetMultimap<K, V> invertMapUsingSets(Map<V, K> map) {
        HashMultimap mm = HashMultimap.create();
        return (SetMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(map), (Multimap)mm);
    }

    public static String substringUpTo(String str, String separator) {
        return StringUtils.substringBefore((String)str, (String)separator);
    }

    public static String substringUpTo(String str, CharMatcher matcher) {
        int i = matcher.indexIn((CharSequence)Preconditions.checkNotNull((Object)str));
        if (i < 0) {
            return str;
        }
        return str.substring(0, i);
    }

    public static String[] splitToArray(String str, Splitter splitter) {
        Preconditions.checkNotNull((Object)str);
        Preconditions.checkNotNull((Object)splitter);
        return (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)str), String.class);
    }

    public static Map<Integer, String> getStringMatches(String target, String pattern, int maxMismatch) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        int i = 0;
        while (i <= target.length() - pattern.length()) {
            int j = 0;
            int h = i;
            int count = 0;
            int n = pattern.length();
            while (true) {
                int lce;
                if (j + 1 + (lce = Utils.longestCommonExtension(pattern, j, target, h)) == n + 1) {
                    result.put(i, target.substring(i, i + n));
                    break;
                }
                if (count < maxMismatch) {
                    ++count;
                    j = j + lce + 1;
                    h = h + lce + 1;
                    continue;
                }
                if (count == maxMismatch) break;
            }
            ++i;
        }
        return result;
    }

    public static int longestCommonExtension(String t1, int i1, String t2, int i2) {
        int res = 0;
        int i = i1;
        while (i < t1.length() && i2 < t2.length()) {
            if (t1.charAt(i) == t2.charAt(i2)) {
                ++res;
            } else {
                return res;
            }
            ++i;
            ++i2;
        }
        return res;
    }

    public static InputStream post(URL url, Map<String, String> args) throws Exception {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestMethod("POST");
        Map argsEncoded = Maps.transformValues(args, funcUrlEncode);
        String data = Joiner.on((char)'&').withKeyValueSeparator("=").join(argsEncoded);
        DataOutputStream send = new DataOutputStream(con.getOutputStream());
        send.writeBytes(data);
        send.flush();
        send.close();
        try {
            return con.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(con.getURL().toString());
        }
    }

    public static InputStream postMultipartData(URL url, Map<String, String> dataMap) throws Exception {
        return Utils.postMultipartData(url, dataMap, null);
    }

    public static InputStream postMultipartData(URL url, Map<String, String> dataMap, Map<String, String> fileMap) throws Exception {
        String nl = "\r\n";
        String boundary = "---------------------------41184676334";
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        con.setRequestMethod("POST");
        StringBuilder data = new StringBuilder();
        for (Map.Entry<String, String> e : dataMap.entrySet()) {
            data.append("--").append(boundary).append(nl);
            data.append("Content-Disposition: form-data; name=\"").append(e.getKey()).append("\"").append(nl);
            data.append(nl);
            data.append(e.getValue());
            data.append(nl);
        }
        if (fileMap != null) {
            for (Map.Entry<String, String> e : fileMap.entrySet()) {
                data.append("--").append(boundary).append(nl);
                data.append("Content-Disposition: form-data; name=\"").append(e.getKey()).append("\"; filename=\"").append(UUID.randomUUID().toString()).append("\"").append(nl);
                data.append(nl);
                data.append(e.getValue());
                data.append(nl);
            }
        }
        data.append("--").append(boundary).append("--").append(nl);
        con.setRequestProperty("Content-Length", "" + data.length());
        DataOutputStream send = new DataOutputStream(con.getOutputStream());
        send.writeBytes(data.toString());
        send.flush();
        send.close();
        try {
            return con.getInputStream();
        }
        catch (IOException e) {
            throw new Exception(con.getURL().toString());
        }
    }

    public static String readStreamAtOnce(InputStream is) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuilder result = new StringBuilder();
        while ((line = in.readLine()) != null) {
            result.append(line).append(nl);
        }
        in.close();
        return result.toString();
    }

    public static String readFileAtOnce(File file) throws IOException {
        return Utils.readStreamAtOnce(new FileInputStream(file));
    }

    public static String readFileAtOnce(String path) throws IOException {
        return Utils.readFileAtOnce(new File(path));
    }

    public static List<String> readStreamToList(InputStream is) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        in.close();
        return lines;
    }

    public static List<String> readFileToList(File file) throws IOException {
        return Utils.readStreamToList(new FileInputStream(file));
    }

    public static List<String> readFileToList(String path) throws IOException {
        return Utils.readFileToList(new File(path));
    }

    public static Map<String, String> readStreamToMap(InputStream is, Splitter s) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        while ((line = in.readLine()) != null) {
            ArrayList elems = Lists.newArrayList((Iterable)s.split((CharSequence)line));
            m.put((String)elems.get(0), (String)elems.get(1));
        }
        in.close();
        return m;
    }

    public static Map<String, String> readFileToMap(File file, Splitter s) throws IOException {
        return Utils.readStreamToMap(new FileInputStream(file), s);
    }

    public static Map<String, String> readFileToMap(String path, Splitter s) throws IOException {
        return Utils.readFileToMap(new File(path), s);
    }

    public static BufferedReader readUrl(String strUrl) throws MalformedURLException, IOException {
        if (strUrl.endsWith(".gz")) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(new URL(strUrl).openStream())));
        }
        return new BufferedReader(new InputStreamReader(new URL(strUrl).openStream()));
    }

    public static String signedString(int i) {
        return i < 0 ? String.valueOf(i) : "+" + String.valueOf(i);
    }

    public static <E> Set<E> sample(List<E> l, int size) {
        HashSet subset = new HashSet(size);
        while (subset.size() < size) {
        }
        return subset;
    }

    public static int randomInt(int min, int max) {
        if (max == min) {
            return min;
        }
        Preconditions.checkArgument((max > min ? 1 : 0) != 0);
        return (int)Math.floor((double)min + Math.random() * (double)(max - min + 1));
    }

    public static int randomInt(int max) {
        return Utils.randomInt(0, max);
    }

    public static int randomIndex(int size) {
        return Utils.randomInt(0, size - 1);
    }

    public static String longestCommonSubstring(String s1, String s2) {
        int start = 0;
        int max = 0;
        int i = 0;
        while (i < s1.length()) {
            int j = 0;
            while (j < s2.length()) {
                int x = 0;
                while (s1.charAt(i + x) == s2.charAt(j + x)) {
                    if (i + ++x >= s1.length() || j + x >= s2.length()) break;
                }
                if (x > max) {
                    max = x;
                    start = i;
                }
                ++j;
            }
            ++i;
        }
        return s1.substring(start, start + max);
    }

    public static Multimap<String, String> longestComnmonSubstrings(String[] strings) {
        String s;
        HashMultimap m = HashMultimap.create();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            m.put((Object)s, (Object)s);
            ++n2;
        }
        stringArray = strings;
        n = strings.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            for (String key : m.keySet()) {
                String lcs = Utils.longestCommonSubstring(s, key);
                if (lcs.length() <= 0) continue;
                ArrayList hits = new ArrayList(m.get((Object)key));
                hits.addAll(m.get((Object)s));
                m.removeAll((Object)s);
                m.removeAll((Object)key);
                m.putAll((Object)lcs, hits);
                break;
            }
            ++n2;
        }
        return m;
    }

    public static Multimap<String, String> shortestSubstrings(String[] strings) {
        String s;
        HashMultimap m = HashMultimap.create();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            m.put((Object)s, (Object)s);
            ++n2;
        }
        stringArray = strings;
        n = strings.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            for (String key : m.keySet()) {
                if (key.equals(s) || s.indexOf(key) < 0 && key.indexOf(s) < 0) continue;
                m.putAll((Object)key, (Iterable)m.get((Object)s));
                m.removeAll((Object)s);
                break;
            }
            ++n2;
        }
        return m;
    }

    public static File fileDialogOpen(String title, String defaultFileName) {
        return Utils.fileDialog(title, defaultFileName, 0);
    }

    public static File fileDialogSave(String title, String defaultFileName) {
        return Utils.fileDialog(title, defaultFileName, 1);
    }

    protected static File fileDialog(String title, String defaultFileName, int flags) {
        FileDialog dialog = new FileDialog(new Frame(), title, flags);
        dialog.setFile(defaultFileName);
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return null;
        }
        return new File(String.valueOf(dialog.getDirectory()) + dialog.getFile());
    }

    public static File[] fileDialogOpenMulti(String title, String defaultFileName) {
        FileDialog dialog = new FileDialog(new Frame(), title, 0);
        dialog.setMultipleMode(true);
        dialog.setFile(defaultFileName);
        dialog.setVisible(true);
        return dialog.getFiles();
    }

    public static String toJSON(Map<String, Object> m) {
        return "{" + Joiner.on((char)',').join(Iterables.transform(m.entrySet(), (Function)new Function<Map.Entry<String, Object>, String>(){

            public String apply(Map.Entry<String, Object> arg) {
                return "\"" + arg.getKey().replace('\"', '\'').replace('\\', '/') + "\":\"" + arg.getValue().toString().replace('\"', '\'').replace('\\', '/') + "\"";
            }
        })) + "}";
    }

    public static String jsonObjectArray(Iterable<? extends Object> it) {
        if (it == null) {
            return "[]";
        }
        return "[" + Joiner.on((String)",\n").join(it) + "]";
    }

    public static <T extends Comparable<T>> Double[] getRanks(Collection<T> c) {
        Double[] ranks = new Double[c.size()];
        int size = 0;
        TreeMap m = new TreeMap();
        Iterator<T> it = c.iterator();
        int ind = 0;
        while (it.hasNext()) {
            Comparable value = (Comparable)it.next();
            if (value != null) {
                if (!m.containsKey(value)) {
                    m.put(value, new ArrayList());
                }
                ((List)m.get(value)).add(ind);
                ++size;
            }
            ++ind;
        }
        int rank = size;
        for (List indices : m.values()) {
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int ind2 = (Integer)iterator.next();
                ranks[ind2] = 1.0 * (double)rank - (double)(indices.size() - 1) / 2.0;
            }
            rank -= indices.size();
        }
        return ranks;
    }

    public static <T> List<T> concatLists(List<T> ... lists) {
        ArrayList<T> concat = new ArrayList<T>();
        List<T>[] listArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            List<T> list = listArray[n2];
            concat.addAll(list);
            ++n2;
        }
        return concat;
    }

    public static class ExitTrappedException
    extends SecurityException {
        private static final long serialVersionUID = 7194185325210102452L;
        int exitCode;

        public ExitTrappedException(String s, int exitCode) {
            super(s);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MACOSX;


        public static OS getOS() {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                return WINDOWS;
            }
            if (osName.equals("Mac OS X")) {
                return MACOSX;
            }
            return LINUX;
        }
    }

    public static class TarReader {
        LineProcessor lineProcessor;
        Splitter splitter = Splitter.on((char)'\u0000').omitEmptyStrings();
        int newfileEntries;

        public static void read(File tarFile, LineProcessor lineProcessor) throws Exception {
            new TarReader(lineProcessor).process(tarFile);
        }

        protected TarReader(LineProcessor lineProcessor) {
            this.lineProcessor = lineProcessor;
        }

        protected void process(File tarFile) throws Exception {
            String line;
            BufferedReader in = Utils.reader(tarFile);
            String currentFile = null;
            String previousFile = null;
            while ((line = in.readLine()) != null) {
                LinkedList elems;
                if (currentFile == null) {
                    elems = Lists.newLinkedList((Iterable)this.splitter.split((CharSequence)line));
                    System.out.println(elems);
                    this.newfileEntries = elems.size() > 8 && ((String)elems.get(8)).trim().equals("ustar") ? 10 : 5;
                    currentFile = (String)elems.getFirst();
                    if (currentFile.endsWith("/")) {
                        System.err.println("file is within a subfolder");
                    }
                    if (line.lastIndexOf(0) == line.length() - 1) {
                        this.lineProcessor.processLine("", currentFile, previousFile, true, false);
                    } else {
                        this.lineProcessor.processLine((String)elems.getLast(), currentFile, previousFile, true, false);
                    }
                } else if (line.indexOf(0) >= 0) {
                    elems = Lists.newLinkedList((Iterable)this.splitter.split((CharSequence)line));
                    System.out.println(elems);
                    if (line.indexOf(0) == 0) {
                        this.lineProcessor.processLine("", currentFile, previousFile, false, true);
                    } else {
                        this.lineProcessor.processLine((String)elems.removeFirst(), currentFile, previousFile, false, true);
                    }
                    if (elems.size() > 1) {
                        currentFile = (String)elems.getFirst();
                        if (line.lastIndexOf(0) == line.length() - 1) {
                            this.lineProcessor.processLine("", currentFile, previousFile, true, false);
                        } else {
                            this.lineProcessor.processLine((String)elems.getLast(), currentFile, previousFile, true, false);
                        }
                    }
                } else {
                    this.lineProcessor.processLine(line, currentFile, previousFile, false, false);
                }
                previousFile = currentFile;
            }
            in.close();
        }

        public static interface LineProcessor {
            public void processLine(String var1, String var2, String var3, boolean var4, boolean var5) throws Exception;
        }
    }
}

