/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import iptgxdb.utils.Utils;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;

public class GenomicsUtil {
    public static final HashMap<String, Character> translationTable11 = new HashMap<String, Character>(){
        private static final long serialVersionUID = 8562663901478718584L;
        {
            this.put("TTT", Character.valueOf('F'));
            this.put("TCT", Character.valueOf('S'));
            this.put("TAT", Character.valueOf('Y'));
            this.put("TGT", Character.valueOf('C'));
            this.put("TTC", Character.valueOf('F'));
            this.put("TCC", Character.valueOf('S'));
            this.put("TAC", Character.valueOf('Y'));
            this.put("TGC", Character.valueOf('C'));
            this.put("TTA", Character.valueOf('L'));
            this.put("TCA", Character.valueOf('S'));
            this.put("TAA", Character.valueOf('*'));
            this.put("TGA", Character.valueOf('*'));
            this.put("TTG", Character.valueOf('L'));
            this.put("TCG", Character.valueOf('S'));
            this.put("TAG", Character.valueOf('*'));
            this.put("TGG", Character.valueOf('W'));
            this.put("CTT", Character.valueOf('L'));
            this.put("CCT", Character.valueOf('P'));
            this.put("CAT", Character.valueOf('H'));
            this.put("CGT", Character.valueOf('R'));
            this.put("CTC", Character.valueOf('L'));
            this.put("CCC", Character.valueOf('P'));
            this.put("CAC", Character.valueOf('H'));
            this.put("CGC", Character.valueOf('R'));
            this.put("CTA", Character.valueOf('L'));
            this.put("CCA", Character.valueOf('P'));
            this.put("CAA", Character.valueOf('Q'));
            this.put("CGA", Character.valueOf('R'));
            this.put("CTG", Character.valueOf('L'));
            this.put("CCG", Character.valueOf('P'));
            this.put("CAG", Character.valueOf('Q'));
            this.put("CGG", Character.valueOf('R'));
            this.put("ATT", Character.valueOf('I'));
            this.put("ACT", Character.valueOf('T'));
            this.put("AAT", Character.valueOf('N'));
            this.put("AGT", Character.valueOf('S'));
            this.put("ATC", Character.valueOf('I'));
            this.put("ACC", Character.valueOf('T'));
            this.put("AAC", Character.valueOf('N'));
            this.put("AGC", Character.valueOf('S'));
            this.put("ATA", Character.valueOf('I'));
            this.put("ACA", Character.valueOf('T'));
            this.put("AAA", Character.valueOf('K'));
            this.put("AGA", Character.valueOf('R'));
            this.put("ATG", Character.valueOf('M'));
            this.put("ACG", Character.valueOf('T'));
            this.put("AAG", Character.valueOf('K'));
            this.put("AGG", Character.valueOf('R'));
            this.put("GTT", Character.valueOf('V'));
            this.put("GCT", Character.valueOf('A'));
            this.put("GAT", Character.valueOf('D'));
            this.put("GGT", Character.valueOf('G'));
            this.put("GTC", Character.valueOf('V'));
            this.put("GCC", Character.valueOf('A'));
            this.put("GAC", Character.valueOf('D'));
            this.put("GGC", Character.valueOf('G'));
            this.put("GTA", Character.valueOf('V'));
            this.put("GCA", Character.valueOf('A'));
            this.put("GAA", Character.valueOf('E'));
            this.put("GGA", Character.valueOf('G'));
            this.put("GTG", Character.valueOf('V'));
            this.put("GCG", Character.valueOf('A'));
            this.put("GAG", Character.valueOf('E'));
            this.put("GGG", Character.valueOf('G'));
        }
    };
    public static ListMultimap<Character, String> reverseTranslationTable = ArrayListMultimap.create();

    static {
        Multimaps.invertFrom((Multimap)Multimaps.forMap(translationTable11), reverseTranslationTable);
        reverseTranslationTable.putAll((Object)Character.valueOf('X'), translationTable11.keySet());
        reverseTranslationTable.putAll((Object)Character.valueOf('J'), (Iterable)reverseTranslationTable.get((Object)Character.valueOf('L')));
        reverseTranslationTable.putAll((Object)Character.valueOf('J'), (Iterable)reverseTranslationTable.get((Object)Character.valueOf('I')));
        reverseTranslationTable.putAll((Object)Character.valueOf('Z'), (Iterable)reverseTranslationTable.get((Object)Character.valueOf('Q')));
        reverseTranslationTable.putAll((Object)Character.valueOf('Z'), (Iterable)reverseTranslationTable.get((Object)Character.valueOf('E')));
        reverseTranslationTable.putAll((Object)Character.valueOf('B'), (Iterable)reverseTranslationTable.get((Object)Character.valueOf('N')));
        reverseTranslationTable.putAll((Object)Character.valueOf('B'), (Iterable)reverseTranslationTable.get((Object)Character.valueOf('D')));
    }

    public static StringBuilder reverseNucleotides(String forward) {
        return new StringBuilder(forward.toUpperCase().replace('A', 't').replace('T', 'a').replace('G', 'c').replace('C', 'g').toUpperCase()).reverse();
    }

    public static String createGFFheader(String trackName, Color col) {
        String colString = "";
        if (col != null) {
            colString = " color=" + col.getRed() + "," + col.getGreen() + "," + col.getBlue();
        }
        return "##gff-version 3" + Utils.nl + "#track name=\"" + trackName + "\"" + colString;
    }

    public static StringBuilder translate(CharSequence nt) throws Exception {
        StringBuilder aa = new StringBuilder();
        int i = 0;
        while (i < nt.length() - nt.length() % 3) {
            String codon = nt.subSequence(i, i + 3).toString().toUpperCase();
            if (!translationTable11.containsKey(codon)) {
                System.err.println("WARNING: unkown codon " + codon);
                return new StringBuilder();
            }
            aa.append(translationTable11.get(codon));
            i += 3;
        }
        return aa;
    }

    public static StringBuilder reverseTranslate(CharSequence aa, boolean addStopCodon) throws Exception {
        StringBuilder nt = new StringBuilder();
        int i = 0;
        while (i < aa.length()) {
            List codons = reverseTranslationTable.get((Object)Character.valueOf(aa.charAt(i)));
            nt.append((String)codons.get(Utils.randomIndex(codons.size())));
            ++i;
        }
        if (addStopCodon) {
            List codons = reverseTranslationTable.get((Object)Character.valueOf('*'));
            nt.append((String)codons.get(Utils.randomIndex(codons.size())));
        }
        return nt;
    }

    public static String complement(String nt) {
        return nt.toUpperCase().replace('A', 't').replace('T', 'a').replace('G', 'c').replace('C', 'g').toUpperCase();
    }
}

