/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import iptgxdb.utils.GenomicsUtil;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class GenomeLocation
implements Comparable<GenomeLocation> {
    public String chromosome;
    public int from;
    public int to;
    public Strand strand;

    public GenomeLocation(Integer start, Integer end, String chromosome) throws Exception {
        if (start < 0 && end < 0) {
            this.strand = Strand.MINUS;
            this.from = -end.intValue();
            this.to = -start.intValue();
        } else if (start > 0 && end > 0) {
            if (end < start) {
                this.from = end;
                this.to = start;
                this.strand = Strand.MINUS;
            } else {
                this.from = start;
                this.to = end;
                this.strand = Strand.PLUS;
            }
        } else {
            throw new Exception("either signed OR normal coordinates");
        }
        this.chromosome = chromosome;
    }

    public GenomeLocation(Integer from, Integer to, Strand strand, String chromosome) throws Exception {
        if (to < from) {
            throw new Exception("'to' coordinate cannot be before 'from' coordinate");
        }
        this.from = from;
        this.to = to;
        this.strand = strand;
        this.chromosome = chromosome;
    }

    public GenomeLocation(String genBankLocation, String chromosome) throws Exception {
        String location = genBankLocation.trim();
        this.strand = Strand.PLUS;
        if (location.startsWith("complement")) {
            this.strand = Strand.MINUS;
            location = location.substring(11, location.length() - 1);
        }
        if (location.indexOf(60) != -1 || location.indexOf(62) != -1) {
            System.out.println("WARN: ignoring open location ends at '" + genBankLocation + "'");
            location = location.replace("<", "").replace(">", "");
        }
        if (!location.matches("\\d+\\.\\.>?\\d+")) {
            throw new Exception("unknown location: " + genBankLocation);
        }
        this.from = Integer.valueOf(location.split("\\.\\.")[0]);
        this.to = Integer.valueOf(location.split("\\.\\.>?")[1]);
        this.chromosome = chromosome;
    }

    public int length() {
        return this.to - this.from + 1;
    }

    public Integer lengthAA() {
        if (this.length() % 3 == 0) {
            return this.length() / 3 - 1;
        }
        return null;
    }

    public boolean isStartingInternalOf(GenomeLocation otherLoc) {
        if (Objects.equal((Object)otherLoc.chromosome, (Object)this.chromosome) && otherLoc.strand == this.strand && otherLoc.getEnd() == this.getEnd()) {
            return otherLoc.length() > this.length();
        }
        return false;
    }

    public String getSequence(StringBuilder forwardSequence) {
        int start = Math.max(1, this.from);
        int end = Math.min(forwardSequence.length(), this.to);
        String seq = String.valueOf(StringUtils.repeat((char)'-', (int)(start - this.from))) + forwardSequence.substring(start - 1, end) + StringUtils.repeat((char)'-', (int)(this.to - end));
        if (this.strand == Strand.MINUS) {
            return GenomicsUtil.reverseNucleotides(seq).toString();
        }
        return seq;
    }

    public int getFrame(int seqLength) {
        if (this.strand.equals((Object)Strand.MINUS)) {
            return -((seqLength - this.getStart()) % 3 + 1);
        }
        return (this.getStart() - 1) % 3 + 1;
    }

    public int getStart() {
        if (this.strand == Strand.PLUS) {
            return this.from;
        }
        if (this.strand == Strand.MINUS) {
            return this.to;
        }
        return 0;
    }

    public int getSignedStart() {
        if (this.strand == Strand.PLUS) {
            return this.from;
        }
        if (this.strand == Strand.MINUS) {
            return -this.to;
        }
        return 0;
    }

    public int getEnd() {
        if (this.strand == Strand.PLUS) {
            return this.to;
        }
        if (this.strand == Strand.MINUS) {
            return this.from;
        }
        return 0;
    }

    public int getSignedEnd() {
        if (this.strand == Strand.PLUS) {
            return this.to;
        }
        if (this.strand == Strand.MINUS) {
            return -this.from;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.from) + ".." + this.to + "(" + (Object)((Object)this.strand) + ")";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        GenomeLocation that = (GenomeLocation)o;
        return this.from == that.from && this.to == that.to && this.strand == that.strand && Objects.equal((Object)this.chromosome, (Object)that.chromosome);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.from;
        hash = 31 * hash + this.to;
        hash = 31 * hash + this.strand.ordinal();
        if (this.chromosome != null) {
            hash = 31 * hash + this.chromosome.hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(GenomeLocation that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.chromosome), (Comparable)((Object)that.chromosome)).compare((Comparable)((Object)this.strand), (Comparable)((Object)that.strand)).compare(this.to, that.to).compare(this.from, that.from).result();
    }

    public static enum Strand {
        PLUS("+"),
        MINUS("-");

        private final String str;

        private Strand(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }

        public static Strand fromString(String value) {
            Strand returnValue = null;
            for (Strand element : EnumSet.allOf(Strand.class)) {
                if (!element.toString().equals(value)) continue;
                returnValue = element;
            }
            return returnValue;
        }
    }
}

