/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import iptgxdb.utils.GenomeFeature;
import iptgxdb.utils.GenomeLocation;
import iptgxdb.utils.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class GenomeFeatureSet
extends LinkedHashSet<GenomeFeature> {
    private static final long serialVersionUID = 5035865359437800455L;
    public Map<GenomeLocation, GenomeFeature> byLocation = new HashMap<GenomeLocation, GenomeFeature>();
    public Map<String, GenomeFeature> byId = new HashMap<String, GenomeFeature>();
    public SortedMap<GenomeLocation, SortedSet<GenomeFeature>> byEndPosition = new TreeMap<GenomeLocation, SortedSet<GenomeFeature>>();
    public AnnotationSource annotationSource;
    public String name;

    public GenomeFeatureSet(File gffFile, AnnotationSource annotationSource, boolean readPseudo) throws IOException, Exception {
        this.annotationSource = annotationSource;
        if (annotationSource != null) {
            this.name = annotationSource.defaultName;
        }
        if (gffFile != null) {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(gffFile));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                GenomeFeature gff = new GenomeFeature(line);
                if (!readPseudo && gff.getAtt("pseudo", "").equals("true")) continue;
                this.add(gff);
            }
            in.close();
        }
    }

    public String generateId(GenomeFeature gff, boolean shortVersion) {
        String newId = shortVersion ? this.annotationSource.tag : (this.annotationSource.idManipulator != null ? this.annotationSource.idManipulator.generateId(gff) : gff.getID());
        if (this.annotationSource.unmentionedTypes != null && !this.annotationSource.unmentionedTypes.contains(gff.type)) {
            newId = String.valueOf(newId) + "_" + gff.type;
        }
        if (gff.hasAtt("idRedundancy")) {
            newId = String.valueOf(newId) + StringUtils.substringBefore((String)gff.getAtt("idRedundancy"), (String)"of");
        }
        if (gff.getAtt("pseudo", "false").equals("true")) {
            newId = String.valueOf(newId) + "_p";
        }
        return newId;
    }

    @Override
    public boolean add(GenomeFeature gff) {
        boolean result = super.add(gff);
        if (result) {
            this.byId.put(gff.getID(), gff);
            if (this.byLocation.containsKey(gff.location)) {
                System.err.println("duplicated genome feature location: " + gff);
            } else {
                this.byLocation.put(gff.location, gff);
                try {
                    int signedEnd = gff.location.getSignedEnd();
                    GenomeLocation endLoc = new GenomeLocation(signedEnd, signedEnd, gff.location.chromosome);
                    if (!this.byEndPosition.containsKey(endLoc)) {
                        this.byEndPosition.put(endLoc, new TreeSet<GenomeFeature>(GenomeFeature.comparatorLength));
                    }
                    ((SortedSet)this.byEndPosition.get(endLoc)).add(gff);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("error");
                }
            }
        } else {
            System.err.println("duplicated genome feature not added to set: " + gff);
        }
        return result;
    }

    public static enum AnnotationSource {
        ORF("orf", "in-silico ORFs", Color.GRAY.brighter(), true, null, new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                return String.valueOf(prefix) + "ORF";
            }
        }),
        REFSEQ("refseq", "RefSeq", Color.BLUE, false, Arrays.asList("CDS", "gene"), new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                return gff.getID();
            }
        }),
        REF("ref", "Reference", Color.BLUE, false, null, new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                return String.valueOf(prefix) + "REF";
            }
        }),
        ENSEMBL("ens", "Ensembl", Color.BLUE.darker().darker(), false, Arrays.asList("CDS"), new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                if (gff.getID() != null) {
                    return String.valueOf(prefix) + "ENS" + gff.getID().split(" ")[0];
                }
                return String.valueOf(prefix) + "ENS";
            }
        }),
        GENOSCOPE("geno", "Genoscope", Color.GREEN.darker(), false, Arrays.asList("CDS"), new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                if (Utils.rx(gff.getID(), "[A-Z]{5}(\\d+)")) {
                    return String.valueOf(prefix) + "GENO" + Utils.rxMatcher.group(1);
                }
                return String.valueOf(prefix) + "GENO" + gff.getID();
            }
        }),
        CMR("cmr", "CMR", Color.RED, false, null, new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                if (Utils.rx(gff.getID(), "NT\\d+[A-Z]+(\\d+)")) {
                    return String.valueOf(prefix) + "CMR" + Utils.rxMatcher.group(1);
                }
                return String.valueOf(prefix) + "CMR" + gff.getID();
            }
        }),
        CHEMGENOME("chemg", "ChemGenome", Color.YELLOW, false, null, new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                return String.valueOf(prefix) + "CHEMG";
            }
        }),
        SHORTORF("short", "ShortORFs", Color.PINK, false, null, new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                return String.valueOf(prefix) + "SHORT";
            }
        }),
        EASYGENE("easy", "EasyGene", Color.MAGENTA, false, null, new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                return String.valueOf(prefix) + "EASY";
            }
        }),
        PRODIGAL("prod", "Prodigal", Color.ORANGE, false, null, new GenomeFeature.IdManipulator(){

            @Override
            public String generateId(GenomeFeature gff) {
                return String.valueOf(prefix) + "PROD";
            }
        });

        public static String prefix;
        public final String defaultName;
        public final String tag;
        public final Color color;
        public final boolean extensionsOnly;
        public final GenomeFeature.IdManipulator idManipulator;
        public final List<String> unmentionedTypes;

        private AnnotationSource(String tag, String defaultName, Color color, boolean extensionsOnly, List<String> unmentionedTypes, GenomeFeature.IdManipulator idManipulator) {
            this.tag = tag;
            this.defaultName = defaultName;
            this.color = color;
            this.extensionsOnly = extensionsOnly;
            this.unmentionedTypes = unmentionedTypes;
            this.idManipulator = idManipulator;
        }

        public String toString() {
            return this.tag;
        }

        public static AnnotationSource byTag(String tag) {
            AnnotationSource[] annotationSourceArray = AnnotationSource.values();
            int n = annotationSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationSource as = annotationSourceArray[n2];
                if (as.tag.equals(tag)) {
                    return as;
                }
                ++n2;
            }
            return null;
        }
    }
}

