/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import iptgxdb.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class FastaReader
implements LineProcessor<Map<String, String>> {
    Function<String, String> headerProcessor;
    Map<String, String> m = Maps.newLinkedHashMap();
    String header = null;
    StringBuilder sequence = new StringBuilder(256);
    public static final Function<String, String> headerUpToFirstWhitespace = new Function<String, String>(){

        public String apply(String header) {
            return Utils.substringUpTo(header, CharMatcher.WHITESPACE);
        }
    };
    public static final Function<String, String> headerComplete = new Function<String, String>(){

        public String apply(String header) {
            return header;
        }
    };

    public FastaReader(Function<String, String> headerProcessor) {
        this.headerProcessor = headerProcessor;
    }

    public Map<String, String> getResult() {
        this.processEntry();
        return this.m;
    }

    public boolean processLine(String line) throws IOException {
        if (line.startsWith(">")) {
            if (this.header != null) {
                this.processEntry();
            }
            this.header = (String)this.headerProcessor.apply((Object)line.substring(1));
            this.sequence.setLength(0);
        } else if (!line.startsWith("#")) {
            this.sequence.append(CharMatcher.WHITESPACE.removeFrom((CharSequence)line));
        }
        return true;
    }

    private void processEntry() {
        this.m.put(this.header, this.sequence.toString());
    }

    public static Map<String, String> readFile(String filename, Function<String, String> headerProcessor) throws IOException {
        return FastaReader.readFile(new File(filename), headerProcessor);
    }

    public static Map<String, String> readFile(File file, Function<String, String> headerProcessor) throws IOException {
        return (Map)Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new FastaReader(headerProcessor));
    }
}

