/*
 * Decompiled with CFR 0.152.
 */
package iptgxdb.utils;

import iptgxdb.utils.UOBufferedWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;

public class CLIUtils {
    public static Option createArgOption(String option, String arg, String description, boolean required, boolean multiple) {
        if (multiple) {
            OptionBuilder.hasArgs();
        } else {
            OptionBuilder.hasArg();
        }
        OptionBuilder.withArgName((String)arg);
        OptionBuilder.isRequired((boolean)required);
        OptionBuilder.withDescription((String)description);
        return OptionBuilder.create((String)option);
    }

    public static File getFileOption(CommandLine cli, String option, boolean errorOnExistance) {
        if (cli.hasOption(option)) {
            File f = new File(cli.getOptionValue(option));
            if (errorOnExistance && f.exists()) {
                System.err.println("ERROR: " + f.getName() + " already exists.");
                System.exit(0);
            }
            return f;
        }
        return null;
    }

    public static File[] getFileArray(CommandLine cli, String option) {
        if (!cli.hasOption(option)) {
            return null;
        }
        String[] arr = cli.getOptionValues(option);
        File[] files = new File[arr.length];
        int i = 0;
        while (i < arr.length) {
            files[i] = new File(arr[i]);
            ++i;
        }
        return files;
    }

    public static UOBufferedWriter getUOWriter(CommandLine cli, String option, boolean errorOnExistance) throws IOException {
        File f = CLIUtils.getFileOption(cli, option, errorOnExistance);
        if (f != null) {
            return new UOBufferedWriter(f);
        }
        return null;
    }
}

