rm(list=ls())

library(iClusterPlus)
## First, set all the parameters:
maxGeneNo=2000
kRange=1:9 ## would be 2:10 clusters
nThread=60

# dataPath="~/Desktop/Projects/SubTyping/DataTCGA/"
# resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/iClusterPlusResult/"

dataPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/DataTCGA/"
resultPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/iClusterPlusResult/"



# only GBM needs to be done this time

dataset="GBM"

prefix=paste(dataPath, dataset, "/", sep="")

file=paste(prefix, dataset, "_ProcessedData.RData" ,sep="")
load(file)

patients=rownames(survival)
patients=intersect(patients,rownames(mydatGE))
patients=intersect(patients,rownames(mydatME))
patients=intersect(patients,rownames(mydatMI))
  
mydatGE=as.matrix(mydatGE[patients,])
mydatME=as.matrix(mydatME[patients,])
mydatMI=as.matrix(mydatMI[patients,])
survival=survival[patients,]

## get top features only
if (ncol(mydatGE) > maxGeneNo) {
    sds=apply(mydatGE,FUN=mad,MARGIN=2)
    mydatGE=mydatGE[,order(sds, decreasing = T)[1:maxGeneNo]]
}
if (ncol(mydatME) > maxGeneNo) {
    sds=apply(mydatME,FUN=mad,MARGIN=2)
    mydatME=mydatME[,order(sds, decreasing = T)[1:maxGeneNo]]
}
if (ncol(mydatMI) > maxGeneNo) {
  sds=apply(mydatMI,FUN=mad,MARGIN=2)
  mydatMI=mydatMI[,order(sds, decreasing = T)[1:maxGeneNo]]
}

set.seed(1)
#### mRNA + methylation
t1=Sys.time()
cv.fit=alist()

for (k in kRange) {
  cv.fit[[k]]=tune.iClusterPlus(cpus=nThread, dt1=mydatGE, dt2=mydatME, K=k, type=c("gaussian", "gaussian"))
}
t2=Sys.time()
print(t2-t1)
resultFile=paste(resultPath, "No_miRNA/iClusterPlus_", dataset,"_", maxGeneNo, ".RData" ,sep="")  
save(cv.fit, t1, t2, mydatGE, mydatME, survival, file=resultFile)

set.seed(1)
#### mRNA + miRNA
t1=Sys.time()
cv.fit=alist()
for (k in kRange) {
  cv.fit[[k]]=tune.iClusterPlus(cpus=nThread, dt1=mydatGE, dt2=mydatMI, K=k, type=c("gaussian", "gaussian"))
}
t2=Sys.time()
print(t2-t1)
resultFile=paste(resultPath, "No_methyl/iClusterPlus_", dataset,"_", maxGeneNo, ".RData" ,sep="")  
save(cv.fit, t1, t2, mydatGE, mydatME, survival, file=resultFile)


set.seed(1)
#### miRNA + methylation
t1=Sys.time()
cv.fit=alist()

for (k in kRange) {
  cv.fit[[k]]=tune.iClusterPlus(cpus=nThread, dt1=mydatME, dt2=mydatMI, K=k, type=c("gaussian", "gaussian"))
}

t2=Sys.time()
print(t2-t1)

resultFile=paste(resultPath, "No_mRNA/iClusterPlus_", dataset,"_", maxGeneNo, ".RData" ,sep="")  
save(cv.fit, t1, t2, mydatGE, mydatME, survival, file=resultFile)




library(iClusterPlus)
library(survival)
dataset="GBM"
maxGeneNo=2000

folders=c("No_miRNA", "No_methyl", "No_mRNA")
kAlls=c(9,6,4)
for (type in 1:3) {
  folder=folders[type]
  pdfFile=paste(resultPath, "/", folder, "/iClusterPlus_TCGA_Summary_", maxGeneNo,".pdf" ,sep="")
  pdf(pdfFile)
  resultFile=paste(resultPath, "/", folder, "/iClusterPlus_", dataset, "_", maxGeneNo, ".RData" ,sep="")
  load(resultFile)
  
  nK = length(cv.fit)
  
  BIC=getBIC(cv.fit)
  devR = getDevR(cv.fit)
  minBICid = apply(BIC,2,which.min)
  devRatMinBIC = rep(NA,nK)
  for(i in 1:nK) {devRatMinBIC[i] = devR[minBICid[i],i]}
  if(sum(is.na(devRatMinBIC))==0) plot(devRatMinBIC, xlab="k", main=paste("iClusterPlus result, ", dataset, ", ", maxGeneNo, sep=""))
  dev.off()
  
  clusters=getClusters(cv.fit)
  
  ## these number of subtypes were determined using the BIC curves, the devRatMinBIC plots
  k=kAlls[type]
  
  groups_All=clusters[,k]
  groups_All <- factor(groups_All); names(groups_All) = rownames(survival)
  
  pdfFile=paste(resultPath, "/", folder, "/iClusterPlus_", dataset, "_", maxGeneNo, ".pdf" ,sep="")
  pdf(pdfFile)
  
  groups=groups_All
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ groups, data = survival, ties="exact")
  #summary(coxFit)
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groups), data = survival)
  plot(mfit, col=unique(groups), main = paste("Survival curves for combined data of ", dataset, " (iClusterPlus)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
  legend("top", legend = paste("Cox p-value:", round(summary(coxFit)$sctest[3],digits = 5), sep=""))
  legend("topright", fill=levels(factor(groups)), legend=paste("Group ",levels(factor(groups)), ": ", table(groups)[levels(factor(groups))], sep=""))
  
  dev.off()
}


