rm(list=ls())
SNFPath="~/Desktop/Projects/SubTyping/PackageAndTesting/SNFResult/"
PINSPath="~/Desktop/Projects/SubTyping/PackageAndTesting/PINSResult/"
CCPath="~/Desktop/Projects/SubTyping/PackageAndTesting/CCResult/"
iClusterPlusPath="~/Desktop/Projects/SubTyping/PackageAndTesting/iClusterPlusResult/"
pdfPath="~/Desktop/Projects/SubTyping/PackageAndTesting/Plots/Figures/"

library("gplots")
library(survival)
library(iClusterPlus)
library(cluster)
library(SNFtool)

datasets=c("KIRC", "GBM", "LAML", "LUSC", "BRCA", "COAD")
datatypes=c("GE", "ME", "MI", "Integration")
rows=as.vector(t(outer(datasets, datatypes, paste, sep="_")))

Table_CI=data.frame(row.names = rows, PINS=rep(NA,length(rows)), CC=rep(NA,length(rows)), SNF=rep(NA,length(rows)), iCluster=rep(NA,length(rows)))
Patients=rep(NA, length(datasets));names(Patients)=datasets
Table_cluster=data.frame(row.names = rows, PINS=rep(NA,length(rows)), CC=rep(NA,length(rows)), SNF=rep(NA,length(rows)), iCluster=rep(NA,length(rows)))

for (dataset in datasets) {
    resultFile=paste(PINSPath, "PINS_", dataset, ".RData" ,sep="")
    load(resultFile)

    groupsGE=result$dataTypeResult[[1]]$groups
    groupsME=result$dataTypeResult[[2]]$groups
    groupsMI=result$dataTypeResult[[3]]$groups
    groups=result$groups2
    
    Table_CI[paste(dataset, "GE", sep="_"),"PINS"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groupsGE), data = survival))$concordance[1]
    Table_CI[paste(dataset, "ME", sep="_"),"PINS"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groupsME), data = survival))$concordance[1]
    Table_CI[paste(dataset, "MI", sep="_"),"PINS"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groupsMI), data = survival))$concordance[1]
    Table_CI[paste(dataset, "Integration", sep="_"),"PINS"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groups), data = survival))$concordance[1]
    
    Patients[dataset]=nrow(survival)
    Table_cluster[paste(dataset, "GE", sep="_"),"PINS"]=length(unique(groupsGE))
    Table_cluster[paste(dataset, "ME", sep="_"),"PINS"]=length(unique(groupsME))
    Table_cluster[paste(dataset, "MI", sep="_"),"PINS"]=length(unique(groupsMI))
    Table_cluster[paste(dataset, "Integration", sep="_"),"PINS"]=length(unique(groups))
    
    
    
    resultFile=paste(SNFPath, "SNF_", dataset, ".RData" ,sep="")
    load(resultFile)
    Table_CI[paste(dataset, "GE", sep="_"),"SNF"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groupGE), data = survival))$concordance[1]
    Table_CI[paste(dataset, "ME", sep="_"),"SNF"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groupME), data = survival))$concordance[1]
    Table_CI[paste(dataset, "MI", sep="_"),"SNF"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groupMI), data = survival))$concordance[1]
    Table_CI[paste(dataset, "Integration", sep="_"),"SNF"]=summary(coxph(Surv(time = Survival, event = Death) ~ factor(groupSNF), data = survival))$concordance[1]
    
    Table_cluster[paste(dataset, "GE", sep="_"),"SNF"]=length(unique(groupsGE))
    Table_cluster[paste(dataset, "ME", sep="_"),"SNF"]=length(unique(groupsME))
    Table_cluster[paste(dataset, "MI", sep="_"),"SNF"]=length(unique(groupsMI))
    Table_cluster[paste(dataset, "Integration", sep="_"),"SNF"]=length(unique(groupSNF))
    
    resultFile=paste(CCPath, "CC_", dataset, ".RData" ,sep="")
    load(resultFile)
    if (dataset=="KIRC") {
        kGE=6
        kME=6
        kMI=5
        kAll=6
    } else if (dataset=="GBM") {
        kGE=5
        kME=6
        kMI=6
        kAll=7
    } else if (dataset=="LAML") {
        kGE=5
        kME=7
        kMI=6
        kAll=8
    } else if (dataset=="LUSC") {
        kGE=5
        kME=9
        kMI=7
        kAll=6
    } else if (dataset=="BRCA") {
        kGE=8
        kME=8
        kMI=5
        kAll=7
    } else if (dataset=="COAD") {
        kGE=8
        kME=8
        kMI=7
        kAll=5
    }
    groupsGE=result_GE[[kGE]]$consensusClass
    groupsME=result_ME[[kME]]$consensusClass
    groupsMI=result_MI[[kMI]]$consensusClass
    groupsCC = result_All[[kAll]]$consensusClass
    Table_CI[paste(dataset, "GE", sep="_"),"CC"]=summary(coxph(Surv(time = Survival, event = Death) ~ groupsGE, data = survival))$concordance[1]
    Table_CI[paste(dataset, "ME", sep="_"),"CC"]=summary(coxph(Surv(time = Survival, event = Death) ~ groupsME, data = survival))$concordance[1]
    Table_CI[paste(dataset, "MI", sep="_"),"CC"]=summary(coxph(Surv(time = Survival, event = Death) ~ groupsMI, data = survival))$concordance[1]
    Table_CI[paste(dataset, "Integration", sep="_"),"CC"]=summary(coxph(Surv(time = Survival, event = Death) ~ groupsCC, data = survival))$concordance[1]
   
    Table_cluster[paste(dataset, "GE", sep="_"),"CC"]=length(unique(groupsGE))
    Table_cluster[paste(dataset, "ME", sep="_"),"CC"]=length(unique(groupsME))
    Table_cluster[paste(dataset, "MI", sep="_"),"CC"]=length(unique(groupsMI))
    Table_cluster[paste(dataset, "Integration", sep="_"),"CC"]=length(unique(groupsCC))
    
    
    resultFile=paste(iClusterPlusPath, "iClusterPlus_", dataset, "_2000.RData" ,sep="")
    load(resultFile)
    clusters_GE=getClusters(cv.fitGE)
    clusters_ME=getClusters(cv.fitME)
    if (dataset=="GBM") clusters_MI=getClusters(cv.fitMI) else clusters_MI=NA
    clusters=getClusters(cv.fit)
    if (dataset=="KIRC") {
        kGE=8
        kME=9
        kMI=NA
        k=5
    } else if (dataset=="GBM") {
        kGE=9
        kME=9
        kMI=9
        k=4
    } else if (dataset=="LAML") {
        kGE=5
        kME=9
        kMI=NA
        k=4
    } else if (dataset=="LUSC") {
        kGE=6
        kME=9
        kMI=NA
        k=3
    } else if (dataset=="BRCA") {
        kGE=8
        kME=9
        kMI=NA
        k=9
    } else if (dataset=="COAD") {
        kGE=5
        kME=9
        kMI=NA
        k=9
    }
    
    groups_GE=clusters_GE[,kGE]
    groups_GE <- groups_GE; names(groups_GE) = rownames(survival)
    
    groups_ME=clusters_ME[,kME]
    groups_ME <- groups_ME; names(groups_ME) = rownames(survival)
    
    if (dataset=="GBM") {
        groups_MI=clusters_MI[,kMI]
        groups_MI <- groups_MI; names(groups_MI) = rownames(survival)
    } else {
        groups_MI=NA
    }
    
    groups_All=clusters[,k]
    groups_All <- groups_All; names(groups_All) = rownames(survival)
    
    Table_CI[paste(dataset, "GE", sep="_"),"iCluster"]=summary(coxph(Surv(time = Survival, event = Death) ~ groups_GE, data = survival))$concordance[1]
    Table_CI[paste(dataset, "ME", sep="_"),"iCluster"]=summary(coxph(Surv(time = Survival, event = Death) ~ groups_ME, data = survival))$concordance[1]
    if (dataset=="GBM") Table_CI[paste(dataset, "MI", sep="_"),"iCluster"]=summary(coxph(Surv(time = Survival, event = Death) ~ groups_MI, data = survival))$concordance[1]
    Table_CI[paste(dataset, "Integration", sep="_"),"iCluster"]=summary(coxph(Surv(time = Survival, event = Death) ~ groups_All, data = survival))$concordance[1]
    
    Table_cluster[paste(dataset, "GE", sep="_"),"iCluster"]=length(unique(groups_GE))
    Table_cluster[paste(dataset, "ME", sep="_"),"iCluster"]=length(unique(groups_ME))
    Table_cluster[paste(dataset, "MI", sep="_"),"iCluster"]=ifelse(sum(is.na(groups_MI)),NA,length(unique(groups_MI)))
    Table_cluster[paste(dataset, "Integration", sep="_"),"iCluster"]=length(unique(groups_All))
}


Table_sil=data.frame(row.names = rows, PINS=rep(NA,length(rows)), CC=rep(NA,length(rows)), SNF=rep(NA,length(rows)), iCluster=rep(NA,length(rows)))

for (dataset in datasets) {
    resultFile=paste(PINSPath, "PINS_", dataset, ".RData" ,sep="")
    load(resultFile)
    
    mydatGE=dataList[[1]]
    # sds=apply(mydatGE,FUN=sd,MARGIN=2)
    # mydatGE=mydatGE[,order(sds, decreasing = T)[1:2000]]
    
    mydatME=dataList[[2]]
    # sds=apply(mydatME,FUN=sd,MARGIN=2)
    # mydatME=mydatME[,order(sds, decreasing = T)[1:2000]]
    
    mydatMI=dataList[[3]]
    # sds=apply(mydatMI,FUN=mad,MARGIN=2)
    # mydatMI=mydatMI[,order(sds, decreasing = T)[1:2000]]
    
    dataAll=cbind(mydatGE, mydatME, mydatMI)
    # sds=apply(dataAll,FUN=sd,MARGIN=2)
    # dataAll=dataAll[,order(sds, decreasing = T)[1:2000]]
    
    distGE=daisy(mydatGE)
    distME=daisy(mydatME)
    distMI=daisy(mydatMI)
    distAll=daisy(dataAll)
    
    groupsGE=result$dataTypeResult[[1]]$groups
    groupsME=result$dataTypeResult[[2]]$groups
    groupsMI=result$dataTypeResult[[3]]$groups
    groups=as.numeric(factor(result$groups))
    
    Table_sil[paste(dataset, "GE", sep="_"),"PINS"]=mean(silhouette(groupsGE, distGE)[,3])
    Table_sil[paste(dataset, "ME", sep="_"),"PINS"]=mean(silhouette(groupsME, distME)[,3])
    Table_sil[paste(dataset, "MI", sep="_"),"PINS"]=mean(silhouette(groupsMI, distMI)[,3])
    Table_sil[paste(dataset, "Integration", sep="_"),"PINS"]=mean(silhouette(groups, distAll)[,3])
    
    resultFile=paste(SNFPath, "SNF_", dataset, ".RData" ,sep="")
    load(resultFile)
    Table_sil[paste(dataset, "GE", sep="_"),"SNF"]=mean(silhouette(groupGE, distGE)[,3])
    Table_sil[paste(dataset, "ME", sep="_"),"SNF"]=mean(silhouette(groupME, distME)[,3])
    Table_sil[paste(dataset, "MI", sep="_"),"SNF"]=mean(silhouette(groupMI, distMI)[,3])
    Table_sil[paste(dataset, "Integration", sep="_"),"SNF"]=mean(silhouette(groupSNF, distAll)[,3])
    
    resultFile=paste(CCPath, "CC_", dataset, ".RData" ,sep="")
    load(resultFile)
    if (dataset=="KIRC") {
        kGE=6
        kME=6
        kMI=5
        kAll=6
    } else if (dataset=="GBM") {
        kGE=5
        kME=6
        kMI=6
        kAll=7
    } else if (dataset=="LAML") {
        kGE=5
        kME=7
        kMI=6
        kAll=8
    } else if (dataset=="LUSC") {
        kGE=5
        kME=9
        kMI=7
        kAll=6
    } else if (dataset=="BRCA") {
        kGE=8
        kME=8
        kMI=5
        kAll=7
    } else if (dataset=="COAD") {
        kGE=8
        kME=8
        kMI=7
        kAll=5
    }
    groupsGE=result_GE[[kGE]]$consensusClass
    groupsME=result_ME[[kME]]$consensusClass
    groupsMI=result_MI[[kMI]]$consensusClass
    groupsCC = result_All[[kAll]]$consensusClass
    
    Table_sil[paste(dataset, "GE", sep="_"),"CC"]=mean(silhouette(groupsGE, distGE)[,3])
    Table_sil[paste(dataset, "ME", sep="_"),"CC"]=mean(silhouette(groupsME, distME)[,3])
    Table_sil[paste(dataset, "MI", sep="_"),"CC"]=mean(silhouette(groupsMI, distMI)[,3])
    Table_sil[paste(dataset, "Integration", sep="_"),"CC"]=mean(silhouette(groupsCC, distAll)[,3])
    
    
    resultFile=paste(iClusterPlusPath, "iClusterPlus_", dataset, "_2000.RData" ,sep="")
    load(resultFile)
    clusters_GE=getClusters(cv.fitGE)
    clusters_ME=getClusters(cv.fitME)
    if (dataset=="GBM") clusters_MI=getClusters(cv.fitMI) else clusters_MI=NA
    clusters=getClusters(cv.fit)
    if (dataset=="KIRC") {
        kGE=8
        kME=9
        kMI=NA
        k=5
    } else if (dataset=="GBM") {
        kGE=9
        kME=9
        kMI=9
        k=4
    } else if (dataset=="LAML") {
        kGE=5
        kME=9
        kMI=NA
        k=4
    } else if (dataset=="LUSC") {
        kGE=6
        kME=9
        kMI=NA
        k=3
    } else if (dataset=="BRCA") {
        kGE=8
        kME=9
        kMI=NA
        k=9
    } else if (dataset=="COAD") {
        kGE=5
        kME=9
        kMI=NA
        k=9
    }
    
    groups_GE=clusters_GE[,kGE]
    groups_GE <- groups_GE; names(groups_GE) = rownames(survival)
    
    groups_ME=clusters_ME[,kME]
    groups_ME <- groups_ME; names(groups_ME) = rownames(survival)
    
    if (dataset=="GBM") {
        groups_MI=clusters_MI[,kMI]
        groups_MI <- groups_MI; names(groups_MI) = rownames(survival)
    } else {
        groups_MI=NA
    }
    
    groups_All=clusters[,k]
    groups_All <- groups_All; names(groups_All) = rownames(survival)
    
    Table_sil[paste(dataset, "GE", sep="_"),"iCluster"]=mean(silhouette(groupsGE, distGE)[,3])
    Table_sil[paste(dataset, "ME", sep="_"),"iCluster"]=mean(silhouette(groupsME, distME)[,3])
    if (dataset=="GBM") Table_sil[paste(dataset, "MI", sep="_"),"iCluster"]=mean(silhouette(groupsMI, distMI)[,3])
    Table_sil[paste(dataset, "Integration", sep="_"),"iCluster"]=mean(silhouette(groups_All, distAll)[,3])
}




LatexMakeTable_CI <- function(datasets, Table_cluster, Table_CI) {
    latexSource="\\toprule\n"
    latexSource=paste(latexSource,"\\multicolumn{3}{c}{TCGA dataset}&&\\multicolumn{2}{c}{PINS}&&\\multicolumn{2}{c}{CC}&&\\multicolumn{2}{c}{SNF}&&\\multicolumn{2}{c}{iClusterPlus}\\\\\n",sep="")
    latexSource=paste(latexSource, "\\cmidrule{1-3} \\cmidrule{5-6} \\cmidrule{8-9} \\cmidrule{11-12} \\cmidrule{14-15}\n", sep="")
    latexSource=paste(latexSource, "Name&\\#Patients&Data type&&k&CI&&k&CI&&k&CI&&k&CI\\\\\n", sep="")
    latexSource=paste(latexSource, "\\toprule\n", sep="")
    
    for (dataset in datasets) {
        latexSource=paste(latexSource, "\\multirow{3}{*}{", dataset, "}&\\multirow{3}{*}{", Patients[dataset], "}&mRNA", 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "PINS"], "&", round(Table_CI[paste(dataset,"GE", sep="_"), "PINS"],3), 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "CC"], "&", round(Table_CI[paste(dataset,"GE", sep="_"), "CC"], 3), 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "SNF"], "&", round(Table_CI[paste(dataset,"GE", sep="_"), "SNF"], 3), 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "iCluster"], "&", round(Table_CI[paste(dataset,"GE", sep="_"), "iCluster"], 3), "\\\\\n", sep="")
        latexSource=paste(latexSource, "&&Methylation",
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "PINS"], "&", round(Table_CI[paste(dataset,"ME", sep="_"), "PINS"],3), 
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "CC"], "&", round(Table_CI[paste(dataset,"ME", sep="_"), "CC"], 3), 
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "SNF"], "&", round(Table_CI[paste(dataset,"ME", sep="_"), "SNF"], 3), 
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "iCluster"], "&", round(Table_CI[paste(dataset,"ME", sep="_"), "iCluster"], 3), "\\\\\n", sep="")
        latexSource=paste(latexSource, "&&miRNA",
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "PINS"], "&", round(Table_CI[paste(dataset,"MI", sep="_"), "PINS"],3), 
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "CC"], "&", round(Table_CI[paste(dataset,"MI", sep="_"), "CC"], 3), 
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "SNF"], "&", round(Table_CI[paste(dataset,"MI", sep="_"), "SNF"], 3), 
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "iCluster"], "&", round(Table_CI[paste(dataset,"MI", sep="_"), "iCluster"], 3), "\\\\\n", sep="")
        latexSource=paste(latexSource, "\\cmidrule{3-3} \\cmidrule{5-6} \\cmidrule{5-6} \\cmidrule{8-9} \\cmidrule{11-12} \\cmidrule{14-15}\n", sep="")
        latexSource=paste(latexSource, "&&\\textbf{Integration}",
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "PINS"], "}&\\textbf{", round(Table_CI[paste(dataset,"Integration", sep="_"), "PINS"],3),"}", 
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "CC"], "}&\\textbf{", round(Table_CI[paste(dataset,"Integration", sep="_"), "CC"],3),"}", 
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "SNF"], "}&\\textbf{", round(Table_CI[paste(dataset,"Integration", sep="_"), "SNF"],3),"}", 
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "iCluster"], "}&\\textbf{", round(Table_CI[paste(dataset,"Integration", sep="_"), "iCluster"],3),"}", 
                          "\\\\\n", sep="")
        latexSource=paste(latexSource, "\\midrule\n", sep="")
    }
    
    latexSource
}



LatexMakeTable_sil <- function(datasets, Table_cluster, Table_sil) {
    latexSource="\\toprule\n"
    latexSource=paste(latexSource,"\\multicolumn{3}{c}{TCGA dataset}&&\\multicolumn{2}{c}{PINS}&&\\multicolumn{2}{c}{CC}&&\\multicolumn{2}{c}{SNF}&&\\multicolumn{2}{c}{iClusterPlus}\\\\\n",sep="")
    latexSource=paste(latexSource, "\\cmidrule{1-3} \\cmidrule{5-6} \\cmidrule{8-9} \\cmidrule{11-12} \\cmidrule{14-15}\n", sep="")
    latexSource=paste(latexSource, "Name&\\#Patients&Data type&&k&Silhouette&&k&Silhouette&&k&Silhouette&&k&Silhouette\\\\\n", sep="")
    latexSource=paste(latexSource, "\\toprule\n", sep="")
    
    for (dataset in datasets) {
        latexSource=paste(latexSource, "\\multirow{3}{*}{", dataset, "}&\\multirow{3}{*}{", Patients[dataset], "}&mRNA", 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "PINS"], "&", round(Table_sil[paste(dataset,"GE", sep="_"), "PINS"],3), 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "CC"], "&", round(Table_sil[paste(dataset,"GE", sep="_"), "CC"], 3), 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "SNF"], "&", round(Table_sil[paste(dataset,"GE", sep="_"), "SNF"], 3), 
                          "&&", Table_cluster[paste(dataset,"GE", sep="_"), "iCluster"], "&", round(Table_sil[paste(dataset,"GE", sep="_"), "iCluster"], 3), "\\\\\n", sep="")
        latexSource=paste(latexSource, "&&Methylation",
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "PINS"], "&", round(Table_sil[paste(dataset,"ME", sep="_"), "PINS"],3), 
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "CC"], "&", round(Table_sil[paste(dataset,"ME", sep="_"), "CC"], 3), 
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "SNF"], "&", round(Table_sil[paste(dataset,"ME", sep="_"), "SNF"], 3), 
                          "&&", Table_cluster[paste(dataset,"ME", sep="_"), "iCluster"], "&", round(Table_sil[paste(dataset,"ME", sep="_"), "iCluster"], 3), "\\\\\n", sep="")
        latexSource=paste(latexSource, "&&miRNA",
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "PINS"], "&", round(Table_sil[paste(dataset,"MI", sep="_"), "PINS"],3), 
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "CC"], "&", round(Table_sil[paste(dataset,"MI", sep="_"), "CC"], 3), 
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "SNF"], "&", round(Table_sil[paste(dataset,"MI", sep="_"), "SNF"], 3), 
                          "&&", Table_cluster[paste(dataset,"MI", sep="_"), "iCluster"], "&", round(Table_sil[paste(dataset,"MI", sep="_"), "iCluster"], 3), "\\\\\n", sep="")
        latexSource=paste(latexSource, "\\cmidrule{3-3} \\cmidrule{5-6} \\cmidrule{5-6} \\cmidrule{8-9} \\cmidrule{11-12} \\cmidrule{14-15}\n", sep="")
        latexSource=paste(latexSource, "&&\\textbf{Integration}",
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "PINS"], "}&\\textbf{", round(Table_sil[paste(dataset,"Integration", sep="_"), "PINS"],3),"}", 
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "CC"], "}&\\textbf{", round(Table_sil[paste(dataset,"Integration", sep="_"), "CC"],3),"}", 
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "SNF"], "}&\\textbf{", round(Table_sil[paste(dataset,"Integration", sep="_"), "SNF"],3),"}", 
                          "&&\\textbf{", Table_cluster[paste(dataset,"Integration", sep="_"), "iCluster"], "}&\\textbf{", round(Table_sil[paste(dataset,"Integration", sep="_"), "iCluster"],3),"}", 
                          "\\\\\n", sep="")
        latexSource=paste(latexSource, "\\midrule\n", sep="")
    }
    
    latexSource
}

cat(LatexMakeTable_CI(datasets, Table_cluster, Table_CI))

cat(LatexMakeTable_sil(datasets, Table_cluster, Table_sil))






