library(flexclust)
library(scales)
library(cluster)
library(survival)

### TCGA counter example
rm(list=ls())



# Please set dataPath and resultPath correctly
dataPath="~/Desktop/Projects/SubTyping/DataTCGA/"
resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/SilhouetteResult/"
Kmax=10
set.seed(800)
datasets=c("GBM", "KIRC", "LUSC", "BRCA", "COAD", "LAML")

pdfFile=paste(resultPath, "Silhouette_2type.pdf" ,sep="")
pdf(pdfFile)

for (dataset in datasets) {
  ####Using Perturbation-------------------------->
  file=paste(dataPath,dataset, "/", dataset, "_ProcessedData.RData" ,sep="") 
  load(file) 
  
  t1=Sys.time()
  
  patients=rownames(survival)
  patients=intersect(patients,rownames(mydatGE))
  patients=intersect(patients,rownames(mydatME))
  patients=intersect(patients,rownames(mydatMI))
  
  mydatGE=mydatGE[patients,]
  mydatME=mydatME[patients,]
  mydatMI=mydatMI[patients,]
  survival=survival[patients,]
  
  data_No_miRNA=cbind(mydatGE,mydatME)
  data_No_methyl=cbind(mydatGE, mydatMI)
  data_No_mRNA=cbind(mydatME, mydatMI)
  
  pca_No_miRNA=prcomp(data_No_miRNA)$x
  pca_No_methyl=prcomp(data_No_methyl)$x
  pca_No_mRNA=prcomp(data_No_mRNA)$x
  
  dist_No_miRNA=daisy(pca_No_miRNA)
  dist_No_methyl=daisy(pca_No_methyl)
  dist_No_mRNA=daisy(pca_No_mRNA)
  
  sil_No_miRNA=0
  group_No_miRNA=NULL
  for (i in 2:Kmax) {
    g <- kmeans(pca_No_miRNA, centers = i, 100, 20)$cluster
    if (mean(silhouette(g, dist_No_miRNA)[,3]) > sil_No_miRNA) {
      sil_No_miRNA <- mean(silhouette(g, dist_No_miRNA)[,3])
      group_No_miRNA <- g
    }
  }
  
  sil_No_methyl=0
  group_No_methyl=NULL
  for (i in 2:Kmax) {
    g <- kmeans(pca_No_methyl, centers = i, 100, 20)$cluster
    if (mean(silhouette(g, dist_No_methyl)[,3]) > sil_No_methyl) {
      sil_No_methyl <- mean(silhouette(g, dist_No_methyl)[,3])
      group_No_methyl <- g
    }
  }
  
  
  sil_No_mRNA=0
  group_No_mRNA=NULL
  for (i in 2:Kmax) {
    g <- kmeans(pca_No_mRNA, centers = i, 100, 20)$cluster
    if (mean(silhouette(g, dist_No_mRNA)[,3]) > sil_No_mRNA) {
      sil_No_mRNA <- mean(silhouette(g, dist_No_mRNA)[,3])
      group_No_mRNA <- g
    }
  }
  
  
  t2=Sys.time()
  print(t2-t1)
  
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(group_No_miRNA), data = survival, ties="exact")
  mfit <- survfit(Surv(Survival, Death == 1) ~ as.factor(group_No_miRNA), data = survival)
  plot(mfit, col=unique(group_No_miRNA), main = paste("Survival curves for mRNA+methyl ",dataset, " (Silhouette)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
  legend("topright", c(paste("Cox p-value:", round(summary(coxFit)$sctest[3],digits = 5), sep=""), paste0("silhouette:", sil_No_miRNA)))
  
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(group_No_methyl), data = survival, ties="exact")
  mfit <- survfit(Surv(Survival, Death == 1) ~ as.factor(group_No_methyl), data = survival)
  plot(mfit, col=unique(group_No_methyl), main = paste("Survival curves for mRNA+miRNA of ", dataset, " (Silhouette)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
  legend("topright", legend = c(paste("Cox p-value:", round(summary(coxFit)$sctest[3],digits = 5), sep=""), paste0("silhouette:", sil_No_methyl)))
  
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(group_No_mRNA), data = survival, ties="exact")
  mfit <- survfit(Surv(Survival, Death == 1) ~ as.factor(group_No_mRNA), data = survival)
  plot(mfit, col=unique(group_No_mRNA), main = paste("Survival curves for methyl+miRNA of ", dataset, " (Silhouette)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
  legend("topright", legend = c(paste("Cox p-value:", round(summary(coxFit)$sctest[3],digits = 5), sep=""), paste0("silhouette:", sil_No_mRNA)))
}

dev.off()
