rm(list=ls())

dataPath="~/Desktop/Projects/SubTyping/DataTCGA/"
resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/SNFResult/No_miRNA/"

# dataPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/DataTCGA/"
# resultPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/SNFResult/"

library(survival)
#load this last to reserve the distance function functions. 
#please restart your R
#For unknown reason, loading some other packages may change the SNF results slightly
library(SNFtool)

## First, set all the parameters:
K = 20;##number of neighbors, usually (10~30)
alpha = 0.5; ##hyperparameter, usually (0.3~0.8)
NIT = 10; ###Number of Iterations, usually (10~20)

set.seed(1)
for (dataset in c("LUSC", "GBM", "BRCA", "LAML", "KIRC", "COAD")) {
  prefix=paste(dataPath, dataset, "/", sep="")

  ####Using SNF -------------------------->
  file=paste(prefix, dataset, "_ProcessedData.RData" ,sep="")
  load(file)

  patients=rownames(survival)
  patients=intersect(patients,rownames(mydatGE))
  patients=intersect(patients,rownames(mydatME))
  patients=intersect(patients,rownames(mydatMI))

  mydatGE=mydatGE[patients,]
  mydatME=mydatME[patients,]
  mydatMI=mydatMI[patients,]
  survival=survival[patients,]


  # Normalization
  datGE = standardNormalization(mydatGE)
  datME = standardNormalization(mydatME)
  # datMI = standardNormalization(mydatMI)

  PSMgeneE = dist2(as.matrix(datGE),as.matrix(datGE));
  PSMmethy = dist2(as.matrix(datME),as.matrix(datME));
  # PSMmir = dist2(as.matrix(datMI),as.matrix(datMI));

  W1 = affinityMatrix(PSMgeneE, K, alpha)
  W2 = affinityMatrix(PSMmethy, K, alpha)
  # W3 = affinityMatrix(PSMmir, K, alpha)
  W = SNF(list(W1,W2), K, NIT)

  #####Clustering
  #Groups with just geneExpression
  CGE = estimateNumberOfClustersGivenGraph(W1, 2:10)[[1]]
  groupGE = spectralClustering(W1,CGE);
  #Groups with methylation
  CME = estimateNumberOfClustersGivenGraph(W2, 2:10)[[1]]
  groupME = spectralClustering(W2,CME);
  #Groups with microRNA
  # CMI = estimateNumberOfClustersGivenGraph(W3, 2:10)[[1]]
  # groupMI = spectralClustering(W3,CMI);
  #Groups with SNF
  C = estimateNumberOfClustersGivenGraph(W, 2:10)[[1]]
  groupSNF = spectralClustering(W,C); #the final subtypes information

  #Cox SNF
  groups <- factor(groupSNF); names(groups) = rownames(survival)
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ groups, data = survival, ties="exact")
  summary(coxFit)

  pdfFile=paste(resultPath, "SNF_", dataset, ".pdf" ,sep="")
  pdf(pdfFile)
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groups), data = survival)
  plot(mfit, col=unique(groups), main = paste("Survival curves for combined data of ", dataset, " (SNF)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
  legend("top", legend = paste("Cox p-value:", round(summary(coxFit)$sctest[3],digits = 5), sep=""))
  legend("topright", fill=levels(factor(groups)), legend=paste("Group ",levels(factor(groups)), ": ", table(groups)[levels(factor(groups))], sep=""))


  dev.off()
  ####Using SNF <--------------------------

  resultFile=paste(resultPath, "SNF_", dataset, ".RData" ,sep="")
  save(mydatGE, mydatME, mydatMI, groupSNF, file=resultFile)
}


# miRNA + methylation
dataPath="~/Desktop/Projects/SubTyping/DataTCGA/"
resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/SNFResult/No_mRNA/"
set.seed(1)
for (dataset in c("LUSC", "GBM", "BRCA", "LAML", "KIRC", "COAD")) {
  prefix=paste(dataPath, dataset, "/", sep="")
  
  ####Using SNF -------------------------->
  file=paste(prefix, dataset, "_ProcessedData.RData" ,sep="")
  load(file)
  
  
  patients=rownames(survival)
  patients=intersect(patients,rownames(mydatGE))
  patients=intersect(patients,rownames(mydatME))
  patients=intersect(patients,rownames(mydatMI))
  
  mydatGE=mydatGE[patients,]
  mydatME=mydatME[patients,]
  mydatMI=mydatMI[patients,]
  survival=survival[patients,]
  
  # Normalization
  # datGE = standardNormalization(mydatGE)
  datME = standardNormalization(mydatME)
  datMI = standardNormalization(mydatMI)
  
  # PSMgeneE = dist2(as.matrix(datGE),as.matrix(datGE));
  PSMmethy = dist2(as.matrix(datME),as.matrix(datME));
  PSMmir = dist2(as.matrix(datMI),as.matrix(datMI));
  
  # W1 = affinityMatrix(PSMgeneE, K, alpha)
  W2 = affinityMatrix(PSMmethy, K, alpha)
  W3 = affinityMatrix(PSMmir, K, alpha)
  W = SNF(list(W2,W3), K, NIT)
  
  #####Clustering
  #Groups with just geneExpression
  # CGE = estimateNumberOfClustersGivenGraph(W1, 2:10)[[1]]
  # groupGE = spectralClustering(W1,CGE);
  #Groups with methylation
  CME = estimateNumberOfClustersGivenGraph(W2, 2:10)[[1]]
  groupME = spectralClustering(W2,CME);
  #Groups with microRNA
  CMI = estimateNumberOfClustersGivenGraph(W3, 2:10)[[1]]
  groupMI = spectralClustering(W3,CMI);
  #Groups with SNF
  C = estimateNumberOfClustersGivenGraph(W, 2:10)[[1]]
  groupSNF = spectralClustering(W,C); #the final subtypes information

  
  #Cox SNF
  groups <- factor(groupSNF); names(groups) = rownames(survival)
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ groups, data = survival, ties="exact")
  summary(coxFit)
  
  
  pdfFile=paste(resultPath, "SNF_", dataset, ".pdf" ,sep="")  
  pdf(pdfFile)
  
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groups), data = survival)
  plot(mfit, col=unique(groups), main = paste("Survival curves for combined data of ", dataset, " (SNF)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
  legend("top", legend = paste("Cox p-value:", round(summary(coxFit)$sctest[3],digits = 5), sep=""))
  legend("topright", fill=levels(factor(groups)), legend=paste("Group ",levels(factor(groups)), ": ", table(groups)[levels(factor(groups))], sep=""))
  
  dev.off()
  ####Using SNF <--------------------------
  
  resultFile=paste(resultPath, "SNF_", dataset, ".RData" ,sep="")  
  save(mydatGE, mydatME, mydatMI, groupSNF, file=resultFile)
}




#mRNA+miRNA
dataPath="~/Desktop/Projects/SubTyping/DataTCGA/"
resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/SNFResult/No_methyl/"
set.seed(1)
for (dataset in c("LUSC", "GBM", "BRCA", "LAML", "KIRC", "COAD")) {
  prefix=paste(dataPath, dataset, "/", sep="")
  
  ####Using SNF -------------------------->
  file=paste(prefix, dataset, "_ProcessedData.RData" ,sep="")
  load(file)
  
  
  patients=rownames(survival)
  patients=intersect(patients,rownames(mydatGE))
  # patients=intersect(patients,rownames(mydatME))
  patients=intersect(patients,rownames(mydatMI))
  
  mydatGE=mydatGE[patients,]
  # mydatME=mydatME[patients,]
  mydatMI=mydatMI[patients,]
  survival=survival[patients,]
  
  
  # Normalization
  datGE = standardNormalization(mydatGE)
  # datME = standardNormalization(mydatME)
  datMI = standardNormalization(mydatMI)
  
  PSMgeneE = dist2(as.matrix(datGE),as.matrix(datGE));
  # PSMmethy = dist2(as.matrix(datME),as.matrix(datME));
  PSMmir = dist2(as.matrix(datMI),as.matrix(datMI));
  
  W1 = affinityMatrix(PSMgeneE, K, alpha)
  # W2 = affinityMatrix(PSMmethy, K, alpha)
  W3 = affinityMatrix(PSMmir, K, alpha)
  W = SNF(list(W1,W3), K, alpha)
  
  #####Clustering
  #Groups with just geneExpression
  CGE = estimateNumberOfClustersGivenGraph(W1, 2:10)[[1]]
  groupGE = spectralClustering(W1,CGE);
  #Groups with methylation
  # CME = estimateNumberOfClustersGivenGraph(W2, 2:10)[[1]]
  # groupME = spectralClustering(W2,CME);
  #Groups with microRNA
  CMI = estimateNumberOfClustersGivenGraph(W3, 2:10)[[1]]
  groupMI = spectralClustering(W3,CMI);
  #Groups with SNF
  C = estimateNumberOfClustersGivenGraph(W, 2:10)[[1]]
  groupSNF = spectralClustering(W,C); #the final subtypes information
  
  
  #Cox SNF
  groups <- factor(groupSNF); names(groups) = rownames(survival)
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ groups, data = survival, ties="exact")
  summary(coxFit)
  
  pdfFile=paste(resultPath, "SNF_", dataset, ".pdf" ,sep="")
  pdf(pdfFile)
  
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groups), data = survival)
  plot(mfit, col=unique(groups), main = paste("Survival curves for combined data of ", dataset, " (SNF)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
  legend("top", legend = paste("Cox p-value:", round(summary(coxFit)$sctest[3],digits = 5), sep=""))
  legend("topright", fill=levels(factor(groups)), legend=paste("Group ",levels(factor(groups)), ": ", table(groups)[levels(factor(groups))], sep=""))

  
  dev.off()
  ####Using SNF <--------------------------
  
  resultFile=paste(resultPath, "SNF_", dataset, ".RData" ,sep="")  
  save(mydatGE, mydatME, mydatMI, groupSNF, file=resultFile)
}


