rm(list=ls())
SNFPath="~/Desktop/Projects/SubTyping/PackageAndTesting/SNFResult/"
PINSPath="~/Desktop/Projects/SubTyping/PackageAndTesting/PINSResult/"
CCPath="~/Desktop/Projects/SubTyping/PackageAndTesting/CCResult/"
iClusterPlusPath="~/Desktop/Projects/SubTyping/PackageAndTesting/iClusterPlusResult/"
pdfPath="~/Desktop/Projects/SubTyping/PackageAndTesting/Plots/Figures/"

library("gplots")
library(survival)
library(iClusterPlus)


formatNumber <- function (x) {
  ret=0
  if (x>1) {
    ret=round(x,digits=2)
  } else {
    i=1
    while (x < 10^(-i)) {
      i=i+1
    }
    if (i>1) ret=round(x, digits = i+1) else ret=round(x, digits = i+2)
  }
  
  ret
}

for (dataset in c("GBM", "LUSC", "BRCA", "LAML", "KIRC", "COAD")) {
#for dataset in c("KIRC") {
  resultFile=paste(PINSPath, "PINS_", dataset, ".RData" ,sep="")
  load(resultFile)
  
  groups=result$groups
  groupsNew=result$groups2
  
  pdfFile=paste(pdfPath,"PINS_TCGA_", dataset, ".pdf",sep="") 
  pdf(pdfFile, height=5, width=7)
  #pdf(pdfFile)
  
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsNew), data = survival, ties="exact")    
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupsNew), data = survival)
  par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
  if (prod(groupsNew==groups)) {
    med=summary(mfit)$table[, "median"]
    ord=order(med) #this is the order according to mean
    colors=ord
  } else {
    a <-intersect(unique(groupsNew), unique(groups));names(a) <- intersect(unique(groupsNew), unique(groups)); a[setdiff(unique(groupsNew), unique(groups))] <- seq(setdiff(unique(groupsNew), unique(groups)))+max(groups)
    colors <- a[levels(factor(groupsNew))]
  }  
  plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
  a<- table(groupsNew)
  legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
  
  title(paste("PINS result, ", dataset, ", p = ",formatNumber(summary(coxFit)$sctest[3]), sep=""), cex.main=1.5)
  if (dataset%in%c("KIRC", "COAD")) {
    #legend("bottomright", legend = paste("Cox p-value: ", round(summary(coxFit)$sctest[3],digits = 6), sep=""), cex=1.2)
    legend("bottomleft", legend=legend, fill=colors, cex=1.2)  
  } else {
    #legend("topright", legend = paste("Cox p-value: ", round(summary(coxFit)$sctest[3],digits = 6), sep=""), cex=1.2)
    legend("topright", legend=legend, fill=colors, cex=1.2)  
  }
  dev.off()
  
  
  resultFile=paste(SNFPath, "SNF_", dataset, ".RData" ,sep="")
  load(resultFile)
  
  pdfFile=paste(pdfPath,"SNF_TCGA_", dataset, ".pdf",sep="")  
  pdf(pdfFile, height=5, width=7)
  #pdf(pdfFile)
  
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(groupSNF), data = survival, ties="exact")
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupSNF), data = survival)
  par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
  med=summary(mfit)$table[, "median"]
  ord=order(med) #this is the order according to mean
  colors=ord
  plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
  a<- table(groupSNF)
  legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
  
  title(paste("SNF result, ", dataset, ", p = ", formatNumber(summary(coxFit)$sctest[3]), sep=""), cex.main=1.5)
  if (dataset%in%c("KIRC", "COAD")) {
    #legend("bottomright", legend = paste("Cox p-value: ", round(summary(coxFit)$sctest[3],digits = 6), sep=""), cex=1.2)
    legend("bottomleft", legend=legend, fill=colors, cex=1.2)
  } else {
    #legend("topright", legend = paste("Cox p-value: ", round(summary(coxFit)$sctest[3],digits = 6), sep=""), cex=1.2)
    legend("topright", legend=legend, fill=colors, cex=1.2)
  }
  dev.off()
  
  
  
  resultFile=paste(CCPath, "CC_", dataset, ".RData" ,sep="")
  load(resultFile)
  if (dataset=="KIRC") {
      kAll=6
  } else if (dataset=="GBM") {
      kAll=7
  } else if (dataset=="LAML") {
      kAll=8
  } else if (dataset=="LUSC") {
      kAll=6
  } else if (dataset=="BRCA") {
      kAll=7
  } else if (dataset=="COAD") {
      kAll=5
  }
  
  groupsCC = result_All[[kAll]]$consensusClass
  
  pdfFile=paste(pdfPath,"CC_TCGA_", dataset, ".pdf",sep="")  
  pdf(pdfFile, height=5, width=7)
  #pdf(pdfFile)
  
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsCC), data = survival, ties="exact")
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupsCC), data = survival)
  par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
  med=summary(mfit)$table[, "median"]
  ord=order(med) #this is the order according to mean
  colors=ord
  plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
  a<- table(groupsCC)
  legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
  
  title(paste("CC result, ", dataset, ", p = ", formatNumber(summary(coxFit)$sctest[3]), sep=""), cex.main=1.5)
  if (dataset%in%c("KIRC", "COAD")) {
      legend("bottomleft", legend=legend, fill=colors, cex=1.2)
  } else {
      legend("topright", legend=legend, fill=colors, cex=1.2)
  }
  dev.off()
  
  
  
  
  
  resultFile=paste(iClusterPlusPath, "iClusterPlus_", dataset, "_2000.RData" ,sep="")
  load(resultFile)
  if (dataset=="KIRC") {
      k=5
  } else if (dataset=="GBM") {
      k=4
  } else if (dataset=="LAML") {
      k=4
  } else if (dataset=="LUSC") {
      k=3
  } else if (dataset=="BRCA") {
      k=9
  } else if (dataset=="COAD") {
      k=9
  }
  clusters=getClusters(cv.fit)
  groupsiCluster=clusters[,k]
  
  pdfFile=paste(pdfPath,"iClusterPlus_TCGA_", dataset, ".pdf",sep="")  
  pdf(pdfFile, height=5, width=7)
  #pdf(pdfFile)
  
  coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsiCluster), data = survival, ties="exact")
  mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupsiCluster), data = survival)
  par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
  med=summary(mfit)$table[, "median"]
  ord=order(med) #this is the order according to mean
  colors=ord
  plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
  a<- table(groupsiCluster)
  legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
  
  title(paste("iClusterPlus result, ", dataset, ", p = ", formatNumber(summary(coxFit)$sctest[3]), sep=""), cex.main=1.5)
  if (dataset%in%c("KIRC", "COAD")) {
      legend("bottomleft", legend=legend, fill=colors, cex=1.2)
  } else {
      legend("topright", legend=legend, fill=colors, cex=1.2)
  }
  dev.off()

}






