rm(list=ls())
SNFPath="~/Desktop/Projects/SubTyping/PackageAndTesting/SNFResult/"
PINSPath="~/Desktop/Projects/SubTyping/PackageAndTesting/PINSResult/"
CCPath="~/Desktop/Projects/SubTyping/PackageAndTesting/CCResult/"
iClusterPlusPath="~/Desktop/Projects/SubTyping/PackageAndTesting/iClusterPlusResult/"
pdfPath="~/Desktop/Projects/SubTyping/PackageAndTesting/Plots/Figures/"

library("gplots")
library(survival)
library(iClusterPlus)


formatNumber <- function (x) {
  ret=0
  if (x>1) {
    ret=round(x,digits=2)
  } else {
    i=1
    while (x < 10^(-i)) {
      i=i+1
    }
    if (i>1) ret=round(x, digits = i+1) else ret=round(x, digits = i+2)
  }
  
  ret
}

for (dataname in c("discovery","validation")) {
    
    # SNF results
    resultFile=paste(SNFPath, "SNF_METABRIC_", dataname, ".RData" ,sep="")
    load(resultFile)
    
    pdfFile=paste(pdfPath,"SNF_DFS_METABRIC_", dataname,".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survivalDFS[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupSNF), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupSNF), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupSNF), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groupSNF)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("SNF result (DFS), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    pdfFile=paste(pdfPath,"SNF_overall_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survival[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupSNF), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupSNF), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupSNF), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groupSNF)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("SNF result (overall), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    
    
    ### PAM50
    pdfFile=paste(pdfPath,"PAM50_DFS_METABRIC_", dataname,".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survivalDFS[patients,]
    group=clinical[patients,"Pam50_SUBTYPE"]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(group), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(group), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(group), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(group)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("PAM50 result (DFS), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    
    pdfFile=paste(pdfPath,"PAM50_overall_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survival[patients,]
    group=clinical[patients,"Pam50_SUBTYPE"]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(group), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(group), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(group), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(group)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("PAM50 result (overall), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    
    
    # Consensus clustering
    resultFile=paste(CCPath, "CC_METABRIC_", dataname, ".RData" ,sep="")
    load(resultFile)
    if (dataname=="discovery") {
        kAll=10
    } else if (dataname=="validation") {
        kAll=8
    }

    groupsCC = result_All[[kAll]]$consensusClass
    pdfFile=paste(pdfPath,"CC_DFS_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survivalDFS[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsCC), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsCC), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupsCC), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groupsCC)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("CC result (DFS), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    pdfFile=paste(pdfPath,"CC_overall_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survival[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsCC), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsCC), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupsCC), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groupsCC)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("CC result (overall), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    
    
    ## iclusterplus
    resultFile=paste(iClusterPlusPath, "iClusterPlus_METABRIC_", dataname, "_2000.RData" ,sep="")
    load(resultFile)
    if (dataname=="discovery") {
        k=9
    } else if (dataname=="validation") {
        k=8
    }
    clusters=getClusters(cv.fit)
    groupsiCluster=clusters[,k]

    pdfFile=paste(pdfPath,"iClusterPlus_DFS_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survivalDFS[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsiCluster), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsiCluster), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupsiCluster), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groupsiCluster)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("iClusterPlus result (DFS), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    pdfFile=paste(pdfPath,"iClusterPlus_overall_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survival[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsiCluster), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groupsiCluster), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groupsiCluster), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    med=summary(mfit)$table[, "median"]
    colors=order(med) #this is the order according to mean
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groupsiCluster)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("iClusterPlus result (overall), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
    
    
    
    
    ## PINS
    resultFile=paste(PINSPath, "PINS_METABRIC_", dataname, ".RData" ,sep="")
    load(resultFile)
    
    groups1=result$groups
    groups=result$groups2

    pdfFile=paste(pdfPath,"PINS_DFS_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survivalDFS[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groups), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groups), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groups), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    if (prod(groups1==groups)) {
        med=summary(mfit,rmean=TRUE)$table[, "median"]
        colors=order(med) #this is the order according to mean
    } else {
        a <-intersect(unique(groups), unique(groups1));names(a) <- intersect(unique(groups), unique(groups1)); a[setdiff(unique(groups), unique(groups1))] <- seq(setdiff(unique(groups), unique(groups1)))+max(groups1)
        colors <- a[levels(factor(groups))]
    }
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groups)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("PINS result (DFS), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()

    pdfFile=paste(pdfPath,"PINS_overall_METABRIC_", dataname, ".pdf",sep="")
    pdf(pdfFile, height=5, width=7.5)
    survi=survival[patients,]
    coxp=formatNumber(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groups), data = survi, ties="exact"))$sctest[3])
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ as.factor(groups), data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ factor(groups), data = survi)
    par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
    plot(mfit, col=colors, xlab = "Days", ylab="Survival probability", lwd=2, cex=1.3, cex.lab=1.3, cex.axis=1.2, cex.main=1.5)
    a<- table(groups)
    legend <- NULL;for (i in names(a)) {legend[i]=paste("Group ", i, ": ", a[i], sep="")}
    title(paste("PINS result (overall), ", dataname, ", p=", coxp, ", CI=", CI, sep=""), cex.main=1.5)
    legend("topright", legend=legend, fill=colors, cex=1.2)
    dev.off()
}






