rm(list=ls())

dataPath="~/Desktop/Projects/SubTyping/DataTCGA/"
resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/PINSResult/"
pdfPath="~/Desktop/Projects/Subtyping/PackageAndTesting/Plots/Figures/"

#datasets=c("KIRC", "LUSC", "BRCA", "LAML", "GBM", "COAD")

dataset="GBM"
resultFile=paste(resultPath, "PINS_", dataset, ".RData" ,sep="")
load(resultFile)


mutFile=paste(dataPath,dataset, "/", dataset, "_Mutation.RData", sep="")
load(mutFile)
groups=result$groups
groups2=result$groups2
group1Mut=apply(mydatMut[groups2=="1-2",], 2, FUN = sum)
group2Mut=apply(mydatMut[groups2=="2",], 2, FUN = sum)

pdfFile=paste(pdfPath,"GBM_Mutation.pdf",sep="")
pdf(pdfFile, height=5, width=7)
par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
plot(group1Mut, group2Mut, pch=8, cex.lab=1.3, cex.axis=1.2, cex.main=1.5, xlab="Group 1-2 (short-term survival)", ylab="Group 2 (long-term survival)")
title(paste("Mutations in ", dataset, " subtypes", sep=""), cex.main=1.5)
for (mut in c("IDH1","ATRX","TP53")) {
    x=group1Mut[mut]
    y=group2Mut[mut]
    text(x+1, y, mut, col="blue")
}
for (mut in c("PIK3R1", "PTEN","TTN","EGFR")) {
    x=group1Mut[mut]
    y=group2Mut[mut]
    text(x, y+0.5, mut, col="blue")
}
dev.off()





dataset="KIRC"
resultFile=paste(resultPath, "PINS_", dataset, ".RData" ,sep="")
load(resultFile)

mutFile=paste(dataPath,dataset, "/", dataset, "_Mutation.RData", sep="")
load(mutFile)
groups=result$groups
groups2=result$groups2
group2Mut=apply(mydatMut[groups2%in%c("1-2","2","3"),], 2, FUN = sum)
group1Mut=apply(mydatMut[groups2%in%c("1-1"),], 2, FUN = sum)

# pdfFile=paste(pdfPath,"KIRC_Mutation.pdf",sep="")
# pdf(pdfFile, height=5, width=7)
par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
plot(group1Mut, group2Mut, pch=8, cex.lab=1.3, cex.axis=1.2, cex.main=1.5, xlab="Group 1-1", ylab="Group 1-2, 2, and 3")
title(paste("Mutations in ", dataset, " subtypes", sep=""), cex.main=1.5)
for (mut in c("VHL")) {
    x=group1Mut[mut]
    y=group2Mut[mut]
    text(x, y+0.5, mut, col="blue")
}
# dev.off()



dataset="LAML"
resultFile=paste(resultPath, "PINS_", dataset, ".RData" ,sep="")
load(resultFile)

mutFile=paste(dataPath,dataset, "/", dataset, "_Mutation.RData", sep="")
load(mutFile)
mydatMut=mydatMut[,!colnames(mydatMut)%in%c("Unknown")]
groups=result$groups
groups2=result$groups2
group2Mut=apply(mydatMut[groups2%in%c("1","2","3"),], 2, FUN = sum)
group1Mut=apply(mydatMut[groups2%in%c("4"),], 2, FUN = sum)

pdfFile=paste(pdfPath,"LAML_Mutation.pdf",sep="")
pdf(pdfFile, height=5, width=7)
par(tcl=0.3,mgp=c(1.7,0.4,0),mar=c(3,3,3,1.2), xpd=T)
plot(group1Mut, group2Mut, pch=8, cex.lab=1.3, cex.axis=1.2, cex.main=1.5, xlab="Group 4 (short-term survival)", ylab="Group 1, 2, and 3 (long-term survival)")
title(paste("Mutations in ", dataset, " subtypes", sep=""), cex.main=1.5)
for (mut in c("DNMT3A","FLT3","NPM1")) {
    x=group1Mut[mut]
    y=group2Mut[mut]
    text(x + 0.9, y, mut, col="blue")
}
for (mut in c("RUNX1","TP53")) {
    x=group1Mut[mut]
    y=group2Mut[mut]
    text(x, y+3, mut, col="blue")
}
dev.off()
