rm(list=ls())

# Please set dataPath and resultPath correctly
dataPath="~/Desktop/Projects/SubTyping/METABRIC/"
resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/PINSResult/"

# dataPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/METABRIC/"
# resultPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/PINSResult/"


library(PINS)
library(survival)


for (dataset in c("METABRIC_discovery","METABRIC_validation")) {
    set.seed(1)
    file=paste(dataPath, dataset, ".RData" ,sep="")
    load(file)
    
    t1=Sys.time()
    
    mydatCNV=t(mydatCNV[,-c(1:5)])
    
    patients=rownames(survival)
    patients=intersect(patients,rownames(mydatGE))
    patients=intersect(patients,rownames(mydatCNV))
    
    mydatGE=mydatGE[patients,]
    mydatCNV=mydatCNV[patients,]
    
    dataList <- list(mydatGE, mydatCNV) 
    names(dataList) = c("GE", "CNV")
    
    result=SubtypingOmicsData(dataList = dataList, Kmax = 10, noisePercent = "med", iter = 200)

    t2=Sys.time()
    print(t2-t1)
    
    resultFile=paste(resultPath, "PINS_", dataset, ".RData" ,sep="")
    save(dataset, Kmax, patients, survivalDFS, survival, clinical, result, t1, t2, file=resultFile)
}


for (dataset in c("METABRIC_discovery","METABRIC_validation")) {
    resultFile=paste(resultPath, "PINS_", dataset, ".RData" ,sep="")
    load (resultFile)
    
    pdfFile=paste(resultPath, "PINS_", dataset, ".pdf" ,sep="")
    pdf(pdfFile)
    
    groups = result$groups
    groups2=result$groups2
    
    survi=survivalDFS[patients,]
    # gene expression
    groups=as.factor(result$dataTypeResult[[1]]$groups)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("DFS survival curves for gene expression of ",dataset, " (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    # CNV
    groups=as.factor(result$dataTypeResult[[2]]$groups)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("DFS survival curves for CNV of ", dataset, " (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    
    # level 1
    groups = as.factor(result$groups)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("DFS survival curves for ", dataset, ", level 1 (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    
    # level 2
    groups = as.factor(result$groups2)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("DFS survival curves for ", dataset, ", level 2 (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    
    
    
    survi=survival[patients,]
    # gene expression
    groups=as.factor(result$dataTypeResult[[1]]$groups)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("Overall survival curves for gene expression of ",dataset, " (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    # CNV
    groups=as.factor(result$dataTypeResult[[2]]$groups)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("Overall survival curves for CNV of ", dataset, " (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    
    # level 1
    groups = as.factor(result$groups)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("Overall survival curves for ", dataset, ", level 1 (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    
    # level 2
    groups = as.factor(result$groups2)
    coxp <- round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi, ties="exact"))$sctest[3],10)
    CI=round(summary(coxph(Surv(time = Survival, event = Death) ~ groups, data = survi))$concordance[1],3)
    mfit <- survfit(Surv(Survival, Death == 1) ~ groups, data = survi)
    plot(mfit, col=unique(groups), main = paste("Overall survival curves for ", dataset, ", level 2 (PINS)", sep=""), xlab = "Days", ylab="Survival", lwd=2)
    legend("topright", legend = paste("Cox p-value:", coxp, ", CI=", CI, sep=""))
    
    dev.off()
}

  
  