rm(list=ls())

# Please set dataPath and resultPath correctly
dataPath="~/Desktop/Projects/SubTyping/DataGEO/"
resultPath="~/Desktop/Projects/SubTyping/PackageAndTesting/PINSResult/"

# dataPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/DataGEO/"
# resultPath="/wsu/home/ex/ex60/ex6091/Subtyping/PackageAndTesting/PINSResult/"


library("flexclust")
library(PINS)

Kmax=10
iter=200
noisePercent="med"
kmIter=200

for (dataset in c("AML2004", "GSE10245", "GSE15061", "GSE19188","GSE14924", "Brain2002", "GSE43580","Lung2001")) {
  set.seed(1)
  
  print(paste("SUBTYPING ", dataset, sep=""))
  
  load(paste(dataPath,dataset,".RData",sep=""))
  
  data=(get(paste("gene_",dataset,sep="")))
  group=get(paste("group_",dataset,sep=""))
  #remove healthy samples
  data=data[!rownames(data)%in%rownames(group)[group[,2]=="healthy"],]
  group=group[!rownames(group)%in%rownames(group)[group[,2]=="healthy"],]
  
  t1=Sys.time()
  result = PerturbationClustering(data=data, Kmax = Kmax, noisePercent = "med", iter = iter, kmIter = kmIter)
  t2=Sys.time()
  
  print(t2-t1)
  
  resultFile=paste(resultPath, "PINS_", dataset, ".RData" ,sep="") 
  save(result, t1, t2, file=resultFile)
}


