#-----------------------------------------------------------------------------------+
#                                                                                   |
#                               LOAD CLEANED UP DATA                                |
#                                                                                   |
#-----------------------------------------------------------------------------------+

source("~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R/functions.r")

load(file="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R/one2one.7species.v5.Rdata")
load(file="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R/final.expression.tables.7species.v5.Rdata")
load(file="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R/final.expression.tables.lizard.ASU221.Rdata")

#####################################################################
#                       ENSEMBL 77 annotation
#####################################################################
# Male biased transcripts
#####################################################################

data=EM.full.7sp[["lizard"]]

colnames(data)
cutoff.exp=5
cutoff.ratio=1.5
MF.all = data[, 1:5] / data[, 6:10]
tissues.male.biased=list()
for (tissue in c("brain", "heart", "kidney", "liver")){
  male=paste(tissue, "male", sep=".")
  female=paste(tissue, "female", sep=".")
  MF = data[(data[,male] >= cutoff.exp), c(male, female)]
  ii = order(MF[,male], decreasing=T)
  MF = MF[ii,]
  MtoF=MF[MF[,male]/MF[,female] >= cutoff.ratio, ]
  tissues.male.biased[[tissue]] = rownames(MtoF)
}

male.genes = intersect.many.arrays(tissues.male.biased)
MF.all[male.genes, ]
data[male.genes,]


#######################################
# Female biased transcripts
#######################################

data=EM.full.7sp[["lizard"]]

colnames(data)
cutoff.exp=5
cutoff.ratio=1.5
FM.all = data[, 6:10] / data[, 1:5]
tissues.female.biased=list()
for (tissue in c("brain", "heart", "kidney", "liver")){
  male=paste(tissue, "male", sep=".")
  female=paste(tissue, "female", sep=".")
  FM = data[(data[,female] >= cutoff.exp), c(male, female)]
  ii = order(FM[,female], decreasing=T)
  FM = FM[ii,]
  FtoM=FM[FM[,female]/FM[,male] >= cutoff.ratio, ]
  tissues.female.biased[[tissue]] = rownames(FtoM)
}

female.genes = intersect.many.arrays(tissues.female.biased)
FM.all[female.genes, ]
data[female.genes,]



#####################################################################
#                       ASU 2.2.1 annotation
#####################################################################
# Male biased transcripts
#####################################################################

data=lizard.ASU

colnames(data)
cutoff.exp=5
cutoff.ratio=1.5
MF.all = data[, 1:5] / data[, 6:10]
tissues.male.biased=list()
for (tissue in c("brain", "heart", "kidney", "liver")){
  male=paste(tissue, "male", sep=".")
  female=paste(tissue, "female", sep=".")
  MF = data[(data[,male] >= cutoff.exp), c(male, female)]
  ii = order(MF[,male], decreasing=T)
  MF = MF[ii,]
  MtoF=MF[MF[,male]/MF[,female] >= cutoff.ratio, ]
  tissues.male.biased[[tissue]] = rownames(MtoF)
}

male.genes = intersect.many.arrays(tissues.male.biased)
MF.all[male.genes, ]
data[male.genes,]

# Output form the 12 Feb 2015
# > MF.all[male.genes, ]
# brain.male heart.male kidney.male liver.male gonads.male
# ASU_Acar_G.11200   1.705997   4.036785    1.543501   3.400395   0.8978113
# ASU_Acar_G.22613   2.119900   2.600644    1.637730   1.505294   2.6991770
# ASU_Acar_G.2659    2.256391   1.854835    1.984465   1.611109   1.6062207
# ASU_Acar_G.20945   2.453124   2.047403    1.733126   1.915998   3.6844442
# ASU_Acar_G.21683   3.950521   2.509196    2.372623   6.342342   0.8854526
# ASU_Acar_G.17409   5.958635   3.869570   20.467906   6.287936   9.3906026
# ASU_Acar_G.13858   2.185075   2.140276    1.584463   1.802592   1.1519455
# ASU_Acar_G.22361   2.547001   2.218808    1.597598   1.583753   1.0593819
# ASU_Acar_G.11951   8.495573   8.607416    7.514912   7.243375  18.0775540
# ASU_Acar_G.21682   1.513526   2.099439    1.704962   1.641324   1.7741223
# ASU_Acar_G.22592   5.634333   5.630534    2.732070   3.027507   0.7550051

#####################################################################
# Female biased transcripts
#####################################################################

data=lizard.ASU

colnames(data)
cutoff.exp=5
cutoff.ratio=1.5
FM.all = data[, 6:10] / data[, 1:5]
tissues.female.biased=list()
for (tissue in c("brain", "heart", "kidney", "liver")){
  male=paste(tissue, "male", sep=".")
  female=paste(tissue, "female", sep=".")
  FM = data[(data[,female] >= cutoff.exp), c(male, female)]
  ii = order(FM[,female], decreasing=T)
  FM = FM[ii,]
  FtoM=FM[FM[,female]/FM[,male] >= cutoff.ratio, ]
  tissues.female.biased[[tissue]] = rownames(FtoM)
}

female.genes = intersect.many.arrays(tissues.female.biased)
FM.all[female.genes, ]
data[female.genes,]


#-------------------------------------------------------------
# Plot of Fe65 expression in different species                |
#-------------------------------------------------------------

setwd("~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/Figures")
pdf(file = "expression_levels_Fe65_5species_v5.pdf", width = 5, height = 5)
par(mar=c(3,5,2,2))
plot(t(lizard.7sp["ENSACAG00000012505", 1:4]), type="b", ylim=c(0,350), col="red", lwd=1.5, axes=F, ylab="Expression level (FPKM)", xlab="", pch=16)
lines(t(lizard.7sp["ENSACAG00000012505", 6:9]), type="b", ylim=c(0,350), col="red", lwd=1.5, lty=2, pch=16)
lines(t(human.7sp["ENSG00000166313", 1:4]), lwd=1.5, col="orange", t="b", pch=0)
lines(t(human.7sp["ENSG00000166313", 6:9]), lwd=1.5, lty=2, col="orange", t="b", pch=0)
# lines(t(mouse.7sp["ENSMUSG00000037032", 1:4]), lwd=1.5, col="grey", t="b", pch=1) # Removed these not to make it so crowded
# lines(t(mouse.7sp["ENSMUSG00000037032", 6:9]), lwd=1.5, lty=2, col="grey", t="b", pch=1)
lines(t(opossum.7sp["ENSMODG00000018585", 1:4]), lwd=1.5, col="#0099ff", t="b", pch=1)
lines(t(opossum.7sp["ENSMODG00000018585", 6:9]), lwd=1.5, lty=2, col="#0099ff", t="b", pch=1)
lines(t(platypus.7sp["ENSOANG00000014174", 1:4]), lwd=1.5, col="#00cc00", t="b", pch=2)
lines(t(platypus.7sp["ENSOANG00000014174", 6:9]), lwd=1.5, lty=2, col="#00cc00", t="b", pch=2)
lines(t(chicken.7sp["ENSGALG00000029159", 1:4]), lwd=1.5, col="#777777", t="b", pch=5)
lines(t(chicken.7sp["ENSGALG00000029159", 6:9]), lwd=1.5, lty=2, col="#777777", t="b", pch=5)
axis(1, at=seq(1,4,by=1), labels=c("Brain", "Heart", "Kidney","Liver"), las=1, cex.axis=1, tick=FALSE, pos=-2.1)
axis(2, at=seq(0,350,by=50), labels=seq(0,350,by=50), las=2, xlab=F)

legend(3,350, legend=c("Male", "Female"), lty=c(1, 2), col=rep(c("black"),2), bty="n", horiz=F, inset=0,cex=0.7, adj=-0) 
legend(3,300, legend=c("Lizard","Human", "Opossum", "Platypus", "Chicken"), col=c("red", "orange", "#0099ff", "#00cc00", "#777777"), pch=c(16,0,1,2,5), bty="n", horiz=F, inset=0,cex=0.7, adj=-0) 
dev.off()


#-------------------------------------------------------------
# Extra stuff                                                |
#-------------------------------------------------------------
lizard.7sp["ENSACAG00000014691", ] # APP amyloid beta (A4) precursor protein. This gene is necessary for APBB1 (Fe65) to associate to chromatin
1 /(lizard.7sp["ENSACAG00000014691", 1:4] /  lizard.7sp["ENSACAG00000014691", 6:9])
lizard.7sp["ENSACAG00000008839", ] # Tip60.  Catalytic subunit of the NuA4 histone acetyltransferase complex which is involved in transcriptional activation of select genes principally by acetylation of nucleosomal histones H4 and H2A. This gene carries similar function as the MOF protein in Drosophila, i.e., acetylation of Lysine 16 to upregulate transcription.
1 /(lizard.7sp["ENSACAG00000008839", 1:4] /  lizard.7sp["ENSACAG00000008839", 6:9])

lizard.ASU["ASU_Acar_G.22450", ]  # APBB1 (Fe65)
lizard.7sp["ENSACAG00000012505", ]  # APBB1 (Fe65)
lizard.7sp["ENSACAG00000012505", 1:4] / lizard.7sp["ENSACAG00000012505", 6:9] 

lizard.dev.7sp["ENSACAG00000012505", ]
lizard.dev.7sp["ENSACAG00000012505", c("embryo.5_6d.male", "embryo.9d.male", "brain.15d.male", "heart.15d.male", "kidney.15d.male", "liver.15d.male")] /lizard.dev.7sp["ENSACAG00000012505", c("embryo.5_6d.female", "embryo.9d.female", "brain.15d.female", "heart.15d.female", "kidney.15d.female", "liver.15d.female")]


# MSL (DCC) complex in Drosophila
MLE.lizard = "ENSACAG00000005023"; MLE.human = "ENSG00000135829"  # 1-to-1 in both cases
MSL1.lizard = "ENSACAG00000002768"; MSL1.human = "ENSG00000188895"
MSL2.lizard = ""; MSL2.human = "ENSG00000174579"
MSL3.lizard = "ENSACAG00000001416"; MSL3.human = "ENSG00000005302"
MOF1.lizard = "ENSACAG00000012392"; MOF1.human = "ENSG00000083168" # MOF show 3 othologues in human
MOF2.lizard = "ENSACAG00000005025"; MOF2.human = "ENSG00000136504" # 
MOF3.lizard = "ENSACAG00000008709"; MOF3.human = "ENSG00000156650" # 
roX1.lizard = ""; roX1.human = ""
roX2.lizard = ""; roX2.human = ""

DCC.lizard = c(MLE.lizard, MSL1.lizard, MSL3.lizard, MOF1.lizard, MOF2.lizard, MOF3.lizard)
DCC.human = c(MLE.human, MSL1.human, MSL2.human, MSL3.human, MOF1.human, MOF2.human, MOF3.human)
lizard.7sp[DCC.lizard,1:4]/lizard.7sp[DCC.lizard,6:9]
human.7sp[DCC.human,1:4]/human.7sp[DCC.human,6:9]


subset(one2one.7sp, lizard == "ENSACAG00000022641")$human
subset(one2one.7sp, lizard == "ENSACAG00000002807")$human
subset(one2one.7sp, lizard == "ENSACAG00000023758")$human
subset(one2one.7sp, lizard == "")$human
subset(one2one.7sp, lizard == "")$human
subset(one2one.7sp, lizard == "")$human
subset(one2one.7sp, lizard == "")$human


one2one.7sp["ENSG00000147099",]
EM.full.7sp.un[["human"]]["ENSG00000147099",1:3]/  EM.full.7sp.un[["human"]]["ENSG00000147099",6:8]
EM.full.7sp.un[["mouse"]][one2one.7sp["ENSG00000147099","mouse"],1:3]/ EM.full.7sp.un[["mouse"]][one2one.7sp["ENSG00000147099","mouse"],6:8]
EM.full.7sp.un[["opossum"]][one2one.7sp["ENSG00000147099","opossum"],1:3]/ EM.full.7sp.un[["opossum"]][one2one.7sp["ENSG00000147099","opossum"],6:8]
EM.full.7sp.un[["platypus"]][one2one.7sp["ENSG00000147099","platypus"],1:3]/ EM.full.7sp.un[["platypus"]][one2one.7sp["ENSG00000147099","platypus"],6:8]
EM.full.7sp.un[["chicken"]][one2one.7sp["ENSG00000147099","chicken"],1:3]/ EM.full.7sp.un[["chicken"]][one2one.7sp["ENSG00000147099","chicken"],6:8]
EM.full.7sp.un[["xenopus"]][one2one.7sp["ENSG00000147099","xenopus"],1:3]/ EM.full.7sp.un[["xenopus"]][one2one.7sp["ENSG00000147099","xenopus"],6:8]


