path="/Users/agkaessmann/Projects/Anolis/Documentation_dosage_compensation"
source(paste0(path, "/Scripts_R/functions.r"))

load(file=paste0(path, "/one2one.6sp.no.xenopus.Rdata"))
load(file=paste0(path, "/Rdata/expression.all.7species.normal.v5.Rdata"))
load(file=paste0(path, "/Rdata/final.expression.tables.7species.v5.Rdata"))

##############################################################################
#            Select X, proto-X, autosome and proto-autosome genes            #
##############################################################################
#                               6 Species                                    #
##############################################################################

human.one2one.6sp = one2one.6sp.no.xenopus[, "human"]
human.A = human.7sp[human.7sp[,"AXY"]=="A", "gene"]
human.AK = human.7sp[(human.7sp[,"AXY"]=="A" | human.7sp[,"AXY"]=="UNK"), "gene"]
human.A.one2one.6sp = intersect(human.A, human.one2one.6sp)
human.AK.one2one.6sp = intersect(human.AK, human.one2one.6sp)
h.human.A.one2one.6sp = one2one.6sp.no.xenopus[which(human.one2one.6sp %in% human.A.one2one.6sp), 1]
h.human.AK.one2one.6sp = one2one.6sp.no.xenopus[which(human.one2one.6sp %in% human.AK.one2one.6sp), 1]
human.X = human.7sp[human.7sp[,"AXY"]=="X", "gene"]
human.X.one2one.6sp = intersect(human.X, human.one2one.6sp)
h.human.X.one2one.6sp = one2one.6sp.no.xenopus[which(human.one2one.6sp %in% human.X.one2one.6sp), 1]
length(h.human.A.one2one.6sp)
length(h.human.AK.one2one.6sp)
length(h.human.X.one2one.6sp)

mouse.one2one.6sp = one2one.6sp.no.xenopus[, "mouse"]
mouse.A = mouse.7sp[mouse.7sp[,"AXY"]=="A", "gene"]
mouse.AK = mouse.7sp[(mouse.7sp[,"AXY"]=="A" | mouse.7sp[,"AXY"]=="UNK"), "gene"]
mouse.A.one2one.6sp = intersect(mouse.A, mouse.one2one.6sp)
mouse.AK.one2one.6sp = intersect(mouse.AK, mouse.one2one.6sp)
h.mouse.A.one2one.6sp = one2one.6sp.no.xenopus[which(mouse.one2one.6sp %in% mouse.A.one2one.6sp), 1]
h.mouse.AK.one2one.6sp = one2one.6sp.no.xenopus[which(mouse.one2one.6sp %in% mouse.AK.one2one.6sp), 1]
mouse.X = mouse.7sp[mouse.7sp[,"AXY"]=="X", "gene"]
mouse.X.one2one.6sp = intersect(mouse.X, mouse.one2one.6sp)
h.mouse.X.one2one.6sp = one2one.6sp.no.xenopus[which(mouse.one2one.6sp %in% mouse.X.one2one.6sp), 1]
length(h.mouse.A.one2one.6sp)
length(h.mouse.AK.one2one.6sp)
length(h.mouse.X.one2one.6sp)

opossum.one2one.6sp = one2one.6sp.no.xenopus[, "opossum"]
opossum.A = opossum.7sp[opossum.7sp[,"AXY"]=="A", "gene"]
opossum.AK = opossum.7sp[(opossum.7sp[,"AXY"]=="A" | opossum.7sp[,"AXY"]=="UNK"), "gene"]
opossum.A.one2one.6sp = intersect(opossum.A, opossum.one2one.6sp)
opossum.AK.one2one.6sp = intersect(opossum.AK, opossum.one2one.6sp)
h.opossum.A.one2one.6sp = one2one.6sp.no.xenopus[which(opossum.one2one.6sp %in% opossum.A.one2one.6sp), 1]
h.opossum.AK.one2one.6sp = one2one.6sp.no.xenopus[which(opossum.one2one.6sp %in% opossum.AK.one2one.6sp), 1]
opossum.X = opossum.7sp[opossum.7sp[,"AXY"]=="X", "gene"]
opossum.X.one2one.6sp = intersect(opossum.X, opossum.one2one.6sp)
h.opossum.X.one2one.6sp = one2one.6sp.no.xenopus[which(opossum.one2one.6sp %in% opossum.X.one2one.6sp), 1]
length(h.opossum.A.one2one.6sp)
length(h.opossum.AK.one2one.6sp)
length(h.opossum.X.one2one.6sp)

platypus.one2one.6sp = one2one.6sp.no.xenopus[, "platypus"]
platypus.A = platypus.7sp[platypus.7sp[,"AXY"]=="A", "gene"]
platypus.AK = platypus.7sp[(platypus.7sp[,"AXY"]=="A" | platypus.7sp[,"AXY"]=="UNK"), "gene"]
platypus.A.one2one.6sp = intersect(platypus.A, platypus.one2one.6sp)
platypus.AK.one2one.6sp = intersect(platypus.AK, platypus.one2one.6sp)
h.platypus.A.one2one.6sp = one2one.6sp.no.xenopus[which(platypus.one2one.6sp %in% platypus.A.one2one.6sp), 1]
h.platypus.AK.one2one.6sp = one2one.6sp.no.xenopus[which(platypus.one2one.6sp %in% platypus.AK.one2one.6sp), 1]
platypus.X = platypus.7sp[platypus.7sp[,"AXY"]=="X", "gene"]
platypus.X.one2one.6sp = intersect(platypus.X, platypus.one2one.6sp)
h.platypus.X.one2one.6sp = one2one.6sp.no.xenopus[which(platypus.one2one.6sp %in% platypus.X.one2one.6sp), 1]
length(h.platypus.A.one2one.6sp)
length(h.platypus.AK.one2one.6sp)
length(h.platypus.X.one2one.6sp)

chicken.one2one.6sp = one2one.6sp.no.xenopus[, "chicken"]
chicken.A = chicken.7sp[chicken.7sp[,"AXY"]=="A", "gene"]
chicken.AK = chicken.7sp[(chicken.7sp[,"AXY"]=="A" | chicken.7sp[,"AXY"]=="UNK"), "gene"]
chicken.A.one2one.6sp = intersect(chicken.A, chicken.one2one.6sp)
chicken.AK.one2one.6sp = intersect(chicken.AK, chicken.one2one.6sp)
h.chicken.A.one2one.6sp = one2one.6sp.no.xenopus[which(chicken.one2one.6sp %in% chicken.A.one2one.6sp), 1]
h.chicken.AK.one2one.6sp = one2one.6sp.no.xenopus[which(chicken.one2one.6sp %in% chicken.AK.one2one.6sp), 1]
chicken.X = chicken.7sp[chicken.7sp[,"AXY"]=="X", "gene"]
chicken.X.one2one.6sp = intersect(chicken.X, chicken.one2one.6sp)
h.chicken.X.one2one.6sp = one2one.6sp.no.xenopus[which(chicken.one2one.6sp %in% chicken.X.one2one.6sp), 1]
length(h.chicken.A.one2one.6sp)
length(h.chicken.AK.one2one.6sp)
length(h.chicken.X.one2one.6sp)

lizard.one2one.6sp = one2one.6sp.no.xenopus[, "lizard"]
lizard.A = lizard.7sp[lizard.7sp[,"AXY"]=="A", "gene"]
lizard.AK = lizard.7sp[(lizard.7sp[,"AXY"]=="A" | lizard.7sp[,"AXY"]=="UNK"), "gene"]
lizard.A.one2one.6sp = intersect(lizard.A, lizard.one2one.6sp)
lizard.AK.one2one.6sp = intersect(lizard.AK, lizard.one2one.6sp)
h.lizard.A.one2one.6sp = one2one.6sp.no.xenopus[which(lizard.one2one.6sp %in% lizard.A.one2one.6sp), 1]
h.lizard.AK.one2one.6sp = one2one.6sp.no.xenopus[which(lizard.one2one.6sp %in% lizard.AK.one2one.6sp), 1]
lizard.X = lizard.7sp[lizard.7sp[,"AXY"]=="X", "gene"]
lizard.X.one2one.6sp = intersect(lizard.X, lizard.one2one.6sp)
h.lizard.X.one2one.6sp = one2one.6sp.no.xenopus[which(lizard.one2one.6sp %in% lizard.X.one2one.6sp), 1]
length(h.lizard.A.one2one.6sp)
length(h.lizard.AK.one2one.6sp)
length(h.lizard.X.one2one.6sp)

one2one.6sp.X.A.genes.no.xenopus = list(
  "humanX"=h.human.X.one2one.6sp, "humanA"= h.human.A.one2one.6sp, "humanAK"= h.human.AK.one2one.6sp,
  "mouseX"=h.mouse.X.one2one.6sp, "mouseA"=h.mouse.A.one2one.6sp, "mouseAK"=h.mouse.AK.one2one.6sp,
  "opossumX"=h.opossum.X.one2one.6sp, "opossumA"=h.opossum.A.one2one.6sp, "opossumAK"=h.opossum.AK.one2one.6sp,
  "chickenX"=h.chicken.X.one2one.6sp, "chickenA"=h.chicken.A.one2one.6sp, "chickenAK"=h.chicken.AK.one2one.6sp,
  "platypusX"=h.platypus.X.one2one.6sp, "platypusA"=h.platypus.A.one2one.6sp, "platypusAK"=h.platypus.AK.one2one.6sp,
  "lizardX"=h.lizard.X.one2one.6sp, "lizardA"=h.lizard.A.one2one.6sp, "lizardAK"=h.lizard.AK.one2one.6sp)

save(one2one.6sp.X.A.genes.no.xenopus, file=paste0(path, "/one2one.6sp.X.A.genes.no.xenopus.Rdata"))