#clear workspace
rm(list=ls())

library(ggplot2)
library(gridExtra)
load("~/Dropbox/Anolis_paper/Rdata/log2.chip.genic.2k.up.AX.GC.cor.10k.Rdata")
all.data.genic <- all.data
rm(all.data)
load("~/Dropbox/Anolis_paper/Rdata/log2.chip.intergenic.2k.AX.GC.cor.10k.Rdata")
all.data.intergenic <- all.data
rm(all.data)

all.data.genic$location <- rep("genic", nrow(all.data.genic))
all.data.intergenic$location <- rep("intergenic", nrow(all.data.intergenic))
all.data <- rbind(all.data.genic, all.data.intergenic)
all.data$location <- factor(all.data$location, levels = c("intergenic", "genic")) 

######
# All chromosomes Main
######

###### Run Mann-Whitney test
for (s in unique(all.data.genic$sample)){
  print(s)
  x <- subset(all.data, sample == s)
  y <- wilcox.test(log2ratio ~ location, data = x)
  print(y)
  if(y$p.value > 0.05){
    y$symbol <- "ns"
  }
  if(y$p.value <= 0.05){
    y$symbol <- "*"
  }
  if(y$p.value <= 0.01){
    y$symbol <- "**"
  }
  if(y$p.value <= 0.001){
    y$symbol <- "***"
  }
  if(y$p.value <= 0.0001){
    y$symbol <- "****"
  }
  assign(paste0(s,".","MW"), y)
}

pvalues <- c(F1040_Lv_H4K16ac.MW$p.value, F127012016_Lv_H4K16ac.MW$p.value,
             F1040_WB_H4K16ac.MW$p.value, F127012016_WB_H4K16ac.MW$p.value,
             M11060514_Lv_H4K16ac.MW$p.value, M127012016_Lv_H4K16ac.MW$p.value,
             M11060514_WB_H4K16ac.MW$p.value, M127012016_WB_H4K16ac.MW$p.value)

qvalues <- p.adjust(pvalues, method = "BH")

female.liver <- ggplot(subset(all.data, sample == "F1040_Lv_H4K16ac"), aes(x=sample, y=log2ratio)) +
  #ggtitle("Liver") +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.text.y = element_text(face = "bold", size = 20),
        axis.title.y = element_text(face = "bold", size = 20),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_Lv_H4K16ac.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = F127012016_Lv_H4K16ac.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

female.brain <- ggplot(subset(all.data, sample == "F1040_WB_H4K16ac"), aes(x=sample, y=log2ratio)) +
  #ggtitle("Brain") +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(), 
        axis.text.x = element_blank(),
        legend.position = "none",
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_WB_H4K16ac.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = F127012016_WB_H4K16ac.MW$symbol, size = 5) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2640", size = 15) +
  ylab(NULL) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

male.liver <- ggplot(subset(all.data, sample == "M127012016_Lv_H4K16ac"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  #ggtitle("Liver") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.title.y = element_blank(),
        axis.line.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = M11060514_Lv_H4K16ac.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = M127012016_Lv_H4K16ac.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

male.brain <- ggplot(subset(all.data, sample == "M127012016_WB_H4K16ac"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  #ggtitle("Brain") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(),
        axis.text.x = element_blank(),
        legend.position = "none",
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = M11060514_WB_H4K16ac.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = M127012016_WB_H4K16ac.MW$symbol, size = 5) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2642", size = 15) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

setwd("~/Dropbox/Anolis_paper/")
cairo_pdf(file = "Figures/Final/log2.ChIP.Input.genic.intergenic.GC.cor.A.boxplot.pdf",family = "Arial", height = 4, width = 16)
grid.arrange(female.liver, male.liver, female.brain,  male.brain, nrow = 1, ncol = 4)
dev.off()

######
# All chromosomes Supplemental
######

###### Run Mann-Whitney test
for (s in unique(all.data.genic$sample)){
  print(s)
  x <- subset(all.data, sample == s)
  y <- wilcox.test(log2ratio ~ location, data = x)
  print(y)
  if(y$p.value > 0.05){
    y$symbol <- "ns"
  }
  if(y$p.value <= 0.05){
    y$symbol <- "*"
  }
  if(y$p.value <= 0.01){
    y$symbol <- "**"
  }
  if(y$p.value <= 0.001){
    y$symbol <- "***"
  }
  if(y$p.value <= 0.0001){
    y$symbol <- "****"
  }
  assign(paste0(s,".","MW"), y)
}

pvalues <- c(F1040_Lv_H4K16ac.MW$p.value, F127012016_Lv_H4K16ac.MW$p.value,
             F1040_WB_H4K16ac.MW$p.value, F127012016_WB_H4K16ac.MW$p.value,
             M11060514_Lv_H4K16ac.MW$p.value, M127012016_Lv_H4K16ac.MW$p.value,
             M11060514_WB_H4K16ac.MW$p.value, M127012016_WB_H4K16ac.MW$p.value)

p.adjust(pvalues, method = "BH")

female.liver <- ggplot(subset(all.data, sex=="F" & tissue=="liver"), aes(x=sample, y=log2ratio)) +
  ggtitle("Liver") +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.text.y = element_text(face = "bold", size = 15),
        axis.title.y = element_text(face = "bold", size = 15),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_Lv_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = F127012016_Lv_H4K16ac.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

female.brain <- ggplot(subset(all.data, sex=="F" & tissue=="brain"), aes(x=sample, y=log2ratio)) +
  ggtitle("Brain") +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(), 
        axis.text.x = element_blank(),
        legend.position = "none",
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_WB_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = F127012016_WB_H4K16ac.MW$symbol, size = 5) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2640", size = 15) +
  ylab(NULL) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

male.liver <- ggplot(subset(all.data, sex=="M" & tissue=="liver"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  ggtitle("Liver") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.title.y = element_blank(),
        axis.line.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = M11060514_Lv_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = M127012016_Lv_H4K16ac.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

male.brain <- ggplot(subset(all.data, sex=="M" & tissue=="brain"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=location), notch = F) +
  theme_classic() +
  ggtitle("Brain") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(),
        axis.text.x = element_blank(),
        legend.position = "none",
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = M11060514_WB_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = M127012016_WB_H4K16ac.MW$symbol, size = 5) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2642", size = 15) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

setwd("~/Dropbox/Anolis_paper/")
cairo_pdf(file = "Figures/Final/Supplemental/log2.ChIP.Input.genic.intergenic.GC.cor.A.boxplot.pdf",family = "Arial", height = 4, width = 16)
grid.arrange(female.liver, female.brain, male.liver, male.brain, nrow = 1, ncol = 4)
dev.off()

######
# Autosomes
######

###### Run Mann-Whitney test
for (s in unique(all.data.genic$sample)){
  print(s)
  x <- subset(all.data, sample == s & chr.type == "A")
  y <- wilcox.test(log2ratio ~ location, data = x)
  print(y)
  if(y$p.value > 0.05){
    y$symbol <- "ns"
  }
  if(y$p.value <= 0.05){
    y$symbol <- "*"
  }
  if(y$p.value <= 0.01){
    y$symbol <- "**"
  }
  if(y$p.value <= 0.001){
    y$symbol <- "***"
  }
  if(y$p.value <= 0.0001){
    y$symbol <- "****"
  }
  assign(paste0(s,".","MW"), y)
}


female.liver.A <- ggplot(subset(all.data, sex == "F" & tissue == "liver" & chr.type == "A"), aes(x=sample, y=log2ratio)) +
  ggtitle("Liver") +
  geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_text(face = "bold", size = 7),
        axis.text.y = element_text(face = "bold", size = 15),
        axis.title.y = element_text(face = "bold", size = 15),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_Lv_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = F127012016_Lv_H4K16ac.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Pastel1")

female.brain.A <- ggplot(subset(all.data, sex=="F" & tissue=="brain" & chr.type == "A"), aes(x=sample, y=log2ratio)) +
   geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
   theme_classic() +
   ggtitle("Brain") +
   theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
         axis.ticks.x = element_blank(),
         axis.ticks.y = element_blank(),
         axis.text.y = element_blank(),
         axis.line.y = element_blank(), 
         axis.text.x = element_text(face = "bold", size = 7),
         legend.title=element_blank(),
         legend.text=element_text(face = "bold", size = 15),
         legend.key=element_rect(fill = "white", colour = "white"),
         panel.grid.major.y = element_line(colour = "grey87")) +
   annotate("text", x = 1, y = 2, label = F1040_WB_H4K16ac.MW$symbol, size = 5) +
   annotate("text", x = 2, y = 2, label = F127012016_WB_H4K16ac.MW$symbol, size = 5) +
   annotate("text", x = 2.5, y = 1.5, label = "\u2640", size = 12) +
   ylab(NULL) +
   ylim(c(-2,2)) +
   labs(x=NULL, y=NULL) +
   scale_fill_brewer(palette = "Pastel1") +
  geom_hline(yintercept = 0, linetype = "dashed")

male.liver.A <- ggplot(subset(all.data, sex=="M" & tissue=="liver" & chr.type == "A"), aes(x=sample, y=log2ratio)) +
   geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
   theme_classic() +
   theme(legend.position = "none",
         axis.ticks.x = element_blank(),
         axis.text.x = element_text(face = "bold", size = 7),
         axis.text.y = element_text(face = "bold", size = 15),
         axis.title.y = element_text(face = "bold", size = 15),
         panel.grid.major.y = element_line(colour = "grey87")) +
   annotate("text", x = 1, y = 2, label = M11060514_Lv_H4K16ac.MW$symbol, size = 5) +
   annotate("text", x = 2, y = 2, label = M127012016_Lv_H4K16ac.MW$symbol, size = 5) +
   ylim(c(-2,2)) +
   labs(y="log2(ChIP/Input)", x=NULL) +
   scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed") 

male.brain.A <- ggplot(subset(all.data, sex=="M" & tissue=="brain" & chr.type == "A"), aes(x=sample, y=log2ratio)) +
   geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
   theme_classic() +
   theme(axis.ticks.x = element_blank(),
         axis.ticks.y = element_blank(),
         axis.text.y = element_blank(),
         axis.line.y = element_blank(),
         axis.text.x = element_text(face = "bold", size = 7),
         legend.title=element_blank(),
         legend.text=element_text(face = "bold", size = 15),
         legend.key=element_rect(fill = "white", colour = "white"),
         panel.grid.major.y = element_line(colour = "grey87")) +
   annotate("text", x = 2.5, y = 1.5, label = "\u2642", size = 12) +
   annotate("text", x = 1, y = 2, label = M11060514_WB_H4K16ac.MW$symbol, size = 5) +
   annotate("text", x = 2, y = 2, label = M127012016_WB_H4K16ac.MW$symbol, size = 5) +
   ylim(c(-2,2)) +
   labs(x=NULL, y=NULL) +
   scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

cairo_pdf(file = "Figures/Final//log2.ChIP.Input.genic.intergenic.GC.cor.A.boxplot.pdf",family = "Arial", height = 10, width = 10)
grid.arrange(female.liver.A, female.brain.A,
             male.liver.A, male.brain.A, nrow = 2, ncol = 2, top = textGrob("Autosomes", gp=gpar(fontsize=25, fontface="bold")))
dev.off()

######
# X chromosome
######

###### Run Mann-Whitney test
for (s in unique(all.data.genic$sample)){
  print(s)
  x <- subset(all.data, sample == s & chr.type == "X")
  y <- wilcox.test(log2ratio ~ location, data = x)
  print(y)
  if(y$p.value > 0.05){
    y$symbol <- "ns"
  }
  if(y$p.value <= 0.05){
    y$symbol <- "*"
  }
  if(y$p.value <= 0.01){
    y$symbol <- "**"
  }
  if(y$p.value <= 0.001){
    y$symbol <- "***"
  }
  if(y$p.value <= 0.0001){
    y$symbol <- "****"
  }
  assign(paste0(s,".","MW"), y)
}

female.liver.X <- ggplot(subset(all.data, sex == "F" & tissue == "liver" & chr.type == "X"), aes(x=sample, y=log2ratio)) +
  ggtitle("Liver") +
  geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_text(face = "bold", size = 7),
        axis.text.y = element_text(face = "bold", size = 15),
        axis.title.y = element_text(face = "bold", size = 15),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_Lv_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = F127012016_Lv_H4K16ac.MW$symbol, size = 5) + 
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Pastel1") +
  geom_hline(yintercept = 0, linetype = "dashed")

female.brain.X <- ggplot(subset(all.data, sex=="F" & tissue=="brain" & chr.type == "X"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
  theme_classic() +
  ggtitle("Brain") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(), 
        axis.text.x = element_text(face = "bold", size = 7),
        legend.title=element_blank(),
        legend.text=element_text(face = "bold", size = 15),
        legend.key=element_rect(fill = "white", colour = "white"),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_WB_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = F127012016_WB_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2.5, y = 1.5, label = "\u2640", size = 12) +
  ylab(NULL) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_brewer(palette = "Pastel1") +
  geom_hline(yintercept = 0, linetype = "dashed")

male.liver.X <- ggplot(subset(all.data, sex=="M" & tissue=="liver" & chr.type == "X"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
  theme_classic() +
  theme(legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_text(face = "bold", size = 7),
        axis.text.y = element_text(face = "bold", size = 15),
        axis.title.y = element_text(face = "bold", size = 15),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = M11060514_Lv_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = M127012016_Lv_H4K16ac.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

male.brain.X <- ggplot(subset(all.data, sex=="M" & tissue=="brain" & chr.type == "X"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=location), notch = T, outlier.size = 1) +
  theme_classic() +
  theme(axis.ticks.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(),
        axis.text.x = element_text(face = "bold", size = 7),
        legend.title=element_blank(),
        legend.text=element_text(face = "bold", size = 15),
        legend.key=element_rect(fill = "white", colour = "white"),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 2.5, y = 1.5, label = "\u2642", size = 12) +
  annotate("text", x = 1, y = 2, label = M11060514_WB_H4K16ac.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = M127012016_WB_H4K16ac.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_brewer(palette = "Set3") +
  geom_hline(yintercept = 0, linetype = "dashed")

cairo_pdf(file = "Figures/Final/log2.ChIP.Input.genic.intergenic.GC.cor.X.boxplot.pdf",family = "Arial", height = 10, width = 10)
grid.arrange(female.liver.X, female.brain.X,
             male.liver.X, male.brain.X, nrow = 2, ncol = 2, top = textGrob("X", gp=gpar(fontsize=25, fontface="bold")))
dev.off()
