#clear workspace
rm(list=ls())

library(ggplot2)
library(grid)
library(gridExtra)
library(RColorBrewer)
setwd("~/Dropbox/Anolis_paper/Rdata/")
load("log2.chip.AX.GC.cor.10k.Rdata")

# All data
#---------
###### Run Mann-Whitney test
for (s in unique(all.data$sample)){
  print(s)
  x <- subset(all.data, sample == s)
  y <- wilcox.test(log2ratio ~ chr.type, data = x)
  print(y)
  if(y$p.value > 0.05){
    y$symbol <- "n.s."
  }
  if(y$p.value <= 0.05){
    y$symbol <- "*"
  }
  if(y$p.value <= 0.01){
    y$symbol <- "**"
  }
  if(y$p.value <= 0.001){
    y$symbol <- "***"
  }
  if(y$p.value <= 0.0001){
    y$symbol <- "****"
  }
  assign(paste0(s,".","MW"), y)
}

pvalues <- c(F1040_Lv_H4K16ac.MW$p.value, F127012016_Lv_H4K16ac.MW$p.value,
             F1040_WB_H4K16ac.MW$p.value, F127012016_WB_H4K16ac.MW$p.value,
             M11060514_Lv_H4K16ac.MW$p.value, M127012016_Lv_H4K16ac.MW$p.value,
             M11060514_WB_H4K16ac.MW$p.value, M127012016_WB_H4K16ac.MW$p.value)

qvalues <- p.adjust(pvalues, method = "BH")

female.liver <- ggplot(subset(all.data, sex=="F" & tissue=="liver"), aes(x=sample, y=log2ratio)) +
  ggtitle("Liver") +
  geom_boxplot(aes(fill=chr.type), notch = F) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.text.y = element_text(face = "bold", size = 20),
        axis.title.y = element_text(face = "bold", size = 20),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_Lv_H4K16ac.MW$symbol, size = 10) +
  annotate("text", x = 2, y = 2, label = F127012016_Lv_H4K16ac.MW$symbol, size = 10) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_manual(values = c("#FB9A99", "#E31A1C")) +
  geom_hline(yintercept = 0, linetype = "dashed")

female.brain <- ggplot(subset(all.data, sex=="F" & tissue=="brain"), aes(x=sample, y=log2ratio)) +
  ggtitle("Brain") +
  geom_boxplot(aes(fill=chr.type ), notch = F) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(), 
        axis.text.x = element_blank(),
        legend.position = "none",
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = F1040_WB_H4K16ac.MW$symbol, size = 10) +
  annotate("text", x = 2, y = 2, label = F127012016_WB_H4K16ac.MW$symbol, size = 10) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2640", size = 15) +
  ylab(NULL) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_manual(values = c("#FB9A99", "#E31A1C")) +
  geom_hline(yintercept = 0, linetype = "dashed")

male.liver <- ggplot(subset(all.data, sex=="M" & tissue=="liver"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=chr.type), notch = F) +
  theme_classic() +
  ggtitle("Liver") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.title.y = element_blank(),
        axis.line.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = M11060514_Lv_H4K16ac.MW$symbol, size = 10) +
  annotate("text", x = 2, y = 2, label = M127012016_Lv_H4K16ac.MW$symbol, size = 10) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_manual(values = c("#A6CEE3", "#1F78B4")) +
  geom_hline(yintercept = 0, linetype = "dashed")

male.brain <- ggplot(subset(all.data, sex=="M" & tissue=="brain"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=chr.type), notch = F) +
  theme_classic() +
  ggtitle("Brain") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(),
        axis.text.x = element_blank(),
        legend.position = "none",
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = M11060514_WB_H4K16ac.MW$symbol, size = 10) +
  annotate("text", x = 2, y = 2, label = M127012016_WB_H4K16ac.MW$symbol, size = 10) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2642", size = 15) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_manual(values = c("#A6CEE3", "#1F78B4")) +
  geom_hline(yintercept = 0, linetype = "dashed")

setwd("~/Dropbox/Anolis_paper/")
cairo_pdf(file = "Figures/Final/log2.ChIP.Input.GC.cor.boxplot.pdf",family = "Arial", height = 4, width = 16)
grid.arrange(female.liver, female.brain,
             male.liver, male.brain, nrow = 1,ncol = 4)
dev.off()