# install.packages("fields")
# library(fields)
library("gplots")
path="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/"
source(paste0(path, "/R/functions.r"))

load(file=paste0(path, "/R/one2one.7species.v5.Rdata"))
load(file=paste0(path, "/R/one2one.7species.X.A.genes.v5.Rdata"))
load(file=paste0(path, "/R/final.expression.tables.7species.v5.Rdata"))
load(file=paste0(path, "/R/all.genes.v5.Rdata"))





# Old Y annotation
XYgametologs <- read.table("~/Documents/Research/Genomics/Lizard/Ensembl/lizard.XY.gametologs.edited", head=F, sep="\t", fill=TRUE, stringsAsFactors=F)
colnames(XYgametologs) = c("Y", "X")
XYgametologs

# New Y annotation
XYgametologs <- read.table("~/Documents/Research/Genomics/Lizard/Ensembl/lizard.XY.gametologs.v2", head=F, sep="\t", fill=TRUE, stringsAsFactors=F)
XYgametologs = XYgametologs[1:7,]
colnames(XYgametologs) = c("Y", "X")
XYgametologs

save(XYgametologs, file="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R/xygametologs.Rdata")
# load(file="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R/xygametologs.Rdata")


####################################################################################
#                          Expression during development                           #
####################################################################################

lizard.all = cbind(lizard.dev.7sp, lizard.7sp)
colnames(lizard.all)
colnames(lizard.7sp)
lizard.all[XYgametologs[,1],]
lizard.7sp[XYgametologs[,1],]

male = grep("d.male", colnames(lizard.dev.7sp), value=T, invert=F)
embryo =  intersect(male, grep("embryo", colnames(lizard.dev.7sp), value=T, invert=F))

testis.all = c(embryo, intersect(male, grep("gonads", colnames(lizard.dev.7sp), value=T)), "gonads.male")
brain.all = c(embryo, intersect(male, grep("brain", colnames(lizard.dev.7sp), value=T)), "brain.male")
heart.all = c(embryo, intersect(male, grep("heart", colnames(lizard.dev.7sp), value=T)), "heart.male")
kidney.all = c(embryo, intersect(male, grep("kidney", colnames(lizard.dev.7sp), value=T)), "kidney.male")
liver.all = c(embryo, intersect(male, grep("liver", colnames(lizard.dev.7sp), value=T)), "liver.male")

testis = c(intersect(male, grep("gonads", colnames(lizard.dev.7sp), value=T)), "gonads.male")
brain = c(intersect(male, grep("brain", colnames(lizard.dev.7sp), value=T)), "brain.male")
heart = c(intersect(male, grep("heart", colnames(lizard.dev.7sp), value=T)), "heart.male")
kidney = c(intersect(male, grep("kidney", colnames(lizard.dev.7sp), value=T)), "kidney.male")
liver = c(intersect(male, grep("liver", colnames(lizard.dev.7sp), value=T)), "liver.male")

testis
brain
heart
kidney
liver

# Plot of every stage (both gametologs) in lines format
#------------------------------------------------------
setwd(paste0(path, "/Figures"))
pdf(file = "XY_gamtologs_exp_profiles_v5.pdf", width = 13, height = 10)
par(mfrow=c(7,8), oma=c(1,1,0,0), mar=c(1,0,0,0))

plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.5, 0.3, "RPL6\nds=1.73", cex=2, col="black")
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.5, 0.3, "UBE2L3\nds=0.69", cex=2, col="black")
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.5, 0.3, "RTDR1\nds=0.62", cex=2, col="black")
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.5, 0.3, "PPP1CC\nds=0.58", cex=2, col="black")
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.5, 0.3, "DENR\nds=0.34", cex=2, col="black")
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.5, 0.3, "EWSR1\nds=0.15", cex=2, col="black")
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.5, 0.3, "SLC5A1\nds=0.078", cex=2, col="black")
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n') 

plot.develop.lizard(embryo, size.label=0.8)
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.3, 0.5, "Embryo", cex=2, col="black")
plot.develop.lizard(brain, size.label=0.8)
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.3, 0.5, "Brain", cex=2, col="black")
plot.develop.lizard(heart, size.label=0.8)
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.3, 0.5, "Heart", cex=2, col="black")
plot.develop.lizard(kidney, size.label=0.8)
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.3, 0.5, "Kidney", cex=2, col="black")
plot.develop.lizard(liver, size.label=0.8)
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.3, 0.5, "Liver", cex=2, col="black")
plot.develop.lizard(testis, size.label=0.8)
plot(c(0,1), c(0,1), ann=F, bty="n", type='n', xaxt='n', yaxt='n'); text(0.3, 0.5, "Testis", cex=2, col="black")

dev.off()



####################################################################################
#                          Tissue Specificity Gametologs                           #
####################################################################################


# Manually adding genes that could be considered as 1-to-1 orthologs
#-------------------------------------------------------------------

# 1:1: orthologs
subset(one2one.7sp, lizard %in% XYgametologs[,"X"])
XYgametologs
Xgametolog.one2one=subset(one2one.7sp, lizard %in% XYgametologs[,"X"])
Xgametolog.one2one
EM_one2one.7sp.collapsed.tmp = EM_one2one.7sp.collapsed

# DENR: in E73 only one ortholog was reported but there was another copy (ENSOANG00000011417) tagged as "possible ortholog". In E77 this second copy was included officialy as an ortholog and has in fact better homolgy
EM_one2one.7sp.collapsed.tmp["ENSG00000139726", ] = Xgametolog.one2one["ENSG00000139726", ] = c("ENSG00000139726", "ENSMUSG00000023106", "ENSMODG00000012302", "ENSOANG00000011417", "ENSGALG00000003795", "ENSACAG00000016012", "ENSXETG00000005791")
Xgametolog.one2one

# RPL6: only lizard and mouse have paralogs of this gene, but in both cases one of the copies is a pseudogene
EM_one2one.7sp.collapsed.tmp["ENSG00000089009", ] = Xgametolog.one2one["ENSG00000089009", ] = c("ENSG00000089009", "ENSMUSG00000029614", "ENSMODG00000003096", "ENSOANG00000004808", "ENSGALG00000004818", "ENSACAG00000003060", "ENSXETG00000004304")
Xgametolog.one2one

# SLC5A1 There are two copies in human. We use the copy that has the highest homololgy in lizard, chicken and xenopus. In the other species the are 1:1 orthologs
EM_one2one.7sp.collapsed.tmp["ENSG00000100170", ] = Xgametolog.one2one["ENSG00000100170", ] = c("ENSG00000100170", "ENSMUSG00000011034", "ENSMODG00000009915", "ENSOANG00000003573", "ENSGALG00000006728", "ENSACAG00000002264", "ENSXETG00000004206")
Xgametolog.one2one

# UBE2L3 There are several copies in human. The best match is a pseudogene so Diego took the second best match. It has several orthologs in mouse, opossum, chicken, lizard and xenopus. It doesn't have ortholog in Platypus


# Analysis for gametologs 
#----------------------------------------------------------

lizard.15d = lizard.dev.7sp[, c("brain.15d.male", "heart.15d.male", "kidney.15d.male", "liver.15d.male", "gonads.15d.male")]
lizard.16d = lizard.dev.7sp[, c("brain.16d.male", "heart.16d.male", "kidney.16d.male", "liver.16d.male", "gonads.16d.male")]
lizard.adult = lizard.7sp[, c("brain.male", "heart.male", "kidney.male", "liver.male", "gonads.male")]
lizard.adult.female = lizard.7sp[, c("brain.female", "heart.female", "kidney.female", "liver.female", "gonads.female")]

# Analysis for protoX of gametologs
#----------------------------------------------------------

# Male
# -------
protoX.brain = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "brain.male"], 
                           EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "brain.male"],
                           EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "brain.male"],
                           EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "brain.male"],
                           EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "brain.male"]), 1, median)

protoX.heart = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "heart.male"], 
                           EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "heart.male"],
                           EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "heart.male"],
                           EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "heart.male"],
                           EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "heart.male"]), 1, median)

protoX.kidney = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "kidney.male"], 
                            EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "kidney.male"],
                            EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "kidney.male"],
                            EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "kidney.male"],
                            EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "kidney.male"]), 1, median)

protoX.liver = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "liver.male"], 
                           EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "liver.male"],
                           EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "liver.male"],
                           EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "liver.male"],
                           EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "liver.male"]), 1, median)

protoX.gonads = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "gonads.male"], 
                            EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "gonads.male"],
                            EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "gonads.male"],
                            EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "gonads.male"],
                            EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "gonads.male"]), 1, median)
protoX.male=cbind(protoX.brain, protoX.heart, protoX.kidney, protoX.liver, protoX.gonads)

# The results show that RTDR1 was already testis specific explainig why this is the only gene for which both gametologs are testis specific!

# Female
# -------
protoX.brain = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "brain.female"], 
                           EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "brain.female"],
                           EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "brain.female"],
                           EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "brain.female"],
                           EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "brain.female"]), 1, median)

protoX.heart = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "heart.female"], 
                           EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "heart.female"],
                           EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "heart.female"],
                           EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "heart.female"],
                           EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "heart.female"]), 1, median)

protoX.kidney = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "kidney.female"], 
                            EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "kidney.female"],
                            EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "kidney.female"],
                            EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "kidney.female"],
                            EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "kidney.female"]), 1, median)

protoX.liver = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "liver.female"], 
                           EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "liver.female"],
                           EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "liver.female"],
                           EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "liver.female"],
                           EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "liver.female"]), 1, median)

protoX.gonads = apply(cbind(EM.full.7sp[["mouse"]][Xgametolog.one2one$mouse, "gonads.female"], 
                            EM.full.7sp[["opossum"]][Xgametolog.one2one$opossum, "gonads.female"],
                            EM.full.7sp[["platypus"]][Xgametolog.one2one$platypus, "gonads.female"],
                            EM.full.7sp[["chicken"]][Xgametolog.one2one$chicken, "gonads.female"],
                            EM.full.7sp[["xenopus"]][Xgametolog.one2one$xenopus, "gonads.female"]), 1, median)
protoX.female=cbind(protoX.brain, protoX.heart, protoX.kidney, protoX.liver, protoX.gonads)

matrix1=cbind(TE.for.image(lizard.adult, "X"),
                TE.for.image(lizard.adult, "Y"),
                TE.for.image.proto(protoX.male),
                TE.for.image(lizard.adult.female, "X", female=1),
                TE.for.image.proto(protoX.female, female=1))
matrix1[matrix1==0] = NA
matrix1[is.na(matrix1)] = NA
matrix1.text = matrix1%%1
matrix1.text[matrix1.text==0] = 1.000

tissue.colors = c(rep("#cccccc", 20),
                  colorRampPalette( c("navy", "cyan2"))(20),
                  colorRampPalette( c("darkorchid4", "orchid1"))(20),
                  colorRampPalette( c("#550000", "orangered1"))(20),
                  colorRampPalette( c("orange4", "orange1"))(20),
                  colorRampPalette( c("#003300", "olivedrab1"))(20),
                  colorRampPalette( c("yellow4", "yellow1"))(20))
genes.ordered= c("RPL6", "UBE2L3", "RTDR1","PPP1CC", "DENR", "EWSR1", "SLC5A1")
organs = c("Brain", "Heart", "Kidney", "Testis", "Ovary")
tissue.colors2 = c("cyan2", "orchid1", "orangered1", "olivedrab1", "yellow1")

setwd(paste0(path, "/Figures"))
pdf(file = "TE_XY_gamtologs_v5.pdf", width = 10, height = 10)
mylwid=c(1,6) 
mylhei=c(1,6)
heatmap.2((matrix1), density.info="none", trace="none", Colv="NA", Rowv="NA", dendrogram="none",  labRow=genes.ordered, labCol=c("X", "Y", "protoX", "X", "protoX"), cexCol=2, cexRow=2, scale="none", col=tissue.colors, key=F, colsep=seq(1,6), rowsep=seq(1,6), sepwidth=c(0.02,0.02), na.color="#cccccc", cellnote=signif(matrix1.text,2), notecex=2.0, breaks=seq(0,7,length.out=141), notecol="#000000", srtCol=0, margins=c(9,8),  lhei=mylhei, lwid=mylwid, adjCol=c(0.5,1))
axis(1, at=c(0.07,0.55), tick=T, labels=F, lwd.ticks=0)
axis(1, at=c(0.58, 0.9), tick=T, labels=F, lwd.ticks=0)
mtext(c("Male", "Female"), at=c(0.32, 0.7), side=1, line=1, adj=c(0.5,0), cex=1.5 )
legend("top", legend=organs, col=tissue.colors2, pch=rep(15,6), bty="n", horiz=T, inset=0,cex=1.5) 
dev.off()


matrix2=cbind(TE.for.image(lizard.adult, "X"),
                TE.for.image(lizard.adult, "Y"),
                TE.for.image.proto(protoX.male),
                TE.for.image(lizard.15d, "X"),
                TE.for.image(lizard.15d, "Y"),
                TE.for.image(lizard.16d, "X"),
                TE.for.image(lizard.16d, "Y"))
matrix2[matrix2==0] = NA
matrix2[is.na(matrix2)] = NA
matrix2.text = matrix2%%1
matrix2.text[matrix2.text==0] = 1.000

setwd(paste0(path, "/Figures"))
pdf(file = "TE_XY_gamtologs_dev_v5.pdf", width = 10, height = 10)
mylwid=c(1,6) 
mylhei=c(1,6)
heatmap.2((matrix2), density.info="none", trace="none", Colv="NA", Rowv="NA", dendrogram="none",  labRow=genes.ordered, labCol=c("X", "Y", "protoX", "X 15d", "Y 15d", "X 16d", "Y 16d"), cexCol=1.5, cexRow=2, scale="none", col=tissue.colors, key=F, colsep=seq(1,6), rowsep=seq(1,6), sepwidth=c(0.02,0.02), na.color="#cccccc", cellnote=signif(matrix2.text,2), notecex=2.0, breaks=seq(0,7,length.out=141), notecol="#000000", srtCol=0, margins=c(6,8),  lhei=mylhei, lwid=mylwid, adjCol=c(0.5,1))
legend("top", legend=organs, col=tissue.colors2, pch=rep(15,5), bty="n", horiz=T, inset=0,cex=1.5) 
dev.off()




# image.plot(t(matrix2)[,7:1], col=colramp(200), zlim=c(1,7))
# image.plot(t(matrix2)[,7:1], col=tissue.colors, zlim=c(0.02,7.02) )
# image(t(matrix2)[,7:1], col=tissue.colors, zlim=c(0.02,7.02), axes=F )
# grid(nx=7,ny=7, col="white", lwd=2, lty=1)
# axis(1, at=seq(0,6)/6, labels=c("X", "Y", "protoX", "X 15d", "Y 15d", "X 16d", "Y 16d"), las=1, cex.axis=0.7, tick=F, pos=-0.05)
# axis(2, at=seq(0,6)/6, labels=rev(genes.ordered), las=1, cex.axis=0.7, tick=F, pos=-0.05)




