library(Hmisc)

reset.par = function(){
  dev.new()
  op <- par(no.readonly = TRUE)
  dev.off()
  op
}

X.to.protoX.ratio.2sp = function(target, target.sample, tissue, remove.inf=TRUE, sex="both"){
  #target="human"
  #target.sample = "human"
  #tissue="Brain"
  #sex="male"
  targetX=paste(target, "X", sep="")
  targetA=paste(target, "A", sep="")
  
  target.protoX = intersect(one2one.X.A.genes[[targetX]], intersect(one2one.X.A.genes[["chickenA"]], one2one.X.A.genes[["platypusA"]]))
  target.protoA = intersect(one2one.X.A.genes[[targetA]], intersect(one2one.X.A.genes[["chickenA"]], one2one.X.A.genes[["platypusA"]]))
  if (sex=="male"){
    if (tissue=="Gonads"){
      target.protoX.Male = apply(EM_one2one_hk[target.protoX, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"))], 1, median)
      target.protoA.Male = apply(EM_one2one_hk[target.protoA, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"))], 1, median)
      
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]      
    }else{
      target.protoX.Male = apply(EM_one2one_hk[target.protoX, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"))], 1, median)
      target.protoA.Male = apply(EM_one2one_hk[target.protoA, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"))], 1, median)
            
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
        
    target.XtoA.Male = target.X.Male/median(target.A.Male)
        
    target.matrix=log2(target.XtoA.Male/target.protoXtoA.Male)
  }else{
    if (tissue=="Gonads"){
      target.protoX.Male = apply(EM_one2one_hk[target.protoX, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"))], 1, median)
      target.protoX.Female = apply(EM_one2one_hk[target.protoX, c(paste("platypus", "Ovary", "Female", sep="_"), paste("chicken", "Ovary", "Female", sep="_"))], 1, median)
      target.protoA.Male = apply(EM_one2one_hk[target.protoA, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"))], 1, median)
      target.protoA.Female = apply(EM_one2one_hk[target.protoA, c(paste("platypus", "Ovary", "Female", sep="_"), paste("chicken", "Ovary", "Female", sep="_"))], 1, median)
      
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]
      target.X.Female = EM_one2one_hk[target.protoX, paste(target.sample, "Ovary", "Female", sep="_")]
      target.A.Female = EM_one2one_hk[target.protoA, paste(target.sample, "Ovary", "Female", sep="_")]
    }else{
      target.protoX.Male = apply(EM_one2one_hk[target.protoX, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"))], 1, median)
      target.protoX.Female = apply(EM_one2one_hk[target.protoX, c(paste("platypus", tissue, "Female", sep="_"), paste("chicken", tissue, "Female", sep="_"))], 1, median)
      target.protoA.Male = apply(EM_one2one_hk[target.protoA, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"))], 1, median)
      target.protoA.Female = apply(EM_one2one_hk[target.protoA, c(paste("platypus", tissue, "Female", sep="_"), paste("chicken", tissue, "Female", sep="_"))], 1, median)
      
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
      target.X.Female = EM_one2one_hk[target.protoX, paste(target.sample, tissue, "Female", sep="_")]
      target.A.Female = EM_one2one_hk[target.protoA, paste(target.sample, tissue, "Female", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    target.protoXtoA.Female = target.protoX.Female/median(target.protoA.Female)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    target.XtoA.Female = target.X.Female/median(target.A.Female)
    
    target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                             target.XtoA.Female/target.protoXtoA.Female))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

X.to.protoX.ratio.1sp = function(target, target.sample, tissue, outgroup, outgroup.sample, remove.inf=TRUE, sex="both"){
#   target="lizard"
#   target.sample = "lizard1"
#   tissue="Brain"
#   outgroup="human"
#   outgroup.sample="human"
  targetX=paste(target, "X", sep="")
  targetA=paste(target, "A", sep="")
  outgroupA=paste(outgroup, "A", sep="")
  
  target.protoX = intersect(one2one.X.A.genes[[targetX]], one2one.X.A.genes[[outgroupA]])
  target.protoA = intersect(one2one.X.A.genes[[targetA]], one2one.X.A.genes[[outgroupA]])
  
  if (sex=="male"){
    if(tissue=="Gonads"){
      target.protoX.Male = EM_one2one_hk[target.protoX, paste(outgroup.sample, "Testis", "Male", sep="_")]
      target.protoA.Male = EM_one2one_hk[target.protoA, paste(outgroup.sample, "Testis", "Male", sep="_")]
      
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]
    }else{
      target.protoX.Male = EM_one2one_hk[target.protoX, paste(outgroup.sample, tissue, "Male", sep="_")]
      target.protoA.Male = EM_one2one_hk[target.protoA, paste(outgroup.sample, tissue, "Male", sep="_")]
      
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    
    target.matrix=log2(target.XtoA.Male/target.protoXtoA.Male)
  }else{
    if(tissue=="Gonads"){
      target.protoX.Male = EM_one2one_hk[target.protoX, paste(outgroup.sample, "Testis", "Male", sep="_")]
      target.protoA.Male = EM_one2one_hk[target.protoA, paste(outgroup.sample, "Testis", "Male", sep="_")]
      target.protoX.Female = EM_one2one_hk[target.protoX, paste(outgroup.sample, "Ovary", "Female", sep="_")]
      target.protoA.Female = EM_one2one_hk[target.protoA, paste(outgroup.sample, "Ovary", "Female", sep="_")]
      
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]
      target.X.Female = EM_one2one_hk[target.protoX, paste(target.sample, "Ovary", "Female", sep="_")]
      target.A.Female = EM_one2one_hk[target.protoA, paste(target.sample, "Ovary", "Female", sep="_")]
    }else{
      target.protoX.Male = EM_one2one_hk[target.protoX, paste(outgroup.sample, tissue, "Male", sep="_")]
      target.protoA.Male = EM_one2one_hk[target.protoA, paste(outgroup.sample, tissue, "Male", sep="_")]
      target.protoX.Female = EM_one2one_hk[target.protoX, paste(outgroup.sample, tissue, "Female", sep="_")]
      target.protoA.Female = EM_one2one_hk[target.protoA, paste(outgroup.sample, tissue, "Female", sep="_")]
      
      target.X.Male = EM_one2one_hk[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = EM_one2one_hk[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
      target.X.Female = EM_one2one_hk[target.protoX, paste(target.sample, tissue, "Female", sep="_")]
      target.A.Female = EM_one2one_hk[target.protoA, paste(target.sample, tissue, "Female", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    target.protoXtoA.Female = target.protoX.Female/median(target.protoA.Female)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    target.XtoA.Female = target.X.Female/median(target.A.Female)
    
    target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                             target.XtoA.Female/target.protoXtoA.Female))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

X.to.protoX.ratio.1sp.v2 = function(target, target.sample, tissue, outgroup, outgroup.sample, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix){
  #   target="lizard"
  #   target.sample = "lizard1"
  #   tissue="Brain"
  #   outgroup="human"
  #   outgroup.sample="human"
  targetX=paste(target, "X", sep="")
  targetA=paste(target, "A", sep="")
  outgroupA=paste(outgroup, "A", sep="")
  
  target.protoX = intersect(one2one.genes[[targetX]], one2one.genes[[outgroupA]])
  target.protoA = intersect(one2one.genes[[targetA]], one2one.genes[[outgroupA]])
  
  if (sex=="male"){
    if(tissue=="Gonads"){
      target.protoX.Male = one2one.exp.matrix[target.protoX, paste(outgroup.sample, "Testis", "Male", sep="_")]
      target.protoA.Male = one2one.exp.matrix[target.protoA, paste(outgroup.sample, "Testis", "Male", sep="_")]
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]
    }else{
      target.protoX.Male = one2one.exp.matrix[target.protoX, paste(outgroup.sample, tissue, "Male", sep="_")]
      target.protoA.Male = one2one.exp.matrix[target.protoA, paste(outgroup.sample, tissue, "Male", sep="_")]
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    
    target.matrix=log2(target.XtoA.Male/target.protoXtoA.Male)
  }else{
    if(tissue=="Gonads"){
      target.protoX.Male = one2one.exp.matrix[target.protoX, paste(outgroup.sample, "Testis", "Male", sep="_")]
      target.protoA.Male = one2one.exp.matrix[target.protoA, paste(outgroup.sample, "Testis", "Male", sep="_")]
      target.protoX.Female = one2one.exp.matrix[target.protoX, paste(outgroup.sample, "Ovary", "Female", sep="_")]
      target.protoA.Female = one2one.exp.matrix[target.protoA, paste(outgroup.sample, "Ovary", "Female", sep="_")]
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]
      target.X.Female = one2one.exp.matrix[target.protoX, paste(target.sample, "Ovary", "Female", sep="_")]
      target.A.Female = one2one.exp.matrix[target.protoA, paste(target.sample, "Ovary", "Female", sep="_")]
    }else{
      target.protoX.Male = one2one.exp.matrix[target.protoX, paste(outgroup.sample, tissue, "Male", sep="_")]
      target.protoA.Male = one2one.exp.matrix[target.protoA, paste(outgroup.sample, tissue, "Male", sep="_")]
      target.protoX.Female = one2one.exp.matrix[target.protoX, paste(outgroup.sample, tissue, "Female", sep="_")]
      target.protoA.Female = one2one.exp.matrix[target.protoA, paste(outgroup.sample, tissue, "Female", sep="_")]
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
      target.X.Female = one2one.exp.matrix[target.protoX, paste(target.sample, tissue, "Female", sep="_")]
      target.A.Female = one2one.exp.matrix[target.protoA, paste(target.sample, tissue, "Female", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    target.protoXtoA.Female = target.protoX.Female/median(target.protoA.Female)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    target.XtoA.Female = target.X.Female/median(target.A.Female)
    
    target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                             target.XtoA.Female/target.protoXtoA.Female))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

X.to.protoX.ratio.1sp.v3 = function(target, target.sample, tissue, stage="adult", outgroup, outgroup.sample, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix){
#   target="lizard"
#   target.sample = "lizard"
#   tissue="brain"
#   outgroup="mouse"
#   outgroup.sample="mouse"
#   one2one.genes = one2one.5sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.5sp.collapsed
  if (stage != "adult"){
    tissue = paste0(tissue, ".", stage)
  }
    
  genes.expressed = one2one.exp.matrix[which(one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] >=1.0), "gene"]
    
  targetX=paste0(target, "X")
  targetA=paste0(target, "AK")
  outgroupA=paste0(outgroup, "AK")
  
  target.protoX = intersect(genes.expressed, intersect(one2one.genes[[targetX]], one2one.genes[[outgroupA]]))
  target.protoA = intersect(genes.expressed, intersect(one2one.genes[[targetA]], one2one.genes[[outgroupA]]))
    
  target.protoX.Male = one2one.exp.matrix[target.protoX, paste(outgroup, tissue, "male", sep=".")]
  target.protoA.Male = one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "male", sep=".")]
  target.X.Male = one2one.exp.matrix[target.protoX, paste(target, tissue, "male", sep=".")]
  target.A.Male = one2one.exp.matrix[target.protoA, paste(target, tissue, "male", sep=".")]
  
  target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
  target.XtoA.Male = target.X.Male/median(target.A.Male)
  target.matrix=log2(target.XtoA.Male/target.protoXtoA.Male)
  
  if (sex=="both"){
    target.protoX.Female = one2one.exp.matrix[target.protoX, paste(outgroup, tissue, "female", sep=".")]
    target.protoA.Female = one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "female", sep=".")]
    target.X.Female = one2one.exp.matrix[target.protoX, paste(target, tissue, "female", sep=".")]
    target.A.Female = one2one.exp.matrix[target.protoA, paste(target, tissue, "female", sep=".")]    
    
    target.protoXtoA.Female = target.protoX.Female/median(target.protoA.Female)
    target.XtoA.Female = target.X.Female/median(target.A.Female)
    target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                             target.XtoA.Female/target.protoXtoA.Female))
  }
    
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

X.to.protoX.ratio.1sp.random = function(target, tissue, stage="adult", outgroup, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix){
#   target="lizard"
#   target.sample = "lizard"
#   tissue="brain"
#   outgroup="chicken"
#   outgroup.sample="chicken"
#   one2one.genes = one2one.5sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.5sp.collapsed
  if (stage != "adult"){
    tissue = paste0(tissue, ".", stage)
  }
  
  genes.expressed = one2one.exp.matrix[which(one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] >=1.0), "gene"]
  
  targetX=paste0(target, "X")
  targetA=paste0(target, "A")
  outgroupA=paste0(outgroup, "AK")
  
  # Select genes
  #---------------
  target.protoX = intersect(genes.expressed, intersect(one2one.genes[[targetX]], one2one.genes[[outgroupA]]))
  target.protoA = intersect(genes.expressed, intersect(one2one.genes[[targetA]], one2one.genes[[outgroupA]]))
  num.X.genes = length(target.protoX)
  
  # Compute X/ and proto X/A expression for male
  #---------------------------------------------
  target.protoX.Male = one2one.exp.matrix[target.protoX, paste(outgroup, tissue, "male", sep=".")]
  target.X.Male = one2one.exp.matrix[target.protoX, paste(target, tissue, "male", sep=".")]
  target.protoA.Male = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.X.genes, col=paste(outgroup, tissue, "male", sep="."))
  target.A.Male = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.X.genes, paste(target, tissue, "male", sep="."))

  target.protoXtoA.Male = target.protoX.Male/target.protoA.Male
  target.XtoA.Male = target.X.Male/target.A.Male
  
  target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                           target.X.Male/target.protoX.Male, deparse.level=2))
  
  if (sex=="both"){
    # Compute X/ and proto X/A expression for female
    #-----------------------------------------------
    target.protoX.Female = one2one.exp.matrix[target.protoX, paste(outgroup, tissue, "female", sep=".")]
    target.X.Female = one2one.exp.matrix[target.protoX, paste(target, tissue, "female", sep=".")]
    target.protoA.Female = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.X.genes, col=paste(outgroup, tissue, "female", sep="."))
    target.A.Female = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.X.genes, paste(target, tissue, "female", sep="."))
    
    target.protoXtoA.Female = target.protoX.Female/target.protoA.Female
    target.XtoA.Female = target.X.Female/target.A.Female
    
    # Paste results for male and female
    #----------------------------------
    target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                             target.XtoA.Female/target.protoXtoA.Female,
                             target.X.Male/target.protoX.Male,
                             target.X.Female/target.protoX.Female, deparse.level=2))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

M.to.F.ratio = function(exp.matrix, genes, autosomes, tissue, stage="adult", min.exp=0, max.exp=Inf, remove.inf=FALSE){
#   exp.matrix=lizard.6sp
#   tissue="brain"
#   genes = genes.x
#   autosomes = genes.auto
  
  if (stage != "adult"){
    tissue = paste0(tissue, ".", stage)
  }
  genes.expressed = exp.matrix[which(
    exp.matrix[,paste(tissue, "female", sep=".")] >= min.exp &
      exp.matrix[,paste(tissue, "female", sep=".")] < max.exp), "gene"]
  
  genes = intersect(genes, genes.expressed)
  autosomes = intersect(autosomes, genes.expressed)
  MF.ratio.X = exp.matrix[genes, paste(tissue, "male", sep=".")] / exp.matrix[genes, paste(tissue, "female", sep=".")]
  MF.ratio.A = bootstrap.median.vector(
    exp.matrix[autosomes, paste(tissue, "male", sep=".")] / exp.matrix[autosomes, paste(tissue, "female", sep=".")], n=length(genes))
  MF.ratio = log2(MF.ratio.X/MF.ratio.A)
                    
  if (remove.inf==TRUE){
    MF.ratio.A = MF.ratio.A[is.finite(MF.ratio.A)]
  }
  return(MF.ratio.A)  
}

M.to.F.ratio.lizard = function(genes, tissue, remove.inf=FALSE){
  #tissue="Brain"
  #genes = lizard.X
  genes = intersect(genes, rownames(lizard1_hk))
  
  Male1 = paste("lizard1", tissue, "Male", sep="_")
  Male2 = paste("lizard2", tissue, "Male", sep="_")
  Male3 = paste("lizard3", tissue, "Male", sep="_")
  Female1 = paste("lizard1", tissue, "Female", sep="_")
  Female2 = paste("lizard2", tissue, "Female", sep="_")
  Female3 = paste("lizard3", tissue, "Female", sep="_")
  
  X.Male = apply(cbind(lizard1_hk[genes, Male1], lizard2_hk[genes, Male2], lizard3_hk[genes, Male3]), 1, median)
  X.Female = apply(cbind(lizard1_hk[genes, Female1], lizard2_hk[genes, Female2], lizard3_hk[genes, Female3]), 1, median)
  
  MF.ratio = log2(X.Male / X.Female) 
  if (remove.inf==TRUE){
    MF.ratio = MF.ratio[is.finite(MF.ratio)]
  }
  return(MF.ratio)  
}

X.to.protoX.ratio.4sp = function(target, target.sample, tissue, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix){
#   target="lizard"
#   target.sample = "lizard1"
#   tissue="Brain"
#   sex="both"
#   one2one.genes = one2one.10sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.10sp_hk
  targetX=paste(target, "X", sep="")
  targetA=paste(target, "A", sep="")
  
  target.protoX = intersect(one2one.genes[[targetX]], 
                            intersect(one2one.genes[["chickenA"]], 
                                      intersect(one2one.genes[["platypusA"]],
                                                intersect(one2one.genes[["opossumA"]], one2one.genes[["mouseA"]]))))
  target.protoA = intersect(one2one.genes[[targetA]],  
                            intersect(one2one.genes[["chickenA"]], 
                                      intersect(one2one.genes[["platypusA"]],
                                                intersect(one2one.genes[["opossumA"]], one2one.genes[["mouseA"]]))))
  if (sex=="male"){
    if (tissue=="Gonads"){
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]      
    }else{
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    
    target.matrix=log2(target.XtoA.Male/target.protoXtoA.Male)
  }else{
    if (tissue=="Gonads"){
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      target.protoX.Female = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", "Ovary", "Female", sep="_"), paste("chicken", "Ovary", "Female", sep="_"), paste("opossum", "Ovary", "Female", sep="_"), paste("mouse", "Ovary", "Female", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      target.protoA.Female = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", "Ovary", "Female", sep="_"), paste("chicken", "Ovary", "Female", sep="_"), paste("opossum", "Ovary", "Female", sep="_"), paste("mouse", "Ovary", "Female", sep="_"))], 1, median)
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, "Testis", "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, "Testis", "Male", sep="_")]
      target.X.Female = one2one.exp.matrix[target.protoX, paste(target.sample, "Ovary", "Female", sep="_")]
      target.A.Female = one2one.exp.matrix[target.protoA, paste(target.sample, "Ovary", "Female", sep="_")]
    }else{
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      target.protoX.Female = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", tissue, "Female", sep="_"), paste("chicken", tissue, "Female", sep="_"), paste("opossum", tissue, "Female", sep="_"), paste("mouse", tissue, "Female", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      target.protoA.Female = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", tissue, "Female", sep="_"), paste("chicken", tissue, "Female", sep="_"), paste("opossum", tissue, "Female", sep="_"), paste("mouse", tissue, "Female", sep="_"))], 1, median)
      
      target.X.Male = one2one.exp.matrix[target.protoX, paste(target.sample, tissue, "Male", sep="_")]
      target.A.Male = one2one.exp.matrix[target.protoA, paste(target.sample, tissue, "Male", sep="_")]
      target.X.Female = one2one.exp.matrix[target.protoX, paste(target.sample, tissue, "Female", sep="_")]
      target.A.Female = one2one.exp.matrix[target.protoA, paste(target.sample, tissue, "Female", sep="_")]
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    target.protoXtoA.Female = target.protoX.Female/median(target.protoA.Female)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    target.XtoA.Female = target.X.Female/median(target.A.Female)
    
    target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                             target.XtoA.Female/target.protoXtoA.Female))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

Chr.to.protoA.ratio.random = function(target, tissue, stage="adult", outgroup, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix, one2one.table, chr.genes, min.exp=0.1, max.exp=Inf){
#   stage="adult"
#   sex="both"
#   target="mouse"
#   tissue="brain"
#   outgroup=c("chicken")
#   one2one.genes = one2one.2sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.2sp.collapsed
#   one2one.table = one2one.2sp
#   chr.genes = as.character(subset(mouse.2sp, AXY=="X")$gene)
#   min.exp=0.1
#   max.exp=Inf
  
  if (stage != "adult"){
    tissue = paste0(tissue, ".", stage)
  }
  # This part would filter genes by expression in the target (current chr)
  if(sex=="male" | target=="chicken"){
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue, "male", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue, "male", sep=".")] < max.exp), "gene"]
  }else{
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] < max.exp), "gene"]
  }
   
  targetChr = rownames(one2one.table[one2one.table[, target] %in% intersect(one2one.table[,target],chr.genes),])
  targetA = paste0(target, "AK")
  
  outgroup.list = list()
  for (i in 1:length(outgroup)){
    outgroupA=paste0(outgroup[i], "AK")
    outgroup.list[[i]] = one2one.genes[[outgroupA]]
  } 

  # Select genes
  #---------------
  target.protoChr = intersect(genes.expressed, intersect(targetChr, intersect.many.arrays(outgroup.list)))
  target.protoA = setdiff(intersect(genes.expressed, intersect(one2one.genes[[targetA]], intersect.many.arrays(outgroup.list))), targetChr) 
                  # this new line (with the 'setdiff') makes sure that the Autosomal control does not contain any of the genes in "chr".
                  # Only important when computing current/ancestral for autosomes
  num.Chr.genes = length(target.protoChr)
  
  # Compute X/A and proto X/A expression for male
  #---------------------------------------------
  if (length(outgroup) > 1){
    target.protoChr.Male = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "male", sep=".")], 1, median)
#     target.protoA.Male.full = as.data.frame(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "male", sep=".")], 1, median))
#     target.protoA.Male = bootstrap.median(data=target.protoA.Male.full, all.genes=target.protoA, n=num.Chr.genes, col=1)
    target.protoA.Male = median(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "male", sep=".")], 1, median))
  }else{
    target.protoChr.Male = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "male", sep=".")]
    names(target.protoChr.Male) = target.protoChr  # I have to add this because when there is only one species outgroup rownames are not kept
#     target.protoA.Male = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.Chr.genes, col=paste(outgroup, tissue, "male", sep="."))
    target.protoA.Male = median(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "male", sep=".")])
  }
  
  target.Chr.Male = one2one.exp.matrix[target.protoChr, paste(target, tissue, "male", sep=".")]
  names(target.Chr.Male) = target.protoChr  # I have to add this because when there is only one species outgroup rownames are not kept
#   target.A.Male = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.Chr.genes, paste(target, tissue, "male", sep="."))
  target.A.Male = median(one2one.exp.matrix[target.protoA, paste(target, tissue, "male", sep=".")])
  
  target.protoChrtoA.Male = target.protoChr.Male/target.protoA.Male
  target.ChrtoA.Male = target.Chr.Male/target.A.Male
  
  target.matrix=log2(cbind(target.ChrtoA.Male/target.protoChrtoA.Male,
                           target.Chr.Male/target.protoChr.Male, deparse.level=2))
  
  if (sex=="both"){
    # Compute Chr/ and proto Chr/A expression for female
    #-----------------------------------------------
    if (length(outgroup) > 1){
      target.protoChr.Female = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "female", sep=".")], 1, median)
#       target.protoA.Female.full = as.data.frame(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "female", sep=".")], 1, median))
#       target.protoA.Female = bootstrap.median(data=target.protoA.Female.full, all.genes=target.protoA, n=num.Chr.genes, col=1)
      target.protoA.Female = median(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "female", sep=".")], 1, median))
    }else{
      target.protoChr.Female = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "female", sep=".")]
      names(target.protoChr.Female) = target.protoChr
#       target.protoA.Female = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.Chr.genes, col=paste(outgroup, tissue, "female", sep="."))
      target.protoA.Female = median(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "female", sep=".")])
    }
    
    target.Chr.Female = one2one.exp.matrix[target.protoChr, paste(target, tissue, "female", sep=".")]
    names(target.Chr.Female) = target.protoChr
#     target.A.Female = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.Chr.genes, paste(target, tissue, "female", sep="."))
    target.A.Female = median(one2one.exp.matrix[target.protoA, paste(target, tissue, "female", sep=".")])
    
    target.protoChrtoA.Female = target.protoChr.Female/target.protoA.Female
    target.ChrtoA.Female = target.Chr.Female/target.A.Female
    
    # Paste results for male and female
    #----------------------------------
    target.matrix=log2(cbind(target.ChrtoA.Male/target.protoChrtoA.Male,
                             target.Chr.Male/target.protoChr.Male,
                             target.ChrtoA.Female/target.protoChrtoA.Female,
                             target.Chr.Female/target.protoChr.Female, deparse.level=2))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

Chr.to.protoA.ratio.devel = function(target, tissue.target, stage.target="adult", outgroup, stage.outgroup, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix, one2one.table, chr.genes, min.exp=0.1, max.exp=Inf){
#   sex="both"
#   target="lizard"
#   tissue.target="brain"
#   stage.target="15d"
#   outgroup=c("chicken")
#   stage.outgroup="14d"
#   one2one.genes = one2one.7sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.7sp.collapsed
#   one2one.table = one2one.7sp
#   chr.genes = as.character(subset(lizard.devel.7sp, AXY=="X")$gene)
#   min.exp=0.1
#   max.exp=Inf
  
  tissue.outgroup = tissue.target
  if (stage.target != "adult"){
    tissue.target = paste0(tissue.target, ".", stage.target)
  }
  if (stage.outgroup != "adult"){
    tissue.outgroup = paste0(tissue.outgroup, ".", stage.outgroup)
  }
  # This part would filter genes by expression in the target (current chr)
  if(sex=="male" | target=="chicken"){
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue.target, "male", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue.target, "male", sep=".")] < max.exp), "gene"]
  }else{
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue.target, "female", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue.target, "female", sep=".")] < max.exp), "gene"]
  }
  
  targetChr = rownames(one2one.table[one2one.table[, target] %in% intersect(one2one.table[,target],chr.genes),])
  targetA = paste0(target, "AK")
  
  outgroup.list = list()
  for (i in 1:length(outgroup)){
    outgroupA=paste0(outgroup[i], "AK")
    outgroup.list[[i]] = one2one.genes[[outgroupA]]
  } 
  # Select genes
  #---------------
  target.protoChr = intersect(genes.expressed, intersect(targetChr, intersect.many.arrays(outgroup.list)))
  target.protoA = setdiff(intersect(genes.expressed, intersect(one2one.genes[[targetA]], intersect.many.arrays(outgroup.list))), targetChr) 
  # this new line (with the 'setdiff') makes sure that the Autosomal control does not contain any of the genes in "chr".
  # Only important when computing current/ancestral for autosomes
  num.Chr.genes = length(target.protoChr)
  
  # Compute X/A and proto X/A expression for male
  #---------------------------------------------
  if (length(outgroup) > 1){
    target.protoChr.Male = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue.outgroup, "male", sep=".")], 1, median)
    target.protoA.Male = median(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue.outgroup, "male", sep=".")], 1, median))
  }else{
    target.protoChr.Male = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue.outgroup, "male", sep=".")]
    target.protoA.Male = median(one2one.exp.matrix[target.protoA, paste(outgroup, tissue.outgroup, "male", sep=".")])
  }
  
  target.Chr.Male = one2one.exp.matrix[target.protoChr, paste(target, tissue.target, "male", sep=".")]
  target.A.Male = median(one2one.exp.matrix[target.protoA, paste(target, tissue.target, "male", sep=".")])
  
  target.protoChrtoA.Male = target.protoChr.Male/target.protoA.Male
  target.ChrtoA.Male = target.Chr.Male/target.A.Male
  
  target.matrix=log2(cbind(target.ChrtoA.Male/target.protoChrtoA.Male,
                           target.Chr.Male/target.protoChr.Male, deparse.level=2))
  
  if (sex=="both"){
    # Compute Chr/ and proto Chr/A expression for female
    #-----------------------------------------------
    if (length(outgroup) > 1){
      target.protoChr.Female = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue.outgroup, "female", sep=".")], 1, median)
      target.protoA.Female = median(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue.outgroup, "female", sep=".")], 1, median))
    }else{
      target.protoChr.Female = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue.outgroup, "female", sep=".")]
      target.protoA.Female = median(one2one.exp.matrix[target.protoA, paste(outgroup, tissue.outgroup, "female", sep=".")])
    }
    
    target.Chr.Female = one2one.exp.matrix[target.protoChr, paste(target, tissue.target, "female", sep=".")]
    target.A.Female = median(one2one.exp.matrix[target.protoA, paste(target, tissue.target, "female", sep=".")])
    
    target.protoChrtoA.Female = target.protoChr.Female/target.protoA.Female
    target.ChrtoA.Female = target.Chr.Female/target.A.Female
    
    # Paste results for male and female
    #----------------------------------
    target.matrix=log2(cbind(target.ChrtoA.Male/target.protoChrtoA.Male,
                             target.Chr.Male/target.protoChr.Male,
                             target.ChrtoA.Female/target.protoChrtoA.Female,
                             target.Chr.Female/target.protoChr.Female, deparse.level=2))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

X.to.A.ratio.random = function(target, tissue, stage="adult", remove.inf=TRUE, sex="both", exp.matrix, chr.genes, min.exp=0.1, max.exp=Inf, autosomes="AK"){
#   sex="both"
#   target="lizard"
#   tissue="embryo"
#   stage="5_6d"
#   exp.matrix = EM.full.6sp.raw
#   chr.genes = as.character(subset(chicken.genes, Chromosome.Name=="X" &  Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)
#   min.exp=0.1
#   max.exp=Inf
#   autosomes="AK"
#   autosomes=genes.auto
#  length(autosomes)
  
  
  if (stage != "adult"){
    tissue = paste0(tissue, ".", stage)
    target = paste0(target, ".devel")
  }
  # Select expressed genes
  #-----------------------
  if(sex=="male" | target=="chicken"){
    genes.expressed = exp.matrix[[target]][
      which(exp.matrix[[target]][,paste(tissue, "male", sep=".")] >= min.exp &
              exp.matrix[[target]][,paste(tissue, "male", sep=".")] < max.exp), "gene"]
  }else{
    genes.expressed = exp.matrix[[target]][
      which(exp.matrix[[target]][,paste(tissue, "female", sep=".")] >= min.exp &
              exp.matrix[[target]][,paste(tissue, "female", sep=".")] < max.exp), "gene"]
  }
  length(genes.expressed)
  unique(exp.matrix[[target]][, "AXY"])
  
  # Select genes
  #---------------
  if (length(autosomes) > 1){
    targetA = autosomes
  }else{
    if(autosomes=="AK"){
      targetA = exp.matrix[[target]][which(
        exp.matrix[[target]][, "AXY"] == "A" | exp.matrix[[target]][, "AXY"] == "UNK"), "gene"]
    }else{
        targetA = exp.matrix[[target]][which(exp.matrix[[target]][, "AXY"] == "A"), "gene"]
    }
  }
  targetChr=chr.genes
  length(targetChr)
  length(targetA)
  targetChr = intersect(chr.genes, genes.expressed)
  targetA = setdiff(intersect(targetA, genes.expressed), targetChr)
  length(targetChr)
  length(targetA)
  num.Chr.genes = length(targetChr)
  
  # Compute X/A for male
  #---------------------------------------------
  target.Chr.Male = exp.matrix[[target]][targetChr, paste(tissue, "male", sep=".")]
  target.A.Male = bootstrap.median.vector(data=exp.matrix[[target]][targetA, paste(tissue, "male", sep=".")], n=num.Chr.genes)
  target.ChrtoA.Male = target.Chr.Male/target.A.Male
  quantile(target.Chr.Male)
  quantile(target.A.Male)
  quantile(target.ChrtoA.Male)
  target.matrix=log2(target.ChrtoA.Male)
  
  if (sex=="both"){
    # Compute Chr/A for female
    #-----------------------------------------------
    target.Chr.Female = exp.matrix[[target]][targetChr, paste(tissue, "female", sep=".")]
    target.A.Female = bootstrap.median.vector(data=exp.matrix[[target]][targetA, paste(tissue, "female", sep=".")], n=num.Chr.genes)
    target.ChrtoA.Female = target.Chr.Female/target.A.Female
    quantile(target.Chr.Female)
    quantile(target.A.Female)
    quantile(target.ChrtoA.Female)
    
    
    log2(median(target.Chr.Female / target.Chr.Male))
    
    # Paste results for male and female
    #----------------------------------
    target.matrix=log2(cbind(target.ChrtoA.Male,
                             target.ChrtoA.Female, deparse.level=2))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

protoChr.to.protoA.ratio.random = function(target, tissue, stage="adult", outgroup, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix, one2one.table, chr.genes, min.exp=0.1, max.exp=Inf){
#   sex="both"
#   target="human"
#   tissue="brain"
#   outgroup=c("chicken")
#   one2one.genes = one2one.6sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.6sp.collapsed
#   one2one.table = one2one.6sp
#   chr.genes = as.character(subset(human.genes, Chromosome.Name==1)$Ensembl.Gene.ID)
  
  if(sex=="male" | target=="chicken"){
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue, "male", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue, "male", sep=".")] < max.exp), "gene"]
  }else{
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] < max.exp), "gene"]
  }
  
  targetChr = rownames(one2one.table[one2one.table[, target] %in% intersect(one2one.table[,target],chr.genes),])
  targetA = paste0(target, "AK")
  
  outgroup.list = list()
  for (i in 1:length(outgroup)){
    outgroupA=paste0(outgroup[i], "AK")
    outgroup.list[[i]] = one2one.genes[[outgroupA]]
  } 
  
  # Select genes
  #---------------
  target.protoChr = intersect(genes.expressed, intersect(targetChr, intersect.many.arrays(outgroup.list)))
  target.protoA = setdiff(intersect(genes.expressed, intersect(one2one.genes[[targetA]], intersect.many.arrays(outgroup.list))), targetChr)
                  # this new line (with the 'setdiff') makes sure that the Autosomal control does not contain any of the genes in "chr".
                  # Only important when computing current/ancestral for autosomes
  num.Chr.genes = length(target.protoChr)
  
  # Compute proto X/A expression for male
  #---------------------------------------------
  if (length(outgroup) > 1){
    target.protoChr.Male = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "male", sep=".")], 1, median)
#     target.protoA.Male.full = as.data.frame(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "male", sep=".")], 1, median))
#     target.protoA.Male = bootstrap.median(data=target.protoA.Male.full, all.genes=target.protoA, n=num.Chr.genes, col=1)
    target.protoA.Male = median(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "male", sep=".")], 1, median))
  }else{
    target.protoChr.Male = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "male", sep=".")]
#     target.protoA.Male = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.Chr.genes, col=paste(outgroup, tissue, "male", sep="."))
    target.protoA.Male = median(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "male", sep=".")])
  }
  
  target.protoChrtoA.Male = target.protoChr.Male/target.protoA.Male
  
  target.matrix=log2(target.protoChrtoA.Male)
  
  if (sex=="both"){
    # Compute proto Chr/A expression for female
    #-----------------------------------------------
    if (length(outgroup) > 1){
      target.protoChr.Female = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "female", sep=".")], 1, median)
#       target.protoA.Female.full = as.data.frame(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "female", sep=".")], 1, median))
#       target.protoA.Female = bootstrap.median(data=target.protoA.Female.full, all.genes=target.protoA, n=num.Chr.genes, col=1)
      target.protoA.Female = median(apply(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "female", sep=".")], 1, median))
    }else{
      target.protoChr.Female = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "female", sep=".")]
#       target.protoA.Female = bootstrap.median(data=one2one.exp.matrix, all.genes=target.protoA, n=num.Chr.genes, col=paste(outgroup, tissue, "female", sep="."))
      target.protoA.Female = median(one2one.exp.matrix[target.protoA, paste(outgroup, tissue, "female", sep=".")])
    }
    
    target.protoChrtoA.Female = target.protoChr.Female/target.protoA.Female
    
    # Paste results for male and female
    #----------------------------------
    target.matrix=log2(cbind(target.protoChrtoA.Male,
                             target.protoChrtoA.Female, deparse.level=2))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

X.to.protoX.ratio.4sp.merged.samples = function(target, target.sample, tissue, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix){
#   target="lizard"
#   target.sample = "lizard1"
#   tissue="Brain"
#   sex="both"
#   one2one.genes = one2one.10sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.10sp_hk
  targetX=paste(target, "X", sep="")
  targetA=paste(target, "A", sep="")
  
  target.protoX = intersect(one2one.genes[[targetX]], 
                            intersect(one2one.genes[["chickenA"]], 
                                      intersect(one2one.genes[["platypusA"]],
                                                intersect(one2one.genes[["opossumA"]], one2one.genes[["mouseA"]]))))
  target.protoA = intersect(one2one.genes[[targetA]],  
                            intersect(one2one.genes[["chickenA"]], 
                                      intersect(one2one.genes[["platypusA"]],
                                                intersect(one2one.genes[["opossumA"]], one2one.genes[["mouseA"]]))))
  if (sex=="male"){
    if (tissue=="Gonads"){
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      
      target.samples = c()
      for (sample in target.sample){
        target.samples=c(target.samples, paste(sample, "Testis", "Male", sep="_"))
      }
      
      target.X.Male = apply(one2one.exp.matrix[target.protoX, target.samples], 1, median)
      target.A.Male = apply(one2one.exp.matrix[target.protoA, target.samples], 1, median)
      
    }else{
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      target.samples = c()
      for (sample in target.sample){
        target.samples=c(target.samples, paste(sample, tissue, "Male", sep="_"))
      }
      
      target.X.Male = apply(one2one.exp.matrix[target.protoX, target.samples], 1, median)
      target.A.Male = apply(one2one.exp.matrix[target.protoA, target.samples], 1, median)
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    
    target.matrix=log2(target.XtoA.Male/target.protoXtoA.Male)
  }else{
    if (tissue=="Gonads"){
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      target.protoX.Female = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", "Ovary", "Female", sep="_"), paste("chicken", "Ovary", "Female", sep="_"), paste("opossum", "Ovary", "Female", sep="_"), paste("mouse", "Ovary", "Female", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", "Testis", "Male", sep="_"), paste("chicken", "Testis", "Male", sep="_"), paste("opossum", "Testis", "Male", sep="_"), paste("mouse", "Testis", "Male", sep="_"))], 1, median)
      target.protoA.Female = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", "Ovary", "Female", sep="_"), paste("chicken", "Ovary", "Female", sep="_"), paste("opossum", "Ovary", "Female", sep="_"), paste("mouse", "Ovary", "Female", sep="_"))], 1, median)
      
      target.samples.testis = c()
      for (sample in target.sample){
        target.samples.testis=c(target.samples.testis, paste(sample, "Testis", "Male", sep="_"))
      }
      target.samples.ovary = c()
      for (sample in target.sample){
        target.samples.ovary=c(target.samples.ovary, paste(sample, "Ovary", "Female", sep="_"))
      }
      
      target.X.Male = apply(one2one.exp.matrix[target.protoX, target.samples.testis], 1, median)
      target.A.Male = apply(one2one.exp.matrix[target.protoA, target.samples.testis], 1, median)
      target.X.Female = apply(one2one.exp.matrix[target.protoX, target.samples.ovary], 1, median)
      target.A.Female = apply(one2one.exp.matrix[target.protoA, target.samples.ovary], 1, median)
      
    }else{
      target.protoX.Male = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      target.protoX.Female = apply(one2one.exp.matrix[target.protoX, c(paste("platypus", tissue, "Female", sep="_"), paste("chicken", tissue, "Female", sep="_"), paste("opossum", tissue, "Female", sep="_"), paste("mouse", tissue, "Female", sep="_"))], 1, median)
      target.protoA.Male = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", tissue, "Male", sep="_"), paste("chicken", tissue, "Male", sep="_"), paste("opossum", tissue, "Male", sep="_"), paste("mouse", tissue, "Male", sep="_"))], 1, median)
      target.protoA.Female = apply(one2one.exp.matrix[target.protoA, c(paste("platypus", tissue, "Female", sep="_"), paste("chicken", tissue, "Female", sep="_"), paste("opossum", tissue, "Female", sep="_"), paste("mouse", tissue, "Female", sep="_"))], 1, median)
      
      target.samples.male = c()
      for (sample in target.sample){
        target.samples.male=c(target.samples.male, paste(sample, tissue, "Male", sep="_"))
      }
      target.samples.female = c()
      for (sample in target.sample){
        target.samples.female=c(target.samples.female, paste(sample, tissue, "Female", sep="_"))
      }
      
      target.X.Male = apply(one2one.exp.matrix[target.protoX, target.samples.male], 1, median)
      target.A.Male = apply(one2one.exp.matrix[target.protoA, target.samples.male], 1, median)
      target.X.Female = apply(one2one.exp.matrix[target.protoX, target.samples.female], 1, median)
      target.A.Female = apply(one2one.exp.matrix[target.protoA, target.samples.female], 1, median)
      
    }
    
    target.protoXtoA.Male = target.protoX.Male/median(target.protoA.Male)
    target.protoXtoA.Female = target.protoX.Female/median(target.protoA.Female)
    
    target.XtoA.Male = target.X.Male/median(target.A.Male)
    target.XtoA.Female = target.X.Female/median(target.A.Female)
    
    target.matrix=log2(cbind(target.XtoA.Male/target.protoXtoA.Male,
                             target.XtoA.Female/target.protoXtoA.Female))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

get.genes.by.quantiles.v1 = function(species, exp.table, all.genes, tissue.sex, bins=seq(0,1,1/5)){
#   species = "chicken"
#   exp.table = chicken.6sp
#   all.genes = as.character(subset(chicken.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)
#   tissue.sex = "brain.male"
#   bins = seq(0,1,1/5)
  
  sample.exp = exp.table[all.genes,tissue.sex]
  q = quantile(sample.exp[sample.exp >= 0.1], probs = bins, na.rm=TRUE)
  tmp =intersect(subset(exp.table, (exp.table[,tissue.sex] < q[2]))$gene, one2one.6sp[,species])
  ortho = one2one.6sp[one2one.6sp[,species] %in% tmp, ]
  orthologs = list()
  orthologs[[1]] = ortho
  
  for (i in 2:(length(q)-2)){
    tmp =intersect(subset(exp.table, (exp.table[,tissue.sex] >= q[i] & exp.table[,tissue.sex] < q[i+1]))$gene, one2one.6sp[,species])
    ortho = one2one.6sp[one2one.6sp[,species] %in% tmp, ]
    orthologs[[i]] = ortho
  }
  i = i+1
  tmp =intersect(subset(exp.table, (exp.table[,tissue.sex] >= q[i]))$gene, one2one.6sp[,species])
  ortho = one2one.6sp[one2one.6sp[,species] %in% tmp, ]
  orthologs[[i]] = ortho
#   for (i in 1:5){
#     print(dim(orthologs[[i]]))
#   }
  return(orthologs)
}

get.genes.by.quantiles.v2 = function(target, outgroup, exp.outgroup, tissue.sex, bins=seq(0,1,1/5)){
#   target="mouse"
#   outgroup = "chicken"
#   exp.outgroup = chicken.6sp
#   tissue.sex = "brain.male"
#   bins = seq(0,1,1/5)

  targetX = paste0(target,"X")
  outgroup.genes = exp.outgroup[one2one.6sp[one2one.6sp.X.A.genes[[targetX]], outgroup], c(tissue.sex, "gene")] 
  sample.exp = outgroup.genes[outgroup.genes[,tissue.sex] >= 0.1, tissue.sex]
  
  q = quantile(sample.exp[sample.exp >= 0.1], probs = bins, na.rm=TRUE)
  orthologs = list()
  for (i in 1:(length(q)-2)){
    tmp = subset(outgroup.genes, (outgroup.genes[,tissue.sex] >= q[i] & outgroup.genes[,tissue.sex] < q[i+1]))$gene
    orthologs[[i]] = one2one.6sp[one2one.6sp[,outgroup] %in% tmp, target]
  }
  i = i+1
  tmp = subset(outgroup.genes, (outgroup.genes[,tissue.sex] >= q[i]))$gene
  orthologs[[i]] = one2one.6sp[one2one.6sp[,outgroup] %in% tmp, target]
  orthologs[[1]]
#     for (i in 1:5){
#       print(length(orthologs[[i]]))
#     }
  return(orthologs)
}

get.genes.by.quantiles.v3 = function(target, outgroup, tissue.sex, bins=seq(0,1,1/5)){
#   target="lizard"
#   outgroup = c("mouse", "opossum")
#   outgroup = "mouse"
#   tissue.sex = "brain.male"
#   bins = seq(0,1,1/5)
  
  targetX = paste0(target,"X")
  
  if(length(outgroup)>1){
    sample.exp = apply(EM_one2one.6sp.collapsed[one2one.6sp.X.A.genes[[targetX]],paste(outgroup,tissue.sex, sep=".")], 1, function(x) median(x, na.rm=TRUE))
  }else{
    sample.exp = as.vector(EM_one2one.6sp.collapsed[one2one.6sp.X.A.genes[[targetX]],paste(outgroup,tissue.sex, sep=".")])
    names(sample.exp) = one2one.6sp.X.A.genes[[targetX]]
  }
  q = quantile(sample.exp[sample.exp >= 0.1], probs = bins, na.rm=TRUE)
  orthologs = list()
  for (i in 1:(length(q)-2)){
    tmp = names(sample.exp[(sample.exp >= q[i] & sample.exp < q[i+1])])
    orthologs[[i]] = one2one.6sp[tmp, target]
  }
  i = i+1
  tmp = names(sample.exp[(sample.exp >= q[i])])
  orthologs[[i]] = one2one.6sp[tmp, target]
#   orthologs[[2]]
#   t=0
#   for (i in 1:5){
#     print(length(orthologs[[i]]))
#     t=t+length(orthologs[[i]])
#   }
#   t
  return(orthologs)
}

get.genes.by.quantiles.v4 = function(target, outgroup, tissue.sex, bins=seq(0,1,1/5), one2one.exp.matrix=EM_one2one.7sp.un.collapsed, one2one.genes=one2one.7sp.X.A.genes, one2one.table=one2one.7sp, min.exp=0.1){
  #   target="lizard"
  #   outgroup = c("mouse", "opossum")
  #   outgroup = "mouse"
  #   tissue.sex = "brain.male"
  #   bins = seq(0,1,1/5)
  
  targetX = paste0(target,"X")
  
  if(length(outgroup)>1){
    sample.exp = apply(one2one.exp.matrix[one2one.genes[[targetX]],paste(outgroup,tissue.sex, sep=".")], 1, function(x) median(x, na.rm=TRUE))
  }else{
    sample.exp = as.vector(one2one.exp.matrix[one2one.genes[[targetX]],paste(outgroup,tissue.sex, sep=".")])
    names(sample.exp) = one2one.genes[[targetX]]
  }
  q = quantile(sample.exp[sample.exp >= min.exp], probs = bins, na.rm=TRUE)
  orthologs = list()
  for (i in 1:(length(q)-2)){
    tmp = names(sample.exp[(sample.exp >= q[i] & sample.exp < q[i+1])])
    orthologs[[i]] = one2one.table[tmp, target]
  }
  i = i+1
  tmp = names(sample.exp[(sample.exp >= q[i])])
  orthologs[[i]] = one2one.table[tmp, target]
  #   orthologs[[2]]
  #   t=0
  #   for (i in 1:5){
  #     print(length(orthologs[[i]]))
  #     t=t+length(orthologs[[i]])
  #   }
  #   t
  return(orthologs)
}

intersect.many.arrays = function(arrays){
  #   a=seq(0,100,1)
  #   b=seq(0,100,2)
  #   c=seq(0,100,3)
  #   arrays = list(a,b,c)
  output = arrays[[1]]
  if(length(arrays) > 1){
    for (i in 2:length(arrays)){
      output = intersect(output, arrays[[i]])
    }
  }
  return(output)
}

pval.to.colors = function(pval.matrix, pcutoff = 0.05){
  pval.color = matrix(rep(-1, 3*length(pval.matrix[1,])), 3)
  for (i in 1:length(pval.matrix[1,])){
    if((pval.matrix[1,i] < pcutoff)==FALSE){ # sets 1 for those with X:protoX = 0.5
      pval.color[1,i]=1
    }
    if((pval.matrix[2,i] < pcutoff)==FALSE){ # sets 1 for those with X:protoX = 1
      pval.color[2,i]=1
    }
    if(((pval.matrix[1,i] < pcutoff)==TRUE) & ((pval.matrix[2,i] < pcutoff)==TRUE)){ # sets 1 for those with X:protoX != 0.5 AND X:protoX != 1
      pval.color[3,i]=1
    }
    if((pval.matrix[1,i]>1)==TRUE){ # clears the positions of vector "empty" (they have values 2 by default)
      pval.color[1,i]=-1
      pval.color[2,i]=-1
      pval.color[3,i]=-1
    }
  }
  return(pval.color)
}

pval.to.colors.v2 = function(pval.matrix, pcutoff = 0.05){
  pval.color = matrix(rep(-1, 4*length(pval.matrix[1,])), 4)
  for (i in 1:length(pval.matrix[1,])){
    if((pval.matrix[1,i] < pcutoff)==FALSE){ # sets 1 for those with log2(X/protoX) = -1
      pval.color[1,i]=1
    }
    if((pval.matrix[2,i] < pcutoff)==FALSE){ # sets 1 for those with log2(X/protoX) = 0
      pval.color[2,i]=1
    }
    if((pval.matrix[3,i] < pcutoff)==FALSE){ # sets 1 for those with log2(X/protoX) = 1
      pval.color[3,i]=1
    }
    if(((pval.matrix[1,i] < pcutoff)==TRUE) & ((pval.matrix[2,i] < pcutoff)==TRUE) & ((pval.matrix[3,i] < pcutoff)==TRUE)){ # sets 1 for those that don't fall in any of the three cases above
      pval.color[4,i]=1
    }
    if((pval.matrix[1,i]>1)==TRUE){ # clears the positions of vector "empty" (they have values 2 by default)
      pval.color[1,i]=-1
      pval.color[2,i]=-1
      pval.color[3,i]=-1
      pval.color[4,i]=-1
    }
  }
  return(pval.color)
}

mult.h.correct = function(pvals){
#   pvals=MF.lizard.pval
  if (is.matrix(pvals)==TRUE){
    n.row = dim(pvals)[1]
    n.col = dim(pvals)[2]
    pval.bh = matrix(rep(-1.0, n.col*n.row), ncol=n.col, nrow=n.row)
    
    for (i in c(1:n.row)){
      pval.bh[i,] = p.adjust(pvals[i,], method="fdr")
    }
    
  }else{
    pval.bh = rep(-1.0, length(pvals))
    pval.bh = p.adjust(pvals, method="fdr")
  }
  return(pval.bh)
}

compute.wilcox= function(log2.matrix, correct=TRUE){
  if (is.matrix(log2.matrix)==TRUE){
    n.samples=dim(log2.matrix)[2]
    pval = matrix(rep(-1.0, 3*n.samples), 3)
    pval.bh = pval
    for (i in c(1:n.samples)){
      pval[1,i] = wilcox.test(log2.matrix[,i], alternative="t", mu=-1)$p.value
      pval[2,i] = wilcox.test(log2.matrix[,i], alternative="t", mu=0)$p.value
      pval[3,i] = wilcox.test(log2.matrix[,i], alternative="t", mu=1)$p.value
    }
    if (correct==TRUE){
      for (i in c(1:3)){
        pval.bh[i,] = p.adjust(pval[i,], method="fdr")
      }
    }else{
      pval.bh = pval
    }
    
  }else{
    pval = rep(-1.0, 3)
    pval.bh = pval
    pval[1] = wilcox.test(log2.matrix, alternative="t", mu=-1)$p.value
    pval[2] = wilcox.test(log2.matrix, alternative="t", mu=0)$p.value
    pval[3] = wilcox.test(log2.matrix, alternative="t", mu=1)$p.value
    pval.bh = pval
  }
  return(pval.bh)
} 

compute.wilcox.list= function(log2.list, correct=TRUE){
  if (is.list(log2.list)==TRUE){
    n.samples=length(log2.list)
    pval = matrix(rep(-1.0, 3*n.samples), 3)
    pval.bh = pval
    for (i in c(1:n.samples)){
      pval[1,i] = wilcox.test(log2.list[[i]], alternative="t", mu=-1)$p.value
      pval[2,i] = wilcox.test(log2.list[[i]], alternative="t", mu=0)$p.value
      pval[3,i] = wilcox.test(log2.list[[i]], alternative="t", mu=1)$p.value
    }
    if (correct==TRUE){
      for (i in c(1:3)){
        pval.bh[i,] = p.adjust(pval[i,], method="fdr")
      }
    }else{
      pval.bh = pval
    }
    
  }else{
    pval = rep(-1.0, 3)
    pval.bh = pval
    pval[1] = wilcox.test(log2.list, alternative="t", mu=-1)$p.value
    pval[2] = wilcox.test(log2.list, alternative="t", mu=0)$p.value
    pval[3] = wilcox.test(log2.list, alternative="t", mu=1)$p.value
    pval.bh = pval
  }
  return(pval.bh)
} 

compute.quantile.list= function(log2.list, correct=TRUE){
  if (is.list(log2.list)==TRUE){
    n.samples=length(log2.list)
    q = matrix(rep(-1.0, 5*n.samples), 5)
    for (i in c(1:n.samples)){
      q[,i] = quantile(log2.list[[i]], na.rm=TRUE)
    }  
    rownames(q)=names(quantile(log2.list[[1]], na.rm=TRUE))
  }else{
    q = rep(-1.0, 5)
    q = quantile(log2.list, na.rm=TRUE)
  }  
  return(q)
} 

bootstrap.median = function(data, all.genes, n, col, iterations=100){
#   data=target.protoA.Male.full
#   all.genes=target.protoA
#   n=num.Chr.genes
#   col=1
  set.seed(1)
  output = NULL
  for (i in 1:iterations){
    output = c(output,
               median(data[sample(all.genes, n), col], na.rm=TRUE))
  }
  return(median(output))
}

bootstrap.median.vector = function(data, n, iterations=100){
  set.seed(1)
  output = NULL
  for (i in 1:iterations){
    output = c(output, median(sample(data, n), na.rm=TRUE))
  }
  return(median(output))
}

initialize.table <- function(row.vector, col.vector){
  table = as.data.frame(matrix(NA, nrow = length(row.vector), ncol = length(col.vector)), row.names=row.vector)
  colnames(table) = col.vector
  table
}

plot.X.to.protoX = function(quantile.vec, ymin=-2, ymax=2, my.pch=19, target, outgroup, sample.names){
  step=(ymax-ymin)/8
  if(is.matrix(quantile.vec)==TRUE){
    n.samples = dim(quantile.vec)[2]
    xmin=0.5
    xmax=n.samples + 0.5
    plot(quantile.vec["50%",], xlim=c(xmin,xmax), ylim=c(ymin,ymax), pch=my.pch, axes=FALSE, xlab="Sample", ylab="log2(M:F)", main=paste(target, "vs.", outgroup, sep=" ")); abline(h=-1, lty=1); abline(h=0, lty=2); abline(h=1, lty=1)
    errbar(c(1:n.samples), quantile.vec["50%",], quantile.vec["25%",], quantile.vec["75%",], add=T, pch=my.pch, cap=.03, errbar.col="red")
  }else{
    n.samples=1
    plot(quantile.vec["50%"], xlim=c(0.5,1.5), ylim=c(ymin,ymax), pch=my.pch, axes=FALSE, xlab="Sample", ylab="log2(M:F)", main=paste(target, "vs.", outgroup, sep=" ")); abline(h=-1, lty=1); abline(h=0, lty=2); abline(h=1, lty=1)
    errbar(1, quantile.vec["50%"], quantile.vec["25%"], quantile.vec["75%"], add=T, pch=my.pch, cap=.03, errbar.col="red")
  }
  
  axis(1, at=seq(1,n.samples,by=1), labels=sample.names, las=1)
  axis(2, at=seq(ymin,ymax,by=step), labels=seq(ymin,ymax,by=step), las=2, xlab=F)
}

tissue.specificity.info = function(EM, frac.cutoff = 0.3, output=0){
  EM.total = apply(EM, 1, sum)
  tmp=EM/EM.total
  if(output==0){
    print("Breakdown of tissue expression")
    print(tmp)
    print(paste0("Tissue specificity with minimum fraction =", frac.cutoff))
    print(tmp >= frac.cutoff)
    print("Tissue with maximum expression")
    print(t(apply(EM, 1, function(x) x==max(x))))
  }
  if(output==1){
    return(tmp)
  }
  if(output==2){
    return(tmp >= frac.cutoff)
  }
  if(output==3){
    return(t(apply(EM, 1, function(x) x==max(x))))
  }
  
}

tissue.specificity.raw = function(EM){
  EM.total = apply(EM, 1, sum)
  tmp=EM/EM.total
  tmp
}

tissue.specificity = function(EM, frac.cutoff = 0.3, fold=2){
#   EM=mouse.7sp[one2one.7sp[rownames(mouse.proto.EM.chroms[["X"]]), "mouse"], male]
#   EM=lizard.proto.EM.chroms[["X"]]
  EM.total = apply(EM, 1, sum)
  zeroes = which(EM.total == 0)
  if (length(zeroes) > 0){
    EM = EM[-zeroes,]
    EM.total = EM.total[-zeroes]
  }
  tmp=EM/EM.total
  TE=apply(tmp, 1, function(x) {ii=order(x, decreasing=T); y=x[ii]; if(y[1]>=y[2]*fold & y[1]>=frac.cutoff){colnames(EM)[ii[1]]}else{0}})
  return(TE)
}

tissue.exp.normal = function(EM){
  EM.total = apply(EM, 1, sum)
  tmp=EM/EM.total
  return(tmp)
}

tissue.specificity.bool = function(EM, frac.cutoff = 0.3){
  EM.total = apply(EM, 1, sum)
  tmp=EM/EM.total
  TE = tmp >= frac.cutoff
  TE.bool = apply(TE, 1, function(x) length(which(x)))
  return(TE.bool)
}

get.protoX = function (one2one=one2one.7sp.X.A.genes, target, outgroup){
  arrays = list()
  arrays[[1]] = one2one[[paste0(target, "X")]]
  for (i in 1:length(outgroup)){
    arrays[[i+1]] = one2one[[paste0(outgroup[i], "AK")]]
  }
  return(intersect.many.arrays(arrays))
}

get.protoA = function (one2one=one2one.7sp.X.A.genes, target, outgroup){
  arrays = list()
  arrays[[1]] = one2one[[paste0(target, "AK")]]
  for (i in 1:length(outgroup)){
    arrays[[i+1]] = one2one[[paste0(outgroup[i], "AK")]]
  }
  return(intersect.many.arrays(arrays))
}

get.protoGroup = function (one2one=one2one.7sp.X.A.genes, one2one.set=one2one.7sp, target, outgroup, group){
  arrays = list()
#   target="lizard"
#   genes = as.vector(subset(lizard.genes, Chromosome.Name == "1")$Ensembl.Gene.ID)
  genes.ortho = one2one.set[one2one.set[, target] %in% intersect(group, one2one.set[,target]), "human"]
  arrays[[1]] = genes.ortho
  for (i in 1:length(outgroup)){
    arrays[[i+1]] = one2one[[paste0(outgroup[i], "AK")]]
  }
  return(intersect.many.arrays(arrays))
}

get.curr.ances.auto.partners = function(species, outgroup.species, adjacency.matrix,  genes.x, genes.x.one2one, cor.cutoff=0.9, max.fc=0.5, min.fc=-Inf, split.fc=-0.5, type="A"){
#   cor.cutoff=0.9
#   max.fc=0.5
#   min.fc=-Inf
#   split.fc=-0.5
#   species="chicken"
#   adjacency.matrix=adjacency.signed.chicken
#   genes.x = chicken.genes.x
#   genes.x.one2one = chicken.genes.x.one2one
  genenames = colnames(adjacency.matrix)
  result = list()
  list.all = list()
  list.all.compensated.genes = list()
  list.all.nocompensated.genes = list()
  list.all.compensated = list()
  list.all.nocompensated = list()

  tissues = c("brain", "heart", "kidney", "liver", "gonads")
  tissues.sex = paste(tissues, c(rep("male", 5), rep("female", 5)), sep=".")
  stats.names = c("X", "X-c", "X-nc", "PartnersX-c", "PartnersX-nc", "PartnersX-c-u", "PartnersX-nc-u", "Partners-common",  "PartnersX-c-1:1", "PartnersX-nc-1:1", "C/A-PartnersX-c", "C/A-PartnersX-nc")
  stats = matrix(rep(NA, 12*10), nrow=10, dimnames=list(tissues.sex, stats.names))
  
  for (mytissue in tissues){
    #   mytissue="liver"
    for (sex in c("male", "female")){
      #     sex="female"
      if (type == "A"){
        if (sex == "male"){sexID = 1}else{sexID = 3}
      }else{
        if (sex == "male"){sexID = 2}else{sexID = 4}
      }
      
      
      print(c(mytissue, sex))
      mytissue.sex = paste(mytissue, sex, sep=".")
      list.all[[mytissue]] = Chr.to.protoA.ratio.random(target=species, tissue=mytissue, outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
      list.all.compensated.genes[[mytissue.sex]] = intersect(subset(one2one.7sp, human %in% names(which(list.all[[mytissue]][,sexID] >= split.fc & list.all[[mytissue]][,sexID] <= max.fc )))[,species], genenames)
      list.all.nocompensated.genes[[mytissue.sex]] = intersect(subset(one2one.7sp, human %in% names(which(list.all[[mytissue]][,sexID] < split.fc & list.all[[mytissue]][,sexID] >= min.fc )))[,species], genenames)
      stats[mytissue.sex, "X"] = dim(list.all[[mytissue]])[1]
      stats[mytissue.sex, "X-c"] = length(list.all.compensated.genes[[mytissue.sex]])
      stats[mytissue.sex, "X-nc"] = length(list.all.nocompensated.genes[[mytissue.sex]])
      
      partners.compensated = c()
      for (gene in list.all.compensated.genes[[mytissue.sex]]){
        # select interacting genes
        tmp = names(which(adjacency.matrix[gene,] >= (1+cor.cutoff)/2))
        # remove non-autosomal genes
        partners = setdiff(tmp, genes.x.one2one)
        # add to set of autosomal partners
        partners.compensated = union(partners.compensated, partners)
      }
      stats[mytissue.sex, "PartnersX-c"] = length(partners.compensated)
      
      partners.nocompensated = c()
      for (gene in list.all.nocompensated.genes[[mytissue.sex]]){
        # select interacting genes
        tmp = names(which(adjacency.matrix[gene,] >= (1+cor.cutoff)/2))
        # remove non-autosomal genes
        partners = setdiff(tmp, genes.x.one2one)
        # add to set of autosomal partners
        partners.nocompensated = union(partners.nocompensated, partners)
      }
      stats[mytissue.sex, "PartnersX-nc"] = length(partners.nocompensated)
      
      partners.compensated.uniq = setdiff(partners.compensated, partners.nocompensated)
      partners.nocompensated.uniq = setdiff(partners.nocompensated, partners.compensated)
      stats[mytissue.sex, "PartnersX-c-u"] = length(partners.compensated.uniq)
      stats[mytissue.sex, "PartnersX-nc-u"] = length(partners.nocompensated.uniq)
      stats[mytissue.sex, "Partners-common"] = length(intersect(partners.compensated, partners.nocompensated))
      
      list.all.compensated[[mytissue.sex]] = Chr.to.protoA.ratio.random(target=species, tissue=mytissue, outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=partners.compensated.uniq, min.exp=0)[,sexID]
      stats[mytissue.sex, "PartnersX-c-1:1"] = length(list.all.compensated[[mytissue.sex]])
      stats[mytissue.sex, "C/A-PartnersX-c"] = median(list.all.compensated[[mytissue.sex]])
      
      list.all.nocompensated[[mytissue.sex]] = Chr.to.protoA.ratio.random(target=species, tissue=mytissue, outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=partners.nocompensated.uniq, min.exp=0)[,sexID]
      stats[mytissue.sex, "PartnersX-nc-1:1"] = length(list.all.nocompensated[[mytissue.sex]])
      stats[mytissue.sex, "C/A-PartnersX-nc"] = median(list.all.nocompensated[[mytissue.sex]])
    }
  }
  result = list("all.x"=list.all, "x.compensated" = list.all.compensated.genes, "auto.compensated" = list.all.compensated, "x.nocompensated" = list.all.nocompensated.genes, "auto.nocompensated" = list.all.nocompensated, "stats"=stats)
  print(stats)
  return(result)
}

A.to.protoA.ratio.random = function(target, tissue, stage="adult", outgroup, remove.inf=TRUE, sex="both", one2one.genes, one2one.exp.matrix, one2one.table, chr.genes, min.exp=0.1, max.exp=Inf){
#   stage="adult"
#   sex="both"
#   target="human"
#   tissue="liver"
#   outgroup=c("chicken")
#   outgroup = c("lizard", "platypus", "chicken", "xenopus")
#   one2one.genes = one2one.7sp.X.A.genes
#   one2one.exp.matrix = EM_one2one.7sp.collapsed
#   one2one.table = one2one.7sp
#   chr.genes = subset(one2one.7sp, human %in% one2one.7sp.X.A.genes[["humanAK"]])$human
#   min.exp=0
#   max.exp=Inf
#   remove.inf=TRUE
  
  if (stage != "adult"){
    tissue = paste0(tissue, ".", stage)
  }
  # This part would filter genes by expression in the target (current chr)
  if(sex=="male" | target=="chicken"){
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue, "male", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue, "male", sep=".")] < max.exp), "gene"]
  }else{
    genes.expressed = one2one.exp.matrix[
      which(one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] >= min.exp &
              one2one.exp.matrix[,paste(target, tissue, "female", sep=".")] < max.exp), "gene"]
  }
  
  targetChr = rownames(one2one.table[one2one.table[, target] %in% intersect(one2one.table[,target],chr.genes),])
  targetA = paste0(target, "AK")
  
  outgroup.list = list()
  for (i in 1:length(outgroup)){
    outgroupA=paste0(outgroup[i], "AK")
    outgroup.list[[i]] = one2one.genes[[outgroupA]]
  } 
  
  # Select genes
  #---------------
  target.protoChr = intersect(genes.expressed, intersect(targetChr, intersect.many.arrays(outgroup.list)))
  num.Chr.genes = length(target.protoChr)
  
  # Compute X/A and proto X/A expression for male
  #---------------------------------------------
  if (length(outgroup) > 1){
    target.protoChr.Male = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "male", sep=".")], 1, median)
  }else{
    target.protoChr.Male = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "male", sep=".")]
    names(target.protoChr.Male) = target.protoChr  # I have to add this because when there is only one species outgroup rownames are not kept
  }
  
  target.Chr.Male = one2one.exp.matrix[target.protoChr, paste(target, tissue, "male", sep=".")]
  names(target.Chr.Male) = target.protoChr  # I have to add this because when there is only one species outgroup rownames are not kept
  
  target.matrix= as.matrix(log2(target.Chr.Male/target.protoChr.Male))
  
  if (sex=="both"){
    # Compute Chr/ and proto Chr/A expression for female
    #-----------------------------------------------
    if (length(outgroup) > 1){
      target.protoChr.Female = apply(one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "female", sep=".")], 1, median)
    }else{
      target.protoChr.Female = one2one.exp.matrix[target.protoChr, paste(outgroup, tissue, "female", sep=".")]
      names(target.protoChr.Female) = target.protoChr
    }
    
    target.Chr.Female = one2one.exp.matrix[target.protoChr, paste(target, tissue, "female", sep=".")]
    names(target.Chr.Female) = target.protoChr
    
    # Paste results for male and female
    #----------------------------------
    target.matrix=log2(cbind(target.Chr.Male/target.protoChr.Male,
                             target.Chr.Female/target.protoChr.Female, deparse.level=2))
  }
  
  if (remove.inf==TRUE){
    if (is.matrix(target.matrix)==TRUE){
      target.matrix = target.matrix[apply(target.matrix, 1, function(x) all(is.finite(x))),]  
    }else{
      target.matrix = target.matrix[is.finite(target.matrix)]
    }
  }
  return(target.matrix)  
}

fraction.autosomal.down = function (target, outgroup.species, results.B ){
  species = target
  speciesAK = paste0(species, "AK")
  autosomal.one2one = subset(one2one.7sp, human %in% one2one.7sp.X.A.genes[[speciesAK]])[,species]
  tissues = c("brain", "heart", "kidney", "liver", "gonads")
  tissues.sex = paste(tissues, c(rep("male", 5), rep("female", 5)), sep=".")
  stats = c("auto.NC.down", "auto.NC.normal1", "auto.NC.normal2", "auto.C.down", "auto.C.normal1", "auto.C.normal2", "background.down", "background.normal1", "background.normal2")
  results=matrix(rep(NA, 10*9), ncol=9, dimnames=list(tissues.sex, stats))
  results.raw=matrix(rep(NA, 10*9), ncol=9, dimnames=list(tissues.sex, stats))
  for (sex in c("male", "female")){
    if (sex == "male"){sexID = 1}else{sexID=2}
    for (mytissue in tissues){
      tissue.sex = paste(mytissue, sex, sep=".")
      print(tissue.sex)
      tmp = A.to.protoA.ratio.random(target=species, tissue=mytissue, outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=autosomal.one2one, min.exp=0)[,sexID]
      
      auto.NC.down = length(which(results.B$auto.nocompensated[[tissue.sex]] < -0.5))  
      auto.NC.normal1 = length(which(results.B$auto.nocompensated[[tissue.sex]] >= -0.5 & results.B$auto.nocompensated[[tissue.sex]] < 0.5))
      auto.NC.normal2 = length(which(results.B$auto.nocompensated[[tissue.sex]] >= -0.5 )) 
      
      auto.C.down = length(which(results.B$auto.compensated[[tissue.sex]] < -0.5)) 
      auto.C.normal1 = length(which(results.B$auto.compensated[[tissue.sex]] >= -0.5 & results.B$auto.compensated[[tissue.sex]] < 0.5))
      auto.C.normal2 = length(which(results.B$auto.compensated[[tissue.sex]] >= -0.5 )) 
      
      background.down = length(which(tmp < -0.5)) 
      background.normal1 = length(which(tmp >= -0.5 & tmp < 0.5)) 
      background.normal2 = length(which(tmp >= -0.5)) 
      results.raw[tissue.sex,] = c(auto.NC.down, auto.NC.normal1, auto.NC.normal2, auto.C.down, auto.C.normal1, auto.C.normal2, background.down, background.normal1, background.normal2)
      
      auto.NC.down = length(which(results.B$auto.nocompensated[[tissue.sex]] < -0.5)) / length(results.B$auto.nocompensated[[tissue.sex]]) 
      auto.NC.normal1 = length(which(results.B$auto.nocompensated[[tissue.sex]] >= -0.5 & results.B$auto.nocompensated[[tissue.sex]] < 0.5)) / length(results.B$auto.nocompensated[[tissue.sex]]) 
      auto.NC.normal2 = length(which(results.B$auto.nocompensated[[tissue.sex]] >= -0.5 )) / length(results.B$auto.nocompensated[[tissue.sex]]) 
      
      auto.C.down = length(which(results.B$auto.compensated[[tissue.sex]] < -0.5)) / length(results.B$auto.compensated[[tissue.sex]]) 
      auto.C.normal1 = length(which(results.B$auto.compensated[[tissue.sex]] >= -0.5 & results.B$auto.compensated[[tissue.sex]] < 0.5)) / length(results.B$auto.compensated[[tissue.sex]]) 
      auto.C.normal2 = length(which(results.B$auto.compensated[[tissue.sex]] >= -0.5 )) / length(results.B$auto.compensated[[tissue.sex]]) 
      
      background.down = length(which(tmp < -0.5)) / length(tmp)
      background.normal1 = length(which(tmp >= -0.5 & tmp < 0.5)) / length(tmp)
      background.normal2 = length(which(tmp >= -0.5)) / length(tmp)
      results[tissue.sex,] = c(auto.NC.down, auto.NC.normal1, auto.NC.normal2, auto.C.down, auto.C.normal1, auto.C.normal2, background.down, background.normal1, background.normal2)
    }
  }
  return(list("frac" = results, "raw" = results.raw))
}

frac.broadly.exp = function(species, chroms, outgroup.species, genes.E77){
#   species = "lizard"
#   chrom = 1
#   genes.E77 = lizard.genes
#   outgroup.species=c("human", "mouse", "opossum", "platypus", "chicken", "xenopus")
  
  broad.exp = NULL
  broad.exp.current = NULL
  proto.EM.chroms = list()
  current.EM.chroms = list()
  
  for (chrom in chroms){
    if (chrom == "X"){
      proto = get.protoX(target=species, outgroup=outgroup.species)
    }else{
      genes = as.vector(subset(genes.E77, Chromosome.Name == chrom)$Ensembl.Gene.ID)
      proto = get.protoGroup(target=species, outgroup=outgroup.species, group=genes)
    }
    if(length(proto) >= 5){
      proto.brain = apply(EM_one2one.7sp.collapsed[proto, paste0(outgroup.species, ".brain.male")], 1, median)
      current.brain = EM.full.7sp[[species]][one2one.7sp[proto, species], "brain.male"]

      proto.heart = apply(EM_one2one.7sp.collapsed[proto, paste0(outgroup.species, ".heart.male")], 1, median)
      current.heart = EM.full.7sp[[species]][one2one.7sp[proto, species], "heart.male"]
      
      proto.kidney = apply(EM_one2one.7sp.collapsed[proto, paste0(outgroup.species, ".kidney.male")], 1, median)
      current.kidney = EM.full.7sp[[species]][one2one.7sp[proto, species], "kidney.male"]
      
      proto.liver = apply(EM_one2one.7sp.collapsed[proto, paste0(outgroup.species, ".liver.male")], 1, median)
      current.liver = EM.full.7sp[[species]][one2one.7sp[proto, species], "liver.male"]
      
      proto.gonads = apply(EM_one2one.7sp.collapsed[proto, paste0(outgroup.species, ".gonads.male")], 1, median)
      current.gonads = EM.full.7sp[[species]][one2one.7sp[proto, species], "gonads.male"]
      
      proto.EM.chroms[[chrom]] = cbind(proto.brain, proto.heart, proto.kidney, proto.liver, proto.gonads)
      rownames(proto.EM.chroms[[chrom]]) = proto
      colnames(proto.EM.chroms[[chrom]]) = colnames(EM.full.7sp[[species]][,1:5])
      TE=tissue.specificity.bool(proto.EM.chroms[[chrom]], 1.5*1/5)
      broad.exp[chrom] = length(which(TE==0)) / length(proto)  
      
      current.EM.chroms[[chrom]] = cbind(current.brain, current.heart, current.kidney, current.liver, current.gonads)
      rownames(current.EM.chroms[[chrom]]) = proto
      colnames(current.EM.chroms[[chrom]]) = colnames(EM.full.7sp[[species]][,1:5])
      TE=tissue.specificity.bool(current.EM.chroms[[chrom]], 1.5*1/5)
      broad.exp.current[chrom] = length(which(TE==0)) / length(proto)  
    }
  }
  return(list("broad.exp" = broad.exp, "broad.exp.current" = broad.exp.current, "proto.EM.chroms" = proto.EM.chroms, "current.EM.chroms" = current.EM.chroms ))
}

frac.testis.specific = function(species){
#   species = "human"
  
  X.all = intersect(subset(EM.full.7sp[[species]], AXY=="X" & gonads.male > 0)$gene, 
                    subset(genes.all[[species]], Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)
  X.old = intersect(subset(EM.full.7sp[[species]], gonads.male > 0)$gene,
                    one2one.7sp[one2one.7sp.X.A.genes[[paste0(species, "X")]], species])
  X.new = setdiff(X.all, X.old)
  A.all = intersect(subset(EM.full.7sp[[species]], AXY=="A" & gonads.male > 0)$gene,
                    subset(genes.all[[species]], Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)
  A.old = intersect(subset(EM.full.7sp[[species]], gonads.male > 0)$gene,
                    one2one.7sp[one2one.7sp.X.A.genes[[paste0(species, "A")]], species])
  A.new = setdiff(A.all, A.old)
  
  X.values = NULL
  A.values = NULL
  X.values["all"] = length(which(tissue.specificity(EM.full.7sp[[species]][X.all, 1:5], 2*1/5, fold=2) == "gonads.male")) / length(X.all)
  X.values["new"] = length(which(tissue.specificity(EM.full.7sp[[species]][X.new, 1:5], 2*1/5, fold=2) == "gonads.male")) / length(X.new)
  X.values["old"] = length(which(tissue.specificity(EM.full.7sp[[species]][X.old, 1:5], 2*1/5, fold=2) == "gonads.male")) / length(X.old)
  A.values["all"] = length(which(tissue.specificity(EM.full.7sp[[species]][A.all, 1:5], 2*1/5, fold=2) == "gonads.male")) / length(A.all)
  A.values["new"] = length(which(tissue.specificity(EM.full.7sp[[species]][A.new, 1:5], 2*1/5, fold=2) == "gonads.male")) / length(A.new)
  A.values["old"] = length(which(tissue.specificity(EM.full.7sp[[species]][A.old, 1:5], 2*1/5, fold=2) == "gonads.male")) / length(A.old)
  return(list("X.values" = X.values, "A.values" = A.values))
}

plot.develop.lizard = function(tissue, size.label=1){
#   brain = c(intersect(male, grep("brain", colnames(lizard.dev.7sp), value=T)), "brain.male")
#   tissue=brain
  max.all = apply(cbind(apply(lizard.all[c(XYgametologs[c(4,7,5,3,1,2,6),"X"]), tissue], 1, max), apply(lizard.all[c(XYgametologs[c(4,7,5,3,1,2,6),"Y"]), tissue], 1, max)), 1, max)
  x=lizard.all[XYgametologs[c(4,7,5,3,1,2,6),"X"], tissue] / max.all
  y=lizard.all[XYgametologs[c(4,7,5,3,1,2,6),"Y"], tissue]/ max.all
  par(mar=c(1, 2, 1, 0))
  i=1
  plot(t(x[i,]), ylim=c(0,1.1), type="l", xlab="", ylab="", axes=F,   yaxs="i", lwd=3) 
  lines(t(y[i,]), col="red", lwd=3)
  box(lwd=1)
  axis(1, labels=F, tck=0, xaxs="i")
  axis(2, labels=T, tck=-0.05, yaxs="i")
  mtext(paste("FPKM", round(max.all[i], 2), sep="="), side=3, line=0, cex=size.label)
  par(mar=c(1, 1, 1, 1))
  for (i in 2:7){
    plot(t(x[i,]), ylim=c(0,1.1), type="l", xlab="", ylab="", axes=F,   yaxs="i", lwd=3) 
    lines(t(y[i,]), col="red", lwd=3)
    box(lwd=1)
    axis(1, labels=F, tck=0, xaxs="i")
    axis(2, labels=F, tck=-0.05, yaxs="i")
    mtext(paste("FPKM", round(max.all[i], 2), sep="="), side=3, line=0, cex=size.label)
  }
  
}

TE.for.image <- function(data, gametolog="X", cutoff=2*1/5, female=0){
  ii = c(4,7,5,3,1,2,6)
  n=7
  tmp=as.matrix(tissue.specificity.info(data[XYgametologs[ii,gametolog],], cutoff, output=1))
  scale.mat = cbind(rep(1,n), rep(2,n), rep(3,n), rep(4,n), rep(5+female,n))
  tmp=(tmp+scale.mat)*as.matrix(tissue.specificity.info(data[XYgametologs[ii,gametolog],], cutoff, output=2))
  return(apply(tmp, 1, max))
}

TE.for.image.proto <- function(data, cutoff=2*1/5, female=0){
#   data=protoX.male
  i = c(5)
  ii = c(3,1,4,2,6)
  n=7
  data = rbind(data[i,], rep(0,5), data[ii,])
  tmp=as.matrix(tissue.specificity.info(data, cutoff, output=1))
  scale.mat = cbind(rep(1,n), rep(2,n), rep(3,n), rep(4,n), rep(5+female,n))
  tmp=(tmp+scale.mat)*as.matrix(tissue.specificity.info(data, cutoff, output=2))
  return(apply(tmp, 1, max))
}

get.quantile.allelic.expr = function(data, contigs, coverage.cutoff=10){
  data.list = list()
  contigs = contigs[which(contigs %in% data[data[,5] >= coverage.cutoff, 1])]
  for (i in c(1:length(contigs))){
    data.list = append(data.list, list(i = data[data[,1]==contigs[i] & data[,5]>=coverage.cutoff,]))
  }
  data.q = quantile(data.list[[1]][,6])
  
  for (i in c(2:length(contigs))){
    data.q = cbind(data.q, quantile(data.list[[i]][,6]))
  }
  colnames(data.q) = contigs
  return(data.q)
}

get.pval.allelic.expr = function(data, contigs, coverage.cutoff=min.depth, pcutoff=0.05){
  #   data=Brain1
  #   contigs = XLinkedContigs
  #   coverage.cutoff=10
  #   pcutoff=0.05
  data.list = list()
  contigs = contigs[which(contigs %in% data[data[,5] >= coverage.cutoff, 1])]
  for (i in c(1:length(contigs))){
    data.list = append(data.list, list(i = data[data[,1]==contigs[i] & data[,5]>=coverage.cutoff,]))
  }
  
  data.pval.0 = as.vector(wilcox.test(data.list[[1]][,6], alternative="t", mu=0)$p.value)
  data.pval.0.5 = as.vector(wilcox.test(data.list[[1]][,6], alternative="t", mu=0.5)$p.value)
  data.pval.1 = as.vector(wilcox.test(data.list[[1]][,6], alternative="t", mu=1)$p.value)
  for (i in c(2:length(contigs))){
    data.pval.0 = append(data.pval.0, wilcox.test(data.list[[i]][,6], alternative="t", mu=0)$p.value)
    data.pval.0.5 = append(data.pval.0.5, wilcox.test(data.list[[i]][,6], alternative="t", mu=0.5)$p.value)
    data.pval.1 = append(data.pval.1, wilcox.test(data.list[[i]][,6], alternative="t", mu=1)$p.value)
  }
  data.pval.0 = p.adjust(data.pval.0, method="fdr")
  data.pval.0.5 = p.adjust(data.pval.0.5, method="fdr")
  data.pval.1 = p.adjust(data.pval.1, method="fdr")
  
  #   data.pval.0 < pcutoff
  #   data.pval.0.5  < pcutoff
  #   data.pval.1  < pcutoff
  pval.1 = rep(0, length(data.pval.0))
  pval.2 = rep(0, length(data.pval.0))
  #   pval.3 = rep(-1, length(data.pval.0))
  
  for (i in 1:length(data.pval.0)){
    if((data.pval.0.5[i] < pcutoff)==FALSE){ # sets 1 for those ratio = 0
      pval.1[i]=1
    }
    #     if((data.pval.1[i] < pcutoff)==FALSE){ # sets 1 for those ratio = 0.5
    #       pval.2[i]=1
    #     }
    #     if(((data.pval.0.5[i] < pcutoff)==TRUE) & ((data.pval.1[i] < pcutoff)==TRUE)){ # sets 1 for those ratio = 1
    #       pval.3[i]=1
    #     }
    if((data.pval.0.5[i] < pcutoff)==TRUE){ # sets 1 for those ratio = 0
      pval.2[i]=1
    }
  }
  #   final=rbind(pval.1, pval.2, pval.3)
  final=rbind(pval.1, pval.2)
  colnames(final) = contigs
  return(final)
}

plot.allelic.expr = function(q, pval, color="#7777ff", my.pch=19, ymin=0, ymax=1, step=0.2){
  nsamples = dim(q)[2]
  par(fig=c(0,1,0,0.8), new=FALSE, mar=c(7, 5, 0, 2))
  plot(q["50%",], ylim=c(ymin,ymax), pch=my.pch, col=color, lwd=2, axes=FALSE, xlab="", ylab="Fraction reference allele")
  errbar(c(1:nsamples), q["50%", ], q["25%", ], q["75%", ], add=T, pch=my.pch, cap=.03, errbar.col=color, col=color)
  axis(1, at=seq(1,nsamples,by=1), labels=colnames(q), las=2, cex.axis=0.8, tick=T)
  axis(2, at=seq(ymin,ymax,by=step), labels=seq(ymin,ymax,by=step), las=2, xlab=F)
  abline(h=1, lty=1)
  abline(h=0.5, lty=2)
  abline(h=0, lty=1)
  
  par(fig=c(0,1,0.7,1), new=TRUE, mar=c(2, 5, 0, 2))
  plot(pval[1,], xlim=c(1, nsamples), ylim=c(0.5,1.5), pch=15, col="orange", axes=FALSE, xlab="", ylab="", cex=1)
  points(pval[2,], xlim=c(1, nsamples), ylim=c(0.5,1.5), pch=15, col="grey", cex=1)
  axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
  #   legend(nsamples/2,1.5, legend=c("Fraction(ref) = 0.5"), pch=c(15), col=c("orange"), bty="n", horiz=TRUE, inset=0,cex=1, adj=-0) 
  
}
