path="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R"
source(paste0(path, "/functions.r"))
source(paste0(path, "/normalization_hk.r"))

# load(file=paste0(path, "/raw.fpkm.7species.v5.Rdata"))
# load(file=paste0(path, "/one2one.7species.v5.Rdata"))
# load(file=paste0(path, "/one2one.7species.X.A.genes.v5.Rdata"))
# load(file=paste0(path, "/expression.one2one.7species.normal.v5.Rdata"))
# load(file=paste0(path, "/expression.all.7species.normal.v5.Rdata"))
# load(file=paste0(path, "/final.expression.tables.7species.v5.Rdata"))
# load(file=paste0(path, "/all.genes.v5.Rdata"))


#----------------------------------------------------------------------------------#
#---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   --- #
#          B E G I N N I N G   O F  D A T A  P R E P A R A T I O N ! ! !           #
#---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   ---   --- #
#----------------------------------------------------------------------------------#


##############################################################################
#                     Load Expression Data for Lizard                        #
##############################################################################

# Adult samples
#---------------------------------------------------------------
lizard.raw <- read.table("~/Documents/Research/Transcriptomics/Lizard/Cuffnorm/E77.Ychrom/samples/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
head(lizard.raw)
genes.raw=lizard.raw[,1]
lizard.raw = as.data.frame(lizard.raw[,c(-1)]) # removes first column with gene names

rownames(lizard.raw) = genes.raw

# Fixing colnames
colnames(lizard.raw) 
colnames(lizard.raw) = gsub("_0", "", colnames(lizard.raw), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)
colnames(lizard.raw) = paste("lizard", colnames(lizard.raw), sep=".")

# Reformating colnames for developmental samples
dev.vec = strsplit(colnames(lizard.raw), "_")
new.col.names = NULL
for (name in dev.vec){
  new.col.names = c(new.col.names, paste0(paste(name[c(1,2)], collapse=".")))
}
new.col.names
colnames(lizard.raw) = new.col.names
colnames(lizard.raw)


# Developmental samples
#---------------------------------------------------------------
lizard.dev.raw <- read.table("~/Documents/Research/Transcriptomics/Lizard/Cuffnorm/E77.Ychrom/samples.dev/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
head(lizard.dev.raw)
genes.raw=lizard.dev.raw[,1]
lizard.dev.raw = as.data.frame(lizard.dev.raw[,c(-1)]) # removes first column with gene names

rownames(lizard.dev.raw) = genes.raw

# Fixing colnames
colnames(lizard.dev.raw) 
colnames(lizard.dev.raw) = gsub("_0", "", colnames(lizard.dev.raw), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)
colnames(lizard.dev.raw) = paste("lizard", colnames(lizard.dev.raw), sep=".")

# Reformating colnames for developmental samples
dev.vec = strsplit(colnames(lizard.dev.raw), "\\.")
new.col.names = NULL
for (name in dev.vec){
  if (length(name) == 6){
    new.col.names = c(new.col.names, paste0(paste(name[c(1,5,2,3)], collapse="."), "-", name[4]))
  }else{
    new.col.names = c(new.col.names, paste(name[c(1,4,2,3)], collapse="."))
  }
}
new.col.names
colnames(lizard.dev.raw) = new.col.names
colnames(lizard.dev.raw)


##############################################################################
#                     Load Expression Data for Human                         #
##############################################################################
human.raw <- read.table("~/Documents/Research/Transcriptomics/Human/Cuffnorm/E77.Ychrom/samples/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
genes.raw=human.raw[,1]
head(human.raw)
human.raw = as.data.frame(human.raw[,c(-1)]) 
head(human.raw)
rownames(human.raw) = genes.raw
colnames(human.raw)
colnames(human.raw) = sapply(strsplit(colnames(human.raw), "\\."), function(x) paste(c("human", x[c(1,2)]), collapse="."))
colnames(human.raw)


##############################################################################
#                     Load Expression Data for Mouse                         #
##############################################################################
mouse.raw <- read.table("~/Documents/Research/Transcriptomics/Mouse/Cuffnorm/E77.Ychrom/samples/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
genes.raw=mouse.raw[,1]
head(mouse.raw)
mouse.raw = as.data.frame(mouse.raw[,c(-1)]) 
head(mouse.raw)
rownames(mouse.raw) = genes.raw
colnames(mouse.raw)
colnames(mouse.raw) = sapply(strsplit(colnames(mouse.raw), "\\."), function(x) paste(c("mouse", x[c(1,2)]), collapse="."))
colnames(mouse.raw)


##############################################################################
#                     Load Expression Data for Opossum                       #
##############################################################################

opossum.raw <- read.table("~/Documents/Research/Transcriptomics/Opossum/Cuffnorm/E77.Ychrom/samples/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
genes.raw=opossum.raw[,1]
head(opossum.raw)
opossum.raw = as.data.frame(opossum.raw[, -which(colnames(opossum.raw) %in% c("tracking_id", "Brain.Female2.3994sTS_0"))]) # Excluding lib 3994 for bad quality
head(opossum.raw)
rownames(opossum.raw) = genes.raw
colnames(opossum.raw)
colnames(opossum.raw) = sapply(strsplit(colnames(opossum.raw), "\\."), function(x) paste(c("opossum", x[c(1,2)]), collapse="."))
colnames(opossum.raw)

##############################################################################
#                     Load Expression Data for Platypus                      #
##############################################################################
platypus.raw <- read.table("~/Documents/Research/Transcriptomics/Platypus/Cuffnorm/E77.Ychrom/samples/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
genes.raw=platypus.raw[,1]
head(platypus.raw)
platypus.raw = as.data.frame(platypus.raw[,c(-1)]) 
head(platypus.raw)
rownames(platypus.raw) = genes.raw
colnames(platypus.raw)
colnames(platypus.raw) = sapply(strsplit(colnames(platypus.raw), "\\."), function(x) paste(c("platypus", x[c(1,2)]), collapse="."))
colnames(platypus.raw)

##############################################################################
#                     Load Expression Data for Chicken                       #
##############################################################################
chicken.raw <- read.table("~/Documents/Research/Transcriptomics/Chicken/Cuffnorm/E77.Ychrom/samples/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
genes.raw=chicken.raw[,1]
head(chicken.raw)
chicken.raw = as.data.frame(chicken.raw[,c(-1)]) 
head(chicken.raw)
rownames(chicken.raw) = genes.raw
colnames(chicken.raw)
colnames(chicken.raw) = sapply(strsplit(colnames(chicken.raw), "\\."), function(x) paste(c("chicken", x[c(1,2)]), collapse="."))
colnames(chicken.raw)

##############################################################################
#                     Load Expression Data for Xenopus                       #
##############################################################################
xenopus.raw <- read.table("~/Documents/Research/Transcriptomics/Xenopus/Cuffnorm/E77.Ychrom/samples/genes.fpkm_table", head=TRUE, sep="\t", fill=TRUE, stringsAsFactors=F)
genes.raw=xenopus.raw[,1]
head(xenopus.raw)
xenopus.raw = as.data.frame(xenopus.raw[,c(-1)]) 
head(xenopus.raw)
rownames(xenopus.raw) = genes.raw
colnames(xenopus.raw)
colnames(xenopus.raw) = sapply(strsplit(colnames(xenopus.raw), "\\."), function(x) paste(c("xenopus", x[c(1,2)]), collapse="."))
colnames(xenopus.raw)

##############################################################################################################
save(human.raw, 
     mouse.raw, 
     chicken.raw, 
     opossum.raw,
     platypus.raw, 
     lizard.raw,
     lizard.dev.raw,
     xenopus.raw,
     file=paste0(path, "/raw.fpkm.7species.v5.Rdata"))
##############################################################################################################


##############################################################################
#                               Load 1:1 orthologs                           #
##############################################################################
#                                 7 Species                                 #
##############################################################################
one2one.7sp.raw <- read.table("~/Documents/Research/One2OneOrthologs/Lizard.project.E77/one2one.human.xenopus.7species.proteincoding", head=F, sep=" ", fill=TRUE, stringsAsFactors=F)
rownames(one2one.7sp.raw) = one2one.7sp.raw[,1]
colnames(one2one.7sp.raw) = c("human", "mouse", "opossum", "platypus",  "chicken", "lizard", "xenopus")
one2one.7sp.raw = as.data.frame(one2one.7sp.raw)
dim(one2one.7sp.raw)
one2one.7sp = one2one.7sp.raw[intersect(rownames(human.raw), rownames(one2one.7sp.raw)),] # This step is to prevent errors caused by one2one orthologs not present in the expression tables (< 1% are discarded)
one2one.7sp = one2one.7sp.raw
dim(one2one.7sp)

save(one2one.7sp, file=paste0(path, "/one2one.7species.v5.Rdata"))


##############################################################################
#           Normalize expression values across all species an tissues        #
##############################################################################
#                                 7 Species                                  #
##############################################################################

# Merge expression data for one2one orthologs for lizard unstranded
#------------------------------------------------------------------
EM_one2one.7sp = cbind(human.raw[one2one.7sp[,"human"], ],
                       mouse.raw[one2one.7sp[,"mouse"], ], 
                       opossum.raw[one2one.7sp[,"opossum"], ], 
                       platypus.raw[one2one.7sp[,"platypus"], ], 
                       chicken.raw[one2one.7sp[,"chicken"], ], 
                       xenopus.raw[one2one.7sp[,"xenopus"], ],
                       lizard.raw[one2one.7sp[,"lizard"], ], 
                       lizard.dev.raw[one2one.7sp[,"lizard"], ],
                       deparse.level=2)
colnames(EM_one2one.7sp)

# Normalize data for one2one orthologs ONLY
#--------------------------------------------------------
EM_one2one.7sp.hk = normalization(EM_one2one.7sp)

# par(mfrow=c(1,1))
boxplot(sqrt(EM_one2one.7sp), ylim=c(0,20), outline=F)
boxplot(sqrt(EM_one2one.7sp.hk), ylim=c(0,20), outline=F)

save(EM_one2one.7sp, 
     EM_one2one.7sp.hk,
     file=paste0(path, "/expression.one2one.7species.normal.v5.Rdata"))


# Normalize data for all genes in each species Unstranded
#-------------------------------------------------------------
EM_one2one.7sp.hk_coef = normalization_coef(EM_one2one.7sp)
human.hk.7sp = t(t(human.raw) / EM_one2one.7sp.hk_coef[colnames(human.raw)])
mouse.hk.7sp = t(t(mouse.raw) / EM_one2one.7sp.hk_coef[colnames(mouse.raw)])
opossum.hk.7sp = t(t(opossum.raw) / EM_one2one.7sp.hk_coef[colnames(opossum.raw)])
platypus.hk.7sp = t(t(platypus.raw) / EM_one2one.7sp.hk_coef[colnames(platypus.raw)])
chicken.hk.7sp = t(t(chicken.raw) / EM_one2one.7sp.hk_coef[colnames(chicken.raw)])
xenopus.hk.7sp = t(t(xenopus.raw) / EM_one2one.7sp.hk_coef[colnames(xenopus.raw)])
lizard.hk.7sp = t(t(lizard.raw) / EM_one2one.7sp.hk_coef[colnames(lizard.raw)])
lizard.dev.hk.7sp = t(t(lizard.dev.raw) / EM_one2one.7sp.hk_coef[colnames(lizard.dev.raw)])

save(EM_one2one.7sp.hk_coef, 
     human.hk.7sp, 
     mouse.hk.7sp, 
     opossum.hk.7sp, 
     platypus.hk.7sp, 
     chicken.hk.7sp, 
     lizard.hk.7sp, 
     lizard.dev.hk.7sp,
     xenopus.hk.7sp,
     file=paste0(path, "/expression.all.7species.normal.v5.Rdata"))




##############################################################################
#                     Collapse expression values per tissue                  #
##############################################################################
#                                 7 species                                  #
##############################################################################
#                                  Lizard                                    #
##############################################################################

# Adult samples
#---------------------------------------------------------------
brain.male = apply(lizard.hk.7sp[,paste0("lizard.Brain.Male", c(1,2,3))], 1, median)
heart.male = apply(lizard.hk.7sp[,paste0("lizard.Heart.Male", c(1,2,3))], 1, median)
kidney.male = apply(lizard.hk.7sp[,paste0("lizard.Kidney.Male", c(1,2,3))], 1, median)
liver.male = apply(lizard.hk.7sp[,paste0("lizard.Liver.Male", c(1,2,3))], 1, median)
gonads.male = apply(lizard.hk.7sp[,paste0("lizard.Testis.Male", c(1,2,4))], 1, median)
brain.female = apply(lizard.hk.7sp[,paste0("lizard.Brain.Female", c(1,2,3))], 1, median)
heart.female = apply(lizard.hk.7sp[,paste0("lizard.Heart.Female", c(1,2,3))], 1, median)
kidney.female = apply(lizard.hk.7sp[,paste0("lizard.Kidney.Female", c(1,2,3))], 1, median)
liver.female = apply(lizard.hk.7sp[,paste0("lizard.Liver.Female", c(1,2,3))], 1, median)
gonads.female = apply(lizard.hk.7sp[,paste0("lizard.Ovary.Female", c(1,2,3))], 1, median)
colnames(lizard.hk.7sp)
lizard.7sp = as.data.frame(cbind(brain.male, heart.male, kidney.male, liver.male, gonads.male, brain.female, heart.female, kidney.female, liver.female, gonads.female))
head(lizard.7sp)
colnames(lizard.7sp)

# Load list of genes
#---------------------------------------------
lizard.genes <- as.data.frame(read.table("~/Documents/Research/Genomics/Lizard/Ensembl/lizard.genes.E77.txt", head=T, sep="\t", fill=TRUE))
lizard.genes = lizard.genes[, c("Ensembl.Gene.ID", "Chromosome.Name", "Gene.Biotype",  "Associated.Gene.Name")]
lizard.genes = unique(lizard.genes)
# dim(lizard.genes)

# Extract different types of genes
#---------------------------------------------
ALinkedGenes = as.character(subset(lizard.genes, Chromosome.Name %in% c(seq(1,6), "LGa", "LGc", "LGd", "LGe", "LGf", "LGg", "LGh"))$Ensembl.Gene.ID)
unique(lizard.genes$Chromosome.Name)
XLinkedGenes <- read.table("~/Documents/Research/Genomics/Lizard/Analysis_coverage/Cummulative_diff/lizard_Xlinked_genes.uniq", head=F, sep="\t", fill=TRUE)
XLinkedGenes = as.vector(XLinkedGenes[,1])
YLinkedGenes <- read.table("~/Documents/Research/Genomics/Lizard/Ensembl/lizard.Ylinked.genes.v2", head=F, sep="\t", fill=TRUE)
YLinkedGenes = as.vector(YLinkedGenes[,1])
MTLinkedGenes = as.character(subset(lizard.genes, Chromosome.Name=="MT")$Ensembl.Gene.ID)


A <- rep("UNK", length(rownames(lizard.7sp)))
lizard.7sp["AXY"] = A
lizard.7sp[ALinkedGenes, "AXY"] <- "A"
lizard.7sp[XLinkedGenes, "AXY"] <- "X"
lizard.7sp[YLinkedGenes, "AXY"] <- "Y"
lizard.7sp[MTLinkedGenes, "AXY"] <- "MT"
which(lizard.7sp[,"AXY"] == "A")
which(lizard.7sp[,"AXY"] == "X")
which(lizard.7sp[,"AXY"] == "Y")
which(lizard.7sp[,"AXY"] == "MT")
which(lizard.7sp[,"AXY"] == "UNK")

lizard.7sp["gene"] = rownames(lizard.7sp)

# Developmental samples
#---------------------------------------------------------------
embryo.2_3d.male = lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.2-3d")]
embryo.4_5d.male = lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.4-5d")]
embryo.5d.male = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.5d", "lizard.Embryo.Male2.5d")], 1, median)
embryo.5_6d.male = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.5-6d", "lizard.Embryo.Male2.5-6d")], 1, median)
embryo.6_7d.male = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.6-7d", "lizard.Embryo.Male2.6-7d")], 1, median)
embryo.8d.male = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.8d", "lizard.Embryo.Male2.8d", "lizard.Embryo.Male3.8d")], 1, median)
embryo.8_9d.male = lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.8-9d")]
embryo.9d.male = lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.9d")]
embryo.10d.male = lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.10d")]
embryo.10_11d.male = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.10-11d", "lizard.Embryo.Male2.10-11d")], 1, median)
embryo.14d.male = lizard.dev.hk.7sp[,c("lizard.Embryo.Male1.14d")]
brain.13d.male = lizard.dev.hk.7sp[,c("lizard.Brain.Male1.13d")]
gonads.13d.male = lizard.dev.hk.7sp[,c("lizard.Gonads.Male1.13d")]
brain.15d.male = apply(lizard.dev.hk.7sp[,c("lizard.Brain.Male1.15d", "lizard.Brain.Male2.15d")], 1, median)
heart.15d.male = apply(lizard.dev.hk.7sp[,c("lizard.Heart.Male1.15d", "lizard.Heart.Male2.15d")], 1, median)
kidney.15d.male = apply(lizard.dev.hk.7sp[,c("lizard.Kidney.Male1.15d", "lizard.Kidney.Male2.15d")], 1, median)
liver.15d.male = apply(lizard.dev.hk.7sp[,c("lizard.Liver.Male1.15d", "lizard.Liver.Male2.15d")], 1, median)
gonads.15d.male = lizard.dev.hk.7sp[,c("lizard.Gonads.Male2.15d")]
brain.16d.male = lizard.dev.hk.7sp[,c("lizard.Brain.Male1.16d")]
heart.16d.male = lizard.dev.hk.7sp[,c("lizard.Heart.Male1.16d")]
kidney.16d.male = lizard.dev.hk.7sp[,c("lizard.Kidney.Male1.16d")]
liver.16d.male = lizard.dev.hk.7sp[,c("lizard.Liver.Male1.16d")]
gonads.16d.male = lizard.dev.hk.7sp[,c("lizard.Gonads.Male1.16d")]

embryo.5_6d.female = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Female1.5-6d", "lizard.Embryo.Female2.5-6d")], 1, median)
embryo.6d.female = lizard.dev.hk.7sp[,c("lizard.Embryo.Female1.6d")]
embryo.9d.female = lizard.dev.hk.7sp[,c("lizard.Embryo.Female1.9d")]
embryo.9_10d.female = lizard.dev.hk.7sp[,c("lizard.Embryo.Female1.9-10d")]
embryo.11d.female = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Female1.11d", "lizard.Embryo.Female2.11d")], 1, median)
embryo.13d.female = apply(lizard.dev.hk.7sp[,c("lizard.Embryo.Female1.13d", "lizard.Embryo.Female2.13d", "lizard.Embryo.Female2.13d")], 1, median)
brain.15d.female = lizard.dev.hk.7sp[,c("lizard.Brain.Female1.15d")]
heart.15d.female = lizard.dev.hk.7sp[,c("lizard.Heart.Female1.15d")]
kidney.15d.female = lizard.dev.hk.7sp[,c("lizard.Kidney.Female1.15d")]
liver.15d.female = lizard.dev.hk.7sp[,c("lizard.Liver.Female1.15d")]
gonads.15d.female = lizard.dev.hk.7sp[,c("lizard.Gonads.Female1.15d")]

lizard.dev.7sp = as.data.frame(cbind(embryo.2_3d.male, embryo.4_5d.male, embryo.5d.male, embryo.5_6d.male, embryo.6_7d.male, embryo.8d.male, embryo.8_9d.male, embryo.9d.male, embryo.10d.male, embryo.10_11d.male, embryo.14d.male, brain.13d.male, gonads.13d.male, brain.15d.male, heart.15d.male, kidney.15d.male, liver.15d.male, gonads.15d.male, brain.16d.male, heart.16d.male, kidney.16d.male, liver.16d.male, gonads.16d.male, embryo.5_6d.female, embryo.6d.female, embryo.9d.female, embryo.9_10d.female, embryo.11d.female, embryo.13d.female, brain.15d.female, heart.15d.female, kidney.15d.female, liver.15d.female, gonads.15d.female))
head(lizard.dev.7sp)
colnames(lizard.dev.7sp)


# Extract Autosomal genes
#---------------------------------------------
lizard.dev.7sp["AXY"] = A
lizard.dev.7sp[ALinkedGenes, "AXY"] <- "A"
lizard.dev.7sp[XLinkedGenes, "AXY"] <- "X"
lizard.dev.7sp[YLinkedGenes, "AXY"] <- "Y"
lizard.dev.7sp[MTLinkedGenes, "AXY"] <- "MT"
which(lizard.dev.7sp[,"AXY"] == "A")
which(lizard.dev.7sp[,"AXY"] == "X")
which(lizard.dev.7sp[,"AXY"] == "Y")
which(lizard.dev.7sp[,"AXY"] == "MT")
which(lizard.dev.7sp[,"AXY"] == "UNK")

lizard.dev.7sp["gene"] = rownames(lizard.dev.7sp)

##############################################################################
#                                   Human                                    #
##############################################################################

brain.male = human.hk.7sp[,c("human.Brain.Male1")]
heart.male = apply(human.hk.7sp[,c("human.Heart.Male1","human.Heart.Male2")], 1, median)
kidney.male = apply(human.hk.7sp[,c("human.Kidney.Male1","human.Kidney.Male2")], 1, median)
liver.male = human.hk.7sp[,c("human.Liver.Male1")]
gonads.male = apply(human.hk.7sp[,c("human.Testis.Male1","human.Testis.Male2")], 1, median)
brain.female = human.hk.7sp[,c("human.Brain.Female1")]
heart.female = human.hk.7sp[,c("human.Heart.Female1")]
kidney.female = human.hk.7sp[,c("human.Kidney.Female1")]
liver.female = human.hk.7sp[,c("human.Liver.Female1")]
gonads.female = human.hk.7sp[,c("human.Ovary.Female1")]
human.7sp = as.data.frame(cbind(brain.male, heart.male, kidney.male, liver.male, gonads.male,
                                brain.female, heart.female, kidney.female, liver.female, gonads.female))
head(human.7sp)
dim(human.7sp)

# Load list of genes
#---------------------------------------------
human.genes <- as.data.frame(read.table("~/Documents/Research/Genomics/Human/Ensembl/human.genes.E77.txt", head=T, sep="\t", fill=TRUE))
human.genes = human.genes[, c("Ensembl.Gene.ID", "Chromosome.Name", "Gene.Biotype",  "Associated.Gene.Name")]
human.genes = unique(human.genes)
# dim(human.genes)

# Extract different types of genes
#---------------------------------------------
ALinkedGenes = as.character(subset(human.genes, Chromosome.Name %in% seq(1,22))$Ensembl.Gene.ID)
unique(human.genes$Chromosome.Name)
XLinkedGenes = as.character(subset(human.genes, Chromosome.Name=="X")$Ensembl.Gene.ID)
YLinkedGenes = as.character(subset(human.genes, Chromosome.Name=="Y")$Ensembl.Gene.ID)
MTLinkedGenes = as.character(subset(human.genes, Chromosome.Name=="MT")$Ensembl.Gene.ID)


A <- rep("UNK", length(rownames(human.7sp)))
human.7sp["AXY"] = A
human.7sp[ALinkedGenes, "AXY"] <- "A"
human.7sp[XLinkedGenes, "AXY"] <- "X"
human.7sp[YLinkedGenes, "AXY"] <- "Y"
human.7sp[MTLinkedGenes, "AXY"] <- "MT"
which(human.7sp[,"AXY"] == "A")
which(human.7sp[,"AXY"] == "X")
which(human.7sp[,"AXY"] == "Y")
which(human.7sp[,"AXY"] == "MT")
which(human.7sp[,"AXY"] == "UNK")

human.7sp["gene"] = rownames(human.7sp)

##############################################################################
#                                   Mouse                                    #
##############################################################################

brain.male = apply(mouse.hk.7sp[,paste0("mouse.Brain.Male", c(1,2))], 1, median)
heart.male = apply(mouse.hk.7sp[,paste0("mouse.Heart.Male", c(1,2))], 1, median)
# kidney.male = apply(mouse.hk.7sp[,paste0("mouse.Kidney.Male", c(1,2))], 1, median) # Missing Kidney Male 1 here
kidney.male = mouse.hk.7sp[,paste0("mouse.Kidney.Male", c(2))] # Missing Kidney Male 1 here
liver.male = apply(mouse.hk.7sp[,paste0("mouse.Liver.Male", c(1,2))], 1, median)
gonads.male = apply(mouse.hk.7sp[,paste0("mouse.Testis.Male", c(1,2))], 1, median)
brain.female = apply(mouse.hk.7sp[,paste0("mouse.Brain.Female", c(1,2))], 1, median)
heart.female = apply(mouse.hk.7sp[,paste0("mouse.Heart.Female", c(1,2))], 1, median)
kidney.female = apply(mouse.hk.7sp[,paste0("mouse.Kidney.Female", c(1,2))], 1, median)
liver.female = apply(mouse.hk.7sp[,paste0("mouse.Liver.Female", c(1,2))], 1, median)
gonads.female = apply(mouse.hk.7sp[,paste0("mouse.Ovary.Female", c(1,2))], 1, median)
colnames(mouse.hk.7sp)
mouse.7sp = as.data.frame(cbind(brain.male, heart.male, kidney.male, liver.male, gonads.male, brain.female, heart.female, kidney.female, liver.female, gonads.female))
head(mouse.7sp)
colnames(mouse.7sp)

# Load list of genes
#---------------------------------------------
mouse.genes <- as.data.frame(read.table("~/Documents/Research/Genomics/Mouse/Ensembl/mouse.genes.E77.txt", head=T, sep="\t", fill=TRUE))
mouse.genes = mouse.genes[, c("Ensembl.Gene.ID", "Chromosome.Name", "Gene.Biotype",  "Associated.Gene.Name")]
mouse.genes = unique(mouse.genes)
# dim(mouse.genes)

# Extract different types of genes
#---------------------------------------------
ALinkedGenes = as.character(subset(mouse.genes, Chromosome.Name %in% seq(1,19))$Ensembl.Gene.ID)
# unique(mouse.genes$Chromosome.Name)
XLinkedGenes = as.character(subset(mouse.genes, Chromosome.Name=="X")$Ensembl.Gene.ID)
YLinkedGenes = as.character(subset(mouse.genes, Chromosome.Name=="Y")$Ensembl.Gene.ID)
MTLinkedGenes = as.character(subset(mouse.genes, Chromosome.Name=="MT")$Ensembl.Gene.ID)


A <- rep("UNK", length(rownames(mouse.7sp)))
mouse.7sp["AXY"] = A
mouse.7sp[ALinkedGenes, "AXY"] <- "A"
mouse.7sp[XLinkedGenes, "AXY"] <- "X"
mouse.7sp[YLinkedGenes, "AXY"] <- "Y"
mouse.7sp[MTLinkedGenes, "AXY"] <- "MT"
which(mouse.7sp[,"AXY"] == "A")
which(mouse.7sp[,"AXY"] == "X")
which(mouse.7sp[,"AXY"] == "Y")
which(mouse.7sp[,"AXY"] == "MT")
which(mouse.7sp[,"AXY"] == "UNK")

mouse.7sp["gene"] = rownames(mouse.7sp)

##############################################################################
#                                   Opossum                                  #
##############################################################################

# brain.male = apply(opossum.hk.7sp[,paste0("opossum.Brain.Male", c(1,2))], 1, median)
brain.male =  opossum.hk.7sp[,paste0("opossum.Brain.Male", c(1))] # Missing Brain Male 2 here
heart.male = apply(opossum.hk.7sp[,paste0("opossum.Heart.Male", c(1,2))], 1, median)
kidney.male = apply(opossum.hk.7sp[,paste0("opossum.Kidney.Male", c(1,2))], 1, median)
liver.male = apply(opossum.hk.7sp[,paste0("opossum.Liver.Male", c(1,2))], 1, median)
gonads.male = apply(opossum.hk.7sp[,paste0("opossum.Testis.Male", c(1,2))], 1, median)
brain.female = opossum.hk.7sp[,paste0("opossum.Brain.Female", c(1))]  # Missing Brain Female 2 here
heart.female = apply(opossum.hk.7sp[,paste0("opossum.Heart.Female", c(1,2))], 1, median)
kidney.female = apply(opossum.hk.7sp[,paste0("opossum.Kidney.Female", c(1,2))], 1, median)
liver.female = apply(opossum.hk.7sp[,paste0("opossum.Liver.Female", c(1,2))], 1, median)
gonads.female = opossum.hk.7sp[,paste0("opossum.Ovary.Female", c(2))] # Missing Ovary Female 1 here
colnames(opossum.hk.7sp)
opossum.7sp = as.data.frame(cbind(brain.male, heart.male, kidney.male, liver.male, gonads.male, brain.female, heart.female, kidney.female, liver.female, gonads.female))
head(opossum.7sp)
colnames(opossum.7sp)


# Load list of genes
#---------------------------------------------
opossum.genes <- as.data.frame(read.table("~/Documents/Research/Genomics/Opossum/Ensembl/opossum.genes.E77.txt", head=T, sep="\t", fill=TRUE))
opossum.genes = opossum.genes[, c("Ensembl.Gene.ID", "Chromosome.Name", "Gene.Biotype",  "Associated.Gene.Name")]
opossum.genes = unique(opossum.genes)
dim(opossum.genes)

# Extract different types of genes
#---------------------------------------------
ALinkedGenes = as.character(subset(opossum.genes, Chromosome.Name %in% seq(1,8))$Ensembl.Gene.ID)
XLinkedGenes = as.character(subset(opossum.genes, Chromosome.Name=="X")$Ensembl.Gene.ID)
YLinkedGenes <- read.table("~/Documents/Research/Genomics/Opossum/Ensembl/opossum.genes.chrY.txt", head=F, sep="\t", fill=TRUE)
YLinkedGenes = as.vector(YLinkedGenes[,1])
MTLinkedGenes = as.character(subset(opossum.genes, Chromosome.Name=="MT")$Ensembl.Gene.ID)


A <- rep("UNK", length(rownames(opossum.7sp)))
opossum.7sp["AXY"] = A
opossum.7sp[ALinkedGenes, "AXY"] <- "A"
opossum.7sp[XLinkedGenes, "AXY"] <- "X"
opossum.7sp[YLinkedGenes, "AXY"] <- "Y"
opossum.7sp[MTLinkedGenes, "AXY"] <- "MT"
which(opossum.7sp[,"AXY"] == "A")
which(opossum.7sp[,"AXY"] == "X")
which(opossum.7sp[,"AXY"] == "Y")
which(opossum.7sp[,"AXY"] == "MT")
which(opossum.7sp[,"AXY"] == "UNK")

opossum.7sp["gene"] = rownames(opossum.7sp)


##############################################################################
#                                   Platypus                                  #
##############################################################################

brain.male = apply(platypus.hk.7sp[,paste0("platypus.Brain.Male", c(1,2))], 1, median)
heart.male = apply(platypus.hk.7sp[,paste0("platypus.Heart.Male", c(1,2))], 1, median)
kidney.male = apply(platypus.hk.7sp[,paste0("platypus.Kidney.Male", c(1,2))], 1, median)
liver.male = apply(platypus.hk.7sp[,paste0("platypus.Liver.Male", c(1,2))], 1, median)
gonads.male = apply(platypus.hk.7sp[,paste0("platypus.Testis.Male", c(1,2))], 1, median)
brain.female = apply(platypus.hk.7sp[,paste0("platypus.Brain.Female", c(1,2))], 1, median)
heart.female = apply(platypus.hk.7sp[,paste0("platypus.Heart.Female", c(1,2))], 1, median)
kidney.female = apply(platypus.hk.7sp[,paste0("platypus.Kidney.Female", c(1,2))], 1, median)
liver.female = apply(platypus.hk.7sp[,paste0("platypus.Liver.Female", c(1,2))], 1, median)
gonads.female = apply(platypus.hk.7sp[,paste0("platypus.Ovary.Female", c(1,2))], 1, median)
colnames(platypus.hk.7sp)
platypus.7sp = as.data.frame(cbind(brain.male, heart.male, kidney.male, liver.male, gonads.male, brain.female, heart.female, kidney.female, liver.female, gonads.female))
head(platypus.7sp)
colnames(platypus.7sp)

# Load list of genes
#---------------------------------------------
platypus.genes <- as.data.frame(read.table("~/Documents/Research/Genomics/Platypus/Ensembl/platypus.genes.E77.txt", head=T, sep="\t", fill=TRUE))
platypus.genes = platypus.genes[, c("Ensembl.Gene.ID", "Chromosome.Name", "Gene.Biotype",  "Associated.Gene.Name")]
platypus.genes = unique(platypus.genes)
dim(platypus.genes)
head(platypus.genes)


# Extract different types of genes
#---------------------------------------------
ALinkedGenes = as.character(subset(platypus.genes, Chromosome.Name %in% c(seq(1,7), seq(10,12), 15, 17, 18, 20))$Ensembl.Gene.ID)
# unique(subset(platypus.genes, Ensembl.Gene.ID %in% ALinkedGenes)$Chromosome.Name)
XLinkedGenes <- read.table("~/Documents/Research/Genomics/Platypus/Ensembl/platypus.genes.E77.chrX.txt", head=F, sep="\t", fill=TRUE)
XLinkedGenes = as.vector(XLinkedGenes[,1])
YLinkedGenes <- read.table("~/Documents/Research/Genomics/Platypus/Ensembl/platypus.genes.chrY.txt", head=F, sep="\t", fill=TRUE)
YLinkedGenes = as.vector(YLinkedGenes[,1])
MTLinkedGenes = as.character(subset(platypus.genes, Chromosome.Name=="MT")$Ensembl.Gene.ID)


A <- rep("UNK", length(rownames(platypus.7sp)))
platypus.7sp["AXY"] = A
platypus.7sp[ALinkedGenes, "AXY"] <- "A"
platypus.7sp[XLinkedGenes, "AXY"] <- "X"
platypus.7sp[YLinkedGenes, "AXY"] <- "Y"
platypus.7sp[MTLinkedGenes, "AXY"] <- "MT"
which(platypus.7sp[,"AXY"] == "A")
which(platypus.7sp[,"AXY"] == "X")
which(platypus.7sp[,"AXY"] == "Y")
which(platypus.7sp[,"AXY"] == "MT")
which(platypus.7sp[,"AXY"] == "UNK")

platypus.7sp["gene"] = rownames(platypus.7sp)
head(platypus.7sp)



##############################################################################
#                                   Chicken                                  #
##############################################################################

# Adult samples
#---------------------------------------------------------------
brain.male = apply(chicken.hk.7sp[,paste0("chicken.Brain.Male", c(1,2))], 1, median)
heart.male = apply(chicken.hk.7sp[,paste0("chicken.Heart.Male", c(1,2))], 1, median)
kidney.male = apply(chicken.hk.7sp[,paste0("chicken.Kidney.Male", c(1,2))], 1, median)
liver.male = apply(chicken.hk.7sp[,paste0("chicken.Liver.Male", c(1,2))], 1, median)
gonads.male = apply(chicken.hk.7sp[,paste0("chicken.Testis.Male", c(1,2))], 1, median)
brain.female = apply(chicken.hk.7sp[,paste0("chicken.Brain.Female", c(1,2))], 1, median)
heart.female = apply(chicken.hk.7sp[,paste0("chicken.Heart.Female", c(1,2))], 1, median)
kidney.female = apply(chicken.hk.7sp[,paste0("chicken.Kidney.Female", c(1,2))], 1, median)
liver.female = apply(chicken.hk.7sp[,paste0("chicken.Liver.Female", c(1,2))], 1, median)
gonads.female = apply(chicken.hk.7sp[,paste0("chicken.Ovary.Female", c(1,2))], 1, median)
colnames(chicken.hk.7sp)
chicken.7sp = as.data.frame(cbind(brain.male, heart.male, kidney.male, liver.male, gonads.male, brain.female, heart.female, kidney.female, liver.female, gonads.female))
head(chicken.7sp)
colnames(chicken.7sp)

# Load list of genes
#---------------------------------------------
chicken.genes <- as.data.frame(read.table("~/Documents/Research/Genomics/Chicken/Ensembl/chicken.genes.E77.txt.ok", head=T, sep="\t", fill=TRUE))
chicken.genes = chicken.genes[, c("Ensembl.Gene.ID", "Chromosome.Name", "Gene.Biotype",  "Associated.Gene.Name")]
chicken.genes = unique(chicken.genes)
# dim(chicken.genes)

# Extract different types of genes
#---------------------------------------------
ALinkedGenes = as.character(subset(chicken.genes, Chromosome.Name %in% seq(1,28))$Ensembl.Gene.ID)
# unique(subset(chicken.genes, Ensembl.Gene.ID %in% ALinkedGenes)$Chromosome.Name)
ZLinkedGenes = as.character(subset(chicken.genes, Chromosome.Name=="Z")$Ensembl.Gene.ID)
WLinkedGenes <- read.table("~/Documents/Research/Genomics/Chicken/Ensembl/chicken.genes.E77.chrW.mixed.final.txt", head=F, sep="\t", fill=TRUE)
WLinkedGenes = as.vector(WLinkedGenes[,1])
MTLinkedGenes = as.character(subset(chicken.genes, Chromosome.Name=="MT")$Ensembl.Gene.ID)


A <- rep("UNK", length(rownames(chicken.7sp)))
chicken.7sp["AXY"] = A
chicken.7sp[ALinkedGenes, "AXY"] <- "A"
chicken.7sp[ZLinkedGenes, "AXY"] <- "X"
chicken.7sp[WLinkedGenes, "AXY"] <- "Y"
chicken.7sp[MTLinkedGenes, "AXY"] <- "MT"
which(chicken.7sp[,"AXY"] == "A")
which(chicken.7sp[,"AXY"] == "X")
which(chicken.7sp[,"AXY"] == "Y")
which(chicken.7sp[,"AXY"] == "MT")
which(chicken.7sp[,"AXY"] == "UNK")

chicken.7sp["gene"] = rownames(chicken.7sp)


##############################################################################
#                                   Xenopus                                  #
##############################################################################

brain.male = apply(xenopus.hk.7sp[,paste0("xenopus.Brain.Male", c(1,2))], 1, median)
heart.male = apply(xenopus.hk.7sp[,paste0("xenopus.Heart.Male", c(1,2))], 1, median)
kidney.male = apply(xenopus.hk.7sp[,paste0("xenopus.Kidney.Male", c(1,2))], 1, median)
liver.male = apply(xenopus.hk.7sp[,paste0("xenopus.Liver.Male", c(1,2))], 1, median)
gonads.male = apply(xenopus.hk.7sp[,paste0("xenopus.Testis.Male", c(1,2))], 1, median)
brain.female = apply(xenopus.hk.7sp[,paste0("xenopus.Brain.Female", c(1,2))], 1, median)
heart.female = apply(xenopus.hk.7sp[,paste0("xenopus.Heart.Female", c(1,2))], 1, median)
kidney.female = apply(xenopus.hk.7sp[,paste0("xenopus.Kidney.Female", c(1,2))], 1, median)
liver.female = apply(xenopus.hk.7sp[,paste0("xenopus.Liver.Female", c(1,2))], 1, median)
gonads.female = apply(xenopus.hk.7sp[,paste0("xenopus.Ovary.Female", c(1,2))], 1, median)
colnames(xenopus.hk.7sp)
xenopus.7sp = as.data.frame(cbind(brain.male, heart.male, kidney.male, liver.male, gonads.male, brain.female, heart.female, kidney.female, liver.female, gonads.female))
head(xenopus.7sp)
colnames(xenopus.7sp)

# Load list of genes
#---------------------------------------------
xenopus.genes <- as.data.frame(read.table("~/Documents/Research/Genomics/Xenopus/Ensembl/xenopus.genes.E77.txt", head=T, sep="\t", fill=TRUE))
xenopus.genes = xenopus.genes[, c("Ensembl.Gene.ID", "Chromosome.Name", "Gene.Biotype",  "Associated.Gene.Name")]
xenopus.genes = unique(xenopus.genes)
# dim(xenopus.genes)

# Extract different types of genes
#---------------------------------------------

A <- rep("A", length(rownames(xenopus.7sp)))
xenopus.7sp["AXY"] = A

xenopus.7sp["gene"] = rownames(xenopus.7sp)


##############################################################################
# Merge expression data for one2one orthologs and collapsed expression
##############################################################################

human.tmp = human.7sp[one2one.7sp[,"human"], -((length(colnames(human.7sp))-1):length(colnames(human.7sp)))]
colnames(human.tmp) = paste0("human.", colnames(human.tmp))
head(human.tmp)
mouse.tmp = mouse.7sp[one2one.7sp[,"mouse"], -((length(colnames(mouse.7sp))-1):length(colnames(mouse.7sp)))]
colnames(mouse.tmp) = paste0("mouse.", colnames(mouse.tmp))
head(mouse.tmp)
opossum.tmp = opossum.7sp[one2one.7sp[,"opossum"], -((length(colnames(opossum.7sp))-1):length(colnames(opossum.7sp)))]
colnames(opossum.tmp) = paste0("opossum.", colnames(opossum.tmp))
head(opossum.tmp)
platypus.tmp = platypus.7sp[one2one.7sp[,"platypus"], -((length(colnames(platypus.7sp))-1):length(colnames(platypus.7sp)))]
colnames(platypus.tmp) = paste0("platypus.", colnames(platypus.tmp))
head(platypus.tmp)
chicken.tmp = chicken.7sp[one2one.7sp[,"chicken"], -((length(colnames(chicken.7sp))-1):length(colnames(chicken.7sp)))]
colnames(chicken.tmp) = paste0("chicken.", colnames(chicken.tmp))
head(chicken.tmp)
xenopus.tmp = xenopus.7sp[one2one.7sp[,"xenopus"], -((length(colnames(xenopus.7sp))-1):length(colnames(xenopus.7sp)))]
colnames(xenopus.tmp) = paste0("xenopus.", colnames(xenopus.tmp))
head(xenopus.tmp)
lizard.tmp = lizard.7sp[one2one.7sp[,"lizard"], -((length(colnames(lizard.7sp))-1):length(colnames(lizard.7sp)))]
colnames(lizard.tmp) = paste0("lizard.", colnames(lizard.tmp))
head(lizard.tmp)
lizard.dev.tmp = lizard.dev.7sp[one2one.7sp[,"lizard"], -((length(colnames(lizard.dev.7sp))-1):length(colnames(lizard.dev.7sp)))]
colnames(lizard.dev.tmp) = paste0("lizard.", colnames(lizard.dev.tmp))
head(lizard.dev.tmp)

EM_one2one.7sp.collapsed = cbind(human.tmp,
                                 mouse.tmp, 
                                 opossum.tmp, 
                                 platypus.tmp,
                                 chicken.tmp,
                                 xenopus.tmp,
                                 lizard.tmp, 
                                 lizard.dev.tmp, 
                                 deparse.level=2)

EM_one2one.7sp.collapsed["gene"] = rownames(one2one.7sp)
rownames(EM_one2one.7sp.collapsed) = rownames(one2one.7sp)
head(EM_one2one.7sp.collapsed)
colnames(EM_one2one.7sp.collapsed)



EM.full.7sp = list("human"=human.7sp,
                   "mouse"=mouse.7sp,
                   "opossum"=opossum.7sp,
                   "platypus"=platypus.7sp,
                   "chicken"=chicken.7sp,
                   "xenopus"=xenopus.7sp,
                   "lizard"=lizard.7sp,
                   "lizard.dev"=lizard.dev.7sp)
##############################################################################################################
save(EM_one2one.7sp.collapsed, EM.full.7sp, 
     human.7sp, 
     mouse.7sp, 
     opossum.7sp,
     platypus.7sp,
     chicken.7sp, 
     xenopus.7sp,
     lizard.7sp, 
     lizard.dev.7sp,  
     file=paste0(path, "/final.expression.tables.7species.v5.Rdata"))

genes.all = list("human" = human.genes,
                 "mouse" = mouse.genes,
                 "opossum" = opossum.genes,
                 "platypus" = platypus.genes,
                 "chicken" = chicken.genes,
                 "lizard" = lizard.genes,
                 "xenopus" = xenopus.genes)

save(human.genes, 
     mouse.genes, 
     opossum.genes, 
     platypus.genes, 
     chicken.genes, 
     xenopus.genes,
     lizard.genes,
     genes.all,
     file=paste0(path, "/all.genes.v5.Rdata"))


##############################################################################################################

##############################################################################
#            Select X, proto-X, autosome and proto-autosome genes            #
##############################################################################
#                               7 Species                                    #
##############################################################################

human.one2one.7sp = one2one.7sp[, "human"]
human.A = human.7sp[human.7sp[,"AXY"]=="A", "gene"]
human.AK = human.7sp[(human.7sp[,"AXY"]=="A" | human.7sp[,"AXY"]=="UNK"), "gene"]
human.A.one2one.7sp = intersect(human.A, human.one2one.7sp)
human.AK.one2one.7sp = intersect(human.AK, human.one2one.7sp)
h.human.A.one2one.7sp = one2one.7sp[which(human.one2one.7sp %in% human.A.one2one.7sp), 1]
h.human.AK.one2one.7sp = one2one.7sp[which(human.one2one.7sp %in% human.AK.one2one.7sp), 1]
human.X = human.7sp[human.7sp[,"AXY"]=="X", "gene"]
human.X.one2one.7sp = intersect(human.X, human.one2one.7sp)
h.human.X.one2one.7sp = one2one.7sp[which(human.one2one.7sp %in% human.X.one2one.7sp), 1]
length(h.human.A.one2one.7sp)
length(h.human.AK.one2one.7sp)
length(h.human.X.one2one.7sp)

mouse.one2one.7sp = one2one.7sp[, "mouse"]
mouse.A = mouse.7sp[mouse.7sp[,"AXY"]=="A", "gene"]
mouse.AK = mouse.7sp[(mouse.7sp[,"AXY"]=="A" | mouse.7sp[,"AXY"]=="UNK"), "gene"]
mouse.A.one2one.7sp = intersect(mouse.A, mouse.one2one.7sp)
mouse.AK.one2one.7sp = intersect(mouse.AK, mouse.one2one.7sp)
h.mouse.A.one2one.7sp = one2one.7sp[which(mouse.one2one.7sp %in% mouse.A.one2one.7sp), 1]
h.mouse.AK.one2one.7sp = one2one.7sp[which(mouse.one2one.7sp %in% mouse.AK.one2one.7sp), 1]
mouse.X = mouse.7sp[mouse.7sp[,"AXY"]=="X", "gene"]
mouse.X.one2one.7sp = intersect(mouse.X, mouse.one2one.7sp)
h.mouse.X.one2one.7sp = one2one.7sp[which(mouse.one2one.7sp %in% mouse.X.one2one.7sp), 1]
length(h.mouse.A.one2one.7sp)
length(h.mouse.AK.one2one.7sp)
length(h.mouse.X.one2one.7sp)

opossum.one2one.7sp = one2one.7sp[, "opossum"]
opossum.A = opossum.7sp[opossum.7sp[,"AXY"]=="A", "gene"]
opossum.AK = opossum.7sp[(opossum.7sp[,"AXY"]=="A" | opossum.7sp[,"AXY"]=="UNK"), "gene"]
opossum.A.one2one.7sp = intersect(opossum.A, opossum.one2one.7sp)
opossum.AK.one2one.7sp = intersect(opossum.AK, opossum.one2one.7sp)
h.opossum.A.one2one.7sp = one2one.7sp[which(opossum.one2one.7sp %in% opossum.A.one2one.7sp), 1]
h.opossum.AK.one2one.7sp = one2one.7sp[which(opossum.one2one.7sp %in% opossum.AK.one2one.7sp), 1]
opossum.X = opossum.7sp[opossum.7sp[,"AXY"]=="X", "gene"]
opossum.X.one2one.7sp = intersect(opossum.X, opossum.one2one.7sp)
h.opossum.X.one2one.7sp = one2one.7sp[which(opossum.one2one.7sp %in% opossum.X.one2one.7sp), 1]
length(h.opossum.A.one2one.7sp)
length(h.opossum.AK.one2one.7sp)
length(h.opossum.X.one2one.7sp)

platypus.one2one.7sp = one2one.7sp[, "platypus"]
platypus.A = platypus.7sp[platypus.7sp[,"AXY"]=="A", "gene"]
platypus.AK = platypus.7sp[(platypus.7sp[,"AXY"]=="A" | platypus.7sp[,"AXY"]=="UNK"), "gene"]
platypus.A.one2one.7sp = intersect(platypus.A, platypus.one2one.7sp)
platypus.AK.one2one.7sp = intersect(platypus.AK, platypus.one2one.7sp)
h.platypus.A.one2one.7sp = one2one.7sp[which(platypus.one2one.7sp %in% platypus.A.one2one.7sp), 1]
h.platypus.AK.one2one.7sp = one2one.7sp[which(platypus.one2one.7sp %in% platypus.AK.one2one.7sp), 1]
platypus.X = platypus.7sp[platypus.7sp[,"AXY"]=="X", "gene"]
platypus.X.one2one.7sp = intersect(platypus.X, platypus.one2one.7sp)
h.platypus.X.one2one.7sp = one2one.7sp[which(platypus.one2one.7sp %in% platypus.X.one2one.7sp), 1]
length(h.platypus.A.one2one.7sp)
length(h.platypus.AK.one2one.7sp)
length(h.platypus.X.one2one.7sp)

chicken.one2one.7sp = one2one.7sp[, "chicken"]
chicken.A = chicken.7sp[chicken.7sp[,"AXY"]=="A", "gene"]
chicken.AK = chicken.7sp[(chicken.7sp[,"AXY"]=="A" | chicken.7sp[,"AXY"]=="UNK"), "gene"]
chicken.A.one2one.7sp = intersect(chicken.A, chicken.one2one.7sp)
chicken.AK.one2one.7sp = intersect(chicken.AK, chicken.one2one.7sp)
h.chicken.A.one2one.7sp = one2one.7sp[which(chicken.one2one.7sp %in% chicken.A.one2one.7sp), 1]
h.chicken.AK.one2one.7sp = one2one.7sp[which(chicken.one2one.7sp %in% chicken.AK.one2one.7sp), 1]
chicken.X = chicken.7sp[chicken.7sp[,"AXY"]=="X", "gene"]
chicken.X.one2one.7sp = intersect(chicken.X, chicken.one2one.7sp)
h.chicken.X.one2one.7sp = one2one.7sp[which(chicken.one2one.7sp %in% chicken.X.one2one.7sp), 1]
length(h.chicken.A.one2one.7sp)
length(h.chicken.AK.one2one.7sp)
length(h.chicken.X.one2one.7sp)

lizard.one2one.7sp = one2one.7sp[, "lizard"]
lizard.A = lizard.7sp[lizard.7sp[,"AXY"]=="A", "gene"]
lizard.AK = lizard.7sp[(lizard.7sp[,"AXY"]=="A" | lizard.7sp[,"AXY"]=="UNK"), "gene"]
lizard.A.one2one.7sp = intersect(lizard.A, lizard.one2one.7sp)
lizard.AK.one2one.7sp = intersect(lizard.AK, lizard.one2one.7sp)
h.lizard.A.one2one.7sp = one2one.7sp[which(lizard.one2one.7sp %in% lizard.A.one2one.7sp), 1]
h.lizard.AK.one2one.7sp = one2one.7sp[which(lizard.one2one.7sp %in% lizard.AK.one2one.7sp), 1]
lizard.X = lizard.7sp[lizard.7sp[,"AXY"]=="X", "gene"]
lizard.X.one2one.7sp = intersect(lizard.X, lizard.one2one.7sp)
h.lizard.X.one2one.7sp = one2one.7sp[which(lizard.one2one.7sp %in% lizard.X.one2one.7sp), 1]
length(h.lizard.A.one2one.7sp)
length(h.lizard.AK.one2one.7sp)
length(h.lizard.X.one2one.7sp)

xenopus.one2one.7sp = one2one.7sp[, "xenopus"]
xenopus.A = xenopus.7sp[xenopus.7sp[,"AXY"]=="A", "gene"]
xenopus.AK = xenopus.7sp[(xenopus.7sp[,"AXY"]=="A" | xenopus.7sp[,"AXY"]=="UNK"), "gene"]
xenopus.A.one2one.7sp = intersect(xenopus.A, xenopus.one2one.7sp)
xenopus.AK.one2one.7sp = intersect(xenopus.AK, xenopus.one2one.7sp)
h.xenopus.A.one2one.7sp = one2one.7sp[which(xenopus.one2one.7sp %in% xenopus.A.one2one.7sp), 1]
h.xenopus.AK.one2one.7sp = one2one.7sp[which(xenopus.one2one.7sp %in% xenopus.AK.one2one.7sp), 1]
xenopus.X = xenopus.7sp[xenopus.7sp[,"AXY"]=="X", "gene"]
xenopus.X.one2one.7sp = intersect(xenopus.X, xenopus.one2one.7sp)
h.xenopus.X.one2one.7sp = one2one.7sp[which(xenopus.one2one.7sp %in% xenopus.X.one2one.7sp), 1]
length(h.xenopus.A.one2one.7sp)
length(h.xenopus.AK.one2one.7sp)
length(h.xenopus.X.one2one.7sp)

one2one.7sp.X.A.genes = list(
  "humanX"=h.human.X.one2one.7sp, "humanA"= h.human.A.one2one.7sp, "humanAK"= h.human.AK.one2one.7sp,
  "mouseX"=h.mouse.X.one2one.7sp, "mouseA"=h.mouse.A.one2one.7sp, "mouseAK"=h.mouse.AK.one2one.7sp,
  "opossumX"=h.opossum.X.one2one.7sp, "opossumA"=h.opossum.A.one2one.7sp, "opossumAK"=h.opossum.AK.one2one.7sp,
  "platypusX"=h.platypus.X.one2one.7sp, "platypusA"=h.platypus.A.one2one.7sp, "platypusAK"=h.platypus.AK.one2one.7sp,
  "chickenX"=h.chicken.X.one2one.7sp, "chickenA"=h.chicken.A.one2one.7sp, "chickenAK"=h.chicken.AK.one2one.7sp, 
  "xenopusX"=h.xenopus.X.one2one.7sp, "xenopusA"=h.xenopus.A.one2one.7sp, "xenopusAK"=h.xenopus.AK.one2one.7sp,
  "lizardX"=h.lizard.X.one2one.7sp, "lizardA"=h.lizard.A.one2one.7sp, "lizardAK"=h.lizard.AK.one2one.7sp)

################################################################################################
save(one2one.7sp.X.A.genes, file=paste0(path, "/one2one.7species.X.A.genes.v5.Rdata"))
################################################################################################


