path="/Users/agkaessmann/Projects/Anolis/Documentation_dosage_compensation"

##############################################################################
#                           Load 1:1 orthologs  (GHIS)                       #
##############################################################################
#                                 7 Species                                  #
##############################################################################

load(file=paste0(path, "/Rdata/one2one.7species.v5.Rdata"))
setwd("~/Projects/Anolis/Documentation_dosage_compensation")
human.genes.ghis <- read.table("ghis_scores_human.txt", header = TRUE) 
colnames(human.genes.ghis)[1] <- "human"
one2one.7sp <- merge(one2one.7sp, human.genes.ghis)
rownames(one2one.7sp) <- one2one.7sp$human
ghis <- one2one.7sp$GHIS

save(one2one.7sp, ghis, human.genes.ghis, file=paste0(path, "/Rdata/GHIS/one2one.7species.ghis.all.Rdata"))

# Filter by GHIS score
# -------------------+

# High (>= median)
#one2one.7sp <- subset(one2one.7sp, GHIS >= median(one2one.7sp$GHIS))
#save(one2one.7sp, file=paste0(path, "/Rdata/GHIS/one2one.7species.ghis.hi.50.Rdata"))

# High (upper quartile)
#one2one.7sp <- subset(one2one.7sp, GHIS >= quantile(one2one.7sp$GHIS)[4])
#save(one2one.7sp, file=paste0(path, "/Rdata/GHIS/one2one.7species.ghis.hi.75.Rdata"))

# Low (< median)
#one2one.7sp <- subset(one2one.7sp, GHIS < median(one2one.7sp$GHIS))
#save(one2one.7sp, file=paste0(path, "/Rdata/GHIS/one2one.7species.ghis.lo.50.Rdata"))

# Low (lower quartile)
#one2one.7sp <- subset(one2one.7sp, GHIS <= quantile(one2one.7sp$GHIS)[2])
#save(one2one.7sp, file=paste0(path, "/Rdata/GHIS/one2one.7species.ghis.lo.25.Rdata"))

##############################################################################
#            Select X, proto-X, autosome and proto-autosome genes (GHIS)     #
##############################################################################
#                               7 Species                                    #
##############################################################################

load(file=paste0(path, "/Rdata/final.expression.tables.7species.v5.Rdata"))

human.one2one.7sp = one2one.7sp[, "human"]
human.A = human.7sp[human.7sp[,"AXY"]=="A", "gene"]
human.AK = human.7sp[(human.7sp[,"AXY"]=="A" | human.7sp[,"AXY"]=="UNK"), "gene"]
human.A.one2one.7sp = intersect(human.A, human.one2one.7sp)
human.AK.one2one.7sp = intersect(human.AK, human.one2one.7sp)
h.human.A.one2one.7sp = one2one.7sp[which(human.one2one.7sp %in% human.A.one2one.7sp), 1]
h.human.AK.one2one.7sp = one2one.7sp[which(human.one2one.7sp %in% human.AK.one2one.7sp), 1]
human.X = human.7sp[human.7sp[,"AXY"]=="X", "gene"]
human.X.one2one.7sp = intersect(human.X, human.one2one.7sp)
h.human.X.one2one.7sp = one2one.7sp[which(human.one2one.7sp %in% human.X.one2one.7sp), 1]
length(h.human.A.one2one.7sp)
length(h.human.AK.one2one.7sp)
length(h.human.X.one2one.7sp)

mouse.one2one.7sp = one2one.7sp[, "mouse"]
mouse.A = mouse.7sp[mouse.7sp[,"AXY"]=="A", "gene"]
mouse.AK = mouse.7sp[(mouse.7sp[,"AXY"]=="A" | mouse.7sp[,"AXY"]=="UNK"), "gene"]
mouse.A.one2one.7sp = intersect(mouse.A, mouse.one2one.7sp)
mouse.AK.one2one.7sp = intersect(mouse.AK, mouse.one2one.7sp)
h.mouse.A.one2one.7sp = one2one.7sp[which(mouse.one2one.7sp %in% mouse.A.one2one.7sp), 1]
h.mouse.AK.one2one.7sp = one2one.7sp[which(mouse.one2one.7sp %in% mouse.AK.one2one.7sp), 1]
mouse.X = mouse.7sp[mouse.7sp[,"AXY"]=="X", "gene"]
mouse.X.one2one.7sp = intersect(mouse.X, mouse.one2one.7sp)
h.mouse.X.one2one.7sp = one2one.7sp[which(mouse.one2one.7sp %in% mouse.X.one2one.7sp), 1]
length(h.mouse.A.one2one.7sp)
length(h.mouse.AK.one2one.7sp)
length(h.mouse.X.one2one.7sp)

opossum.one2one.7sp = one2one.7sp[, "opossum"]
opossum.A = opossum.7sp[opossum.7sp[,"AXY"]=="A", "gene"]
opossum.AK = opossum.7sp[(opossum.7sp[,"AXY"]=="A" | opossum.7sp[,"AXY"]=="UNK"), "gene"]
opossum.A.one2one.7sp = intersect(opossum.A, opossum.one2one.7sp)
opossum.AK.one2one.7sp = intersect(opossum.AK, opossum.one2one.7sp)
h.opossum.A.one2one.7sp = one2one.7sp[which(opossum.one2one.7sp %in% opossum.A.one2one.7sp), 1]
h.opossum.AK.one2one.7sp = one2one.7sp[which(opossum.one2one.7sp %in% opossum.AK.one2one.7sp), 1]
opossum.X = opossum.7sp[opossum.7sp[,"AXY"]=="X", "gene"]
opossum.X.one2one.7sp = intersect(opossum.X, opossum.one2one.7sp)
h.opossum.X.one2one.7sp = one2one.7sp[which(opossum.one2one.7sp %in% opossum.X.one2one.7sp), 1]
length(h.opossum.A.one2one.7sp)
length(h.opossum.AK.one2one.7sp)
length(h.opossum.X.one2one.7sp)

platypus.one2one.7sp = one2one.7sp[, "platypus"]
platypus.A = platypus.7sp[platypus.7sp[,"AXY"]=="A", "gene"]
platypus.AK = platypus.7sp[(platypus.7sp[,"AXY"]=="A" | platypus.7sp[,"AXY"]=="UNK"), "gene"]
platypus.A.one2one.7sp = intersect(platypus.A, platypus.one2one.7sp)
platypus.AK.one2one.7sp = intersect(platypus.AK, platypus.one2one.7sp)
h.platypus.A.one2one.7sp = one2one.7sp[which(platypus.one2one.7sp %in% platypus.A.one2one.7sp), 1]
h.platypus.AK.one2one.7sp = one2one.7sp[which(platypus.one2one.7sp %in% platypus.AK.one2one.7sp), 1]
platypus.X = platypus.7sp[platypus.7sp[,"AXY"]=="X", "gene"]
platypus.X.one2one.7sp = intersect(platypus.X, platypus.one2one.7sp)
h.platypus.X.one2one.7sp = one2one.7sp[which(platypus.one2one.7sp %in% platypus.X.one2one.7sp), 1]
length(h.platypus.A.one2one.7sp)
length(h.platypus.AK.one2one.7sp)
length(h.platypus.X.one2one.7sp)

chicken.one2one.7sp = one2one.7sp[, "chicken"]
chicken.A = chicken.7sp[chicken.7sp[,"AXY"]=="A", "gene"]
chicken.AK = chicken.7sp[(chicken.7sp[,"AXY"]=="A" | chicken.7sp[,"AXY"]=="UNK"), "gene"]
chicken.A.one2one.7sp = intersect(chicken.A, chicken.one2one.7sp)
chicken.AK.one2one.7sp = intersect(chicken.AK, chicken.one2one.7sp)
h.chicken.A.one2one.7sp = one2one.7sp[which(chicken.one2one.7sp %in% chicken.A.one2one.7sp), 1]
h.chicken.AK.one2one.7sp = one2one.7sp[which(chicken.one2one.7sp %in% chicken.AK.one2one.7sp), 1]
chicken.X = chicken.7sp[chicken.7sp[,"AXY"]=="X", "gene"]
chicken.X.one2one.7sp = intersect(chicken.X, chicken.one2one.7sp)
h.chicken.X.one2one.7sp = one2one.7sp[which(chicken.one2one.7sp %in% chicken.X.one2one.7sp), 1]
length(h.chicken.A.one2one.7sp)
length(h.chicken.AK.one2one.7sp)
length(h.chicken.X.one2one.7sp)

lizard.one2one.7sp = one2one.7sp[, "lizard"]
lizard.A = lizard.7sp[lizard.7sp[,"AXY"]=="A", "gene"]
lizard.AK = lizard.7sp[(lizard.7sp[,"AXY"]=="A" | lizard.7sp[,"AXY"]=="UNK"), "gene"]
lizard.A.one2one.7sp = intersect(lizard.A, lizard.one2one.7sp)
lizard.AK.one2one.7sp = intersect(lizard.AK, lizard.one2one.7sp)
h.lizard.A.one2one.7sp = one2one.7sp[which(lizard.one2one.7sp %in% lizard.A.one2one.7sp), 1]
h.lizard.AK.one2one.7sp = one2one.7sp[which(lizard.one2one.7sp %in% lizard.AK.one2one.7sp), 1]
lizard.X = lizard.7sp[lizard.7sp[,"AXY"]=="X", "gene"]
lizard.X.one2one.7sp = intersect(lizard.X, lizard.one2one.7sp)
h.lizard.X.one2one.7sp = one2one.7sp[which(lizard.one2one.7sp %in% lizard.X.one2one.7sp), 1]
length(h.lizard.A.one2one.7sp)
length(h.lizard.AK.one2one.7sp)
length(h.lizard.X.one2one.7sp)

xenopus.one2one.7sp = one2one.7sp[, "xenopus"]
xenopus.A = xenopus.7sp[xenopus.7sp[,"AXY"]=="A", "gene"]
xenopus.AK = xenopus.7sp[(xenopus.7sp[,"AXY"]=="A" | xenopus.7sp[,"AXY"]=="UNK"), "gene"]
xenopus.A.one2one.7sp = intersect(xenopus.A, xenopus.one2one.7sp)
xenopus.AK.one2one.7sp = intersect(xenopus.AK, xenopus.one2one.7sp)
h.xenopus.A.one2one.7sp = one2one.7sp[which(xenopus.one2one.7sp %in% xenopus.A.one2one.7sp), 1]
h.xenopus.AK.one2one.7sp = one2one.7sp[which(xenopus.one2one.7sp %in% xenopus.AK.one2one.7sp), 1]
xenopus.X = xenopus.7sp[xenopus.7sp[,"AXY"]=="X", "gene"]
xenopus.X.one2one.7sp = intersect(xenopus.X, xenopus.one2one.7sp)
h.xenopus.X.one2one.7sp = one2one.7sp[which(xenopus.one2one.7sp %in% xenopus.X.one2one.7sp), 1]
length(h.xenopus.A.one2one.7sp)
length(h.xenopus.AK.one2one.7sp)
length(h.xenopus.X.one2one.7sp)

one2one.7sp.X.A.genes = list(
  "humanX"=h.human.X.one2one.7sp, "humanA"= h.human.A.one2one.7sp, "humanAK"= h.human.AK.one2one.7sp,
  "mouseX"=h.mouse.X.one2one.7sp, "mouseA"=h.mouse.A.one2one.7sp, "mouseAK"=h.mouse.AK.one2one.7sp,
  "opossumX"=h.opossum.X.one2one.7sp, "opossumA"=h.opossum.A.one2one.7sp, "opossumAK"=h.opossum.AK.one2one.7sp,
  "platypusX"=h.platypus.X.one2one.7sp, "platypusA"=h.platypus.A.one2one.7sp, "platypusAK"=h.platypus.AK.one2one.7sp,
  "chickenX"=h.chicken.X.one2one.7sp, "chickenA"=h.chicken.A.one2one.7sp, "chickenAK"=h.chicken.AK.one2one.7sp, 
  "xenopusX"=h.xenopus.X.one2one.7sp, "xenopusA"=h.xenopus.A.one2one.7sp, "xenopusAK"=h.xenopus.AK.one2one.7sp,
  "lizardX"=h.lizard.X.one2one.7sp, "lizardA"=h.lizard.A.one2one.7sp, "lizardAK"=h.lizard.AK.one2one.7sp)

##########################################################################################################
save(one2one.7sp.X.A.genes, file=paste0(path, "/Rdata/GHIS/one2one.7species.X.A.genes.v5.ghis.lo.25.Rdata"))
##########################################################################################################