#clear workspace
rm(list=ls())
library(ggplot2)
library(grid)
library(gridExtra)
library(RColorBrewer)

#setwd("~/Projects/Anolis/ChIP-Seq/Figures/R/Sushi/")
# setwd("~/Server/ForClusterWS/hd_cc141-Anolis_project-0/ChIP-Seq/paired_bams/")
# 
# F127012016.lv.input <- read.table("paired_bwa_F127012016_Lv2_Inp.rmdup.bam.uniq.sorted.GC.bam.bs10k.rpkm.bw.bg",
#                                   sep = "\t",
#                                   header = FALSE)
# 
# M127012016.lv.input <- read.table("paired_bwa_M127012016_Lv1_Input.rmdup.bam.uniq.sorted.GC.bam.bs10k.rpkm.bw.bg",
#                                   sep = "\t",
#                                   header = FALSE)
# 
# F127012016.br.input <- read.table("paired_bwa_F127012016_WB_Input.rmdup.bam.uniq.sorted.GC.bam.bs10k.rpkm.bw.bg",
#                                  sep = "\t",
#                                  header = FALSE)
# 
# M127012016.br.input <- read.table("paired_bwa_M127012016_WB_Input.rmdup.bam.uniq.sorted.GC.bam.bs10k.rpkm.bw.bg",
#                                   sep = "\t",
#                                   header = FALSE)
# 
# F1040.lv.H4K16ac <- read.table("paired_bwa_F1040_Lv_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                sep = "\t",
#                                header = FALSE)
# 
# F127012016.lv.H4K16ac <- read.table("paired_bwa_F127012016_Lv2_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                     sep = "\t",
#                                     header = FALSE)
# 
# M11060514.lv.H4K16ac <- read.table("paired_bwa_M11060514_Lv_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                    sep = "\t",
#                                    header = FALSE)
# 
# M127012016.lv.H4K16ac <- read.table("paired_bwa_M127012016_Lv1_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                     sep = "\t",
#                                     header = FALSE)
# 
# F1040.br.H4K16ac <- read.table("paired_bwa_F1040_WB_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                 sep = "\t",
#                                 header = FALSE)
# 
# F127012016.br.H4K16ac <- read.table("paired_bwa_F127012016_WB_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                     sep = "\t",
#                                     header = FALSE)
# 
# M11060514.br.H4K16ac <- read.table("paired_bwa_M11060514_WB_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                     sep = "\t",
#                                     header = FALSE)
# 
# M127012016.br.H4K16ac <- read.table("paired_bwa_M127012016_WB_H4K16ac.rmdup.bam.uniq.sorted.log2ratio.bs10k.rpkm.bw.bg",
#                                     sep = "\t",
#                                     header = FALSE)
# 
# chr.sizes <- read.table("../../Genome/Aca.txt",
#                         sep = "\t")
#save.image("~/Projects/Anolis/ChIP-Seq/chr_plots.Rdata")
load("~/Dropbox/Anolis_paper/Rdata/chr_plots.Rdata")
############################################################################################################################
F1040.lv.H4K16ac$sample <- rep("F1040.lv.H4K16ac", nrow(F1040.lv.H4K16ac))
F1040.br.H4K16ac$sample <- rep("F1040.br.H4K16ac", nrow(F1040.br.H4K16ac))
F127012016.lv.input$sample <- rep("F127012016.lv.input", nrow(F127012016.lv.input))
F127012016.br.input$sample <- rep("F127012016.br.input", nrow(F127012016.br.input))
F127012016.lv.H4K16ac$sample <- rep("F127012016.lv.H4K16ac", nrow(F127012016.lv.H4K16ac))
F127012016.br.H4K16ac$sample <- rep("F127012016.br.H4K16ac", nrow(F127012016.br.H4K16ac))
M11060514.lv.H4K16ac$sample <- rep("M11060514.lv.H4K16ac", nrow(M11060514.lv.H4K16ac))
M11060514.br.H4K16ac$sample <- rep("M11060514.br.H4K16ac", nrow(M11060514.br.H4K16ac))
M127012016.lv.input$sample <- rep("M127012016.lv.input", nrow(M127012016.lv.input))
M127012016.br.input$sample <- rep("M127012016.br.input", nrow(M127012016.br.input))
M127012016.lv.H4K16ac$sample <- rep("M127012016.lv.H4K16ac", nrow(M127012016.lv.H4K16ac))
M127012016.br.H4K16ac$sample <- rep("M127012016.br.H4K16ac", nrow(M127012016.br.H4K16ac))

all.data <- rbind(F127012016.lv.input, M127012016.lv.input,
                  F127012016.br.input, M127012016.br.input,
                  F1040.lv.H4K16ac, F127012016.lv.H4K16ac,
                  M11060514.lv.H4K16ac, M127012016.lv.H4K16ac,
                  F1040.br.H4K16ac, F127012016.br.H4K16ac,
                  M11060514.br.H4K16ac, M127012016.br.H4K16ac)

colnames(all.data) <- c("chr", "start", "end", "fpkm", "sample")
all.data$chr.type <- ifelse(all.data$chr != "LGb" &
                            all.data$chr != "GL343282.1" &
                            all.data$chr != "GL343338.1" &
                            all.data$chr != "GL343364.1" &
                            all.data$chr != "GL343417.1" &
                            all.data$chr != "GL343423.1" &
                            all.data$chr != "GL343550.1", "A", "X")

sp1 <- do.call(rbind ,strsplit(as.character(all.data$sample), ".", fixed = T))
all.data$tissue <- sp1[, 2]
all.data$data <- sp1[, 3]
sp2 <- do.call(rbind, strsplit(as.character(all.data$sample), "1", fixed = T))
all.data$sex <- sp2[, 1]
all.data <- subset(all.data, chr == "1" |
                             chr == "2" |
                             chr == "3" |
                             chr == "4" |
                             chr == "5" |
                             chr == "6" |
                             chr == "LGa" |
                             chr == "LGb" |
                             chr == "LGc" |
                             chr == "LGd" |
                             chr == "LGf" |
                             chr == "LGg" |
                             chr == "LGh" |
                             chr == "GL343282.1" |
                             chr == "GL343338.1" |
                             chr == "GL343364.1" |
                             chr == "GL343417.1" |
                             chr == "GL343423.1" |
                             chr == "GL343550.1")
all.data$chr <- factor(all.data$chr, levels = c("1", "2", "3", "4", "5", "6",
                                                "LGa", "LGc", "LGd", "LGf", "LGg", "LGh",
                                                "LGb", "GL343282.1", "GL343338.1", "GL343364.1", "GL343417.1",
                                                "GL343423.1", "GL343550.1"
                                                ))

levels(all.data$chr) <- c("1", "2", "3", "4", "5", "6",
                            "LGa", "LGc", "LGd", "LGf", "LGg", "LGh",
                            "LGb", "X1", "X2", "X3", "X4",
                            "X5", "X6")
############################################################################################################################
F127012016.lv.input.plot <- ggplot(subset(all.data, sample == "F127012016.lv.input"), aes(x=start, y=fpkm)) +
  geom_smooth(aes(colour=chr.type, fill=chr.type, alpha=chr.type)) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_text(size = 8, face = "bold"),
        panel.spacing = unit(0.0, "lines"),
        plot.title = element_blank(),
        legend.position = c(0.1, 0.05),
        legend.title = element_blank(),
        legend.text = element_text(face = "bold", size = 10),
        legend.direction = "horizontal",
        axis.line.x = element_blank(),
        axis.title.x = element_blank(),
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.title.y = element_blank(),
        axis.text.y = element_text(face = "bold", size = 7)) +
  ylim(c(0,1)) +
  geom_hline(yintercept = 0.5, linetype = "dashed") +
  scale_colour_manual(values = c("#FB9A99", "#E31A1C")) +
  scale_fill_manual(values = c("#FB9A99", "#E31A1C")) +
  scale_alpha_manual(values = c(0.25, 0.25)) +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE) 
  
M127012016.lv.input.plot <- ggplot(subset(all.data, sample == "M127012016.lv.input"), aes(x=start, y=fpkm)) +
  geom_smooth(aes(colour=chr.type, fill=chr.type, alpha=chr.type)) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_text(size = 8, face = "bold"),
        panel.spacing = unit(0.0, "lines"),
        plot.title = element_blank(),
        legend.position = c(0.1, 0.05),
        legend.title = element_blank(),
        legend.text = element_text(face = "bold", size = 10),
        legend.direction = "horizontal",
        axis.line.x = element_blank(),
        axis.title.x = element_blank(),
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.title.y = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks.y = element_blank(),
        axis.line.y = element_blank()) + 
  ylim(c(0,1)) +
  geom_hline(yintercept = 0.5, linetype = "dashed") +
  scale_colour_manual(values = c("#A6CEE3", "#1F78B4")) +
  scale_fill_manual(values = c("#A6CEE3", "#1F78B4")) +
  scale_alpha_manual(values = c(0.25, 0.25)) +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

# F1040.lv.H4K16ac.plot <- ggplot(subset(all.data, sample == "F1040.lv.H4K16ac"), aes(x=start, y=fpkm)) +
#   geom_smooth(fullrange = F, aes(colour=chr.type)) +
#   theme_classic() +
#   theme(strip.background = element_blank(),
#         strip.text.x = element_blank(),
#         panel.spacing = unit(0.0, "lines"),
#         plot.title = element_blank(),
#         legend.position = "none",
#         axis.line.x = element_blank(),
#         axis.title.x = element_blank(),
#         axis.ticks.x = element_blank(),
#         axis.text.x = element_blank(),
#         axis.title.y = element_blank(),
#         axis.text.y = element_text(face = "bold", size = 15)) +
#   ylim(c(-1,2)) +
#   geom_hline(yintercept = 0, linetype = "dashed") +
#   geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
#   scale_colour_manual(values = c("#4DAF4A", "#984EA3")) +
#   facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

F127012016.lv.H4K16ac.plot <- ggplot(subset(all.data, sample == "F127012016.lv.H4K16ac"), aes(x=start, y=fpkm)) +
  geom_smooth(aes(colour=chr.type, fill=chr.type, alpha=chr.type)) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_blank(),
        plot.title = element_blank(),
        panel.spacing = unit(0.0, "lines"),
        legend.position = "none",
        axis.line.x = element_blank(),
        axis.title.x =  element_blank(),
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.title.y = element_blank(),
        axis.text.y = element_text(face = "bold", size = 15)) +
  ylim(c(-1,2)) +
  geom_hline(yintercept = 0, linetype = "dashed") +
  geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
  scale_colour_manual(values = c("#FB9A99", "#E31A1C")) +
  scale_fill_manual(values = c("#FB9A99", "#E31A1C")) +
  scale_alpha_manual(values = c(0.25, 0.25)) +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

M11060514.lv.H4K16ac.plot <- ggplot(subset(all.data, sample == "M11060514.lv.H4K16ac"), aes(x=start, y=fpkm)) +
  geom_smooth(aes(colour=chr.type, fill=chr.type, alpha=chr.type)) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_blank(),
        panel.spacing = unit(0.0, "lines"),
        plot.title = element_blank(),
        legend.position = "none",
        axis.line.x = element_blank(),
        axis.title.x = element_blank(),
        axis.text.x = element_blank(),
        axis.title.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(),
        axis.ticks.y = element_blank(),
        axis.ticks.length = unit(0, "cm")) + 
  scale_colour_manual(values = c("#A6CEE3", "#1F78B4")) +
  scale_fill_manual(values = c("#A6CEE3", "#1F78B4")) +
  scale_alpha_manual(values = c(0.25, 0.25)) +
  ylim(c(-1,2)) +
  geom_hline(yintercept = 0, linetype = "dashed") +
  geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

# M127012016.lv.H4K16ac.plot <- ggplot(subset(all.data, sample == "M127012016.lv.H4K16ac"), aes(x=start, y=fpkm)) +
#   geom_smooth(aes(colour=chr.type )) +
#   theme_classic() +
#   theme(strip.background = element_blank(),
#         strip.text.x = element_blank(),
#         panel.spacing = unit(0.0, "lines"),
#         plot.title = element_blank(),
#         legend.position = "none",
#         axis.line.x = element_blank(),
#         axis.title.x =  element_blank(),
#         axis.ticks.x = element_blank(),
#         axis.text.x = element_blank(),
#         axis.title.y = element_blank(),
#         axis.text.y = element_text(face = "bold", size = 15)) +
#   ylim(c(-1,2)) +
#   geom_hline(yintercept = 0, linetype = "dashed") +
#   geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
#   scale_colour_manual(values = c("#A65628", "#F781BF")) +
#   facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)
############################################################################################################################
F127012016.br.input.plot <- ggplot(subset(all.data, sample == "F127012016.br.input"), aes(x=start, y=fpkm)) +
  geom_smooth(aes(colour=chr.type )) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_text(size = 5, face = "bold"),
        panel.spacing = unit(0.0, "lines"),
        plot.title = element_blank(),
        legend.position = "none",
        axis.line = element_line(color="white"),
        axis.title = element_blank(),
        axis.text = element_blank(), 
        axis.ticks = element_blank()) +
  ylim(c(0,1)) +
  geom_hline(yintercept = 0.5, linetype = "dashed") +
  scale_colour_brewer(palette = "Set1") +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE) 

M127012016.br.input.plot <- ggplot(subset(all.data, sample == "M127012016.br.input"), aes(x=start, y=fpkm)) +
  geom_smooth(aes(colour=chr.type )) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_blank(),
        panel.spacing = unit(0.0, "lines"),
        plot.title = element_blank(),
        legend.position = "none",
        axis.line = element_line(color="white"),
        axis.title = element_blank(),
        axis.text = element_blank(),
        axis.ticks = element_blank()) + 
  ylim(c(0,1)) +
  geom_hline(yintercept = 0.5, linetype = "dashed") +
  scale_colour_brewer(palette = "Set1") +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

# F1040.br.H4K16ac.plot <- ggplot(subset(all.data, sample == "F1040.br.H4K16ac"), aes(x=start, y=fpkm)) +
#   geom_smooth(fullrange = F, aes(colour=chr.type)) +
#   theme_classic() +
#   theme(strip.background = element_blank(),
#         strip.text.x = element_blank(),
#         panel.spacing = unit(0.0, "lines"),
#         plot.title = element_blank(),
#         legend.position = "none",
#         axis.line = element_line(color="white"),
#         axis.title = element_blank(),
#         axis.ticks = element_blank(),
#         axis.text = element_blank()) +
#   ylim(c(-1,2)) +
#   geom_hline(yintercept = 0, linetype = "dashed") +
#   geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
#   scale_colour_manual(values = c("#4DAF4A", "#984EA3")) +
#   facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

F127012016.br.H4K16ac.plot <- ggplot(subset(all.data, sample == "F127012016.br.H4K16ac"), aes(x=start, y=fpkm)) +
  geom_smooth(fullrange = F, aes(colour=chr.type)) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_blank(),
        plot.title = element_blank(),
        panel.spacing = unit(0.0, "lines"),
        legend.position = "none",
        axis.line = element_line(color="white"),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank()) +
  ylim(c(-1,2)) +
  geom_hline(yintercept = 0, linetype = "dashed") +
  geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
  scale_colour_manual(values = c("#4DAF4A", "#984EA3")) +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

M11060514.br.H4K16ac.plot <- ggplot(subset(all.data, sample == "M11060514.br.H4K16ac"), aes(x=start, y=fpkm)) +
  geom_smooth(fullrange = F, aes(colour=chr.type)) +
  theme_classic() +
  theme(strip.background = element_blank(),
        strip.text.x = element_blank(),
        panel.spacing = unit(0.0, "lines"),
        plot.title = element_blank(),
        legend.position = "none",
        axis.line = element_line(color="white"),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank()) +  
  scale_colour_manual(values = c("#A65628", "#F781BF")) +
  ylim(c(-1,2)) +
  geom_hline(yintercept = 0, linetype = "dashed") +
  geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
  facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

# M127012016.br.H4K16ac.plot <- ggplot(subset(all.data, sample == "M127012016.br.H4K16ac"), aes(x=start, y=fpkm)) +
#   geom_smooth(aes(colour=chr.type )) +
#   theme_classic() +
#   theme(strip.background = element_blank(),
#         strip.text.x = element_blank(),
#         panel.spacing = unit(0.0, "lines"),
#         plot.title = element_blank(),
#         legend.position = "none",
#         axis.line = element_line(color="white"),
#         axis.title = element_blank(),
#         axis.ticks = element_blank(),
#         axis.text = element_blank()) +  
#   ylim(c(-1,2)) +
#   geom_hline(yintercept = 0, linetype = "dashed") +
#   geom_ribbon(aes(ymin=-1, ymax=1), fill = "grey20", alpha = "0.1") +
#   scale_colour_manual(values = c("#A65628", "#F781BF")) +
#   facet_grid(. ~ chr, scales = "free_x", shrink = FALSE)

#setwd("~/Dropbox/Anolis_paper/Figures/")
# cairo_pdf(file = "Final/chr_all.pdf",family = "Arial", height = 10, width = 20)
# grid.arrange(F127012016.lv.input.plot, F127012016.br.input.plot,
#              M127012016.lv.input.plot, M127012016.br.input.plot,
#              F1040.lv.H4K16ac.plot, F1040.br.H4K16ac.plot,  
#              F127012016.lv.H4K16ac.plot, F127012016.br.H4K16ac.plot,
#              M11060514.lv.H4K16ac.plot, M11060514.br.H4K16ac.plot, 
#              M127012016.lv.H4K16ac.plot, M127012016.br.H4K16ac.plot,
#              nrow = 6, ncol = 2)
#dev.off()

setwd("~/Dropbox/Anolis_paper/Figures/")
cairo_pdf(file = "Final/chr.pdf",family = "Arial", height = 3, width = 10)
grid.arrange(F127012016.lv.input.plot, #F127012016.br.input.plot,
             M127012016.lv.input.plot, #M127012016.br.input.plot,
             F127012016.lv.H4K16ac.plot, #F127012016.br.H4K16ac.plot,
             M11060514.lv.H4K16ac.plot, #M11060514.br.H4K16ac.plot, 
             nrow = 2, ncol = 2)
dev.off()