
#-----------------------------------------------------------------------------------+
#                                                                                   |
#                            0.  LOAD CLEANED UP DATA                               |
#                                                                                   |
#-----------------------------------------------------------------------------------+

path="~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/"
source(paste0(path, "/R/functions.r"))

load(file=paste0(path, "/R/one2one.7species.v5.Rdata"))
load(file=paste0(path, "/R/one2one.7species.X.A.genes.v5.Rdata"))
load(file=paste0(path, "/R/final.expression.tables.7species.v5.Rdata"))
load(file=paste0(path, "/R/all.genes.v5.Rdata"))


#-----------------------------------------------------------------------------------+
#                                                                                   |
#                 1.  M:F EXPRESSION RATIO IN X(Z)-LINKED GENES                     |
#                          (Fig 1 in Philippe's paper)                              |
#                                                                                   |
#-----------------------------------------------------------------------------------+

#-----------------------------------------------------------------------------------+
#                    1.1.  M:F ratio for ALL expressed genes                        |
#-----------------------------------------------------------------------------------+

exp.cutoff = 0
organs = c("Brain", "Heart", "Kidney", "Liver")

# Human
# ------------
# Selection of coding X-linked genes
genes.x = intersect.many.arrays(list(subset(human.7sp, AXY=="X")$gene, subset(human.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))

# Selection of coding autotomal genes
genes.auto = intersect.many.arrays(list(subset(human.7sp, AXY=="A" | AXY=="UNK")$gene, subset(human.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))

# Computation of the M/F ratio for each gene in genes.x in different tissues
MF.brain = M.to.F.ratio(human.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(human.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(human.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(human.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)

# Formatting and computation of quantiles and p-val
MF.human=list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.human.pval = compute.wilcox.list(MF.human, correct=T)
MF.human.q = compute.quantile.list(MF.human)
colnames(MF.human.pval)= organs
colnames(MF.human.q)= organs
MF.human.q
MF.human.pval

# Mouse
# ------------
genes.x = intersect.many.arrays(list(subset(mouse.7sp, AXY=="X")$gene, subset(mouse.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
genes.auto = intersect.many.arrays(list(subset(mouse.7sp, AXY=="A" | AXY=="UNK")$gene, subset(mouse.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
MF.brain = M.to.F.ratio(mouse.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(mouse.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(mouse.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(mouse.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.mouse=list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.mouse.pval = compute.wilcox.list(MF.mouse, correct=T)
MF.mouse.q = compute.quantile.list(MF.mouse)
colnames(MF.mouse.pval)= organs
colnames(MF.mouse.q)= organs
MF.mouse.q
MF.mouse.pval

# Opossum
# ------------
genes.x = intersect.many.arrays(list(subset(opossum.7sp, AXY=="X")$gene, subset(opossum.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
genes.auto = intersect.many.arrays(list(subset(opossum.7sp, AXY=="A" | AXY=="UNK")$gene, subset(opossum.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
MF.brain = M.to.F.ratio(opossum.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(opossum.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(opossum.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(opossum.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.opossum=list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.opossum.pval = compute.wilcox.list(MF.opossum, correct=T)
MF.opossum.q = compute.quantile.list(MF.opossum)
colnames(MF.opossum.pval)= organs
colnames(MF.opossum.q)= organs
MF.opossum.q
MF.opossum.pval

# Platypus
# ------------
genes.x = intersect.many.arrays(list(subset(platypus.7sp, AXY=="X")$gene, subset(platypus.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
genes.auto = intersect.many.arrays(list(subset(platypus.7sp, AXY=="A" | AXY=="UNK")$gene, subset(platypus.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
MF.brain = M.to.F.ratio(platypus.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(platypus.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(platypus.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(platypus.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.platypus=list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.platypus.pval = compute.wilcox.list(MF.platypus, correct=T)
MF.platypus.q = compute.quantile.list(MF.platypus)
colnames(MF.platypus.pval)= organs
colnames(MF.platypus.q)= organs
MF.platypus.q
MF.platypus.pval

# Chicken
# ------------
genes.x = intersect.many.arrays(list(subset(chicken.7sp, AXY=="X")$gene, subset(chicken.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
genes.auto = intersect.many.arrays(list(subset(chicken.7sp, AXY=="A" | AXY=="UNK")$gene, subset(chicken.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
MF.brain = M.to.F.ratio(chicken.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(chicken.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(chicken.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(chicken.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.chicken=list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.chicken.pval = compute.wilcox.list(MF.chicken, correct=T)
MF.chicken.q = compute.quantile.list(MF.chicken)
colnames(MF.chicken.pval)= organs
colnames(MF.chicken.q)= organs
MF.chicken.q
MF.chicken.pval

# Lizard
# ------------
genes.x = intersect.many.arrays(list(subset(lizard.7sp, AXY=="X")$gene, subset(lizard.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
genes.auto = intersect.many.arrays(list(subset(lizard.7sp, AXY=="A" | AXY=="UNK")$gene, subset(lizard.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID))
MF.brain = M.to.F.ratio(lizard.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(lizard.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(lizard.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(lizard.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.embryo.5_6d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="embryo", stage="5_6d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.embryo.9d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="embryo", stage="9d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.brain.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="brain", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="heart", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="kidney", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="liver", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.lizard=list(MF.embryo.5_6d, MF.embryo.9d, MF.brain.15d, MF.heart.15d,  MF.kidney.15d, MF.liver.15d, MF.brain, MF.heart, MF.kidney, MF.liver)
MF.lizard.lab = c(paste("Embryo", c("5-d","9d"), sep=" "),
                  paste(c("Brain", "Heart", "Kidney", "Liver"), "15d", sep=" "), 
                  paste(c("Brain", "Heart", "Kidney", "Liver"), "Adult", sep=" "))
MF.lizard.pval = compute.wilcox.list(MF.lizard, correct=T)
MF.lizard.q = compute.quantile.list(MF.lizard)
colnames(MF.lizard.pval)= MF.lizard.lab
colnames(MF.lizard.q)= MF.lizard.lab
MF.lizard.q
MF.lizard.pval


# Putting together data for plot
#-------------------------------

empty=c(-10,-10,-10,-10,-10)
data1 = cbind(MF.human.q, empty, MF.mouse.q, empty, MF.opossum.q, empty, MF.platypus.q, empty, MF.chicken.q, empty, MF.lizard.q, deparse.level=2)
colnames(data1) = gsub("empty", "", colnames(data1), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)
data2 = cbind(MF.human.q, empty, MF.mouse.q, empty, MF.opossum.q, empty, MF.platypus.q, empty, MF.chicken.q, empty, MF.lizard.q[,7:10], deparse.level=2)
colnames(data2) = gsub("empty", "", colnames(data2), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)

empty=c(2,2,2)
pval1 = cbind(MF.human.pval, empty, MF.mouse.pval, empty, MF.opossum.pval, empty, MF.platypus.pval, empty, MF.chicken.pval, empty, MF.lizard.pval)
pval1.color = pval.to.colors.v2(pval1, pcutoff=0.01)
pval2 = cbind(MF.human.pval, empty, MF.mouse.pval, empty, MF.opossum.pval, empty, MF.platypus.pval, empty, MF.chicken.pval, empty, MF.lizard.pval[,7:10])
pval2.color = pval.to.colors.v2(pval2, pcutoff=0.01)

nsamples1=dim(data1)[2]
nsamples2=dim(data2)[2]
species=c("Human", "Mouse", "Opossum", "Platypus", "Chicken", "Lizard")

# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
# Plot for adult samples                                                            |
# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
setwd(paste0(path, "/Figures"))
pdf(file = "MF_7species_v5.pdf", width = 7, height = 5)
par(fig=c(0,1,0,0.8), new=FALSE, mar=c(5, 5, 0, 2))

ymin=-2
ymax=2
for.labels = NULL 
plot(c(1:nsamples2), data2["50%",], pch=19, cex=0, ylim=c(ymin,ymax), ylab="", xlab="", axes=F)
errbar(c(1:nsamples2), data2["50%",], data2["25%",], data2["75%",], add=T, pch=19, cap=.01, errbar.col="#aaaaaa", cex=0)

x1=1; x2=4; for.labels=c(for.labels, x1)
par(new=T)
plot(c(x1:x2), data2["50%",x1:x2], xlim=c(1, nsamples2), ylim=c(ymin,ymax), pch=22, bg="#444444", col="#444444", lwd=2, axes=FALSE, xlab="", ylab="log2(M/F)")
abline(h=-1, lty=1); abline(h=0, lty=2); abline(h=1, lty=1)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=22, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=23, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=24, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=25, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)  # W/o dev samples
# x1=x2+2; x2=x1+10-1 # With dev samples
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=21, bg="#00dd00", col="#00dd00", lwd=2)
text(for.labels+1.5, rep(-2,6), species, pos=3, cex=0.8)

axis(1, at=seq(1,nsamples2,by=1), labels=colnames(data2), las=2, cex.axis=0.7, tick=FALSE, pos=-2)
axis(2, at=seq(ymin,ymax,by=1), labels=seq(ymin,ymax,by=1), las=2, xlab=F)


par(fig=c(0,1,0.7,1), new=TRUE, mar=c(1, 5, 2, 2))
plot(pval2.color[1,], xlim=c(1, nsamples2), ylim=c(0.5,1.5), pch=15, col="black", axes=FALSE, xlab="", ylab="", cex=0.9)
points(pval2.color[2,], pch=15, col="orange",  cex=0.7)
points(pval2.color[3,], pch=15, col="#00aaff", cex=0.5)
points(pval2.color[4,], pch=15, col="grey", cex=0.4)
axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
legend(2,1.5, legend=c("median = -1","median = 0", "median = 1", "median not -1,0,1"), pch=c(15, 15, 15, 15), col=c("black", "orange", "#00aaff", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 
dev.off()


# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
# Plot with Developmental samples                                                   |
# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
setwd(paste0(path, "/Figures"))
pdf(file = "MF_7species_dev_v5.pdf", width = 7, height = 5)
par(fig=c(0,1,0,0.8), new=FALSE, mar=c(5, 5, 0, 2))

ymin=-2
ymax=2
for.labels = NULL 
plot(c(1:nsamples1), data1["50%",], pch=19, cex=0, ylim=c(ymin,ymax), ylab="", xlab="", axes=F)
errbar(c(1:nsamples1), data1["50%",], data1["25%",], data1["75%",], add=T, pch=19, cap=.01, errbar.col="#aaaaaa", cex=0)

x1=1; x2=4; for.labels=c(for.labels, (x2+x1)/2)
par(new=T)
plot(c(x1:x2), data1["50%",x1:x2], xlim=c(1, nsamples1), ylim=c(ymin,ymax), pch=22, bg="#444444", col="#444444", lwd=2, axes=FALSE, xlab="", ylab="log2(M/F)")
abline(h=-1, lty=1); abline(h=0, lty=2); abline(h=1, lty=1)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=22, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1;for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=23, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=24, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=25, bg="#444444", col="#444444", lwd=2)
# x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2) # W/o dev samples
x1=x2+2; x2=x1+10-1; for.labels=c(for.labels, (x2+x1)/2)# With dev samples
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=21, bg="#00dd00", col="#00dd00", lwd=2)
text(for.labels, rep(-2,6), species, pos=3, cex=0.8)

axis(1, at=seq(1,nsamples1,by=1), labels=colnames(data1), las=2, cex.axis=0.7, tick=FALSE, pos=-2)
axis(2, at=seq(ymin,ymax,by=1), labels=seq(ymin,ymax,by=1), las=2, xlab=F)


par(fig=c(0,1,0.7,1), new=TRUE, mar=c(1, 5, 2, 2))
plot(pval1.color[1,], xlim=c(1, nsamples1), ylim=c(0.5,1.5), pch=15, col="black", axes=FALSE, xlab="", ylab="", cex=0.9)
points(pval1.color[2,], pch=15, col="orange",  cex=0.7)
points(pval1.color[3,], pch=15, col="#00aaff", cex=0.5)
points(pval1.color[4,], pch=15, col="grey", cex=0.4)
axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
legend(2,1.5, legend=c("median = -1","median = 0", "median = 1", "median not -1,0,1"), pch=c(15, 15, 15, 15), col=c("black", "orange", "#00aaff", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 
dev.off()


#-----------------------------------------------------------------------------------+
#                     1.2.  M:F ratio for 1:1 orthologous genes                     |
#-----------------------------------------------------------------------------------+

exp.cutoff = 0

# Human
# ------------
genes.x = one2one.7sp[one2one.7sp.X.A.genes[["humanX"]], "human"]
genes.auto = one2one.7sp[one2one.7sp.X.A.genes[["humanAK"]], "human"]

MF.brain = M.to.F.ratio(human.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(human.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(human.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(human.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.human.one2one = list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.human.one2one.pval = compute.wilcox.list(MF.human.one2one, correct=T)
MF.human.one2one.q = compute.quantile.list(MF.human.one2one)
colnames(MF.human.one2one.pval)= organs
colnames(MF.human.one2one.q)= organs
MF.human.one2one.q
MF.human.one2one.pval

# Mouse
# ------------
genes.x = one2one.7sp[one2one.7sp.X.A.genes[["mouseX"]], "mouse"]
genes.auto = one2one.7sp[one2one.7sp.X.A.genes[["mouseAK"]], "mouse"]

MF.brain = M.to.F.ratio(mouse.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(mouse.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(mouse.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(mouse.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.mouse.one2one = list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.mouse.one2one.pval = compute.wilcox.list(MF.mouse.one2one, correct=T)
MF.mouse.one2one.q = compute.quantile.list(MF.mouse.one2one)
colnames(MF.mouse.one2one.pval)= organs
colnames(MF.mouse.one2one.q)= organs
MF.mouse.one2one.q
MF.mouse.one2one.pval

# Opossum
# ------------
genes.x = one2one.7sp[one2one.7sp.X.A.genes[["opossumX"]], "opossum"]
genes.auto = one2one.7sp[one2one.7sp.X.A.genes[["opossumAK"]], "opossum"]

MF.brain = M.to.F.ratio(opossum.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(opossum.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(opossum.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(opossum.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.opossum.one2one = list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.opossum.one2one.pval = compute.wilcox.list(MF.opossum.one2one, correct=T)
MF.opossum.one2one.q = compute.quantile.list(MF.opossum.one2one)
colnames(MF.opossum.one2one.pval)= organs
colnames(MF.opossum.one2one.q)= organs
MF.opossum.one2one.q
MF.opossum.one2one.pval

# Platypus
# ------------
genes.x = one2one.7sp[one2one.7sp.X.A.genes[["platypusX"]], "platypus"]
genes.auto = one2one.7sp[one2one.7sp.X.A.genes[["platypusAK"]], "platypus"]

MF.brain = M.to.F.ratio(platypus.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(platypus.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(platypus.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(platypus.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.platypus.one2one = list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.platypus.one2one.pval = compute.wilcox.list(MF.platypus.one2one, correct=T)
MF.platypus.one2one.q = compute.quantile.list(MF.platypus.one2one)
colnames(MF.platypus.one2one.pval)= organs
colnames(MF.platypus.one2one.q)= organs
MF.platypus.one2one.q
MF.platypus.one2one.pval

# Chicken
# ------------
genes.x = one2one.7sp[one2one.7sp.X.A.genes[["chickenX"]], "chicken"]
genes.auto = one2one.7sp[one2one.7sp.X.A.genes[["chickenAK"]], "chicken"]

MF.brain = M.to.F.ratio(chicken.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(chicken.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(chicken.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(chicken.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.chicken.one2one = list(MF.brain, MF.heart, MF.kidney, MF.liver)
MF.chicken.one2one.pval = compute.wilcox.list(MF.chicken.one2one, correct=T)
MF.chicken.one2one.q = compute.quantile.list(MF.chicken.one2one)
colnames(MF.chicken.one2one.pval)= organs
colnames(MF.chicken.one2one.q)= organs
MF.chicken.one2one.q
MF.chicken.one2one.pval

# Lizard
# ------------
genes.x = one2one.7sp[one2one.7sp.X.A.genes[["lizardX"]], "lizard"]
genes.auto = one2one.7sp[one2one.7sp.X.A.genes[["lizardAK"]], "lizard"]

MF.brain = M.to.F.ratio(lizard.7sp, genes.x, tissue="brain", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart = M.to.F.ratio(lizard.7sp, genes.x, tissue="heart", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney = M.to.F.ratio(lizard.7sp, genes.x, tissue="kidney", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver = M.to.F.ratio(lizard.7sp, genes.x, tissue="liver", min.exp=exp.cutoff, autosomes=genes.auto)
MF.embryo.5_6d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="embryo", stage="5_6d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.embryo.9d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="embryo", stage="9d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.brain.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="brain", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.heart.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="heart", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.kidney.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="kidney", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.liver.15d = M.to.F.ratio(lizard.dev.7sp, genes.x, tissue="liver", stage="15d", min.exp=exp.cutoff, autosomes=genes.auto)
MF.lizard.one2one=list(MF.embryo.5_6d, MF.embryo.9d, MF.brain.15d, MF.heart.15d,  MF.kidney.15d, MF.liver.15d, MF.brain, MF.heart, MF.kidney, MF.liver)
MF.lizard.lab = c(paste("Embryo", c("5-d","9d"), sep=" "),
                  paste(c("Brain", "Heart", "Kidney", "Liver"), "15d", sep=" "), 
                  paste(c("Brain", "Heart", "Kidney", "Liver"), "Adult", sep=" "))

MF.lizard.one2one.pval = compute.wilcox.list(MF.lizard.one2one, correct=T)
MF.lizard.one2one.q = compute.quantile.list(MF.lizard.one2one)
colnames(MF.lizard.one2one.pval)= MF.lizard.lab
colnames(MF.lizard.one2one.q)= MF.lizard.lab
MF.lizard.one2one.q
MF.lizard.one2one.pval


# Putting together data for plot
#-------------------------------

empty=c(-10,-10,-10,-10,-10)
data1 = cbind(MF.human.one2one.q, empty, MF.mouse.one2one.q, empty, MF.opossum.one2one.q, empty, MF.platypus.one2one.q, empty, MF.chicken.one2one.q, empty, MF.lizard.one2one.q, deparse.level=2)
colnames(data1) = gsub("empty", "", colnames(data1), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)
data2 = cbind(MF.human.one2one.q, empty, MF.mouse.one2one.q, empty, MF.opossum.one2one.q, empty, MF.platypus.one2one.q, empty, MF.chicken.one2one.q, empty, MF.lizard.one2one.q[,7:10], deparse.level=2)
colnames(data2) = gsub("empty", "", colnames(data2), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)

empty=c(2,2,2)
pval1 = cbind(MF.human.one2one.pval, empty, MF.mouse.one2one.pval, empty, MF.opossum.one2one.pval, empty, MF.platypus.one2one.pval, empty, MF.chicken.one2one.pval, empty, MF.lizard.one2one.pval)
pval1.color = pval.to.colors.v2(pval1, pcutoff=0.01)
pval2 = cbind(MF.human.one2one.pval, empty, MF.mouse.one2one.pval, empty, MF.opossum.one2one.pval, empty, MF.platypus.one2one.pval, empty, MF.chicken.one2one.pval, empty, MF.lizard.one2one.pval[,7:10])
pval2.color = pval.to.colors.v2(pval2, pcutoff=0.01)

nsamples1=dim(data1)[2]
nsamples2=dim(data2)[2]

# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
# Plot for adult samples                                                            |
# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
setwd(paste0(path, "/Figures"))
pdf(file = "MF_one2one_7species_v5.pdf", width = 7, height = 5)
par(fig=c(0,1,0,0.8), new=FALSE, mar=c(5, 5, 0, 2))

ymin=-2
ymax=2
for.labels = NULL 
plot(c(1:nsamples2), data2["50%",], pch=19, cex=0, ylim=c(ymin,ymax), ylab="", xlab="", axes=F)
errbar(c(1:nsamples2), data2["50%",], data2["25%",], data2["75%",], add=T, pch=19, cap=.01, errbar.col="#aaaaaa", cex=0)

x1=1; x2=4; for.labels=c(for.labels, x1)
par(new=T)
plot(c(x1:x2), data2["50%",x1:x2], xlim=c(1, nsamples2), ylim=c(ymin,ymax), pch=22, bg="#444444", col="#444444", lwd=2, axes=FALSE, xlab="", ylab="log2(M/F)")
abline(h=-1, lty=1); abline(h=0, lty=2); abline(h=1, lty=1)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=22, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=23, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=24, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=25, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, x1)  # W/o dev samples
# x1=x2+2; x2=x1+10-1 # With dev samples
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data2["50%",x1:x2], pch=21, bg="#00dd00", col="#00dd00", lwd=2)
text(for.labels+1.5, rep(-2,6), species, pos=3, cex=0.8)

axis(1, at=seq(1,nsamples2,by=1), labels=colnames(data2), las=2, cex.axis=0.7, tick=FALSE, pos=-2)
axis(2, at=seq(ymin,ymax,by=1), labels=seq(ymin,ymax,by=1), las=2, xlab=F)


par(fig=c(0,1,0.7,1), new=TRUE, mar=c(1, 5, 2, 2))
plot(pval2.color[1,], xlim=c(1, nsamples2), ylim=c(0.5,1.5), pch=15, col="black", axes=FALSE, xlab="", ylab="", cex=0.9)
points(pval2.color[2,], pch=15, col="orange",  cex=0.7)
points(pval2.color[3,], pch=15, col="#00aaff", cex=0.5)
points(pval2.color[4,], pch=15, col="grey", cex=0.4)
axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
legend(2,1.5, legend=c("median = -1","median = 0", "median = 1", "median not -1,0,1"), pch=c(15, 15, 15, 15), col=c("black", "orange", "#00aaff", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 
dev.off()

# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
# Plot for Developmental samples                                                    |
# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
setwd(paste0(path, "/Figures"))
pdf(file = "MF_one2one_7species_dev_v5.pdf", width = 7, height = 5)
par(fig=c(0,1,0,0.8), new=FALSE, mar=c(5, 5, 0, 2))

ymin=-2
ymax=2
for.labels = NULL 
plot(c(1:nsamples1), data1["50%",], pch=19, cex=0, ylim=c(ymin,ymax), ylab="", xlab="", axes=F)
errbar(c(1:nsamples1), data1["50%",], data1["25%",], data1["75%",], add=T, pch=19, cap=.01, errbar.col="#aaaaaa", cex=0)

x1=1; x2=4; for.labels=c(for.labels, (x2+x1)/2)
par(new=T)
plot(c(x1:x2), data1["50%",x1:x2], xlim=c(1, nsamples1), ylim=c(ymin,ymax), pch=22, bg="#444444", col="#444444", lwd=2, axes=FALSE, xlab="", ylab="log2(M/F)")
abline(h=-1, lty=1); abline(h=0, lty=2); abline(h=1, lty=1)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=22, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1;for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=23, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=24, bg="#444444", col="#444444", lwd=2)
x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=25, bg="#444444", col="#444444", lwd=2)
# x1=x2+2; x2=x1+4-1; for.labels=c(for.labels, (x2+x1)/2) # W/o dev samples
x1=x2+2; x2=x1+10-1; for.labels=c(for.labels, (x2+x1)/2)# With dev samples
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data1["50%",x1:x2], pch=21, bg="#00dd00", col="#00dd00", lwd=2)
text(for.labels, rep(-2,6), species, pos=3, cex=0.8)

axis(1, at=seq(1,nsamples1,by=1), labels=colnames(data1), las=2, cex.axis=0.7, tick=FALSE, pos=-2)
axis(2, at=seq(ymin,ymax,by=1), labels=seq(ymin,ymax,by=1), las=2, xlab=F)


par(fig=c(0,1,0.7,1), new=TRUE, mar=c(1, 5, 2, 2))
plot(pval1.color[1,], xlim=c(1, nsamples1), ylim=c(0.5,1.5), pch=15, col="black", axes=FALSE, xlab="", ylab="", cex=0.9)
points(pval1.color[2,], pch=15, col="orange",  cex=0.7)
points(pval1.color[3,], pch=15, col="#00aaff", cex=0.5)
points(pval1.color[4,], pch=15, col="grey", cex=0.4)
axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
legend(2,1.5, legend=c("median = -1","median = 0", "median = 1", "median not -1,0,1"), pch=c(15, 15, 15, 15), col=c("black", "orange", "#00aaff", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 
dev.off()


#-----------------------------------------------------------------------------------+
#                                                                                   |
#                 2.  CURRENT:ANCESTRAL RATIO USING 1:1 ORTHOLOGOUS GENES           |
#                            (Fig 3 in Philippe's paper)                            |
#                                                                                   |
#-----------------------------------------------------------------------------------+

# Human
# -----------------

# Selection of species with non-homologous sex system
outgroup.species = c("chicken", "platypus", "xenopus", "lizard")

# Selection of coding X-linked genes
genes.x = intersect(subset(human.7sp, AXY=="X")$gene, 
                    subset(human.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

# Computation of X/protoX ratios. 
# X/protoX genes correspond to 1:1 genes that are X in the target species but autosomal in 
# species with a different sex system. "X expression" is the expression of the gene in the 
# target species and "ProtoX expression" is the median expression of the genes across the 
# outgroup species
human.brain = Chr.to.protoA.ratio.random(target="human", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.heart = Chr.to.protoA.ratio.random(target="human", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.kidney = Chr.to.protoA.ratio.random(target="human", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.liver = Chr.to.protoA.ratio.random(target="human", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.gonads = Chr.to.protoA.ratio.random(target="human", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)


# Formatting and computation of quantiles and p-val
human.all = list(human.brain[,1], human.heart[,1], human.kidney[,1], human.liver[,1], human.gonads[,1],
                 human.brain[,3], human.heart[,3], human.kidney[,3], human.liver[,3], human.gonads[,3])
human.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))
                                    
human.all.pval = compute.wilcox.list(human.all)
human.all.q = compute.quantile.list(human.all)
colnames(human.all.pval)= human.all.lab
colnames(human.all.q)= human.all.lab
human.all.pval
human.all.q


# Mouse
# -----------------
genes.x = intersect(subset(mouse.7sp, AXY=="X")$gene, 
                    subset(mouse.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

mouse.brain = Chr.to.protoA.ratio.random(target="mouse", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.heart = Chr.to.protoA.ratio.random(target="mouse", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.kidney = Chr.to.protoA.ratio.random(target="mouse", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.liver = Chr.to.protoA.ratio.random(target="mouse", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.gonads = Chr.to.protoA.ratio.random(target="mouse", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

mouse.all = list(mouse.brain[,1], mouse.heart[,1], mouse.kidney[,1], mouse.liver[,1], mouse.gonads[,1],
                 mouse.brain[,3], mouse.heart[,3], mouse.kidney[,3], mouse.liver[,3], mouse.gonads[,3])
mouse.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

mouse.all.pval = compute.wilcox.list(mouse.all)
mouse.all.q = compute.quantile.list(mouse.all)
colnames(mouse.all.pval)= mouse.all.lab
colnames(mouse.all.q)= mouse.all.lab
mouse.all.pval
mouse.all.q

# Opossum
# -----------------
genes.x = intersect(subset(opossum.7sp, AXY=="X")$gene, 
                    subset(opossum.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

opossum.brain = Chr.to.protoA.ratio.random(target="opossum", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.heart = Chr.to.protoA.ratio.random(target="opossum", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.kidney = Chr.to.protoA.ratio.random(target="opossum", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.liver = Chr.to.protoA.ratio.random(target="opossum", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.gonads = Chr.to.protoA.ratio.random(target="opossum", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

opossum.all = list(opossum.brain[,1], opossum.heart[,1], opossum.kidney[,1], opossum.liver[,1], opossum.gonads[,1],
                 opossum.brain[,3], opossum.heart[,3], opossum.kidney[,3], opossum.liver[,3], opossum.gonads[,3])
opossum.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

opossum.all.pval = compute.wilcox.list(opossum.all)
opossum.all.q = compute.quantile.list(opossum.all)
colnames(opossum.all.pval)= opossum.all.lab
colnames(opossum.all.q)= opossum.all.lab
opossum.all.pval
opossum.all.q

# Platypus
# -----------------
# outgroup.species = c("human", "mouse", "opossum", "xenopus", "lizard")
# NOTE: Since we don't have human ovaries and we have enough therian species 
#       I prefer not to use human as an outgroup in all organs

outgroup.species = c("mouse", "opossum", "xenopus", "lizard")
genes.x = intersect(subset(platypus.7sp, AXY=="X")$gene, 
                    subset(platypus.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

platypus.brain = Chr.to.protoA.ratio.random(target="platypus", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.heart = Chr.to.protoA.ratio.random(target="platypus", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.kidney = Chr.to.protoA.ratio.random(target="platypus", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.liver = Chr.to.protoA.ratio.random(target="platypus", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.gonads = Chr.to.protoA.ratio.random(target="platypus", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

platypus.all = list(platypus.brain[,1], platypus.heart[,1], platypus.kidney[,1], platypus.liver[,1], platypus.gonads[,1],
                 platypus.brain[,3], platypus.heart[,3], platypus.kidney[,3], platypus.liver[,3], platypus.gonads[,3])
platypus.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

platypus.all.pval = compute.wilcox.list(platypus.all)
platypus.all.q = compute.quantile.list(platypus.all)
colnames(platypus.all.pval)= platypus.all.lab
colnames(platypus.all.q)= platypus.all.lab
platypus.all.pval
platypus.all.q

# Chicken
# -----------------
genes.x = intersect(subset(chicken.7sp, AXY=="X")$gene, 
                    subset(chicken.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

chicken.brain = Chr.to.protoA.ratio.random(target="chicken", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.heart = Chr.to.protoA.ratio.random(target="chicken", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.kidney = Chr.to.protoA.ratio.random(target="chicken", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.liver = Chr.to.protoA.ratio.random(target="chicken", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.gonads = Chr.to.protoA.ratio.random(target="chicken", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

chicken.all = list(chicken.brain[,1], chicken.heart[,1], chicken.kidney[,1], chicken.liver[,1], chicken.gonads[,1],
                 chicken.brain[,3], chicken.heart[,3], chicken.kidney[,3], chicken.liver[,3], chicken.gonads[,3])
chicken.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

chicken.all.pval = compute.wilcox.list(chicken.all)
chicken.all.q = compute.quantile.list(chicken.all)
colnames(chicken.all.pval)= chicken.all.lab
colnames(chicken.all.q)= chicken.all.lab
chicken.all.pval
chicken.all.q

# Lizard
# -----------------
# outgroup.species = c("human", "mouse", "opossum", "platypus", "chicken", "xenopus")
outgroup.species = c("mouse", "opossum", "platypus", "chicken", "xenopus")
genes.x = intersect(subset(lizard.7sp, AXY=="X")$gene, 
                    subset(lizard.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

lizard.brain = Chr.to.protoA.ratio.random(target="lizard", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.heart = Chr.to.protoA.ratio.random(target="lizard", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.kidney = Chr.to.protoA.ratio.random(target="lizard", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.liver = Chr.to.protoA.ratio.random(target="lizard", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.gonads = Chr.to.protoA.ratio.random(target="lizard", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

lizard.all = list(lizard.brain[,1], lizard.heart[,1], lizard.kidney[,1], lizard.liver[,1], lizard.gonads[,1],
                 lizard.brain[,3], lizard.heart[,3], lizard.kidney[,3], lizard.liver[,3], lizard.gonads[,3])
lizard.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

lizard.all.pval = compute.wilcox.list(lizard.all)
lizard.all.q = compute.quantile.list(lizard.all)
colnames(lizard.all.pval)= lizard.all.lab
colnames(lizard.all.q)= lizard.all.lab
lizard.all.pval
lizard.all.q


# Putting together data for plot
#-------------------------------

empty=c(-1,-1,-1,-1,-1)
data = cbind(human.all.q[,1:9], empty, mouse.all.q, empty, opossum.all.q, empty, platypus.all.q, empty, chicken.all.q, empty, lizard.all.q, deparse.level=2)
colnames(data) = gsub("empty", "", colnames(data), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)
empty=c(2,2,2)
pval = cbind(human.all.pval[,1:9], empty, mouse.all.pval, empty,  opossum.all.pval, empty, platypus.all.pval, empty, chicken.all.pval, empty, lizard.all.pval)
pval.color = pval.to.colors.v2(pval, pcutoff=0.01)

nsamples=dim(data)[2]

# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
# Plot for all species                                                              |
# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

setwd(paste0(path, "/Figures"))
pdf(file = "XvsProtoX_7species_many_outgroups_v5.pdf", width = 8, height = 4)
par(fig=c(0,1,0,0.8), new=FALSE, mar=c(5, 5, 1, 2), cex=0.8)

ymin=-2
ymax=2
for.labels=NULL

x1=1; x2=5; for.labels=c(for.labels, x2)
plot(c(x1:x2), data[3,x1:x2], xlim=c(1, nsamples), ylim=c(ymin,ymax), pch=21, bg="#ffffff", col="#444444", lwd=2, cex=1.5, axes=FALSE, xlab="", ylab="")
x1=x2+1; x2=x1+4-1
points(c(x1:x2), data[3,x1:x2], pch=21, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1 ; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")
abline(h=-1, lty=1)
abline(h=0, lty=2)
abline(h=1, lty=1)

points(c(x1:x2), data[3,x1:x2], pch=22, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=22, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data[3,x1:x2], pch=23, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=23, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data[3,x1:x2], pch=24, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=24, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data[3,x1:x2], pch=25, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=25, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data[3,x1:x2], pch=21, bg="#ffffff", col="#00dd00", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=21, bg="#00dd00", col="#00dd00", lwd=2, cex=1.5)

text(for.labels, rep(-1.8,6), species, pos=1, cex=0.8)
axis(1, at=seq(1,nsamples,by=1), labels=colnames(data), las=2, cex.axis=0.6, tick=FALSE, pos=-2.1)
axis(2, at=seq(ymin,ymax,by=1), labels=seq(ymin,ymax,by=1), las=2, xlab=F)

par(fig=c(0,1,0.7,1), new=TRUE, mar=c(1, 5, 2, 2))
plot(pval.color[1,], xlim=c(1, nsamples), ylim=c(0.5,1.5), pch=15, col="black", axes=FALSE, xlab="", ylab="", cex=0.9)
points(pval.color[2,], pch=15, col="orange",  cex=0.7)
points(pval.color[3,], pch=15, col="#00aaff", cex=0.6)
points(pval.color[4,], pch=15, col="grey", cex=0.5)
axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
legend(20,1.5, legend=c("median = -1","median = 0", "median not -1,0,1"), pch=c(15, 15, 15), col=c("black", "orange", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 
dev.off()



#-----------------------------------------------------------------------------------+
#                                                                                   |
#                    3.  BROADLY EXPRESSED X AND PROTO-X GENES                      |
#                                                                                   |
#-----------------------------------------------------------------------------------+

# Human
# --------
# Select chromosomes for which analysis will be done
chroms = c(seq(1,22), "X")

# Select outgroup species
outgroup=c("platypus", "chicken", "xenopus", "lizard")

# Compute the fraction of orthologous genes that are broadly expressed 
# in each chromosome. Broadly expressed are all genes which don't have 
# any organ with higher expression (1.5 times) than expected by chance. For 
# 5 organs the random expectation is that each organ will have 20% of the 
# total expression, therefore if no organ has more than 20%*1.5 = 35%
# of the reads the gene is considered broadly expressed.
broad.exp.human = frac.broadly.exp("human", chroms, outgroup, human.genes)

# Mouse
# --------
chroms = c(seq(1,19), "X")
outgroup=c("platypus", "chicken", "xenopus", "lizard")
broad.exp.mouse = frac.broadly.exp("mouse", chroms, outgroup, mouse.genes)

# Opossum
# --------
chroms = c(seq(1,8), "X")
outgroup=c("platypus", "chicken", "xenopus", "lizard")
broad.exp.opossum = frac.broadly.exp("opossum", chroms, outgroup, opossum.genes)

# Platypus
#------------
chroms = c(seq(1,7), seq(10,12), 15, 17, 18, 20, "X")
# outgroup=c("human", "mouse", "opossum", "xenopus", "lizard")
outgroup=c("mouse", "opossum", "xenopus", "lizard")
broad.exp.platypus = frac.broadly.exp("platypus", chroms, outgroup, platypus.genes)

# Chicken
#------------
chroms = c(seq(1,28), "X")
# outgroup=c("human", "mouse", "opossum", "xenopus", "lizard")
outgroup=c("mouse", "opossum", "xenopus", "lizard")
broad.exp.chicken = frac.broadly.exp("chicken", chroms, outgroup, chicken.genes)

# Lizard
# --------
chroms = c(seq(1,6), "LGa", "LGc", "LGd", "LGf", "LGg", "LGh", "X")
# outgroup=c("human", "mouse", "opossum", "platypus", "chicken", "xenopus")
outgroup=c("mouse", "opossum", "platypus", "chicken", "xenopus")
broad.exp.lizard = frac.broadly.exp("lizard", chroms, outgroup, lizard.genes)

broad.exp.lizard$broad.exp
broad.exp.human$broad.exp
broad.exp.mouse$broad.exp
broad.exp.opossum$broad.exp
broad.exp.chicken$broad.exp

# Gathers the average fraction of genes that were ancestraly broadly expressed across autosomes 
broad.exp.A = c(mean(broad.exp.human$broad.exp[-which(names(broad.exp.human$broad.exp)  == "X")]),
                mean(broad.exp.mouse$broad.exp[-which(names(broad.exp.mouse$broad.exp)  == "X")]),
                mean(broad.exp.opossum$broad.exp[-which(names(broad.exp.opossum$broad.exp)  == "X")]),
                mean(broad.exp.platypus$broad.exp[-which(names(broad.exp.platypus$broad.exp)  == "X")]),
                mean(broad.exp.chicken$broad.exp[-which(names(broad.exp.chicken$broad.exp)  == "X")]),
                mean(broad.exp.lizard$broad.exp[-which(names(broad.exp.lizard$broad.exp)  == "X")]))

# Gathers the fraction of genes that were ancestraly broadly expressed in the X chrom
broad.exp.X = c(broad.exp.human$broad.exp[which(names(broad.exp.human$broad.exp)  == "X")],
                broad.exp.mouse$broad.exp[which(names(broad.exp.mouse$broad.exp)  == "X")],
                broad.exp.opossum$broad.exp[which(names(broad.exp.opossum$broad.exp)  == "X")],
                broad.exp.platypus$broad.exp[which(names(broad.exp.platypus$broad.exp)  == "X")],
                broad.exp.chicken$broad.exp[which(names(broad.exp.chicken$broad.exp)  == "X")],
                broad.exp.lizard$broad.exp[which(names(broad.exp.lizard$broad.exp)  == "X")])

# Gathers the average fraction of genes that are currently broadly expressed across autosomes 
broad.exp.A.current = c(mean(broad.exp.human$broad.exp.current[-which(names(broad.exp.human$broad.exp.current)  == "X")]),
                        mean(broad.exp.mouse$broad.exp.current[-which(names(broad.exp.mouse$broad.exp.current)  == "X")]),
                        mean(broad.exp.opossum$broad.exp.current[-which(names(broad.exp.opossum$broad.exp.current)  == "X")]),
                        mean(broad.exp.platypus$broad.exp.current[-which(names(broad.exp.platypus$broad.exp.current)  == "X")]),
                        mean(broad.exp.chicken$broad.exp.current[-which(names(broad.exp.chicken$broad.exp.current)  == "X")]),
                        mean(broad.exp.lizard$broad.exp.current[-which(names(broad.exp.lizard$broad.exp.current)  == "X")]))

# Gathers the fraction of genes that were currently broadly expressed in the X chrom
broad.exp.X.current = c(mean(broad.exp.human$broad.exp.current[which(names(broad.exp.human$broad.exp.current)  == "X")]),
                        mean(broad.exp.mouse$broad.exp.current[which(names(broad.exp.mouse$broad.exp.current)  == "X")]),
                        mean(broad.exp.opossum$broad.exp.current[which(names(broad.exp.opossum$broad.exp.current)  == "X")]),
                        mean(broad.exp.platypus$broad.exp.current[which(names(broad.exp.platypus$broad.exp.current)  == "X")]),
                        mean(broad.exp.chicken$broad.exp.current[which(names(broad.exp.chicken$broad.exp.current)  == "X")]),
                        mean(broad.exp.lizard$broad.exp.current[which(names(broad.exp.lizard$broad.exp.current)  == "X")]))


# Fraction of broadly expressed genes (ancestral expression)
# ----------------------------------------------------------

setwd(paste0(path, "/Figures"))
pdf(file = "Broad_exp_proto_v5.pdf", width = 7, height = 4)
par(mar=c(2,4,1,1))
barplot(rep(0, 5), plot=T, axes=F, ylim=c(0,40), border=NA, col="white")
grid(nx=0, ny=8, lty=1, col="#aaaaaa")
par(new=T)
barplot(rbind(broad.exp.A, broad.exp.X)*100, 
        beside=T,
        ylim=c(0,40), 
        ylab="% Broadly expr. genes",
        main="Ancestral expression",
        cex.lab=1,
        cex.axis=1,
        col=c("#777777", "#ff0000"),
        border=NA,
        names.arg=c("Human", "Mouse", "Opossum", "Platypus", "Chicken", "Lizard"))

legend(1,40, legend=c("Mean autosomes", "X(Z)"), pch=c(15, 15), col=c("#777777", "#ff0000"), bty="n", horiz=T, inset=0,cex=1, adj=-0) 
dev.off()


# Fraction of broadly expressed genes (current expression)
# ----------------------------------------------------------

setwd(paste0(path, "/Figures"))
pdf(file = "Broad_exp_current_v5.pdf", width = 7, height = 4)
par(mar=c(2,4,1,1))
barplot(rep(0, 5), plot=T, axes=F, ylim=c(0,40), border=NA, col="white")
grid(nx=0, ny=8, lty=1, col="#aaaaaa")
par(new=T)
barplot(rbind(broad.exp.A.current, broad.exp.X.current)*100, 
        beside=T,
        ylim=c(0,40), 
        ylab="% Broadly expr. genes",
        main="Current expression",
        cex.lab=1,
        cex.axis=1,
        col=c("#777777", "#0000ff"),
        border=NA,
        names.arg=c("Human", "Mouse", "Opossum", "Platypus", "Chicken", "Lizard"))

legend(1,40, legend=c("Mean autosomes", "X(Z)"), pch=c(15, 15), col=c("#777777", "#0000ff"), bty="n", horiz=T, inset=0,cex=1, adj=-0) 
dev.off()
 
#-----------------------------------------------------------------------------------+
#                                                                                   |
#                        4.  FRACTION OF TESTIS SPECIFIC GENES                      |
#                             (Fig 5 in Philippe's paper)                           |
#                                                                                   |
#-----------------------------------------------------------------------------------+

# Compute fraction of testis specific genes.
# In order to be considered testis specific, testis should have the highest proportion
# of reads which should be more than 30% of all reads and at least twice as much 
# as in the organ with the second highest number of reads

human.testis.spec = frac.testis.specific("human")
mouse.testis.spec = frac.testis.specific("mouse")
opossum.testis.spec = frac.testis.specific("opossum")
platypus.testis.spec = frac.testis.specific("platypus")
chicken.testis.spec = frac.testis.specific("chicken")
lizard.testis.spec = frac.testis.specific("lizard")


setwd(paste0(path, "/Figures"))
pdf(file = "testis_TE_X_v5.pdf", width = 7, height = 5)
barplot(rep(0, 5), plot=T, axes=F, ylim=c(0,50), border=NA, col="white")
grid(nx=0, ny=10, lty=1, col="#aaaaaa")
par(new=T)
barplot(cbind(human.testis.spec$X.values[c(3,2)], mouse.testis.spec$X.values[c(3,2)], opossum.testis.spec$X.values[c(3,2)], platypus.testis.spec$X.values[c(3,2)], chicken.testis.spec$X.values[c(3,2)], lizard.testis.spec$X.values[c(3,2)])*100, 
        beside=T,
        ylim=c(0,50), 
        ylab="% Testis specific genes",
        main="X-chromosome",
        cex.lab=1,
        cex.axis=1,
        col=c("#ff0000", "#0000ff"),
        border=NA,
        names.arg=c("Human", "Mouse", "Opossum", "Platypus", "Chicken", "Lizard"))

legend(1,52, legend=c("Old", "New"), pch=c(15, 15), col=c("#ff0000", "#0000ff"), bty="n", horiz=T, inset=0,cex=1, adj=-0) 
dev.off()

setwd(paste0(path, "/Figures"))
pdf(file = "testis_TE_A_v5.pdf", width = 7, height = 5)
barplot(rep(0, 5), plot=T, axes=F, ylim=c(0,50), border=NA, col="white")
grid(nx=0, ny=10, lty=1, col="#aaaaaa")
par(new=T)
barplot(cbind(human.testis.spec$A.values[c(3,2)], mouse.testis.spec$A.values[c(3,2)], opossum.testis.spec$A.values[c(3,2)], platypus.testis.spec$A.values[c(3,2)], chicken.testis.spec$A.values[c(3,2)], lizard.testis.spec$A.values[c(3,2)])*100, 
        beside=T,
        ylim=c(0,50), 
        ylab="% Testis specific genes",
        main="Autosomes",
        cex.lab=1,
        cex.axis=1,
        col=c("#ddcc00", "#00dd00"),
        border=NA,
        names.arg=c("Human", "Mouse", "Opossum", "Platypus", "Chicken", "Lizard"))

legend(1,52, legend=c("Old", "New"), pch=c(15, 15), col=c("#ddcc00", "#00dd00"), bty="n", horiz=T, inset=0,cex=1, adj=-0) 
dev.off()


#-----------------------------------------------------------------------------------+
#                                                                                   |
#                            5.  ADITIONAL ANALYSES                                 |
#                                                                                   |
#-----------------------------------------------------------------------------------+


###########################################################################################
#         Comparison of TE indices between X and protoX (Philippe's suppl. figure)        #
###########################################################################################

# Lizard
#------------
outgroup=c("human", "mouse", "opossum", "platypus", "chicken", "xenopus")
lizard.protoX = get.protoX(target="lizard", outgroup=outgroup)
lizard.protoX.TE = tissue.exp.normal(lizard.proto.EM.chroms[["X"]][lizard.protoX,])
lizard.X.TE = tissue.exp.normal(EM_one2one.7sp.collapsed[lizard.protoX, 1:5])

boxplot(lizard.X.TE[,1], lizard.protoX.TE[,1],
        lizard.X.TE[,2], lizard.protoX.TE[,2],
        lizard.X.TE[,3], lizard.protoX.TE[,3],
        lizard.X.TE[,4], lizard.protoX.TE[,4],
        lizard.X.TE[,5], lizard.protoX.TE[,5], notch=T, col=rep(c("blue", "lightblue"), 5))

wilcox.test(lizard.X.TE[,1], lizard.protoX.TE[,1], paired=T, exact=T)$p.value
wilcox.test(lizard.X.TE[,2], lizard.protoX.TE[,2], paired=T, exact=T)$p.value
wilcox.test(lizard.X.TE[,3], lizard.protoX.TE[,3], paired=T, exact=T)$p.value
wilcox.test(lizard.X.TE[,4], lizard.protoX.TE[,4], paired=T, exact=T)$p.value
wilcox.test(lizard.X.TE[,5], lizard.protoX.TE[,5], paired=T, exact=T)$p.value

cor.test(lizard.X.TE[,1], lizard.protoX.TE[,1])
cor.test(lizard.X.TE[,2], lizard.protoX.TE[,2])
cor.test(lizard.X.TE[,3], lizard.protoX.TE[,3])
cor.test(lizard.X.TE[,4], lizard.protoX.TE[,4])
cor.test(lizard.X.TE[,5], lizard.protoX.TE[,5])

# Human
#------------
human.protoX.TE2 = tissue.exp.normal(human.protoX.EM)
human.protoX.TE = tissue.exp.normal(human.protoX.EM)
human.X.TE = tissue.exp.normal(EM_one2one.7sp.collapsed[human.protoX, paste0("human.", male)])

boxplot(human.X.TE[,1], human.protoX.TE[,1],
        human.X.TE[,2], human.protoX.TE[,2],
        human.X.TE[,3], human.protoX.TE[,3],
        human.X.TE[,4], human.protoX.TE[,4],
        human.X.TE[,5], human.protoX.TE[,5], notch=T, col=rep(c("blue", "lightblue"), 5))

wilcox.test(human.X.TE[,1], human.protoX.TE[,1], paired=T)
wilcox.test(human.X.TE[,2], human.protoX.TE[,2], paired=T, exact=T)
wilcox.test(human.X.TE[,3], human.protoX.TE[,3], paired=T, exact=T)
wilcox.test(human.X.TE[,4], human.protoX.TE[,4], paired=T, exact=T)
wilcox.test(human.X.TE[,5], human.protoX.TE[,5], paired=T, exact=T)

cor.test(human.X.TE[,1], human.protoX.TE[,1])
cor.test(human.X.TE[,2], human.protoX.TE[,2])
cor.test(human.X.TE[,3], human.protoX.TE[,3])
cor.test(human.X.TE[,4], human.protoX.TE[,4])
cor.test(human.X.TE[,5], human.protoX.TE[,5])

# Mouse
#------------
mouse.protoX.TE = tissue.exp.normal(mouse.protoX.EM)
mouse.X.TE = tissue.exp.normal(EM_one2one.7sp.collapsed[mouse.protoX, paste0("mouse.", male)])

boxplot(mouse.X.TE[,1], mouse.protoX.TE[,1],
        mouse.X.TE[,2], mouse.protoX.TE[,2],
        mouse.X.TE[,3], mouse.protoX.TE[,3],
        mouse.X.TE[,4], mouse.protoX.TE[,4],
        mouse.X.TE[,5], mouse.protoX.TE[,5], notch=T, col=rep(c("blue", "lightblue"), 5))

wilcox.test(mouse.X.TE[,1], mouse.protoX.TE[,1], paired=T)
wilcox.test(mouse.X.TE[,2], mouse.protoX.TE[,2], paired=T, exact=T)
wilcox.test(mouse.X.TE[,3], mouse.protoX.TE[,3], paired=T, exact=T)
wilcox.test(mouse.X.TE[,4], mouse.protoX.TE[,4], paired=T, exact=T)
wilcox.test(mouse.X.TE[,5], mouse.protoX.TE[,5], paired=T, exact=T)

cor.test(mouse.X.TE[,1], mouse.protoX.TE[,1])
cor.test(mouse.X.TE[,2], mouse.protoX.TE[,2])
cor.test(mouse.X.TE[,3], mouse.protoX.TE[,3])
cor.test(mouse.X.TE[,4], mouse.protoX.TE[,4])
cor.test(mouse.X.TE[,5], mouse.protoX.TE[,5])

# Opossum
#------------
opossum.protoX.TE = tissue.exp.normal(opossum.protoX.EM)
opossum.X.TE = tissue.exp.normal(EM_one2one.7sp.collapsed[opossum.protoX, paste0("opossum.", male)])

boxplot(opossum.X.TE[,1], opossum.protoX.TE[,1],
        opossum.X.TE[,2], opossum.protoX.TE[,2],
        opossum.X.TE[,3], opossum.protoX.TE[,3],
        opossum.X.TE[,4], opossum.protoX.TE[,4],
        opossum.X.TE[,5], opossum.protoX.TE[,5], notch=T, col=rep(c("blue", "lightblue"), 5))

wilcox.test(opossum.X.TE[,1], opossum.protoX.TE[,1], paired=T)
wilcox.test(opossum.X.TE[,2], opossum.protoX.TE[,2], paired=T, exact=T)
wilcox.test(opossum.X.TE[,3], opossum.protoX.TE[,3], paired=T, exact=T)
wilcox.test(opossum.X.TE[,4], opossum.protoX.TE[,4], paired=T, exact=T)
wilcox.test(opossum.X.TE[,5], opossum.protoX.TE[,5], paired=T, exact=T)

cor.test(opossum.X.TE[,1], opossum.protoX.TE[,1])
cor.test(opossum.X.TE[,2], opossum.protoX.TE[,2])
cor.test(opossum.X.TE[,3], opossum.protoX.TE[,3])
cor.test(opossum.X.TE[,4], opossum.protoX.TE[,4])
cor.test(opossum.X.TE[,5], opossum.protoX.TE[,5])

# Platypus
#------------
platypus.protoX.TE = tissue.exp.normal(platypus.protoX.EM)
platypus.X.TE = tissue.exp.normal(EM_one2one.7sp.collapsed[platypus.protoX, paste0("platypus.", male)])

boxplot(platypus.X.TE[,1], platypus.protoX.TE[,1],
        platypus.X.TE[,2], platypus.protoX.TE[,2],
        platypus.X.TE[,3], platypus.protoX.TE[,3],
        platypus.X.TE[,4], platypus.protoX.TE[,4],
        platypus.X.TE[,5], platypus.protoX.TE[,5], notch=T, col=rep(c("blue", "lightblue"), 5))

wilcox.test(platypus.X.TE[,1], platypus.protoX.TE[,1], paired=T)
wilcox.test(platypus.X.TE[,2], platypus.protoX.TE[,2], paired=T, exact=T)
wilcox.test(platypus.X.TE[,3], platypus.protoX.TE[,3], paired=T, exact=T)
wilcox.test(platypus.X.TE[,4], platypus.protoX.TE[,4], paired=T, exact=T)
wilcox.test(platypus.X.TE[,5], platypus.protoX.TE[,5], paired=T, exact=T)

cor.test(platypus.X.TE[,1], platypus.protoX.TE[,1])
cor.test(platypus.X.TE[,2], platypus.protoX.TE[,2])
cor.test(platypus.X.TE[,3], platypus.protoX.TE[,3])
cor.test(platypus.X.TE[,4], platypus.protoX.TE[,4])
cor.test(platypus.X.TE[,5], platypus.protoX.TE[,5])

# Chicken
#------------
chicken.protoX.TE = tissue.exp.normal(chicken.protoX.EM)
chicken.X.TE = tissue.exp.normal(EM_one2one.7sp.collapsed[chicken.protoX, paste0("chicken.", male)])

boxplot(chicken.X.TE[,1], chicken.protoX.TE[,1],
        chicken.X.TE[,2], chicken.protoX.TE[,2],
        chicken.X.TE[,3], chicken.protoX.TE[,3],
        chicken.X.TE[,4], chicken.protoX.TE[,4],
        chicken.X.TE[,5], chicken.protoX.TE[,5], notch=T, col=rep(c("blue", "lightblue"), 5))

wilcox.test(chicken.X.TE[,1], chicken.protoX.TE[,1], paired=T)
wilcox.test(chicken.X.TE[,2], chicken.protoX.TE[,2], paired=T, exact=T)
wilcox.test(chicken.X.TE[,3], chicken.protoX.TE[,3], paired=T, exact=T)
wilcox.test(chicken.X.TE[,4], chicken.protoX.TE[,4], paired=T, exact=T)
wilcox.test(chicken.X.TE[,5], chicken.protoX.TE[,5], paired=T, exact=T)

cor.test(chicken.X.TE[,1], chicken.protoX.TE[,1])
cor.test(chicken.X.TE[,2], chicken.protoX.TE[,2])
cor.test(chicken.X.TE[,3], chicken.protoX.TE[,3])
cor.test(chicken.X.TE[,4], chicken.protoX.TE[,4])
cor.test(chicken.X.TE[,5], chicken.protoX.TE[,5])

# Density plots of TE index in testis
#----------------------------------------

genes.x = subset(lizard.7sp, AXY=="X")$gene
lizard.X.TE.all = tissue.exp.normal(lizard.7sp[genes.x, male])
plot(density(lizard.X.TE.all[,5], na.rm=T))

genes.a = subset(lizard.7sp, AXY=="A")$gene
lizard.A.TE.all = tissue.exp.normal(lizard.7sp[genes.a, male])
plot(density(lizard.A.TE.all[,5], na.rm=T))


genes.x = subset(human.7sp, AXY=="X")$gene
human.X.TE.all = tissue.exp.normal(human.7sp[genes.x, male])
plot(density(human.X.TE.all[,5], na.rm=T))

genes.a = subset(human.7sp, AXY=="A")$gene
human.A.TE.all = tissue.exp.normal(human.7sp[genes.a, male])
plot(density(human.A.TE.all[,5], na.rm=T))





########################################################################################
# protoX to protoAA ratio for all expressed genes
########################################################################################
source("~/Documents/Research/Transcriptomics/Lizard/AncestralExpression/R/functions.r")

# Human
# -------------
outgroup.species = c("platypus", "chicken", "xenopus", "lizard")
genes.x = intersect(subset(human.7sp, AXY=="X")$gene, 
                    subset(human.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

human.brain = protoChr.to.protoA.ratio.random(target="human", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.heart = protoChr.to.protoA.ratio.random(target="human", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.kidney = protoChr.to.protoA.ratio.random(target="human", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.liver = protoChr.to.protoA.ratio.random(target="human", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
human.gonads = protoChr.to.protoA.ratio.random(target="human", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

human.protoXtoA = list(human.brain[,1], human.heart[,1], human.kidney[,1], human.liver[,1], human.gonads[,1],
                       human.brain[,2], human.heart[,2], human.kidney[,2], human.liver[,2], human.gonads[,2])
human.protoXtoA.lab = paste("human", rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

human.protoXtoA.pval = compute.wilcox.list(human.protoXtoA)
human.protoXtoA.q = compute.quantile.list(human.protoXtoA)
colnames(human.protoXtoA.q)= human.protoXtoA.lab
colnames(human.protoXtoA.pval)= human.protoXtoA.lab
human.protoXtoA.q
human.protoXtoA.pval

# Mouse
# -------------
outgroup.species = c("platypus", "chicken", "xenopus", "lizard")
genes.x = intersect(subset(mouse.7sp, AXY=="X")$gene, 
                    subset(mouse.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

mouse.brain = protoChr.to.protoA.ratio.random(target="mouse", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.heart = protoChr.to.protoA.ratio.random(target="mouse", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.kidney = protoChr.to.protoA.ratio.random(target="mouse", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.liver = protoChr.to.protoA.ratio.random(target="mouse", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
mouse.gonads = protoChr.to.protoA.ratio.random(target="mouse", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

mouse.protoXtoA = list(mouse.brain[,1], mouse.heart[,1], mouse.kidney[,1], mouse.liver[,1], mouse.gonads[,1],
                       mouse.brain[,2], mouse.heart[,2], mouse.kidney[,2], mouse.liver[,2], mouse.gonads[,2])
mouse.protoXtoA.lab = paste("mouse", rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

mouse.protoXtoA.pval = compute.wilcox.list(mouse.protoXtoA)
mouse.protoXtoA.q = compute.quantile.list(mouse.protoXtoA)
colnames(mouse.protoXtoA.q)= mouse.protoXtoA.lab
colnames(mouse.protoXtoA.pval)= mouse.protoXtoA.lab
mouse.protoXtoA.q
mouse.protoXtoA.pval

# Opossum
# -------------
outgroup.species = c("platypus", "chicken", "xenopus", "lizard")
genes.x = intersect(subset(opossum.7sp, AXY=="X")$gene, 
                    subset(opossum.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

opossum.brain = protoChr.to.protoA.ratio.random(target="opossum", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.heart = protoChr.to.protoA.ratio.random(target="opossum", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.kidney = protoChr.to.protoA.ratio.random(target="opossum", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.liver = protoChr.to.protoA.ratio.random(target="opossum", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
opossum.gonads = protoChr.to.protoA.ratio.random(target="opossum", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

opossum.protoXtoA = list(opossum.brain[,1], opossum.heart[,1], opossum.kidney[,1], opossum.liver[,1], opossum.gonads[,1],
                         opossum.brain[,2], opossum.heart[,2], opossum.kidney[,2], opossum.liver[,2], opossum.gonads[,2])
opossum.protoXtoA.lab = paste("opossum", rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

opossum.protoXtoA.pval = compute.wilcox.list(opossum.protoXtoA)
opossum.protoXtoA.q = compute.quantile.list(opossum.protoXtoA)
colnames(opossum.protoXtoA.q)= opossum.protoXtoA.lab
colnames(opossum.protoXtoA.pval)= opossum.protoXtoA.lab
opossum.protoXtoA.q
opossum.protoXtoA.pval

# Platypus
# -------------
outgroup.species = c("human", "mouse", "opossum", "xenopus", "lizard")
genes.x = intersect(subset(platypus.7sp, AXY=="X")$gene, 
                    subset(platypus.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

platypus.brain = protoChr.to.protoA.ratio.random(target="platypus", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.heart = protoChr.to.protoA.ratio.random(target="platypus", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.kidney = protoChr.to.protoA.ratio.random(target="platypus", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.liver = protoChr.to.protoA.ratio.random(target="platypus", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
platypus.gonads = protoChr.to.protoA.ratio.random(target="platypus", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

platypus.protoXtoA = list(platypus.brain[,1], platypus.heart[,1], platypus.kidney[,1], platypus.liver[,1], platypus.gonads[,1],
                          platypus.brain[,2], platypus.heart[,2], platypus.kidney[,2], platypus.liver[,2], platypus.gonads[,2])
platypus.protoXtoA.lab = paste("platypus", rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

platypus.protoXtoA.pval = compute.wilcox.list(platypus.protoXtoA)
platypus.protoXtoA.q = compute.quantile.list(platypus.protoXtoA)
colnames(platypus.protoXtoA.q)= platypus.protoXtoA.lab
colnames(platypus.protoXtoA.pval)= platypus.protoXtoA.lab
platypus.protoXtoA.q
platypus.protoXtoA.pval

# Chicken
# -------------
outgroup.species = c("human", "mouse", "opossum", "xenopus", "lizard")
genes.x = intersect(subset(chicken.7sp, AXY=="X")$gene, 
                    subset(chicken.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

chicken.brain = protoChr.to.protoA.ratio.random(target="chicken", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.heart = protoChr.to.protoA.ratio.random(target="chicken", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.kidney = protoChr.to.protoA.ratio.random(target="chicken", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.liver = protoChr.to.protoA.ratio.random(target="chicken", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
chicken.gonads = protoChr.to.protoA.ratio.random(target="chicken", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

chicken.protoXtoA = list(chicken.brain[,1], chicken.heart[,1], chicken.kidney[,1], chicken.liver[,1], chicken.gonads[,1],
                         chicken.brain[,2], chicken.heart[,2], chicken.kidney[,2], chicken.liver[,2], chicken.gonads[,2])
chicken.protoXtoA.lab = paste("chicken", rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

chicken.protoXtoA.pval = compute.wilcox.list(chicken.protoXtoA)
chicken.protoXtoA.q = compute.quantile.list(chicken.protoXtoA)
colnames(chicken.protoXtoA.q)= chicken.protoXtoA.lab
colnames(chicken.protoXtoA.pval)= chicken.protoXtoA.lab
chicken.protoXtoA.q
chicken.protoXtoA.pval

# Lizard
# -------------
outgroup.species = c("human", "mouse", "opossum", "platypus", "chicken", "xenopus")
genes.x = intersect(subset(lizard.7sp, AXY=="X")$gene, 
                    subset(lizard.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

lizard.brain = protoChr.to.protoA.ratio.random(target="lizard", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.heart = protoChr.to.protoA.ratio.random(target="lizard", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.kidney = protoChr.to.protoA.ratio.random(target="lizard", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.liver = protoChr.to.protoA.ratio.random(target="lizard", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)
lizard.gonads = protoChr.to.protoA.ratio.random(target="lizard", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.7sp.X.A.genes, one2one.exp.matrix=EM_one2one.7sp.collapsed, one2one.table = one2one.7sp, chr.genes=genes.x, min.exp=0)

lizard.protoXtoA = list(lizard.brain[,1], lizard.heart[,1], lizard.kidney[,1], lizard.liver[,1], lizard.gonads[,1],
                        lizard.brain[,2], lizard.heart[,2], lizard.kidney[,2], lizard.liver[,2], lizard.gonads[,2])
lizard.protoXtoA.lab = paste("lizard", rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

lizard.protoXtoA.pval = compute.wilcox.list(lizard.protoXtoA)
lizard.protoXtoA.q = compute.quantile.list(lizard.protoXtoA)
colnames(lizard.protoXtoA.q)= lizard.protoXtoA.lab
colnames(lizard.protoXtoA.pval)= lizard.protoXtoA.lab
lizard.protoXtoA.q
lizard.protoXtoA.pval

#---------------------------------------------------------------------------------------------------------------------------------------
save(human.protoXtoA.q, human.protoXtoA.pval,
     mouse.protoXtoA.q, mouse.protoXtoA.pval,
     opossum.protoXtoA.q, opossum.protoXtoA.pval,
     platypus.protoXtoA.q, platypus.protoXtoA.pval,
     chicken.protoXtoA.q, chicken.protoXtoA.pval,
     lizard.protoXtoA.q, lizard.protoXtoA.pval,
     file=paste0(path, "/R/protoXvsA.7species.many.outgroups.v5.Rdata"))
#---------------------------------------------------------------------------------------------------------------------------------------
load(file=paste0(path, "/R/protoXvsA.7species.many.outgroups.v5.Rdata"))

# Putting together X:protoX data for each species            
#------------------------------------------------

# Putting together data for plot
#-------------------------------

empty=c(-1,-1,-1,-1,-1)
data = cbind(human.protoXtoA.q, empty, mouse.protoXtoA.q, empty, opossum.protoXtoA.q, empty, platypus.protoXtoA.q, empty, chicken.protoXtoA.q, empty, lizard.protoXtoA.q, deparse.level=2)
colnames(data) = gsub("empty", "", colnames(data), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)
empty=c(2,2,2)
pval = cbind(human.protoXtoA.pval, empty, mouse.protoXtoA.pval, empty,  opossum.protoXtoA.pval, empty, platypus.protoXtoA.pval, empty, chicken.protoXtoA.pval, empty, lizard.protoXtoA.pval)
pval.color = pval.to.colors.v2(pval, pcutoff=0.01)

nsamples=dim(data)[2]

# Creating the actual plot
#-------------------------------
setwd(paste0(path, "/Figures"))
pdf(file = "protoXvsA.7species.many.outgroups.v5.pdf", width = 8, height = 4)
par(fig=c(0,1,0,0.8), new=FALSE, mar=c(5, 5, 1, 2), cex=0.8)

ymin=-2
ymax=2
x1=1; x2=5

plot(c(x1:x2), human.protoXtoA.q[3,1:5], xlim=c(1, nsamples), ylim=c(ymin,ymax), pch=21, bg="#ffffff", col="#444444", lwd=2, cex=1.5, axes=FALSE, xlab="", ylab="")
x1=x2+1; x2=x1+5-1
points(c(x1:x2), human.protoXtoA.q[3,6:10], pch=21, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1
abline(v=x1-1, lty=2, col="grey")
abline(h=-1, lty=1)
abline(h=0, lty=2)
abline(h=1, lty=1)

points(c(x1:x2), mouse.protoXtoA.q[3,1:5], pch=22, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), mouse.protoXtoA.q[3,6:10], pch=22, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), opossum.protoXtoA.q[3,1:5], pch=23, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), opossum.protoXtoA.q[3,6:10], pch=23, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), platypus.protoXtoA.q[3,1:5], pch=24, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), platypus.protoXtoA.q[3,6:10], pch=24, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), chicken.protoXtoA.q[3,1:5], pch=25, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), chicken.protoXtoA.q[3,6:10], pch=25, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), lizard.protoXtoA.q[3,1:5], pch=21, bg="#ffffff", col="#00dd00", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), lizard.protoXtoA.q[3,6:10], pch=21, bg="#00dd00", col="#00dd00", lwd=2, cex=1.5)


axis(1, at=seq(1,nsamples,by=1), labels=colnames(data), las=2, cex.axis=0.4, tick=FALSE, pos=-2.1)
axis(2, at=seq(ymin,ymax,by=1), labels=seq(ymin,ymax,by=1), las=2, xlab=F)

par(fig=c(0,1,0.7,1), new=TRUE, mar=c(1, 5, 2, 2))
plot(pval.color[1,], xlim=c(1, nsamples), ylim=c(0.5,1.5), pch=15, col="black", axes=FALSE, xlab="", ylab="", cex=0.9)
points(pval.color[2,], pch=15, col="orange",  cex=0.7)
points(pval.color[3,], pch=15, col="#00aaff", cex=0.6)
points(pval.color[4,], pch=15, col="grey", cex=0.5)
axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
# legend(10,1.7, legend=c("median = -1","median = 0", "median = 1", "median not -1,0,1"), pch=c(15, 15, 15, 15), col=c("black", "orange", "#00aaff", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 
legend(20,1.5, legend=c("median = -1","median = 0", "median not -1,0,1"), pch=c(15, 15, 15), col=c("black", "orange", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 

dev.off()
#--------------------------------------------------------------------------#

