path="/Users/agkaessmann/Projects/Anolis/Documentation_dosage_compensation"
source(paste0(path, "/Scripts_R/functions.r"))

load(file=paste0(path, "/one2one.6sp.no.chicken.Rdata"))
load(file=paste0(path, "/Rdata/final.expression.tables.7species.v5.Rdata"))
load(file=paste0(path, "/Rdata/all.genes.v5.Rdata"))
load(file=paste0(path, "/one2one.6sp.X.A.genes.no.chicken.Rdata"))
load(file=paste0(path, "/EM_one2one.6sp.no.chicken.collapsed.Rdata"))

#-----------------------------------------------------------------------------------+
#                                                                                   |
#                 2.  CURRENT:ANCESTRAL RATIO USING 1:1 ORTHOLOGOUS GENES           |
#                            (Fig 3 in Philippe's paper)                            |
#                                                                                   |
#-----------------------------------------------------------------------------------+

species=c("Human", "Mouse", "Opossum", "Platypus",  "Lizard")

# Human
# -----------------

# Selection of species with non-homologous sex system
outgroup.species ="xenopus"

# Selection of coding X-linked genes
genes.x = intersect(subset(human.7sp, AXY=="X")$gene, 
                    subset(human.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

# Computation of X/protoX ratios. 
# X/protoX genes correspond to 1:1 genes that are X in the target species but autosomal in 
# species with a different sex system. "X expression" is the expression of the gene in the 
# target species and "ProtoX expression" is the median expression of the genes across the 
# outgroup species
human.brain = Chr.to.protoA.ratio.random(target="human", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
human.heart = Chr.to.protoA.ratio.random(target="human", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
human.kidney = Chr.to.protoA.ratio.random(target="human", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
human.liver = Chr.to.protoA.ratio.random(target="human", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
human.gonads = Chr.to.protoA.ratio.random(target="human", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)


# Formatting and computation of quantiles and p-val
human.all = list(human.brain[,1], human.heart[,1], human.kidney[,1], human.liver[,1], human.gonads[,1],
                 human.brain[,3], human.heart[,3], human.kidney[,3], human.liver[,3], human.gonads[,3])
human.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

human.all.pval = compute.wilcox.list(human.all)
human.all.q = compute.quantile.list(human.all)
colnames(human.all.pval)= human.all.lab
colnames(human.all.q)= human.all.lab
human.all.pval
human.all.q


# Mouse
# -----------------
genes.x = intersect(subset(mouse.7sp, AXY=="X")$gene, 
                    subset(mouse.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

mouse.brain = Chr.to.protoA.ratio.random(target="mouse", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
mouse.heart = Chr.to.protoA.ratio.random(target="mouse", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
mouse.kidney = Chr.to.protoA.ratio.random(target="mouse", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
mouse.liver = Chr.to.protoA.ratio.random(target="mouse", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
mouse.gonads = Chr.to.protoA.ratio.random(target="mouse", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)

mouse.all = list(mouse.brain[,1], mouse.heart[,1], mouse.kidney[,1], mouse.liver[,1], mouse.gonads[,1],
                 mouse.brain[,3], mouse.heart[,3], mouse.kidney[,3], mouse.liver[,3], mouse.gonads[,3])
mouse.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

mouse.all.pval = compute.wilcox.list(mouse.all)
mouse.all.q = compute.quantile.list(mouse.all)
colnames(mouse.all.pval)= mouse.all.lab
colnames(mouse.all.q)= mouse.all.lab
mouse.all.pval
mouse.all.q

# Opossum
# -----------------
genes.x = intersect(subset(opossum.7sp, AXY=="X")$gene, 
                    subset(opossum.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

opossum.brain = Chr.to.protoA.ratio.random(target="opossum", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
opossum.heart = Chr.to.protoA.ratio.random(target="opossum", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
opossum.kidney = Chr.to.protoA.ratio.random(target="opossum", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
opossum.liver = Chr.to.protoA.ratio.random(target="opossum", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
opossum.gonads = Chr.to.protoA.ratio.random(target="opossum", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)

opossum.all = list(opossum.brain[,1], opossum.heart[,1], opossum.kidney[,1], opossum.liver[,1], opossum.gonads[,1],
                   opossum.brain[,3], opossum.heart[,3], opossum.kidney[,3], opossum.liver[,3], opossum.gonads[,3])
opossum.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

opossum.all.pval = compute.wilcox.list(opossum.all)
opossum.all.q = compute.quantile.list(opossum.all)
colnames(opossum.all.pval)= opossum.all.lab
colnames(opossum.all.q)= opossum.all.lab
opossum.all.pval
opossum.all.q

# Platypus
# -----------------
# outgroup.species = c("human", "mouse", "opossum", "xenopus", "lizard")
# NOTE: Since we don't have human ovaries and we have enough therian species 
#       I prefer not to use human as an outgroup in all organs

outgroup.species ="xenopus"
genes.x = intersect(subset(platypus.7sp, AXY=="X")$gene, 
                    subset(platypus.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

platypus.brain = Chr.to.protoA.ratio.random(target="platypus", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
platypus.heart = Chr.to.protoA.ratio.random(target="platypus", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
platypus.kidney = Chr.to.protoA.ratio.random(target="platypus", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
platypus.liver = Chr.to.protoA.ratio.random(target="platypus", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
platypus.gonads = Chr.to.protoA.ratio.random(target="platypus", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)

platypus.all = list(platypus.brain[,1], platypus.heart[,1], platypus.kidney[,1], platypus.liver[,1], platypus.gonads[,1],
                    platypus.brain[,3], platypus.heart[,3], platypus.kidney[,3], platypus.liver[,3], platypus.gonads[,3])
platypus.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

platypus.all.pval = compute.wilcox.list(platypus.all)
platypus.all.q = compute.quantile.list(platypus.all)
colnames(platypus.all.pval)= platypus.all.lab
colnames(platypus.all.q)= platypus.all.lab
platypus.all.pval
platypus.all.q

# Lizard
# -----------------
# outgroup.species = c("human", "mouse", "opossum", "platypus", "chicken", "xenopus")
outgroup.species = "xenopus"
genes.x = intersect(subset(lizard.7sp, AXY=="X")$gene, 
                    subset(lizard.genes, Gene.Biotype=="protein_coding")$Ensembl.Gene.ID)

lizard.brain = Chr.to.protoA.ratio.random(target="lizard", tissue="brain", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
lizard.heart = Chr.to.protoA.ratio.random(target="lizard", tissue="heart", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
lizard.kidney = Chr.to.protoA.ratio.random(target="lizard", tissue="kidney", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
lizard.liver = Chr.to.protoA.ratio.random(target="lizard", tissue="liver", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)
lizard.gonads = Chr.to.protoA.ratio.random(target="lizard", tissue="gonads", outgroup=outgroup.species, one2one.genes=one2one.6sp.X.A.genes.no.chicken, one2one.exp.matrix=EM_one2one.6sp.no.chicken.collapsed, one2one.table = one2one.6sp.no.chicken, chr.genes=genes.x, min.exp=0)

lizard.all = list(lizard.brain[,1], lizard.heart[,1], lizard.kidney[,1], lizard.liver[,1], lizard.gonads[,1],
                  lizard.brain[,3], lizard.heart[,3], lizard.kidney[,3], lizard.liver[,3], lizard.gonads[,3])
lizard.all.lab = paste(rep(c("Brain", "Heart", "Kidney", "Liver", "Gonads"), 2), c(rep("M", 5), rep("F", 5)))

lizard.all.pval = compute.wilcox.list(lizard.all)
lizard.all.q = compute.quantile.list(lizard.all)
colnames(lizard.all.pval)= lizard.all.lab
colnames(lizard.all.q)= lizard.all.lab
lizard.all.pval
lizard.all.q


# Putting together data for plot
#-------------------------------

empty=c(-1,-1,-1,-1,-1)
data = cbind(human.all.q[,1:9], empty, mouse.all.q, empty, opossum.all.q, empty, platypus.all.q, empty, lizard.all.q, deparse.level=2)
colnames(data) = gsub("empty", "", colnames(data), ignore.case = FALSE, perl = FALSE, fixed = FALSE, useBytes = FALSE)
empty=c(2,2,2)
pval = cbind(human.all.pval[,1:9], empty, mouse.all.pval, empty,  opossum.all.pval, empty, platypus.all.pval, empty, lizard.all.pval)
pval.color = pval.to.colors.v2(pval, pcutoff=0.01)

nsamples=dim(data)[2]

# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
# Plot for all species                                                              |
# = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

setwd(paste0(path, "/Figures"))
pdf(file = "XvsProtoX_6species_no_chicken_xenopus_outgroup_v5.pdf", width = 8, height = 4)
par(fig=c(0,1,0,0.8), new=FALSE, mar=c(5, 5, 1, 2), cex=0.8)

ymin=-2
ymax=2
for.labels=NULL

x1=1; x2=5; for.labels=c(for.labels, x2)
plot(c(x1:x2), data[3,x1:x2], xlim=c(1, nsamples), ylim=c(ymin,ymax), pch=21, bg="#ffffff", col="#444444", lwd=2, cex=1.5, axes=FALSE, xlab="", ylab="")
x1=x2+1; x2=x1+4-1
points(c(x1:x2), data[3,x1:x2], pch=21, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1 ; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")
abline(h=-1, lty=1)
abline(h=0, lty=2)
abline(h=1, lty=1)

points(c(x1:x2), data[3,x1:x2], pch=22, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=22, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data[3,x1:x2], pch=23, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=23, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data[3,x1:x2], pch=24, bg="#ffffff", col="#444444", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=24, bg="#444444", col="#444444", lwd=2, cex=1.5)
x1=x2+2; x2=x1+5-1; for.labels=c(for.labels, x2)
abline(v=x1-1, lty=2, col="grey")

points(c(x1:x2), data[3,x1:x2], pch=21, bg="#ffffff", col="#00dd00", lwd=2, cex=1.5)
x1=x2+1; x2=x1+5-1
points(c(x1:x2), data[3,x1:x2], pch=21, bg="#00dd00", col="#00dd00", lwd=2, cex=1.5)

text(for.labels, rep(-1.8,6), species, pos=1, cex=0.8)
axis(1, at=seq(1,nsamples,by=1), labels=colnames(data), las=2, cex.axis=0.6, tick=FALSE, pos=-2.1)
axis(2, at=seq(ymin,ymax,by=1), labels=seq(ymin,ymax,by=1), las=2, xlab=F)

par(fig=c(0,1,0.7,1), new=TRUE, mar=c(1, 5, 2, 2))
plot(pval.color[1,], xlim=c(1, nsamples), ylim=c(0.5,1.5), pch=15, col="black", axes=FALSE, xlab="", ylab="", cex=0.9)
points(pval.color[2,], pch=15, col="orange",  cex=0.7)
points(pval.color[3,], pch=15, col="#00aaff", cex=0.6)
points(pval.color[4,], pch=15, col="grey", cex=0.5)
axis(2, at=seq(1,1,by=1), labels="P-value", las=2, xlab=F, cex.axis=1, tick=FALSE)
legend(20,1.5, legend=c("median = -1","median = 0", "median = 1", "median not -1,0,1"), pch=c(15, 15, 15, 15), col=c("black", "orange", "#00aaff", "grey"), bty="n", horiz=TRUE, inset=0,cex=0.7, adj=-0) 
dev.off()
