
#-----------------------------------------------------------------------------------+
#                                                                                   |
#                            1. SNPs DETECTED WITH DNA-seq                          |
#                                                                                   |
#-----------------------------------------------------------------------------------+
rm(list=ls())
library("Hmisc")
source("~/Dropbox/Anolis_paper/Scripts_R/functions.r")

#snp = read.table("~/Documents/Research/Genomics/Lizard/SNP_calling/2376g.Female/snpF.biallelic.v2.F0.2.D5.bed", head=F,  fill=TRUE, stringsAsFactors=F)
#head(snp)

#snp.exon = read.table("~/Documents/Research/Genomics/Lizard/SNP_calling/2376g.Female/snpF.biallelic.exons.v2.F0.2.D5.bed", head=F,  fill=TRUE, stringsAsFactors=F)
#head(snp.exon)

#XLinkedContigs <- read.table("~/Documents/Research/Genomics/Lizard/Analysis_coverage/Cummulative_diff/cum_diff_all_3mis_Xlinked", head=F, sep=" ", fill=TRUE, stringsAsFactors=F)
#XLinkedContigs = as.vector(XLinkedContigs[,1])

#save(snp, snp.exon, XLinkedContigs, file="~/Documents/Research/Transcriptomics/Lizard/SNP_analysis/Biallelic_expr/allelic.expression.Rdata")
load(file="~/Dropbox/Anolis_paper/Rdata_old/allelic.expression.Rdata")

#-------------------------------------------------------------
# Positions with coverage >=5 and 20-80% alt allele freq.    |
#-------------------------------------------------------------

#----------------------------
# ALL REGIONS
#----------------------------

# X chromosome
dim(subset(snp, V1 %in% XLinkedContigs))
# LGb contig
dim(subset(snp, V1 == "LGb"))
# Chromosome 1
dim(subset(snp, V1 == "1"))


#----------------------------
# EXONS
#----------------------------

# X chromosome
dim(subset(snp.exon, !(V1 %in% XLinkedContigs)))
detected.dna = paste(subset(snp.exon, V1 %in% XLinkedContigs)[,c(1)],
                     subset(snp.exon, V1 %in% XLinkedContigs)[,c(3)]
                     , sep="-")
# LGb contig
dim(subset(snp.exon, V1 == "LGb"))
# Chromosome 1
dim(subset(snp.exon, V1 == "1"))


#-----------------------------------------------------------------------------------+
#                                                                                   |
#                         2. SNPs COVERED BY RNA-seq READS                          |
#                                                                                   |
#-----------------------------------------------------------------------------------+

#setwd("~/Documents/Research/Transcriptomics/Lizard/SNP_analysis/Biallelic_expr")

#Brain1 <- read.table("Brain_Female1_1696sTS.QC.exons.v2.F0.2.D5.exprRatio.tab", head=FALSE, sep="\t", fill=TRUE)
#Heart1 <- read.table("Heart_Female1_1697sTS.QC.exons.v2.F0.2.D5.exprRatio.tab", head=FALSE, sep="\t", fill=TRUE)
#Kidney1 <- read.table("Kidney_Female1_1699sTS.QC.exons.v2.F0.2.D5.exprRatio.tab", head=FALSE, sep="\t", fill=TRUE)
#Liver1 <- read.table("Liver_Female1_1698sTS.QC.exons.v2.F0.2.D5.exprRatio.tab", head=FALSE, sep="\t", fill=TRUE)
#Ovary1 <- read.table("Ovary_Female1_1700sTS.QC.exons.v2.F0.2.D5.exprRatio.tab", head=FALSE, sep="\t", fill=TRUE)

#save(snp, snp.exon, XLinkedContigs, 
#     Brain1, Heart1, Kidney1, Liver1, Ovary1,
#     file="~/Documents/Research/Transcriptomics/Lizard/SNP_analysis/Biallelic_expr/allelic.expression.Rdata")
# load(file="~/Documents/Research/Transcriptomics/Lizard/SNP_analysis/Biallelic_expr/allelic.expression.Rdata")


min_depth = 5

Brain1.X = Brain1[which(Brain1[,1] %in% XLinkedContigs),]; Brain1.X = Brain1.X[Brain1.X[,5]>=min_depth,]
Brain1.LGb = Brain1[Brain1[,1]=="LGb",]; Brain1.LGb = Brain1.LGb[Brain1.LGb[,5]>=min_depth,]
Brain1.1 = Brain1[Brain1[,1]=="1",]; Brain1.1 = Brain1.1[Brain1.1[,5]>=min_depth,]
dim(Brain1.X)

Heart1.X = Heart1[which(Heart1[,1] %in% XLinkedContigs),]; Heart1.X = Heart1.X[Heart1.X[,5]>=min_depth,]
Heart1.LGb = Heart1[Heart1[,1]=="LGb",]; Heart1.LGb = Heart1.LGb[Heart1.LGb[,5]>=min_depth,]
Heart1.1 = Heart1[Heart1[,1]=="1",]; Heart1.1 = Heart1.1[Heart1.1[,5]>=min_depth,]
dim(Heart1.X)

Kidney1.X = Kidney1[which(Kidney1[,1] %in% XLinkedContigs),]; Kidney1.X = Kidney1.X[Kidney1.X[,5]>=min_depth,]
Kidney1.LGb = Kidney1[Kidney1[,1]=="LGb",]; Kidney1.LGb = Kidney1.LGb[Kidney1.LGb[,5]>=min_depth,]
Kidney1.1 = Kidney1[Kidney1[,1]=="1",]; Kidney1.1 = Kidney1.1[Kidney1.1[,5]>=min_depth,]
dim(Kidney1.X)

Liver1.X = Liver1[which(Liver1[,1] %in% XLinkedContigs),]; Liver1.X = Liver1.X[Liver1.X[,5]>=min_depth,]
Liver1.LGb = Liver1[Liver1[,1]=="LGb",]; Liver1.LGb = Liver1.LGb[Liver1.LGb[,5]>=min_depth,]
Liver1.1 = Liver1[Liver1[,1]=="1",]; Liver1.1 = Liver1.1[Liver1.1[,5]>=min_depth,]
#Liver1.A = Liver1[which(!(Liver1[,1] %in% XLinkedContigs)),]; Liver1.A = Liver1.A[Liver1.A[,5]>=min_depth,]
dim(Liver1.X)

Ovary1.X = Ovary1[which(Ovary1[,1] %in% XLinkedContigs),]; Ovary1.X = Ovary1.X[Ovary1.X[,5]>=min_depth,]
Ovary1.LGb = Ovary1[Ovary1[,1]=="LGb",]; Ovary1.LGb = Ovary1.LGb[Ovary1.LGb[,5]>=min_depth,]
Ovary1.1 = Ovary1[Ovary1[,1]=="1",]; Ovary1.1 = Ovary1.1[Ovary1.1[,5]>=min_depth,]
dim(Ovary1.X)


snp.Brain = paste(Brain1.X[,1], Brain1.X[,2], sep="-")
snp.Heart = paste(Heart1.X[,1], Heart1.X[,2], sep="-")
snp.Kidney = paste(Kidney1.X[,1], Kidney1.X[,2], sep="-")
snp.Liver = paste(Liver1.X[,1], Liver1.X[,2], sep="-")
snp.Ovary = paste(Ovary1.X[,1], Ovary1.X[,2], sep="-")

detected.rna = unique(c(snp.Brain, snp.Heart, snp.Kidney, snp.Liver, snp.Ovary))
length(intersect(detected.dna, detected.rna))/length(detected.dna)


pdf(file = "~/Dropbox/Anolis_paper/Figures/Revision/biallelic_expr_boxplot.pdf", width = 10, height = 5)
  par(mar=c(4, 4, 1, 1))
  female1 = c( "Brain",  "Heart",  "Kidney", "Liver", "Ovary")
  boxplot( Brain1.X[,6], Heart1.X[,6], Kidney1.X[,6], Liver1.X[,6], Ovary1.X[,6], Brain1.LGb[,6], Heart1.LGb[,6], Kidney1.LGb[,6], Liver1.LGb[,6], Ovary1.LGb[,6], Brain1.1[,6], Heart1.1[,6], Kidney1.1[,6], Liver1.1[,6], Ovary1.1[,6], names=rep(female1,3), horizontal=F, col=c(rep("#00aaff", 5), rep("orange", 5), rep("#aaaaaa", 5)), las=2, ylab="Fraction of reference allele", ylim=c(-0.09, 1))
    text(seq(3,15,5), rep(-0.03,3), c("Chrom X", "LGb", "Chrom 1"), pos=1, cex=1, col=c("#00aaff", "orange","#aaaaaa"))
  abline(h=0.5, lty=2, col="red", lwd=1)
dev.off()


