#clear workspace
rm(list=ls())

library(ggplot2)
setwd("~/Projects/Anolis/ChIP-Seq")
load("/Users/agkaessmann/Projects/Anolis/Documentation_dosage_compensation/Rdata/final.expression.tables.7species.v5.Rdata")

gene.n <- rbind(
c(nrow(subset(lizard.7sp, AXY == "A" & brain.male > 1)), "brain", "male", "active", "A"),
c(nrow(subset(lizard.7sp, AXY == "A" & brain.male <= 1)), "brain", "male", "inactive", "A"),
c(nrow(subset(lizard.7sp, AXY == "X" & brain.male > 1)), "brain", "male", "active", "X"),
c(nrow(subset(lizard.7sp, AXY == "X" & brain.male <= 1)), "brain", "male", "inactive", "X"),
c(nrow(subset(lizard.7sp, AXY == "A" & brain.female > 1)), "brain", "female", "active", "A"),
c(nrow(subset(lizard.7sp, AXY == "A" & brain.female <= 1)), "brain", "female", "inactive", "A"),
c(nrow(subset(lizard.7sp, AXY == "X" & brain.female > 1)), "brain", "female", "active", "X"),
c(nrow(subset(lizard.7sp, AXY == "X" & brain.female <= 1)), "brain", "female", "inactive", "X"),

c(nrow(subset(lizard.7sp, AXY == "A" & liver.male > 1)), "liver", "male", "active", "A"),
c(nrow(subset(lizard.7sp, AXY == "A" & liver.male <= 1)), "liver", "male", "inactive", "A"),
c(nrow(subset(lizard.7sp, AXY == "X" & liver.male > 1)), "liver", "male", "active", "X"),
c(nrow(subset(lizard.7sp, AXY == "X" & liver.male <= 1)), "liver", "male", "inactive", "X"),
c(nrow(subset(lizard.7sp, AXY == "A" & liver.female > 1)), "liver", "female", "active", "A"),
c(nrow(subset(lizard.7sp, AXY == "A" & liver.female <= 1)), "liver", "female", "inactive", "A"),
c(nrow(subset(lizard.7sp, AXY == "X" & liver.female > 1)), "liver", "female", "active", "X"),
c(nrow(subset(lizard.7sp, AXY == "X" & liver.female <= 1)), "liver", "female", "inactive", "X"),

kidney.male.active.A <- c(nrow(subset(lizard.7sp, AXY == "A" & kidney.male > 1)), "kidney", "male", "active", "A"),
kidney.male.inactive.A <- c(nrow(subset(lizard.7sp, AXY == "A" & kidney.male <= 1)), "kidney", "male", "inactive", "A"),
kidney.male.active.X <- c(nrow(subset(lizard.7sp, AXY == "X" & kidney.male > 1)), "kidney", "male", "active", "X"),
kidney.male.inactive.X <- c(nrow(subset(lizard.7sp, AXY == "X" & kidney.male <= 1)), "kidney", "male", "inactive", "X"),
kidney.female.active.A <- c(nrow(subset(lizard.7sp, AXY == "A" & kidney.female > 1)), "kidney", "female", "active", "A"),
kidney.female.inactive.A <- c(nrow(subset(lizard.7sp, AXY == "A" & kidney.female <= 1)), "kidney", "female", "inactive", "A"),
kidney.female.active.X <- c(nrow(subset(lizard.7sp, AXY == "X" & kidney.female > 1)), "kidney", "female", "active", "X"),
kidney.female.inactive.X <- c(nrow(subset(lizard.7sp, AXY == "X" & kidney.female <= 1)), "kidney", "female", "inactive", "X"),

heart.male.active.A <- c(nrow(subset(lizard.7sp, AXY == "A" & heart.male > 1)), "heart", "male", "active", "A"),
heart.male.inactive.A <- c(nrow(subset(lizard.7sp, AXY == "A" & heart.male <= 1)), "heart", "male", "inactive", "A"),
heart.male.active.X <- c(nrow(subset(lizard.7sp, AXY == "X" & heart.male > 1)), "heart", "male", "active", "X"),
heart.male.inactive.X <- c(nrow(subset(lizard.7sp, AXY == "X" & heart.male <= 1)), "heart", "male", "inactive", "X"),
heart.female.active.A <- c(nrow(subset(lizard.7sp, AXY == "A" & heart.female > 1)), "heart", "female", "active", "A"),
heart.female.inactive.A <- c(nrow(subset(lizard.7sp, AXY == "A" & heart.female <= 1)), "heart", "female", "inactive", "A"),
heart.female.active.X <- c(nrow(subset(lizard.7sp, AXY == "X" & heart.female > 1)), "heart", "female", "active", "X"),
heart.female.inactive.X <- c(nrow(subset(lizard.7sp, AXY == "X" & heart.female <= 1)), "heart", "female", "inactive", "X"),

gonads.male.active.A <- c(nrow(subset(lizard.7sp, AXY == "A" & gonads.male > 1)), "testis", "male", "active", "A"),
gonads.male.inactive.A <- c(nrow(subset(lizard.7sp, AXY == "A" & gonads.male <= 1)), "testis", "male", "inactive", "A"),
gonads.male.active.X <- c(nrow(subset(lizard.7sp, AXY == "X" & gonads.male > 1)), "testis", "male", "active", "X"),
gonads.male.inactive.X <- c(nrow(subset(lizard.7sp, AXY == "X" & gonads.male <= 1)), "testis", "male", "inactive", "X"),
gonads.female.active.A <- c(nrow(subset(lizard.7sp, AXY == "A" & gonads.female > 1)), "ovary", "female", "active", "A"),
gonads.female.inactive.A <- c(nrow(subset(lizard.7sp, AXY == "A" & gonads.female <= 1)), "ovary", "female", "inactive", "A"),
gonads.female.active.X <- c(nrow(subset(lizard.7sp, AXY == "X" & gonads.female > 1)), "ovary", "female", "active", "X"),
gonads.female.inactive.X <- c(nrow(subset(lizard.7sp, AXY == "X" & gonads.female <= 1)), "ovary", "female", "inactive", "X")
)

colnames(gene.n) <- c("n", "tissue", "sex", "state", "chr.type")
gene.n <- data.frame(gene.n)
gene.n$n <- as.numeric(levels(gene.n$n))[gene.n$n]
save(gene.n, file = "active_inactive_genes.Rdata")

ggplot(data = gene.n, aes(x = tissue, y = n)) +
  geom_bar(stat = "identity", position = "dodge", aes(fill = interaction(sex, state, chr.type))) +
  theme_classic() +
  ggtitle("Active vs. Inactive genes (FPKM > 1)") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.title.x = element_blank(),
        axis.text.x = element_text(face = "bold", size = 15),
        axis.text.y = element_text(face = "bold", size = 15),
        axis.title.y = element_blank(),
        axis.line.x = element_blank(),
        legend.title=element_blank(),
        legend.text=element_text(face = "bold", size = 10),
        panel.grid.major.y = element_line(colour = "grey87")) +
  scale_fill_brewer(palette = "Paired")