 #clear workspace
rm(list=ls())

library(ggplot2)
library(gridExtra)
library(dplyr)
library(tidyr)
library(RColorBrewer)
setwd("~/Dropbox/Anolis_paper/Rdata/")
load("active_inactive_genes.Rdata")
load("log2.chip.genic.agg.AX.GC.cor.Rdata")
load("~/Dropbox/Anolis_paper/Rdata_old/final.expression.tables.7species.v5.Rdata")

#Take median acetylation between replicates
#------------------------------------------
Liver.female <- data.frame("gene" = F1040_Lv_H4K16ac$gene,
                           "chr" = F1040_Lv_H4K16ac$chr,
                           "chr.type" = F1040_Lv_H4K16ac$chr.type,
                           "log2ratio" = rowMeans(cbind(F1040_Lv_H4K16ac$log2ratio, F127012016_Lv_H4K16ac$log2ratio)),
                           "tissue" = F1040_Lv_H4K16ac$tissue,
                           "sex" = F1040_Lv_H4K16ac$sex,
                           "sample" = rep("Liver.female", nrow(F1040_Lv_H4K16ac)))

Liver.male <- data.frame("gene" = M11060514_Lv_H4K16ac$gene,
                         "chr" = M11060514_Lv_H4K16ac$chr,
                         "chr.type" = M11060514_Lv_H4K16ac$chr.type,
                         "log2ratio" = rowMeans(cbind(M11060514_Lv_H4K16ac$log2ratio, M11060514_Lv_H4K16ac$log2ratio)),
                         "tissue" = M11060514_Lv_H4K16ac$tissue,
                         "sex" = M11060514_Lv_H4K16ac$sex,
                         "sample" = rep("Liver.male", nrow(M11060514_Lv_H4K16ac)))


Brain.female <- data.frame("gene" = F1040_WB_H4K16ac$gene,
                           "chr" = F1040_WB_H4K16ac$chr,
                           "chr.type" = F1040_WB_H4K16ac$chr.type,
                           "log2ratio" = rowMeans(cbind(F1040_WB_H4K16ac$log2ratio, F127012016_WB_H4K16ac$log2ratio)),
                           "tissue" = F1040_WB_H4K16ac$tissue,
                           "sex" = F1040_WB_H4K16ac$sex,
                           "sample" = rep("Brain.female", nrow(F1040_WB_H4K16ac)))

Brain.male <- data.frame("gene" = M11060514_WB_H4K16ac$gene,
                         "chr" = M11060514_WB_H4K16ac$chr,
                         "chr.type" = M11060514_WB_H4K16ac$chr.type,
                         "log2ratio" = rowMeans(cbind(M11060514_WB_H4K16ac$log2ratio, M11060514_WB_H4K16ac$log2ratio)),
                         "tissue" = M11060514_WB_H4K16ac$tissue,
                         "sex" = M11060514_WB_H4K16ac$sex,
                         "sample" = rep("Brain.male", nrow(M11060514_WB_H4K16ac)))

all <- rbind(Liver.female, Liver.male,
             Brain.female, Brain.male)

#################################################################################################################################
# Compute median M:F ratios
#--------------------------
sem <- function(x) {sd(x)/sqrt(length(x))}
LA.m <-median(subset(all, sex == "M" & tissue == "liver" & chr.type == "A")$log2ratio-
              subset(all, sex == "F" & tissue == "liver" & chr.type == "A")$log2ratio, na.rm = TRUE)
LA.sem <- sem(subset(all, sex == "M" & tissue == "liver" & chr.type == "A")$log2ratio-
              subset(all, sex == "F" & tissue == "liver" & chr.type == "A")$log2ratio)
BA.m <-median(subset(all, sex == "M" & tissue == "brain" & chr.type == "A")$log2ratio-
              subset(all, sex == "F" & tissue == "brain" & chr.type == "A")$log2ratio, na.rm = TRUE)
BA.sem <-sem(subset(all, sex == "M" & tissue == "brain" & chr.type == "A")$log2ratio-
             subset(all, sex == "F" & tissue == "brain" & chr.type == "A")$log2ratio)

LX.m <- median(subset(all, sex == "M" & tissue == "liver" & chr.type == "X")$log2ratio-
               subset(all, sex == "F" & tissue == "liver" & chr.type == "X")$log2ratio, na.rm = TRUE)
LX.sem <- sem(subset(all, sex == "M" & tissue == "liver" & chr.type == "X")$log2ratio-
              subset(all, sex == "F" & tissue == "liver" & chr.type == "X")$log2ratio)
BX.m <- median(subset(all, sex == "M" & tissue == "brain" & chr.type == "X")$log2ratio-
               subset(all, sex == "F" & tissue == "brain" & chr.type == "X")$log2ratio, na.rm = TRUE)
BX.sem <- sem(subset(all, sex == "M" & tissue == "brain" & chr.type == "X")$log2ratio-
              subset(all, sex == "F" & tissue == "brain" & chr.type == "X")$log2ratio)

male.female.ratio.log <- data.frame("name" = c("Liver M:F", "Brain M:F"),
                                    "A" = c(LA.m, BA.m),
                                    "X" = c(LX.m, BX.m))

male.female.ratio<- data.frame("name" = c("Liver M:F", "Brain M:F"),
                               "A" = c(2^LA.m, 2^BA.m),
                               "X" = c(2^LX.m, 2^BX.m))

# Compute median F:M ratios
#--------------------------

LAa.m <-median(subset(all, sex == "F" & tissue == "liver" & chr.type == "A")$log2ratio-
               subset(all, sex == "M" & tissue == "liver" & chr.type == "A")$log2ratio, na.rm = TRUE)
LAa.sem <-sem(subset(all, sex == "F" & tissue == "liver" & chr.type == "A")$log2ratio-
              subset(all, sex == "M" & tissue == "liver" & chr.type == "A")$log2ratio)
BAa.m <-median(subset(all, sex == "F" & tissue == "brain" & chr.type == "A")$log2ratio-
               subset(all, sex == "M" & tissue == "brain" & chr.type == "A")$log2ratio, na.rm = TRUE)
BAa.sem <-sem(subset(all, sex == "F" & tissue == "brain" & chr.type == "A")$log2ratio-
              subset(all, sex == "M" & tissue == "brain" & chr.type == "A")$log2ratio)
LXa.m <- median(subset(all, sex == "F" & tissue == "liver" & chr.type == "X")$log2ratio-
                subset(all, sex == "M" & tissue == "liver" & chr.type == "X")$log2ratio, na.rm = TRUE)
LXa.sem <- sem(subset(all, sex == "F" & tissue == "liver" & chr.type == "X")$log2ratio-
               subset(all, sex == "M" & tissue == "liver" & chr.type == "X")$log2ratio)
BXa.m <- median(subset(all, sex == "F" & tissue == "brain" & chr.type == "X")$log2ratio-
                subset(all, sex == "M" & tissue == "brain" & chr.type == "X")$log2ratio, na.rm = TRUE)
BXa.sem <- sem(subset(all, sex == "F" & tissue == "brain" & chr.type == "X")$log2ratio-
               subset(all, sex == "M" & tissue == "brain" & chr.type == "X")$log2ratio)

female.male.ratio.log <- data.frame("name" = c("Liver F:M", "Brain F:M"),
                                    "A" = c(LAa.m, BAa.m),
                                    "X" = c(LXa.m, BXa.m))

female.male.ratio<- data.frame("name" = c("Liver F:M", "Brain F:M"),
                               "A" = c(2^LAa.m, 2^BAa.m),
                               "X" = c(2^LXa.m, 2^BXa.m))

#################################################################################################################################

# Add median gene expression values
#----------------------------------
Brain.male.exp <- merge(lizard.7sp, Brain.male)
Brain.male.exp <- Brain.male.exp[, c(1,2,13:18)]
colnames(Brain.male.exp) <- c("gene", "fpkm", "chr", "chr.type", "log2ratio", "tissue", "sex", "sample")

Brain.female.exp <- merge(lizard.7sp, Brain.female)
Brain.female.exp <- Brain.female.exp[, c(1,7,13:18)]
colnames(Brain.female.exp) <- c("gene", "fpkm", "chr", "chr.type", "log2ratio", "tissue", "sex", "sample")

Liver.male.exp <- merge(lizard.7sp, Liver.male)
Liver.male.exp <- Liver.male.exp[, c(1,4,13:18)]
colnames(Liver.male.exp) <- c("gene", "fpkm", "chr", "chr.type", "log2ratio", "tissue", "sex", "sample")

Liver.female.exp <- merge(lizard.7sp, Liver.female)
Liver.female.exp <- Liver.female.exp[, c(1,9,13:18)]
colnames(Liver.female.exp) <- c("gene", "fpkm", "chr", "chr.type", "log2ratio", "tissue", "sex", "sample")

express <- rbind(Liver.female.exp, Liver.male.exp,
                 Brain.female.exp, Brain.male.exp)

express$state <- ifelse(express$fpkm > 1, "active", "inactive")
express$state <- factor(express$state, levels = c("inactive", "active"))

###### Run Mann-Whitney test
for (s in unique(express$sample)){
  print(s)
  x <- subset(express, sample == s)
  y <- wilcox.test(log2ratio ~ chr.type, data = x)
  print(y)
  if(y$p.value > 0.05){
    y$symbol <- "ns"
  }
  if(y$p.value <= 0.05){
    y$symbol <- "*"
  }
  if(y$p.value <= 0.01){
    y$symbol <- "**"
  }
  if(y$p.value <= 0.001){
    y$symbol <- "***"
  }
  if(y$p.value <= 0.0001){
    y$symbol <- "****"
  }
  assign(paste0(s,".","MW"), y)
}

female <- ggplot(subset(express, sex=="F" & fpkm>1), aes(x=sample, y=log2ratio)) +
  ggtitle("Female") +
  geom_boxplot(aes(fill=chr.type ), notch = T) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.text.x = element_text(face = "bold", size = 15),
        axis.line.x = element_blank(),
        axis.text.y = element_text(face = "bold", size = 15),
        axis.title.y = element_text(face = "bold", size = 15),
        legend.title = element_blank(),
        legend.text=element_text(face = "bold", size = 15),
        legend.key=element_rect(fill = "white", colour = "white"),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = Liver.female.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = Brain.female.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_x_discrete(label = c("Liver", "Brain")) +
  scale_fill_brewer(palette = "Pastel1") +
  geom_hline(yintercept = 0, linetype = "dashed")

male <- ggplot(subset(express, sex=="M" & fpkm>1), aes(x=sample, y=log2ratio)) +
  ggtitle("Male") +
  geom_boxplot(aes(fill=chr.type ), notch = T) +
  theme_classic() +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.text.x = element_text(face = "bold", size = 15),
        axis.line.x = element_blank(),
        axis.text.y = element_blank(),
        axis.title.y = element_blank(),
        axis.ticks.y = element_blank(),
        axis.line.y = element_blank(),
        legend.title = element_blank(),
        legend.text=element_text(face = "bold", size = 15),
        legend.key=element_rect(fill = "white", colour = "white"),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = Liver.male.MW$symbol, size = 5) +
  annotate("text", x = 2, y = 2, label = Brain.male.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  scale_x_discrete(label = c("Liver", "Brain")) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_brewer(palette = "Pastel1") +
  geom_hline(yintercept = 0, linetype = "dashed")

cairo_pdf(file = "Figures/Final/log2.ChIP.Input.genic.agg.med.fpkm1.GC.cor.boxplot.pdf",family = "Arial", height = 10, width = 8)
grid.arrange(female, male, nrow = 1, ncol = 2, top = textGrob("Genic (FPKM>1)", gp=gpar(fontsize=25, fontface="bold")))
dev.off()


###### Run Mann-Whitney test
for (s in unique(express$sample)){
  for (c in unique(express$chr.type)){
  print(paste0(s,".",c))
  x <- subset(express, sample == s & chr.type == c)
  y <- wilcox.test(log2ratio ~ state, data = x)
  print(y)
  if(y$p.value > 0.05){
    y$symbol <- "ns"
  }
  if(y$p.value <= 0.05){
    y$symbol <- "*"
  }
  if(y$p.value <= 0.01){
    y$symbol <- "**"
  }
  if(y$p.value <= 0.001){
    y$symbol <- "***"
  }
  if(y$p.value <= 0.0001){
    y$symbol <- "****"
  }
  assign(paste0(s,".",c,".","MW"), y)
  }
}


female.liver <- ggplot(subset(express, sex=="F" & tissue == "liver"), aes(x=sample, y=log2ratio)) +
  #ggtitle("Liver") +
  geom_boxplot(aes(fill=state ), notch = T) +
  theme_classic() +
  theme(legend.position = "none",
        #plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.text.y = element_text(face = "bold", size = 20),
        axis.title.y = element_text(face = "bold", size = 20),
        legend.key=element_rect(fill = "white", colour = "white"),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = Liver.female.X.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = Liver.female.X.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_manual(values = c("red3", "royalblue")) +
  geom_hline(yintercept = 0, linetype = "dashed")

female.brain <- ggplot(subset(express, sex=="F" & tissue=="brain"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=state ), notch = T) +
  theme_classic() +
  #ggtitle("Brain") +
  theme(legend.position = "none",
        #plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(), 
        #legend.title=element_blank(),
        #legend.text=element_text(face = "bold", size = 12),
        #legend.key=element_rect(fill = "white", colour = "white"),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = Brain.female.X.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = Brain.female.X.MW$symbol, size = 5) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2640", size = 12) +
  ylab(NULL) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_manual(values = c("red3", "royalblue")) +
  geom_hline(yintercept = 0, linetype = "dashed")

male.liver <- ggplot(subset(express, sex=="M" & tissue=="liver"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=state), notch = T) +
  theme_classic() +
  #ggtitle("Liver") +
  theme(legend.position = "none",
        #plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.title.y = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = Liver.male.X.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = Liver.male.X.MW$symbol, size = 5) +
  ylim(c(-2,2)) +
  labs(y="log2(ChIP/Input)", x=NULL) +
  scale_fill_manual(values = c("red3", "royalblue")) +
  geom_hline(yintercept = 0, linetype = "dashed")

male.brain <- ggplot(subset(express, sex=="M" & tissue=="brain"), aes(x=sample, y=log2ratio)) +
  geom_boxplot(aes(fill=state), notch = T) +
  theme_classic() +
  #ggtitle("Brain") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        legend.position = "none",
        axis.ticks.x = element_blank(),
        axis.text.x = element_blank(),
        axis.line.x = element_blank(),
        axis.ticks.y = element_blank(),
        axis.text.y = element_blank(),
        axis.line.y = element_blank(),
        #legend.title=element_blank(),
        #legend.text=element_text(face = "bold", size = 12),
        #legend.key=element_rect(fill = "white", colour = "white"),
        panel.grid.major.y = element_line(colour = "grey87")) +
  annotate("text", x = 1, y = 2, label = Brain.male.X.MW$symbol, size = 10) +
  #annotate("text", x = 2, y = 2, label = Brain.male.X.MW$symbol, size = 5) +
  #annotate("text", x = 2.5, y = 1.5, label = "\u2642", size = 12) +
  ylim(c(-2,2)) +
  labs(x=NULL, y=NULL) +
  scale_fill_manual(values = c("red3", "royalblue")) +
  #scale_fill_discrete(labels = c("FPKM1", "FPKM<1")) +
  geom_hline(yintercept = 0, linetype = "dashed")

setwd("~/Dropbox/Anolis_paper/")
cairo_pdf(file = "Figures/Final/Main/log2.ChIP.Input.genic.agg.GC.expr.cor.boxplot.pdf",family = "Arial", height = 4, width = 16)
grid.arrange(female.liver, male.liver, female.brain, male.brain, nrow = 1, ncol = 4)
dev.off()

############################################################################################################################

# Compute correlation (expression, acetylation)
#----------------------------------------------

Liver.female.exp.A <- subset(Liver.female.exp, chr.type == "A")
Liver.female.exp.X <- subset(Liver.female.exp, chr.type == "X")
Brain.female.exp.A <- subset(Brain.female.exp, chr.type == "A")
Brain.female.exp.X <- subset(Brain.female.exp, chr.type == "X")

Liver.male.exp.A <- subset(Liver.male.exp, chr.type == "A")
Liver.male.exp.X <- subset(Liver.male.exp, chr.type == "X")
Brain.male.exp.A <- subset(Brain.male.exp, chr.type == "A")
Brain.male.exp.X <- subset(Brain.male.exp, chr.type == "X")

cor.test(Liver.female.exp.A$fpkm, Liver.female.exp.A$log2ratio, method = "spearman")
cor.test(Liver.female.exp.X$fpkm, Liver.female.exp.X$log2ratio, method = "spearman")
cor.test(Brain.female.exp.A$fpkm, Brain.female.exp.A$log2ratio, method = "spearman")
cor.test(Brain.female.exp.X$fpkm, Brain.female.exp.X$log2ratio, method = "spearman")

cor.test(Liver.male.exp.A$fpkm, Liver.male.exp.A$log2ratio, method = "spearman")
cor.test(Liver.male.exp.X$fpkm, Liver.male.exp.X$log2ratio, method = "spearman")
cor.test(Brain.male.exp.A$fpkm, Brain.male.exp.A$log2ratio, method = "spearman")
cor.test(Brain.male.exp.X$fpkm, Brain.male.exp.X$log2ratio, method = "spearman")

#############################################################################################################################

#Compute active/inactive ratio
#-----------------------------
Brain.male.ratio.A<- gene.n[1,1]/gene.n[2,1]
Brain.male.ratio.X <- gene.n[3,1]/gene.n[4,1]
Brain.female.ratio.A <- gene.n[5,1]/gene.n[6,1]
Brain.female.ratio.X <- gene.n[7,1]/gene.n[8,1]

Liver.male.ratio.A <- gene.n[9,1]/gene.n[10,1]
Liver.male.ratio.X <- gene.n[11,1]/gene.n[12,1]
Liver.female.ratio.A <- gene.n[13,1]/gene.n[14,1]
Liver.female.ratio.X <- gene.n[15,1]/gene.n[16,1]

Kidney.male.ratio.A <- gene.n[17,1]/gene.n[18,1]
Kidney.male.ratio.X <- gene.n[19,1]/gene.n[20,1]
Kidney.female.ratio.A <- gene.n[21,1]/gene.n[22,1]
Kidney.female.ratio.X <- gene.n[23,1]/gene.n[24,1]

Heart.male.ratio.A <- gene.n[25,1]/gene.n[26,1]
Heart.male.ratio.X <- gene.n[27,1]/gene.n[28,1]
Heart.female.ratio.A <- gene.n[29,1]/gene.n[30,1]
Heart.female.ratio.X <- gene.n[31,1]/gene.n[32,1]

Gonads.male.ratio.A <- gene.n[33,1]/gene.n[34,1]
Gonads.male.ratio.X <- gene.n[35,1]/gene.n[36,1]
Gonads.female.ratio.A <- gene.n[37,1]/gene.n[38,1]
Gonads.female.ratio.X <- gene.n[39,1]/gene.n[40,1]

active.inactive.ratio <- data.frame("name" = c("Brain.female", "Brain.male",
                                                "Liver.female", "Liver.male",
                                                "Kidney.female", "Kidney.male",
                                                "Heart.female", "Heart.male",
                                                "Gonads.female", "Gonads.male"),
                                     "A" = c(Brain.female.ratio.A, Brain.male.ratio.A,
                                             Liver.female.ratio.A, Liver.male.ratio.A,
                                             Kidney.female.ratio.A, Kidney.male.ratio.A,
                                             Heart.female.ratio.A, Heart.male.ratio.A,
                                             Gonads.female.ratio.A, Gonads.male.ratio.A
                                             ),
                                     "X" = c(Brain.female.ratio.X, Brain.male.ratio.X,
                                             Liver.female.ratio.X, Liver.male.ratio.X,
                                             Kidney.female.ratio.X, Kidney.male.ratio.X,
                                             Heart.female.ratio.X, Heart.male.ratio.X,
                                             Gonads.female.ratio.X, Gonads.male.ratio.X)
                                     )

#Compute proportion of active genes
#-----------------------------
Brain.male.active.ratio.A <- gene.n[1,1]/(gene.n[2,1] + gene.n[1,1])
Brain.male.active.ratio.X <- gene.n[3,1]/(gene.n[4,1] + gene.n[3,1])
Brain.female.active.ratio.A <- gene.n[5,1]/(gene.n[6,1] + gene.n[5,1])
Brain.female.active.ratio.X <- gene.n[7,1]/(gene.n[8,1] + gene.n[7,1])

Liver.male.active.ratio.A <- gene.n[9,1]/(gene.n[10,1] + gene.n[9,1])
Liver.male.active.ratio.X <- gene.n[11,1]/(gene.n[12,1] + gene.n[11,1])
Liver.female.active.ratio.A <- gene.n[13,1]/(gene.n[14,1] + gene.n[13,1])
Liver.female.active.ratio.X <- gene.n[15,1]/(gene.n[16,1] + gene.n[15,1])

Kidney.male.active.ratio.A <- gene.n[17,1]/(gene.n[18,1] + gene.n[17,1])
Kidney.male.active.ratio.X <- gene.n[19,1]/(gene.n[20,1] + gene.n[19,1])
Kidney.female.active.ratio.A <- gene.n[21,1]/(gene.n[22,1] + gene.n[21,1])
Kidney.female.active.ratio.X <- gene.n[23,1]/(gene.n[24,1] +gene.n[23,1])

Heart.male.active.ratio.A <- gene.n[25,1]/(gene.n[26,1] + gene.n[25,1])
Heart.male.active.ratio.X <- gene.n[27,1]/(gene.n[28,1] + gene.n[27,1])
Heart.female.active.ratio.A <- gene.n[29,1]/(gene.n[30,1] + gene.n[29,1])
Heart.female.active.ratio.X <- gene.n[31,1]/(gene.n[32,1] + gene.n[31,1])

Gonads.male.active.ratio.A <- gene.n[33,1]/(gene.n[34,1] + gene.n[33,1])
Gonads.male.active.ratio.X <- gene.n[35,1]/(gene.n[36,1] + gene.n[35,1])
Gonads.female.active.ratio.A <- gene.n[37,1]/(gene.n[38,1] + gene.n[37,1])
Gonads.female.active.ratio.X <- gene.n[39,1]/(gene.n[40,1] + gene.n[39,1])

active.ratio <- data.frame("name" = c("Brain.female", "Brain.male",
                                      "Liver.female", "Liver.male",
                                      "Kidney.female", "Kidney.male",
                                      "Heart.female", "Heart.male",
                                      "Gonads.female", "Gonads.male"),
                           "A" = c(Brain.female.active.ratio.A, Brain.male.active.ratio.A,
                                   Liver.female.active.ratio.A, Liver.male.active.ratio.A,
                                   Kidney.female.active.ratio.A, Kidney.male.active.ratio.A,
                                   Heart.female.active.ratio.A, Heart.male.active.ratio.A,
                                   Gonads.female.active.ratio.A, Gonads.male.active.ratio.A
                                  ),
                           "X" = c(Brain.female.active.ratio.X, Brain.male.active.ratio.X,
                                   Liver.female.active.ratio.X, Liver.male.active.ratio.X,
                                   Kidney.female.active.ratio.X, Kidney.male.active.ratio.X,
                                   Heart.female.active.ratio.X, Heart.male.active.ratio.X,
                                   Gonads.female.active.ratio.X, Gonads.male.active.ratio.X))

active.ratio <- active.ratio %>% separate(name, c("Tissue", "Sex"), "\\.")
active.ratio.m <- gather(active.ratio, chr.type, prop, -Tissue, -Sex)

Paired <- brewer.pal(12, "Paired")

setwd("~/Dropbox/Anolis_paper/Figures/")
cairo_pdf("prop_active_genes.pdf", family = "Arial", height = 8.86, width = 13.28)
ggplot(data = active.ratio.m, aes(x = Tissue, y = prop)) +
  geom_bar(stat = "identity", position = "dodge", aes(fill = interaction(chr.type, Sex))) +
  theme_classic() +
  ggtitle("Proportion of active genes (FPKM > 1)") +
  theme(plot.title = element_text(size = 20, face = "bold", hjust = 0.5),
        axis.ticks.x = element_blank(),
        axis.title.x = element_blank(),
        axis.text.x = element_text(face = "bold", size = 15),
        axis.text.y = element_text(face = "bold", size = 15),
        axis.title.y = element_blank(),
        axis.line.x = element_blank(),
        legend.title=element_blank(),
        legend.text=element_text(face = "bold", size = 10),
        panel.grid.major.y = element_line(colour = "grey87")) +
  scale_fill_manual(values = c(Paired[5], Paired[6], Paired[1], Paired[2])) +
  ylim(c(0,1))
dev.off()
##############################################################################################################################

