path="/Users/agkaessmann/Projects/Anolis/Documentation_dosage_compensation"
source(paste0(path, "/Scripts_R/functions.r"))

load(file=paste0(path, "/one2one.6sp.no.xenopus.Rdata"))
load(file=paste0(path, "/Rdata/final.expression.tables.7species.v5.Rdata"))

##############################################################################
# Merge expression data for one2one orthologs and collapsed expression
##############################################################################

human.tmp = human.7sp[as.vector(one2one.6sp.no.xenopus[,"human"]), -((length(colnames(human.7sp))-1):length(colnames(human.7sp)))]
colnames(human.tmp) = paste0("human.", colnames(human.tmp))
head(human.tmp)
mouse.tmp = mouse.7sp[as.vector(one2one.6sp.no.xenopus[,"mouse"]), -((length(colnames(mouse.7sp))-1):length(colnames(mouse.7sp)))]
colnames(mouse.tmp) = paste0("mouse.", colnames(mouse.tmp))
head(mouse.tmp)
opossum.tmp = opossum.7sp[as.vector(one2one.6sp.no.xenopus[,"opossum"]), -((length(colnames(opossum.7sp))-1):length(colnames(opossum.7sp)))]
colnames(opossum.tmp) = paste0("opossum.", colnames(opossum.tmp))
head(opossum.tmp)
platypus.tmp = platypus.7sp[as.vector(one2one.6sp.no.xenopus[,"platypus"]), -((length(colnames(platypus.7sp))-1):length(colnames(platypus.7sp)))]
colnames(platypus.tmp) = paste0("platypus.", colnames(platypus.tmp))
head(platypus.tmp)
chicken.tmp = chicken.7sp[as.vector(one2one.6sp.no.xenopus[,"chicken"]), -((length(colnames(chicken.7sp))-1):length(colnames(chicken.7sp)))]
colnames(chicken.tmp) = paste0("chicken.", colnames(chicken.tmp))
head(chicken.tmp)
lizard.tmp = lizard.7sp[as.vector(one2one.6sp.no.xenopus[,"lizard"]), -((length(colnames(lizard.7sp))-1):length(colnames(lizard.7sp)))]
colnames(lizard.tmp) = paste0("lizard.", colnames(lizard.tmp))
head(lizard.tmp)
lizard.dev.tmp = lizard.dev.7sp[as.vector(one2one.6sp.no.xenopus[,"lizard"]), -((length(colnames(lizard.dev.7sp))-1):length(colnames(lizard.dev.7sp)))]
colnames(lizard.dev.tmp) = paste0("lizard.", colnames(lizard.dev.tmp))
head(lizard.dev.tmp)

EM_one2one.6sp.no.xenopus.collapsed = cbind(human.tmp,
                                            mouse.tmp, 
                                            opossum.tmp, 
                                            platypus.tmp,
                                            chicken.tmp,
                                            lizard.tmp, 
                                            lizard.dev.tmp, 
                                            deparse.level=2)

EM_one2one.6sp.no.xenopus.collapsed["gene"] = rownames(one2one.6sp.no.xenopus)
rownames(EM_one2one.6sp.no.xenopus.collapsed) = rownames(one2one.6sp.no.xenopus)
head(EM_one2one.6sp.no.xenopus.collapsed)
colnames(EM_one2one.6sp.no.xenopus.collapsed)

save(EM_one2one.6sp.no.xenopus.collapsed, file=paste0(path, "/EM_one2one.6sp.no.xenopus.collapsed.Rdata"))
