/*
 * Decompiled with CFR 0.152.
 */
package jaligner.ui.filechooser;

import jaligner.ui.filechooser.FileChooser;
import jaligner.ui.filechooser.FileChooserException;
import jaligner.ui.filechooser.NamedInputStream;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;

public class FileChooserJNLP
extends FileChooser {
    private static final Logger logger = Logger.getLogger(FileChooserJNLP.class.getName());

    @Override
    public NamedInputStream open() throws FileChooserException {
        try {
            FileOpenService fos = (FileOpenService)ServiceManager.lookup((String)FileOpenService.class.getName());
            FileContents fc = null;
            fc = fos.openFileDialog(this.getUserDirectory(), null);
            if (fc != null) {
                logger.info("Loaded: " + fc.getName());
                return new NamedInputStream(fc.getName(), fc.getInputStream());
            }
            return null;
        }
        catch (Exception e) {
            String message = "Failed open: " + e.getMessage();
            logger.warning(message);
            throw new FileChooserException(message);
        }
    }

    @Override
    public boolean save(InputStream is, String fileName) throws FileChooserException {
        try {
            FileSaveService fss = (FileSaveService)ServiceManager.lookup((String)FileSaveService.class.getName());
            FileContents fc = fss.saveFileDialog(this.getUserDirectory(), null, is, fileName);
            if (fc != null) {
                logger.info("Saved: " + fc.getName());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            String message = "Failed save: " + e.getMessage();
            logger.warning(message);
            throw new FileChooserException(message);
        }
    }
}

