/*
 * Decompiled with CFR 0.152.
 */
package jaligner.ui.clipboard;

import jaligner.ui.clipboard.ClipboardHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ClipboardService;
import javax.jnlp.ServiceManager;

public class ClipboardHandlerJNLP
implements ClipboardHandler {
    private static Logger logger = Logger.getLogger(ClipboardHandlerJNLP.class.getName());

    @Override
    public String getContents() {
        String contents = null;
        try {
            ClipboardService cs = (ClipboardService)ServiceManager.lookup((String)ClipboardService.class.getName());
            Transferable data = cs.getContents();
            if (data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                contents = (String)data.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting the clipboard contents: " + e.getMessage(), e);
        }
        return contents;
    }

    @Override
    public void setContents(String s) {
        try {
            ClipboardService cs = (ClipboardService)ServiceManager.lookup((String)ClipboardService.class.getName());
            cs.setContents((Transferable)new StringSelection(s));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed setting the clipboard contents: " + e.getMessage(), e);
        }
    }
}

