/*
 * Decompiled with CFR 0.152.
 */
package jaligner.ui;

import jaligner.Alignment;
import jaligner.Sequence;
import jaligner.SmithWatermanGotoh;
import jaligner.example.SmithWatermanGotohExample;
import jaligner.formats.CLUSTAL;
import jaligner.formats.FASTA;
import jaligner.formats.FormatFactory;
import jaligner.formats.Pair;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixLoader;
import jaligner.ui.clipboard.ClipboardListener;
import jaligner.ui.clipboard.ClipboardPoller;
import jaligner.ui.filechooser.FileChooserFactory;
import jaligner.ui.filechooser.NamedInputStream;
import jaligner.ui.images.ToolbarIcons;
import jaligner.ui.logging.DocumentHandler;
import jaligner.ui.util.TextComponentUtil;
import jaligner.ui.util.TextComponentUtilException;
import jaligner.util.Commons;
import jaligner.util.SequenceParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class AlignWindow
extends JFrame
implements ClipboardListener,
DocumentListener {
    private static final long serialVersionUID = 3257844376876364850L;
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 600;
    private static final float DEFAULT_OPEN_GAP_PENALTY = 10.0f;
    private static final float DEFAULT_EXTEND_GAP_PENALTY = 0.5f;
    private static final String DEFAULT_SCORING_MATRIX = "BLOSUM62";
    private static final Logger logger = Logger.getLogger(AlignWindow.class.getName());
    private ClipboardPoller clipboardPoller = null;
    private HashMap<String, Matrix> matrices = new HashMap();
    private JTextComponent currentTextComponent = null;
    public Action nextFocusAction = new AbstractAction("Move Focus Forwards"){
        private static final long serialVersionUID = 3763091972940183858L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocus();
        }
    };
    public Action prevFocusAction = new AbstractAction("Move Focus Backwards"){
        private static final long serialVersionUID = 3257844402628997943L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocusBackward();
        }
    };
    private ButtonGroup buttonGroupSequences;
    private JButton jButtonCopy;
    private JButton jButtonCut;
    private JButton jButtonDelete;
    private JButton jButtonExit;
    private JButton jButtonGo;
    private JButton jButtonOpen;
    private JButton jButtonPaste;
    private JButton jButtonPrint;
    private JButton jButtonSave;
    private JComboBox jComboBoxOutputFormat;
    private JComboBox jComboBoxScoringMatrix;
    private JFormattedTextField jFormattedTextFieldGapExtend;
    private JFormattedTextField jFormattedTextFieldGapOpen;
    private JLabel jLabelExtendGapPenalty;
    private JLabel jLabelOpenGapPenalty;
    private JLabel jLabelOutputFormat;
    private JLabel jLabelScoringMatrix;
    private JMenuBar jMenuBar;
    private JMenu jMenuEdit;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemEditCopy;
    private JMenuItem jMenuItemEditCut;
    private JMenuItem jMenuItemEditDelete;
    private JMenuItem jMenuItemEditPaste;
    private JMenuItem jMenuItemEditSelectAll;
    private JMenuItem jMenuItemFileExit;
    private JMenuItem jMenuItemFileLoadMatrix;
    private JMenuItem jMenuItemFileLoadSequence1;
    private JMenuItem jMenuItemFileLoadSequence2;
    private JMenuItem jMenuItemFileOpen;
    private JMenuItem jMenuItemFilePrint;
    private JMenuItem jMenuItemToolsRunExample;
    private JMenu jMenuTools;
    private JPanel jPanelAlignment;
    private JPanel jPanelConsole;
    private JPanel jPanelControls;
    private JPanel jPanelGapExtend;
    private JPanel jPanelGapOpen;
    private JPanel jPanelGo;
    private JPanel jPanelOutputFormat;
    private JPanel jPanelScoringMatrix;
    private JPanel jPanelSequence1;
    private JPanel jPanelSequence2;
    private JPopupMenu jPopup;
    private JMenuItem jPopupCopy;
    private JMenuItem jPopupCut;
    private JMenuItem jPopupDelete;
    private JMenuItem jPopupOpen;
    private JMenuItem jPopupPaste;
    private JMenuItem jPopupPrint;
    private JMenuItem jPopupSave;
    private JMenuItem jPopupSelectAll;
    private JSeparator jPopupSeparator1;
    private JSeparator jPopupSeparator2;
    private JSeparator jPopupSeparator3;
    private JRadioButton jRadioButtonAlignment;
    private JRadioButton jRadioButtonConsole;
    private JRadioButton jRadioButtonSequence1;
    private JRadioButton jRadioButtonSequence2;
    private JScrollPane jScrollPaneAlignment;
    private JScrollPane jScrollPaneConsole;
    private JScrollPane jScrollPaneSequence1;
    private JScrollPane jScrollPaneSequence2;
    private JSeparator jSeparatorFile;
    private JSplitPane jSplitPaneBody;
    private JSplitPane jSplitPaneIO;
    private JSplitPane jSplitPaneSequences;
    private JTextArea jTextAreaAlignment;
    private JTextArea jTextAreaSequence1;
    private JTextArea jTextAreaSequence2;
    private JTextPane jTextPaneConsole;
    private JToolBar jToolBar;

    public AlignWindow() {
        this.initComponents();
        logger.addHandler(new DocumentHandler(this.jTextPaneConsole));
        try {
            URL url = this.getClass().getResource("/jaligner/ui/images/gifs/jaligner.gif");
            if (url != null) {
                Image image = Toolkit.getDefaultToolkit().getImage(url);
                this.setIconImage(image);
            } else {
                logger.warning("Image URL is NULL");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed setting the frame image: " + e.getMessage(), e);
        }
        this.jMenuItemFileOpen.setVisible(false);
        this.jFormattedTextFieldGapOpen.setValue(new Float(10.0f));
        this.jFormattedTextFieldGapExtend.setValue(new Float(0.5f));
        Collection<String> matrices = null;
        try {
            matrices = MatrixLoader.list(false);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting list of scoring matrices: " + e.getMessage(), e);
        }
        if (matrices != null) {
            this.populateComboBox(this.jComboBoxScoringMatrix, matrices, DEFAULT_SCORING_MATRIX);
        }
        FormatFactory.getInstance().registerFormat(new CLUSTAL());
        FormatFactory.getInstance().registerFormat(new Pair());
        FormatFactory.getInstance().registerFormat(new FASTA());
        Collection<String> formats = FormatFactory.getInstance().getFormats();
        String[] outputFormats = new String[formats.size()];
        Iterator<String> i = formats.iterator();
        int j = 0;
        while (i.hasNext()) {
            outputFormats[j] = i.next();
            ++j;
        }
        this.populateComboBox(this.jComboBoxOutputFormat, outputFormats, null);
        this.jTextAreaSequence1.getDocument().addDocumentListener(this);
        this.jTextAreaSequence2.getDocument().addDocumentListener(this);
        this.jTextAreaAlignment.getDocument().addDocumentListener(this);
        this.jTextAreaSequence1.getInputMap().put(KeyStroke.getKeyStroke("TAB"), this.nextFocusAction.getClass().getName());
        this.jTextAreaSequence1.getActionMap().put(this.nextFocusAction.getClass().getName(), this.nextFocusAction);
        this.jTextAreaSequence1.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), this.prevFocusAction.getClass().getName());
        this.jTextAreaSequence1.getActionMap().put(this.prevFocusAction.getClass().getName(), this.prevFocusAction);
        this.jTextAreaSequence2.getInputMap().put(KeyStroke.getKeyStroke("TAB"), this.nextFocusAction.getClass().getName());
        this.jTextAreaSequence2.getActionMap().put(this.nextFocusAction.getClass().getName(), this.nextFocusAction);
        this.jTextAreaSequence2.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), this.prevFocusAction.getClass().getName());
        this.jTextAreaSequence2.getActionMap().put(this.prevFocusAction.getClass().getName(), this.prevFocusAction);
        this.buttonGroupSequences.add(this.jRadioButtonSequence1);
        this.buttonGroupSequences.add(this.jRadioButtonSequence2);
        this.buttonGroupSequences.add(this.jRadioButtonAlignment);
        this.buttonGroupSequences.add(this.jRadioButtonConsole);
        this.jSplitPaneBody.setResizeWeight(0.9);
        this.jSplitPaneIO.setResizeWeight(0.5);
        this.jSplitPaneSequences.setResizeWeight(0.5);
        this.jTextAreaSequence1.requestFocus();
        this.clipboardPoller = new ClipboardPoller(this);
        this.clipboardPoller.start();
        this.jMenuItemFilePrint.setVisible(false);
        this.setSize(800, 600);
    }

    private void initComponents() {
        this.jPopup = new JPopupMenu();
        this.jPopupOpen = new JMenuItem();
        this.jPopupSave = new JMenuItem();
        this.jPopupSeparator1 = new JSeparator();
        this.jPopupCut = new JMenuItem();
        this.jPopupCopy = new JMenuItem();
        this.jPopupPaste = new JMenuItem();
        this.jPopupDelete = new JMenuItem();
        this.jPopupSeparator2 = new JSeparator();
        this.jPopupPrint = new JMenuItem();
        this.jPopupSeparator3 = new JSeparator();
        this.jPopupSelectAll = new JMenuItem();
        this.buttonGroupSequences = new ButtonGroup();
        this.jToolBar = new JToolBar();
        this.jButtonOpen = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonCut = new JButton();
        this.jButtonCopy = new JButton();
        this.jButtonPaste = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonPrint = new JButton();
        this.jButtonExit = new JButton();
        this.jSplitPaneBody = new JSplitPane();
        this.jSplitPaneIO = new JSplitPane();
        this.jSplitPaneSequences = new JSplitPane();
        this.jPanelSequence1 = new JPanel();
        this.jScrollPaneSequence1 = new JScrollPane();
        this.jTextAreaSequence1 = new JTextArea();
        this.jRadioButtonSequence1 = new JRadioButton();
        this.jPanelSequence2 = new JPanel();
        this.jScrollPaneSequence2 = new JScrollPane();
        this.jTextAreaSequence2 = new JTextArea();
        this.jRadioButtonSequence2 = new JRadioButton();
        this.jPanelAlignment = new JPanel();
        this.jRadioButtonAlignment = new JRadioButton();
        this.jScrollPaneAlignment = new JScrollPane();
        this.jTextAreaAlignment = new JTextArea();
        this.jPanelConsole = new JPanel();
        this.jRadioButtonConsole = new JRadioButton();
        this.jScrollPaneConsole = new JScrollPane();
        this.jTextPaneConsole = new JTextPane();
        this.jPanelControls = new JPanel();
        this.jPanelScoringMatrix = new JPanel();
        this.jLabelScoringMatrix = new JLabel();
        this.jComboBoxScoringMatrix = new JComboBox();
        this.jPanelGapOpen = new JPanel();
        this.jLabelOpenGapPenalty = new JLabel();
        this.jFormattedTextFieldGapOpen = new JFormattedTextField(new DecimalFormat("##0.0##"));
        this.jPanelGapExtend = new JPanel();
        this.jLabelExtendGapPenalty = new JLabel();
        this.jFormattedTextFieldGapExtend = new JFormattedTextField(new DecimalFormat("##0.0##"));
        this.jPanelOutputFormat = new JPanel();
        this.jLabelOutputFormat = new JLabel();
        this.jComboBoxOutputFormat = new JComboBox();
        this.jPanelGo = new JPanel();
        this.jButtonGo = new JButton();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemFileOpen = new JMenuItem();
        this.jMenuItemFileLoadSequence1 = new JMenuItem();
        this.jMenuItemFileLoadSequence2 = new JMenuItem();
        this.jMenuItemFileLoadMatrix = new JMenuItem();
        this.jSeparatorFile = new JSeparator();
        this.jMenuItemFileExit = new JMenuItem();
        this.jMenuItemFilePrint = new JMenuItem();
        this.jMenuEdit = new JMenu();
        this.jMenuItemEditCut = new JMenuItem();
        this.jMenuItemEditCopy = new JMenuItem();
        this.jMenuItemEditPaste = new JMenuItem();
        this.jMenuItemEditDelete = new JMenuItem();
        this.jMenuItemEditSelectAll = new JMenuItem();
        this.jMenuTools = new JMenu();
        this.jMenuItemToolsRunExample = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemAbout = new JMenuItem();
        this.jPopupOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jPopupOpen.setIcon(ToolbarIcons.OPEN);
        this.jPopupOpen.setMnemonic('O');
        this.jPopupOpen.setText("Open...");
        this.jPopupOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupOpenActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupOpen);
        this.jPopupSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jPopupSave.setIcon(ToolbarIcons.SAVE);
        this.jPopupSave.setMnemonic('S');
        this.jPopupSave.setText("Save...");
        this.jPopupSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupSaveActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupSave);
        this.jPopup.add(this.jPopupSeparator1);
        this.jPopupCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jPopupCut.setIcon(ToolbarIcons.CUT);
        this.jPopupCut.setMnemonic('t');
        this.jPopupCut.setText("Cut");
        this.jPopupCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupCutActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupCut);
        this.jPopupCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jPopupCopy.setIcon(ToolbarIcons.COPY);
        this.jPopupCopy.setMnemonic('C');
        this.jPopupCopy.setText("Copy");
        this.jPopupCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupCopyActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupCopy);
        this.jPopupPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jPopupPaste.setIcon(ToolbarIcons.PASTE);
        this.jPopupPaste.setMnemonic('P');
        this.jPopupPaste.setText("Paste");
        this.jPopupPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupPasteActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupPaste);
        this.jPopupDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.jPopupDelete.setIcon(ToolbarIcons.DELETE);
        this.jPopupDelete.setMnemonic('D');
        this.jPopupDelete.setText("Delete");
        this.jPopupDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupDeleteActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupDelete);
        this.jPopup.add(this.jPopupSeparator2);
        this.jPopupPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jPopupPrint.setIcon(ToolbarIcons.PRINT);
        this.jPopupPrint.setMnemonic('D');
        this.jPopupPrint.setText("Print");
        this.jPopupPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupPrintActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupPrint);
        this.jPopup.add(this.jPopupSeparator3);
        this.jPopupSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jPopupSelectAll.setMnemonic('A');
        this.jPopupSelectAll.setText("Select All");
        this.jPopupSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jPopupSelectAllActionPerformed(evt);
            }
        });
        this.jPopup.add(this.jPopupSelectAll);
        this.setDefaultCloseOperation(0);
        this.setTitle("JAligner - biological pairwise sequence alignment <http://jaligner.sf.net>");
        this.setName("AlignWindow");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AlignWindow.this.exitForm(evt);
            }
        });
        this.jButtonOpen.setIcon(ToolbarIcons.OPEN);
        this.jButtonOpen.setToolTipText("Open...");
        this.jButtonOpen.setFocusable(false);
        this.jButtonOpen.setPreferredSize(new Dimension(24, 24));
        this.jButtonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonOpenActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonOpen);
        this.jButtonSave.setIcon(ToolbarIcons.SAVE);
        this.jButtonSave.setToolTipText("Save...");
        this.jButtonSave.setFocusable(false);
        this.jButtonSave.setPreferredSize(new Dimension(24, 24));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonSave);
        this.jButtonCut.setIcon(ToolbarIcons.CUT);
        this.jButtonCut.setToolTipText("Cut");
        this.jButtonCut.setFocusable(false);
        this.jButtonCut.setPreferredSize(new Dimension(24, 24));
        this.jButtonCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonCutActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonCut);
        this.jButtonCopy.setIcon(ToolbarIcons.COPY);
        this.jButtonCopy.setToolTipText("Copy");
        this.jButtonCopy.setFocusable(false);
        this.jButtonCopy.setPreferredSize(new Dimension(24, 24));
        this.jButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonCopyActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonCopy);
        this.jButtonPaste.setIcon(ToolbarIcons.PASTE);
        this.jButtonPaste.setToolTipText("Paste");
        this.jButtonPaste.setFocusable(false);
        this.jButtonPaste.setPreferredSize(new Dimension(24, 24));
        this.jButtonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonPasteActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonPaste);
        this.jButtonDelete.setIcon(ToolbarIcons.DELETE);
        this.jButtonDelete.setToolTipText("Delete");
        this.jButtonDelete.setFocusable(false);
        this.jButtonDelete.setPreferredSize(new Dimension(24, 24));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonDelete);
        this.jButtonPrint.setIcon(ToolbarIcons.PRINT);
        this.jButtonPrint.setToolTipText("Print");
        this.jButtonPrint.setFocusable(false);
        this.jButtonPrint.setPreferredSize(new Dimension(24, 24));
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonPrint);
        this.jButtonExit.setIcon(ToolbarIcons.CLOSE);
        this.jButtonExit.setToolTipText("Exit");
        this.jButtonExit.setFocusable(false);
        this.jButtonExit.setPreferredSize(new Dimension(24, 24));
        this.jButtonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonExitActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jButtonExit);
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.jSplitPaneBody.setOrientation(0);
        this.jSplitPaneBody.setOneTouchExpandable(true);
        this.jSplitPaneIO.setOneTouchExpandable(true);
        this.jSplitPaneSequences.setOrientation(0);
        this.jSplitPaneSequences.setOneTouchExpandable(true);
        this.jPanelSequence1.setLayout(new BorderLayout());
        this.jScrollPaneSequence1.setPreferredSize(new Dimension(400, 50));
        this.jTextAreaSequence1.setFont(new Font("Courier", 0, 12));
        this.jTextAreaSequence1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlignWindow.this.jTextAreaSequence1MouseClicked(evt);
            }
        });
        this.jTextAreaSequence1.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                AlignWindow.this.jTextAreaSequence1CaretUpdate(evt);
            }
        });
        this.jTextAreaSequence1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AlignWindow.this.jTextAreaSequence1FocusGained(evt);
            }
        });
        this.jScrollPaneSequence1.setViewportView(this.jTextAreaSequence1);
        this.jPanelSequence1.add((Component)this.jScrollPaneSequence1, "Center");
        this.jRadioButtonSequence1.setMnemonic('1');
        this.jRadioButtonSequence1.setText("Sequence #1");
        this.jRadioButtonSequence1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jRadioButtonSequence1ActionPerformed(evt);
            }
        });
        this.jPanelSequence1.add((Component)this.jRadioButtonSequence1, "North");
        this.jSplitPaneSequences.setTopComponent(this.jPanelSequence1);
        this.jPanelSequence2.setLayout(new BorderLayout());
        this.jScrollPaneSequence2.setPreferredSize(new Dimension(400, 50));
        this.jTextAreaSequence2.setFont(new Font("Courier", 0, 12));
        this.jTextAreaSequence2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlignWindow.this.jTextAreaSequence2MouseClicked(evt);
            }
        });
        this.jTextAreaSequence2.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                AlignWindow.this.jTextAreaSequence2CaretUpdate(evt);
            }
        });
        this.jTextAreaSequence2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AlignWindow.this.jTextAreaSequence2FocusGained(evt);
            }
        });
        this.jScrollPaneSequence2.setViewportView(this.jTextAreaSequence2);
        this.jPanelSequence2.add((Component)this.jScrollPaneSequence2, "Center");
        this.jRadioButtonSequence2.setMnemonic('2');
        this.jRadioButtonSequence2.setText("Sequence #2");
        this.jRadioButtonSequence2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jRadioButtonSequence2ActionPerformed(evt);
            }
        });
        this.jPanelSequence2.add((Component)this.jRadioButtonSequence2, "North");
        this.jSplitPaneSequences.setBottomComponent(this.jPanelSequence2);
        this.jSplitPaneIO.setLeftComponent(this.jSplitPaneSequences);
        this.jPanelAlignment.setLayout(new BorderLayout());
        this.jRadioButtonAlignment.setMnemonic('A');
        this.jRadioButtonAlignment.setText("Alignment");
        this.jRadioButtonAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jRadioButtonAlignmentActionPerformed(evt);
            }
        });
        this.jPanelAlignment.add((Component)this.jRadioButtonAlignment, "North");
        this.jScrollPaneAlignment.setPreferredSize(new Dimension(400, 50));
        this.jTextAreaAlignment.setEditable(false);
        this.jTextAreaAlignment.setFont(new Font("Courier", 0, 12));
        this.jTextAreaAlignment.setTabSize(0);
        this.jTextAreaAlignment.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlignWindow.this.jTextAreaAlignmentMouseClicked(evt);
            }
        });
        this.jTextAreaAlignment.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                AlignWindow.this.jTextAreaAlignmentCaretUpdate(evt);
            }
        });
        this.jTextAreaAlignment.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AlignWindow.this.jTextAreaAlignmentFocusGained(evt);
            }
        });
        this.jScrollPaneAlignment.setViewportView(this.jTextAreaAlignment);
        this.jPanelAlignment.add((Component)this.jScrollPaneAlignment, "Center");
        this.jSplitPaneIO.setRightComponent(this.jPanelAlignment);
        this.jSplitPaneBody.setTopComponent(this.jSplitPaneIO);
        this.jPanelConsole.setLayout(new BorderLayout());
        this.jRadioButtonConsole.setMnemonic('C');
        this.jRadioButtonConsole.setText("Console");
        this.jRadioButtonConsole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jRadioButtonConsoleActionPerformed(evt);
            }
        });
        this.jPanelConsole.add((Component)this.jRadioButtonConsole, "North");
        this.jScrollPaneConsole.setPreferredSize(new Dimension(400, 50));
        this.jTextPaneConsole.setEditable(false);
        this.jTextPaneConsole.setFont(new Font("Courier", 0, 12));
        this.jTextPaneConsole.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlignWindow.this.jTextPaneConsoleMouseClicked(evt);
            }
        });
        this.jTextPaneConsole.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                AlignWindow.this.jTextPaneConsoleCaretUpdate(evt);
            }
        });
        this.jTextPaneConsole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AlignWindow.this.jTextPaneConsoleFocusGained(evt);
            }
        });
        this.jScrollPaneConsole.setViewportView(this.jTextPaneConsole);
        this.jPanelConsole.add((Component)this.jScrollPaneConsole, "Center");
        this.jSplitPaneBody.setBottomComponent(this.jPanelConsole);
        this.getContentPane().add((Component)this.jSplitPaneBody, "Center");
        this.jPanelControls.setAutoscrolls(true);
        this.jPanelControls.setLayout(new GridLayout(1, 0));
        this.jLabelScoringMatrix.setDisplayedMnemonic('M');
        this.jLabelScoringMatrix.setHorizontalAlignment(0);
        this.jLabelScoringMatrix.setLabelFor(this.jComboBoxScoringMatrix);
        this.jLabelScoringMatrix.setText("Matrix");
        this.jPanelScoringMatrix.add(this.jLabelScoringMatrix);
        this.jComboBoxScoringMatrix.setToolTipText("Scoring matrix");
        this.jComboBoxScoringMatrix.setPrototypeDisplayValue("BLOSUMXXX");
        this.jPanelScoringMatrix.add(this.jComboBoxScoringMatrix);
        this.jPanelControls.add(this.jPanelScoringMatrix);
        this.jLabelOpenGapPenalty.setDisplayedMnemonic('O');
        this.jLabelOpenGapPenalty.setHorizontalAlignment(0);
        this.jLabelOpenGapPenalty.setLabelFor(this.jFormattedTextFieldGapOpen);
        this.jLabelOpenGapPenalty.setText("Open");
        this.jPanelGapOpen.add(this.jLabelOpenGapPenalty);
        this.jFormattedTextFieldGapOpen.setColumns(3);
        this.jFormattedTextFieldGapOpen.setToolTipText("Gap open penalty");
        this.jPanelGapOpen.add(this.jFormattedTextFieldGapOpen);
        this.jPanelControls.add(this.jPanelGapOpen);
        this.jLabelExtendGapPenalty.setDisplayedMnemonic('E');
        this.jLabelExtendGapPenalty.setHorizontalAlignment(0);
        this.jLabelExtendGapPenalty.setLabelFor(this.jFormattedTextFieldGapExtend);
        this.jLabelExtendGapPenalty.setText("Extend");
        this.jPanelGapExtend.add(this.jLabelExtendGapPenalty);
        this.jFormattedTextFieldGapExtend.setColumns(3);
        this.jFormattedTextFieldGapExtend.setToolTipText("Gap extend penalty");
        this.jPanelGapExtend.add(this.jFormattedTextFieldGapExtend);
        this.jPanelControls.add(this.jPanelGapExtend);
        this.jLabelOutputFormat.setDisplayedMnemonic('F');
        this.jLabelOutputFormat.setLabelFor(this.jComboBoxOutputFormat);
        this.jLabelOutputFormat.setText("Format");
        this.jPanelOutputFormat.add(this.jLabelOutputFormat);
        this.jComboBoxOutputFormat.setToolTipText("Alignment output format");
        this.jPanelOutputFormat.add(this.jComboBoxOutputFormat);
        this.jPanelControls.add(this.jPanelOutputFormat);
        this.jButtonGo.setMnemonic('G');
        this.jButtonGo.setText("Go");
        this.jButtonGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jButtonGoActionPerformed(evt);
            }
        });
        this.jPanelGo.add(this.jButtonGo);
        this.jPanelControls.add(this.jPanelGo);
        this.getContentPane().add((Component)this.jPanelControls, "South");
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMenuItemFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemFileOpen.setIcon(ToolbarIcons.OPEN);
        this.jMenuItemFileOpen.setMnemonic('O');
        this.jMenuItemFileOpen.setText("Open...");
        this.jMenuItemFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemFileOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFileOpen);
        this.jMenuItemFileLoadSequence1.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        this.jMenuItemFileLoadSequence1.setIcon(ToolbarIcons.OPEN);
        this.jMenuItemFileLoadSequence1.setMnemonic('1');
        this.jMenuItemFileLoadSequence1.setText("Load sequence #1...");
        this.jMenuItemFileLoadSequence1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemFileLoadSequence1ActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFileLoadSequence1);
        this.jMenuItemFileLoadSequence2.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        this.jMenuItemFileLoadSequence2.setIcon(ToolbarIcons.OPEN);
        this.jMenuItemFileLoadSequence2.setMnemonic('2');
        this.jMenuItemFileLoadSequence2.setText("Load sequence #2...");
        this.jMenuItemFileLoadSequence2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemFileLoadSequence2ActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFileLoadSequence2);
        this.jMenuItemFileLoadMatrix.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jMenuItemFileLoadMatrix.setIcon(ToolbarIcons.OPEN);
        this.jMenuItemFileLoadMatrix.setMnemonic('M');
        this.jMenuItemFileLoadMatrix.setText("Load scoring matrix...");
        this.jMenuItemFileLoadMatrix.setToolTipText("Load user-defined scoring matrix from file system");
        this.jMenuItemFileLoadMatrix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemFileLoadMatrixActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFileLoadMatrix);
        this.jMenuFile.add(this.jSeparatorFile);
        this.jMenuItemFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.jMenuItemFileExit.setIcon(ToolbarIcons.CLOSE);
        this.jMenuItemFileExit.setMnemonic('X');
        this.jMenuItemFileExit.setText("Exit");
        this.jMenuItemFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemFileExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFileExit);
        this.jMenuItemFilePrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jMenuItemFilePrint.setIcon(ToolbarIcons.PRINT);
        this.jMenuItemFilePrint.setText("Print...");
        this.jMenuItemFilePrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemFilePrintActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFilePrint);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuEdit.setMnemonic('E');
        this.jMenuEdit.setText("Edit");
        this.jMenuItemEditCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItemEditCut.setIcon(ToolbarIcons.CUT);
        this.jMenuItemEditCut.setMnemonic('t');
        this.jMenuItemEditCut.setText("Cut");
        this.jMenuItemEditCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemEditCutActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemEditCut);
        this.jMenuItemEditCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItemEditCopy.setIcon(ToolbarIcons.COPY);
        this.jMenuItemEditCopy.setMnemonic('C');
        this.jMenuItemEditCopy.setText("Copy");
        this.jMenuItemEditCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemEditCopyActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemEditCopy);
        this.jMenuItemEditPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItemEditPaste.setIcon(ToolbarIcons.PASTE);
        this.jMenuItemEditPaste.setMnemonic('P');
        this.jMenuItemEditPaste.setText("Paste");
        this.jMenuItemEditPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemEditPasteActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemEditPaste);
        this.jMenuItemEditDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.jMenuItemEditDelete.setIcon(ToolbarIcons.DELETE);
        this.jMenuItemEditDelete.setMnemonic('D');
        this.jMenuItemEditDelete.setText("Delete");
        this.jMenuItemEditDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemEditDeleteActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemEditDelete);
        this.jMenuItemEditSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMenuItemEditSelectAll.setMnemonic('A');
        this.jMenuItemEditSelectAll.setText("Select All");
        this.jMenuItemEditSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemEditSelectAllActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemEditSelectAll);
        this.jMenuBar.add(this.jMenuEdit);
        this.jMenuTools.setMnemonic('T');
        this.jMenuTools.setText("Tools");
        this.jMenuItemToolsRunExample.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.jMenuItemToolsRunExample.setMnemonic('E');
        this.jMenuItemToolsRunExample.setText("Example");
        this.jMenuItemToolsRunExample.setToolTipText("Aligns P53 human and P53 mouse");
        this.jMenuItemToolsRunExample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemToolsRunExampleActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemToolsRunExample);
        this.jMenuBar.add(this.jMenuTools);
        this.jMenuHelp.setMnemonic('H');
        this.jMenuHelp.setText("Help");
        this.jMenuItemAbout.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jMenuItemAbout.setIcon(ToolbarIcons.ABOUT);
        this.jMenuItemAbout.setMnemonic('A');
        this.jMenuItemAbout.setText("About...");
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignWindow.this.jMenuItemAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemAbout);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void jPopupPrintActionPerformed(ActionEvent evt) {
        this.print();
    }

    private void jMenuItemToolsRunExampleActionPerformed(ActionEvent evt) {
        try {
            logger.info("Running the example...");
            this.jTextAreaSequence1.setText(SmithWatermanGotohExample.loadP53Human());
            this.jTextAreaSequence2.setText(SmithWatermanGotohExample.loadP53Mouse());
            this.align();
            this.jTextAreaAlignment.requestFocus();
            logger.info("Finished running the example...");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed running the example: " + e.getMessage(), e);
        }
    }

    private void jMenuItemFilePrintActionPerformed(ActionEvent evt) {
        this.print();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        this.print();
    }

    private void jTextPaneConsoleCaretUpdate(CaretEvent evt) {
        this.handleCaretUpdateEvent(evt);
    }

    private void jTextPaneConsoleMouseClicked(MouseEvent evt) {
        this.jTextPaneConsole.requestFocus();
        if (evt.getButton() == 3) {
            this.jPopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextPaneConsoleFocusGained(FocusEvent evt) {
        this.currentTextComponent = this.jTextPaneConsole;
        this.jRadioButtonConsole.setSelected(true);
        this.handleMoveToTextComponent();
    }

    private void jRadioButtonConsoleActionPerformed(ActionEvent evt) {
        this.jTextPaneConsole.requestFocus();
    }

    private void jTextAreaAlignmentFocusGained(FocusEvent evt) {
        this.currentTextComponent = this.jTextAreaAlignment;
        this.jRadioButtonAlignment.setSelected(true);
        this.handleMoveToTextComponent();
    }

    private void jTextAreaSequence2FocusGained(FocusEvent evt) {
        this.currentTextComponent = this.jTextAreaSequence2;
        this.jRadioButtonSequence2.setSelected(true);
        this.handleMoveToTextComponent();
    }

    private void jTextAreaSequence1FocusGained(FocusEvent evt) {
        this.currentTextComponent = this.jTextAreaSequence1;
        this.jRadioButtonSequence1.setSelected(true);
        this.handleMoveToTextComponent();
    }

    private void jRadioButtonAlignmentActionPerformed(ActionEvent evt) {
        this.jTextAreaAlignment.requestFocus();
    }

    private void jRadioButtonSequence2ActionPerformed(ActionEvent evt) {
        this.jTextAreaSequence2.requestFocus();
    }

    private void jRadioButtonSequence1ActionPerformed(ActionEvent evt) {
        this.jTextAreaSequence1.requestFocus();
    }

    private void jMenuItemEditCopyActionPerformed(ActionEvent evt) {
        this.copy();
    }

    private void jMenuItemEditDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void jMenuItemEditPasteActionPerformed(ActionEvent evt) {
        this.paste();
    }

    private void jMenuItemFileOpenActionPerformed(ActionEvent evt) {
        this.loadFileToTextArea("", this.currentTextComponent);
    }

    private void jMenuItemEditCutActionPerformed(ActionEvent evt) {
        this.cut();
    }

    private void jMenuItemEditSelectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }

    private void jTextAreaSequence2MouseClicked(MouseEvent evt) {
        this.jTextAreaSequence2.requestFocus();
        if (evt.getButton() == 3) {
            this.jPopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextAreaSequence2CaretUpdate(CaretEvent evt) {
        this.handleCaretUpdateEvent(evt);
    }

    private void jButtonExitActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void jButtonGoActionPerformed(ActionEvent evt) {
        this.align();
    }

    private void jMenuItemFileLoadSequence2ActionPerformed(ActionEvent evt) {
        this.loadFileToTextArea("sequence #2", this.jTextAreaSequence2);
    }

    private void jMenuItemFileLoadSequence1ActionPerformed(ActionEvent evt) {
        this.loadFileToTextArea("sequence #1", this.jTextAreaSequence1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemFileLoadMatrixActionPerformed(ActionEvent evt) {
        NamedInputStream selectedInputStream = null;
        try {
            logger.info("Loading scoring matrix...");
            selectedInputStream = FileChooserFactory.getFileChooser().open();
            if (selectedInputStream != null) {
                Matrix matrix = MatrixLoader.load(selectedInputStream);
                this.matrices.put(selectedInputStream.getName(), matrix);
                boolean found = false;
                int index = 0;
                int count = this.jComboBoxScoringMatrix.getItemCount();
                while (index < count && !found) {
                    if (((String)this.jComboBoxScoringMatrix.getItemAt(index)).equalsIgnoreCase(selectedInputStream.getName())) {
                        found = true;
                        continue;
                    }
                    ++index;
                }
                if (!found) {
                    this.jComboBoxScoringMatrix.addItem(selectedInputStream.getName());
                    index = this.jComboBoxScoringMatrix.getItemCount() - 1;
                }
                this.jComboBoxScoringMatrix.setSelectedIndex(index);
                logger.info("Finished loading scoring matrix");
            } else {
                logger.info("Canceled loading scoring matrix");
            }
        }
        catch (Exception e) {
            String message = "Failed loading scoring matrix: " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            this.showErrorMessage(message);
        }
        finally {
            if (selectedInputStream != null) {
                try {
                    selectedInputStream.getInputStream().close();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed closing input stream: " + e.getMessage(), e);
                }
            }
        }
    }

    private void jTextAreaAlignmentMouseClicked(MouseEvent evt) {
        this.jTextAreaAlignment.requestFocus();
        if (evt.getButton() == 3) {
            this.jPopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jPopupSaveActionPerformed(ActionEvent evt) {
        this.saveTextAreaToFile((JTextArea)this.jPopup.getInvoker());
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.saveTextAreaToFile(this.currentTextComponent);
    }

    private void jTextAreaAlignmentCaretUpdate(CaretEvent evt) {
        this.handleCaretUpdateEvent(evt);
    }

    private void jPopupOpenActionPerformed(ActionEvent evt) {
        this.loadFileToTextArea("", (JTextArea)this.jPopup.getInvoker());
    }

    private void jPopupSelectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }

    private void jPopupDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void jPopupPasteActionPerformed(ActionEvent evt) {
        this.paste();
    }

    private void jPopupCopyActionPerformed(ActionEvent evt) {
        this.copy();
    }

    private void jPopupCutActionPerformed(ActionEvent evt) {
        this.cut();
    }

    private void jTextAreaSequence1CaretUpdate(CaretEvent evt) {
        this.handleCaretUpdateEvent(evt);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void jButtonPasteActionPerformed(ActionEvent evt) {
        this.paste();
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        this.copy();
    }

    private void jButtonCutActionPerformed(ActionEvent evt) {
        this.cut();
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        this.loadFileToTextArea("", this.currentTextComponent);
    }

    private void jTextAreaSequence1MouseClicked(MouseEvent evt) {
        this.jTextAreaSequence1.requestFocus();
        if (evt.getButton() == 3) {
            this.jPopup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jMenuItemAboutActionPerformed(ActionEvent evt) {
        String message = "JAligner" + Commons.getLineSeparator() + Commons.getLineSeparator() + "open-source Java implementation" + Commons.getLineSeparator() + "of the Smith-Waterman algorithm" + Commons.getLineSeparator() + "for biological sequence alignment." + Commons.getLineSeparator() + Commons.getLineSeparator() + "Build: " + Commons.getCurrentRelease() + Commons.getLineSeparator() + Commons.getLineSeparator() + "By: Ahmed Moustafa" + Commons.getLineSeparator() + Commons.getLineSeparator() + "https://github.com/ahmedmoustafa/JAligner";
        JOptionPane.showMessageDialog(this, message, "About JAligner", 1);
    }

    private void jMenuItemFileExitActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void exitForm(WindowEvent evt) {
        logger.info("Quitting...");
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to exit JAligner?", "JAligner - confirmation", 0) == 0) {
            logger.info("Thank you for using JAligner!");
            System.exit(0);
        } else {
            logger.info("Canceled quitting");
            this.currentTextComponent.requestFocus();
        }
    }

    private void populateComboBox(JComboBox combobox, String[] items, String selected) {
        for (int i = 0; i < items.length; ++i) {
            combobox.addItem(items[i]);
            if (!items[i].equals(selected)) continue;
            combobox.setSelectedIndex(i);
        }
    }

    private void populateComboBox(JComboBox combobox, Collection<String> items, String selected) {
        Iterator<String> i = items.iterator();
        int index = 0;
        while (i.hasNext()) {
            String item = i.next();
            combobox.addItem(item);
            if (item.equals(selected)) {
                combobox.setSelectedIndex(index);
            }
            ++index;
        }
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "JAligner - error message", 0);
    }

    private void loadFileToTextArea(String id, JTextComponent textComponent) {
        logger.info("Loading " + id + "...");
        try {
            if (TextComponentUtil.open(textComponent)) {
                textComponent.requestFocus();
                textComponent.setCaretPosition(0);
                logger.info("Finished loading " + id);
            } else {
                logger.info("Canceled loading " + id);
            }
        }
        catch (Exception e) {
            String message = "Failed loading " + id + ": " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            this.showErrorMessage(message);
        }
    }

    private void saveTextAreaToFile(JTextComponent textComponent) {
        try {
            logger.info("Saving...");
            if (TextComponentUtil.save(textComponent)) {
                logger.info("Finished saving");
            } else {
                logger.info("Canceled saving");
            }
        }
        catch (Exception e) {
            String message = "Failed saving: " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            this.showErrorMessage(message);
        }
    }

    private void cut() {
        TextComponentUtil.cut(this.currentTextComponent);
    }

    private void copy() {
        TextComponentUtil.copy(this.currentTextComponent);
    }

    private void paste() {
        TextComponentUtil.paste(this.currentTextComponent);
    }

    private void delete() {
        TextComponentUtil.delete(this.currentTextComponent);
    }

    private void selectAll() {
        TextComponentUtil.selectAll(this.currentTextComponent);
    }

    private void print() {
        try {
            logger.info("Printing...");
            TextComponentUtil.print(this.currentTextComponent);
            logger.info("Finished printing.");
        }
        catch (TextComponentUtilException textComponentUtilException) {
            logger.log(Level.SEVERE, "Failed printing: " + textComponentUtilException.getMessage(), textComponentUtilException);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (e.getDocument() == this.currentTextComponent.getDocument()) {
            this.setSaveControlsEnabled(true);
            this.setSelectAllControlsEnabled(true);
            this.setPrintControlsEnabled(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument() == this.currentTextComponent.getDocument() && e.getDocument().getLength() == 0) {
            this.setSaveControlsEnabled(false);
            this.setSelectAllControlsEnabled(false);
            this.setPrintControlsEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void clipboardCheck(String clipboardContents) {
        this.setPasteControlsEnabled(clipboardContents != null && this.currentTextComponent != null && this.currentTextComponent.isEditable());
    }

    private void setOpenControlsEnabled(boolean enabled) {
        this.jMenuItemFileOpen.setEnabled(enabled);
        this.jButtonOpen.setEnabled(enabled);
        this.jPopupOpen.setEnabled(enabled);
    }

    private void setSaveControlsEnabled(boolean enabled) {
        this.jButtonSave.setEnabled(enabled);
        this.jPopupSave.setEnabled(enabled);
    }

    private void setCutControlsEnabled(boolean enabled) {
        this.jMenuItemEditCut.setEnabled(enabled);
        this.jButtonCut.setEnabled(enabled);
        this.jPopupCut.setEnabled(enabled);
    }

    private void setCopyControlsEnabled(boolean enabled) {
        this.jMenuItemEditCopy.setEnabled(enabled);
        this.jButtonCopy.setEnabled(enabled);
        this.jPopupCopy.setEnabled(enabled);
    }

    private void setPasteControlsEnabled(boolean enabled) {
        this.jMenuItemEditPaste.setEnabled(enabled);
        this.jButtonPaste.setEnabled(enabled);
        this.jPopupPaste.setEnabled(enabled);
    }

    private void setDeleteControlsEnabled(boolean enabled) {
        this.jMenuItemEditDelete.setEnabled(enabled);
        this.jButtonDelete.setEnabled(enabled);
        this.jPopupDelete.setEnabled(enabled);
    }

    private void setSelectAllControlsEnabled(boolean enabled) {
        this.jMenuItemEditSelectAll.setEnabled(enabled);
        this.jPopupSelectAll.setEnabled(enabled);
    }

    private void setPrintControlsEnabled(boolean enabled) {
        this.jButtonPrint.setEnabled(enabled);
        this.jPopupPrint.setEnabled(enabled);
    }

    private void handleCaretUpdateEvent(CaretEvent event) {
        if (event.getSource() == this.currentTextComponent) {
            boolean enabled = event.getDot() != event.getMark();
            this.setCopyControlsEnabled(enabled);
            this.setCutControlsEnabled(enabled &= this.currentTextComponent.isEditable());
            this.setDeleteControlsEnabled(enabled);
        }
    }

    private void handleMoveToTextComponent() {
        boolean enabled = this.currentTextComponent.getSelectedText() != null;
        this.setCopyControlsEnabled(enabled);
        if (this.currentTextComponent.isEditable()) {
            this.setOpenControlsEnabled(true);
            this.setCutControlsEnabled(enabled);
            this.setDeleteControlsEnabled(enabled);
        } else {
            this.setPasteControlsEnabled(false);
            this.setOpenControlsEnabled(false);
            this.setCutControlsEnabled(false);
            this.setDeleteControlsEnabled(false);
        }
        enabled = this.currentTextComponent.getText().length() > 0;
        this.setSaveControlsEnabled(enabled);
        this.setSelectAllControlsEnabled(enabled);
        this.setPrintControlsEnabled(enabled);
        Enumeration<AbstractButton> buttons = this.buttonGroupSequences.getElements();
        AbstractButton button = null;
        while (buttons.hasMoreElements()) {
            button = buttons.nextElement();
            if (button.isSelected()) {
                button.setForeground(Color.blue);
                continue;
            }
            button.setForeground(Color.black);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void align() {
        this.jTextAreaAlignment.setText("");
        String matrixId = (String)this.jComboBoxScoringMatrix.getSelectedItem();
        float open = ((Number)this.jFormattedTextFieldGapOpen.getValue()).floatValue();
        float extend = ((Number)this.jFormattedTextFieldGapExtend.getValue()).floatValue();
        Sequence sequence1 = null;
        try {
            logger.info("Processing sequence #1...");
            sequence1 = SequenceParser.parse(this.jTextAreaSequence1.getText());
            logger.info("Finished processing sequence #1");
        }
        catch (Exception e) {
            String message = "Failed parsing sequence #1: " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            this.showErrorMessage(message);
            this.jTextAreaSequence1.requestFocus();
            return;
        }
        Sequence sequence2 = null;
        try {
            logger.info("Processing sequence #2...");
            sequence2 = SequenceParser.parse(this.jTextAreaSequence2.getText());
            logger.info("Finished processing sequence #2");
        }
        catch (Exception e) {
            String message = "Failed parsing sequence #2: " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            this.showErrorMessage(message);
            this.jTextAreaSequence2.requestFocus();
            return;
        }
        logger.info("Aliging...");
        try {
            this.setCursor(new Cursor(3));
            long start = System.currentTimeMillis();
            Matrix matrix = null;
            if (!this.matrices.containsKey(matrixId)) {
                matrix = MatrixLoader.load(matrixId);
                this.matrices.put(matrixId, matrix);
            } else {
                matrix = this.matrices.get(matrixId);
            }
            Alignment alignment = SmithWatermanGotoh.align(sequence1, sequence2, matrix, open, extend);
            long end = System.currentTimeMillis();
            logger.info("Finished aligning in " + (end - start) + " milliseconds");
            StringBuffer buffer = new StringBuffer();
            buffer.append(alignment.getSummary());
            buffer.append(Commons.getLineSeparator());
            String formatId = (String)this.jComboBoxOutputFormat.getSelectedItem();
            String formattedAlignment = FormatFactory.getInstance().getFormat(formatId).format(alignment);
            buffer.append(formattedAlignment);
            this.jTextAreaAlignment.setText("");
            this.jTextAreaAlignment.append(buffer.toString());
            this.jTextAreaAlignment.setCaretPosition(0);
        }
        catch (Error error) {
            String message = "Failed aligning: " + error.getMessage();
            logger.log(Level.SEVERE, message, error);
            this.showErrorMessage(message);
        }
        catch (Exception exception) {
            String message = "Failed aligning: " + exception.getMessage();
            logger.log(Level.SEVERE, message, exception);
            this.showErrorMessage(message);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    public static void main(String[] args) {
        logger.info(Commons.getJAlignerInfo());
        new AlignWindow().setVisible(true);
    }
}

