/*
 * Decompiled with CFR 0.152.
 */
package jaligner.test;

import jaligner.Alignment;
import jaligner.NeedlemanWunsch;
import jaligner.Sequence;
import jaligner.formats.Format;
import jaligner.formats.Pair;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixLoader;
import jaligner.test.RandomSequenceGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class NeedlemanWunschTester {
    public static void main(String[] args) {
        int numberOfTests = Integer.parseInt(args[0]);
        int sequencesSize = Integer.parseInt(args[1]);
        Random random = new Random();
        Pair format = new Pair();
        try {
            ArrayList<String> matrices = new ArrayList<String>();
            Iterator<String> i = MatrixLoader.list().iterator();
            while (i.hasNext()) {
                matrices.add(i.next());
            }
            int countOfMatrices = matrices.size();
            for (int i2 = 1; i2 <= numberOfTests; ++i2) {
                System.gc();
                String s1 = RandomSequenceGenerator.generate(sequencesSize);
                String s2 = RandomSequenceGenerator.generate(sequencesSize);
                float gap = random.nextInt(1000);
                if (s1.length() > 0 && s2.length() > 0) {
                    Sequence seq1 = new Sequence(s1);
                    Sequence seq2 = new Sequence(s2);
                    Matrix matrix = MatrixLoader.load((String)matrices.get(random.nextInt(countOfMatrices)));
                    Alignment alignment1 = NeedlemanWunsch.align(seq1, seq2, matrix, gap);
                    if (!alignment1.checkScore()) {
                        System.out.println("Invalid alignment found:");
                        System.out.println("Sequence 1 = " + s1);
                        System.out.println("Sequence 2 = " + s2);
                        System.out.println(((Format)format).format(alignment1));
                        System.out.println(alignment1.getSummary());
                        System.out.println("The score of the alignment above is: " + alignment1.calculateScore());
                        System.exit(1);
                    }
                    Alignment alignment2 = NeedlemanWunsch.align(seq2, seq1, matrix, gap);
                    if (!alignment1.checkScore()) {
                        System.out.println("Invalid alignment found:");
                        System.out.println("Sequence 1 = " + s2);
                        System.out.println("Sequence 2 = " + s1);
                        System.out.println(((Format)format).format(alignment2));
                        System.out.println(alignment2.getSummary());
                        System.out.println("The score of the alignment above is: " + alignment2.calculateScore());
                        System.exit(1);
                    }
                    if (alignment1.getScore() != alignment2.getScore()) {
                        System.out.println("Not symmetric alignment:");
                        System.out.println("Alignment #1: ");
                        System.out.println("Sequence 1 = " + s1);
                        System.out.println("Sequence 2 = " + s2);
                        System.out.println(((Format)format).format(alignment1));
                        System.out.println(alignment1.getSummary());
                        System.out.println();
                        System.out.println("Alignment #2: ");
                        System.out.println("Sequence 1 = " + s2);
                        System.out.println("Sequence 2 = " + s1);
                        System.out.println(((Format)format).format(alignment2));
                        System.out.println(alignment2.getSummary());
                        System.exit(1);
                    }
                }
                System.out.println("Processed " + i2 + "/" + numberOfTests);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

