/*
 * Decompiled with CFR 0.152.
 */
package jaligner.formats;

import jaligner.Alignment;
import jaligner.formats.Format;

public class CLUSTAL
extends Format {
    private static final int NAME_WIDTH = 36;
    private static final int SEQUENCE_WIDTH = 50;
    private static final String HEADER = "CLUSTAL_FORMAT W(1.60) multiple sequence alignment\n\n";

    public CLUSTAL() {
        this.setId("CLUSTAL");
    }

    public String format(String[] names, String[] sequences) {
        int i;
        StringBuffer buffer = new StringBuffer(HEADER);
        int maxSequenceLength = 0;
        for (i = 0; i < sequences.length; ++i) {
            if (sequences[i].length() <= maxSequenceLength) continue;
            maxSequenceLength = sequences[i].length();
        }
        i = 0;
        while (i * 50 < maxSequenceLength) {
            for (int j = 0; j < sequences.length; ++j) {
                buffer.append(36 <= names[j].length() ? names[j].substring(0, 35) : names[j]);
                for (int k = names[j].length(); k < 36; ++k) {
                    buffer.append(" ");
                }
                if (names[j].length() >= 36) {
                    buffer.append(" ");
                }
                buffer.append(sequences[j].substring(i * 50, (i + 1) * 50 < sequences[j].length() ? (i + 1) * 50 : sequences[j].length()));
                if (j >= sequences.length) continue;
                buffer.append("\n");
            }
            if ((i + 1) * 50 < maxSequenceLength) {
                buffer.append("\n\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public String format(Alignment alignment) {
        String[] sequences = new String[]{new String(alignment.getSequence1()), new String(alignment.getSequence2())};
        String[] names = new String[]{alignment.getName1(), alignment.getName2()};
        return this.format(names, sequences);
    }
}

