/*
 * Decompiled with CFR 0.152.
 */
package jaligner.example;

import jaligner.Alignment;
import jaligner.NeedlemanWunschGotoh;
import jaligner.Sequence;
import jaligner.formats.Pair;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixGenerator;
import jaligner.util.SequenceParser;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NeedlemanWunschGotohExample {
    private static final Logger logger = Logger.getLogger(NeedlemanWunschGotohExample.class.getName());

    public static void main(String[] args) {
        try {
            logger.info("Running example...");
            Sequence s1 = SequenceParser.parse("GAATTCAGTTA");
            Sequence s2 = SequenceParser.parse("GGATCGA");
            float match = 2.0f;
            float mismatch = -1.0f;
            Matrix matrix = MatrixGenerator.generate(match, mismatch);
            float open = 2.0f;
            float extend = 2.0f;
            Alignment alignment = NeedlemanWunschGotoh.align(s1, s2, matrix, open, extend);
            System.out.println(alignment.getSummary());
            System.out.println(new Pair().format(alignment));
            logger.info("Finished running example");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed running example: " + e.getMessage(), e);
        }
    }
}

