/*
 * Decompiled with CFR 0.152.
 */
package jaligner;

import jaligner.Alignment;
import jaligner.Cell;
import jaligner.Sequence;
import jaligner.matrix.Matrix;
import java.util.logging.Logger;

public final class NeedlemanWunschGotoh {
    private static final Logger logger = Logger.getLogger(NeedlemanWunschGotoh.class.getSimpleName());

    private NeedlemanWunschGotoh() {
    }

    public static Alignment align(Sequence s1, Sequence s2, Matrix matrix, float o, float e) {
        Sequence _s2;
        Sequence _s1;
        float[][] scores = matrix.getScores();
        if (s1.length() < s2.length()) {
            _s1 = s2;
            _s2 = s1;
        } else {
            _s1 = s1;
            _s2 = s2;
        }
        int m = _s1.length() + 1;
        int n = _s2.length() + 1;
        byte[] pointers = new byte[m * n];
        short[] lengths = new short[m * n];
        pointers[0] = 0;
        int i = 1;
        int k = n;
        while (i < m) {
            pointers[k] = 3;
            lengths[k] = (short)i;
            ++i;
            k += n;
        }
        for (int j = 1; j < n; ++j) {
            pointers[j] = 1;
            lengths[j] = (short)j;
        }
        Cell cell = NeedlemanWunschGotoh.construct(_s1, _s2, scores, o, e, pointers, lengths);
        Alignment alignment = NeedlemanWunschGotoh.traceback(_s1, _s2, matrix, pointers, cell, lengths);
        alignment.setMatrix(matrix);
        alignment.setOpen(o);
        alignment.setExtend(e);
        alignment.setName1(_s1.getId());
        alignment.setName2(_s2.getId());
        alignment.setOriginalSequence1(_s1);
        alignment.setOriginalSequence2(_s2);
        return alignment;
    }

    private static Cell construct(Sequence s1, Sequence s2, float[][] matrix, float o, float e, byte[] pointers, short[] lengths) {
        logger.info("Started...");
        char[] a1 = s1.toArray();
        char[] a2 = s2.toArray();
        int m = s1.length() + 1;
        int n = s2.length() + 1;
        float[] v = new float[n];
        float vDiagonal = 0.0f;
        float f = Float.NEGATIVE_INFINITY;
        float h = Float.NEGATIVE_INFINITY;
        float[] g = new float[n];
        g[0] = Float.NEGATIVE_INFINITY;
        for (int j = 1; j < n; ++j) {
            v[j] = 0.0f;
            g[j] = Float.NEGATIVE_INFINITY;
        }
        int lengthOfHorizontalGap = 0;
        int[] lengthOfVerticalGap = new int[n];
        float maximumScore = Float.NEGATIVE_INFINITY;
        int maxi = 0;
        int maxj = 0;
        int i = 1;
        int k = n;
        while (i < m) {
            v[0] = -o - (float)(i - 1) * e;
            int j = 1;
            int l = k + 1;
            while (j < n) {
                float similarityScore = matrix[a1[i - 1]][a2[j - 1]];
                f = vDiagonal + similarityScore;
                if (h - e >= v[j - 1] - o) {
                    h -= e;
                    ++lengthOfHorizontalGap;
                } else {
                    h = v[j - 1] - o;
                    lengthOfHorizontalGap = 1;
                }
                if (g[j] - e >= v[j] - o) {
                    g[j] = g[j] - e;
                    lengthOfVerticalGap[j] = lengthOfVerticalGap[j] + 1;
                } else {
                    g[j] = v[j] - o;
                    lengthOfVerticalGap[j] = 1;
                }
                vDiagonal = v[j];
                v[j] = NeedlemanWunschGotoh.maximum(f, g[j], h);
                if (v[j] > maximumScore) {
                    maximumScore = v[j];
                    maxi = i;
                    maxj = j;
                }
                if (v[j] == f) {
                    pointers[l] = 2;
                } else if (v[j] == g[j]) {
                    pointers[l] = 3;
                    lengths[l] = (short)lengthOfVerticalGap[j];
                } else if (v[j] == h) {
                    pointers[l] = 1;
                    lengths[l] = (short)lengthOfHorizontalGap;
                }
                ++j;
                ++l;
            }
            h = Float.NEGATIVE_INFINITY;
            vDiagonal = 0.0f;
            lengthOfHorizontalGap = 0;
            ++i;
            k += n;
        }
        Cell cell = new Cell();
        cell.set(maxi, maxj, v[n - 1]);
        logger.info("Finished.");
        return cell;
    }

    private static Alignment traceback(Sequence s1, Sequence s2, Matrix m, byte[] pointers, Cell cell, short[] lengths) {
        char c2;
        char c1;
        logger.info("Started...");
        char[] array1 = s1.toArray();
        char[] array2 = s2.toArray();
        float[][] scores = m.getScores();
        Alignment alignment = new Alignment();
        alignment.setScore(cell.getScore());
        int maxlen = s1.length() + s2.length();
        char[] reversed1 = new char[maxlen];
        char[] reversed2 = new char[maxlen];
        char[] reversed3 = new char[maxlen];
        int len1 = 0;
        int len2 = 0;
        int len3 = 0;
        int identity = 0;
        int similarity = 0;
        int gaps = 0;
        int i = cell.getRow();
        int j = cell.getCol();
        int n = s2.length() + 1;
        int row = i * n;
        int a = s1.length() - 1;
        int b = s2.length() - 1;
        if (a - i > b - j) {
            while (a - i > b - j) {
                reversed1[len1++] = array1[a];
                reversed2[len2++] = 45;
                reversed3[len3++] = 32;
                ++gaps;
                --a;
            }
            while (b > j - 1) {
                c1 = array1[a];
                c2 = array2[b];
                reversed1[len1++] = c1;
                reversed2[len2++] = c2;
                if (c1 == c2) {
                    reversed3[len3++] = 124;
                    ++identity;
                    ++similarity;
                } else if (scores[c1][c2] > 0.0f) {
                    reversed3[len3++] = 58;
                    ++similarity;
                } else {
                    reversed3[len3++] = 46;
                }
                --a;
                --b;
            }
        } else {
            while (b - j > a - i) {
                reversed1[len1++] = 45;
                reversed2[len2++] = array2[b];
                reversed3[len3++] = 32;
                ++gaps;
                --b;
            }
            while (a > i - 1) {
                c1 = array1[a];
                c2 = array2[b];
                reversed1[len1++] = c1;
                reversed2[len2++] = c2;
                if (c1 == c2) {
                    reversed3[len3++] = 124;
                    ++identity;
                    ++similarity;
                } else if (scores[c1][c2] > 0.0f) {
                    reversed3[len3++] = 58;
                    ++similarity;
                } else {
                    reversed3[len3++] = 46;
                }
                --a;
                --b;
            }
        }
        boolean stillGoing = true;
        block10: while (stillGoing) {
            int l = row + j;
            switch (pointers[l]) {
                case 3: {
                    int k;
                    int len = lengths[l];
                    for (k = 0; k < len; ++k) {
                        reversed1[len1++] = array1[--i];
                        reversed2[len2++] = 45;
                        reversed3[len3++] = 32;
                        row -= n;
                        ++gaps;
                    }
                    continue block10;
                }
                case 2: {
                    c1 = array1[--i];
                    c2 = array2[--j];
                    reversed1[len1++] = c1;
                    reversed2[len2++] = c2;
                    row -= n;
                    if (c1 == c2) {
                        reversed3[len3++] = 124;
                        ++identity;
                        ++similarity;
                        break;
                    }
                    if (scores[c1][c2] > 0.0f) {
                        reversed3[len3++] = 58;
                        ++similarity;
                        break;
                    }
                    reversed3[len3++] = 46;
                    break;
                }
                case 1: {
                    int k;
                    int len = lengths[l];
                    for (k = 0; k < len; ++k) {
                        reversed1[len1++] = 45;
                        reversed2[len2++] = array2[--j];
                        reversed3[len3++] = 32;
                        ++gaps;
                    }
                    continue block10;
                }
                case 0: {
                    stillGoing = false;
                }
            }
        }
        alignment.setSequence1(NeedlemanWunschGotoh.reverse(reversed1, len1));
        alignment.setStart1(i);
        alignment.setSequence2(NeedlemanWunschGotoh.reverse(reversed2, len2));
        alignment.setStart2(j);
        alignment.setMarkupLine(NeedlemanWunschGotoh.reverse(reversed3, len3));
        alignment.setIdentity(identity);
        alignment.setGaps(gaps);
        alignment.setSimilarity(similarity);
        logger.info("Finished.");
        return alignment;
    }

    private static float maximum(float a, float b, float c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    private static char[] reverse(char[] a, int len) {
        char[] b = new char[len];
        int i = len - 1;
        int j = 0;
        while (i >= 0) {
            b[j] = a[i];
            --i;
            ++j;
        }
        return b;
    }
}

