/*
 * Decompiled with CFR 0.152.
 */
package jaligner;

import jaligner.Alignment;
import jaligner.Cell;
import jaligner.Sequence;
import jaligner.matrix.Matrix;

public final class NeedlemanWunsch {
    private NeedlemanWunsch() {
    }

    public static Alignment align(Sequence s1, Sequence s2, Matrix matrix, float gap) {
        float[][] scores = matrix.getScores();
        int m = s1.length() + 1;
        int n = s2.length() + 1;
        byte[][] pointers = new byte[m][n];
        pointers[0][0] = 0;
        for (int i = 1; i < m; ++i) {
            pointers[i][0] = 3;
        }
        for (int j = 1; j < n; ++j) {
            pointers[0][j] = 1;
        }
        Cell cell = NeedlemanWunsch.construct(s1, s2, scores, gap, pointers);
        Alignment alignment = NeedlemanWunsch.traceback(s1, s2, matrix, pointers, cell);
        alignment.setOriginalSequence1(s1);
        alignment.setOriginalSequence2(s2);
        alignment.setMatrix(matrix);
        alignment.setOpen(gap);
        alignment.setExtend(gap);
        if (s1.getId() != null) {
            alignment.setName1(s1.getId());
        }
        if (s2.getId() != null) {
            alignment.setName2(s2.getId());
        }
        return alignment;
    }

    private static Cell construct(Sequence s1, Sequence s2, float[][] matrix, float gap, byte[][] pointers) {
        Cell cell = new Cell();
        char[] a1 = s1.toArray();
        char[] a2 = s2.toArray();
        int m = s1.length() + 1;
        int n = s2.length() + 1;
        float[] v = new float[n];
        for (int j = 1; j < n; ++j) {
            v[j] = (float)j * -gap;
        }
        v[0] = 0.0f;
        float vOld = 0.0f;
        for (int i = 1; i < m; ++i) {
            v[0] = (float)i * -gap;
            for (int j = 1; j < n; ++j) {
                float x = v[j] - gap;
                float y = v[j - 1] - gap;
                float z = vOld + matrix[a1[i - 1]][a2[j - 1]];
                vOld = v[j];
                v[j] = NeedlemanWunsch.maximum(x, y, z);
                pointers[i][j] = v[j] == x ? 3 : (v[j] == y ? 1 : 2);
            }
            vOld = (float)i * -gap;
        }
        cell.set(m - 1, n - 1, v[n - 1]);
        return cell;
    }

    private static Alignment traceback(Sequence s1, Sequence s2, Matrix m, byte[][] pointers, Cell cell) {
        char[] array1 = s1.toArray();
        char[] array2 = s2.toArray();
        float[][] scores = m.getScores();
        Alignment alignment = new Alignment();
        alignment.setScore(cell.getScore());
        int maxlen = s1.length() + s2.length();
        char[] reversed1 = new char[maxlen];
        char[] reversed2 = new char[maxlen];
        char[] reversed3 = new char[maxlen];
        int len1 = 0;
        int len2 = 0;
        int len3 = 0;
        int identity = 0;
        int similarity = 0;
        int gaps = 0;
        int i = cell.getRow();
        int j = cell.getCol();
        boolean stillGoing = true;
        while (stillGoing) {
            switch (pointers[i][j]) {
                case 3: {
                    reversed1[len1++] = array1[--i];
                    reversed2[len2++] = 45;
                    reversed3[len3++] = 32;
                    ++gaps;
                    break;
                }
                case 2: {
                    char c1 = array1[--i];
                    char c2 = array2[--j];
                    reversed1[len1++] = c1;
                    reversed2[len2++] = c2;
                    if (c1 == c2) {
                        reversed3[len3++] = 124;
                        ++identity;
                        ++similarity;
                        break;
                    }
                    if (scores[c1][c2] > 0.0f) {
                        reversed3[len3++] = 58;
                        ++similarity;
                        break;
                    }
                    reversed3[len3++] = 46;
                    break;
                }
                case 1: {
                    reversed1[len1++] = 45;
                    reversed2[len2++] = array2[--j];
                    reversed3[len3++] = 32;
                    ++gaps;
                    break;
                }
                case 0: {
                    stillGoing = false;
                }
            }
        }
        alignment.setSequence1(NeedlemanWunsch.reverse(reversed1, len1));
        alignment.setStart1(i);
        alignment.setSequence2(NeedlemanWunsch.reverse(reversed2, len2));
        alignment.setStart2(j);
        alignment.setMarkupLine(NeedlemanWunsch.reverse(reversed3, len3));
        alignment.setIdentity(identity);
        alignment.setGaps(gaps);
        alignment.setSimilarity(similarity);
        return alignment;
    }

    private static float maximum(float a, float b, float c) {
        if (a > b) {
            return a > c ? a : c;
        }
        return b > c ? b : c;
    }

    private static char[] reverse(char[] a, int len) {
        char[] b = new char[len];
        int i = len - 1;
        int j = 0;
        while (i >= 0) {
            b[j] = a[i];
            --i;
            ++j;
        }
        return b;
    }
}

