/*
 * Decompiled with CFR 0.152.
 */
package ssw;

import ssw.Aligner;
import ssw.Alignment;

public class Example {
    public static void main(String[] stringArray) {
        try {
            System.loadLibrary("sswjni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(String.format("Cannot find libsswjni.so. Has the library been built and LD_LIBRARY_PATH or -Djava.library.path set appropriately?\n%s", unsatisfiedLinkError));
            throw unsatisfiedLinkError;
        }
        int[][] nArray = new int[128][128];
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                nArray[i][j] = i == j ? 2 : -2;
            }
        }
        System.out.println("Aligning nucleotides");
        Alignment alignment = Aligner.align("NNNNCTGAGCCGGTAAATC".getBytes(), "CAGCCTTTCTGACCCGGAAATCAAAATAGGCACAACAAA".getBytes(), nArray, 3, 1, true);
        if (alignment == null) {
            throw new RuntimeException();
        }
        System.out.print(String.format("score1=%d ", alignment.score1));
        System.out.print(String.format("score2=%d ", alignment.score2));
        System.out.print(String.format("ref_begin1=%d ", alignment.ref_begin1));
        System.out.print(String.format("ref_end1=%d ", alignment.ref_end1));
        System.out.print(String.format("read_begin1=%d ", alignment.read_begin1));
        System.out.print(String.format("read_end1=%d ", alignment.read_end1));
        System.out.print(String.format("ref_end2=%d ", alignment.ref_end2));
        System.out.print(String.format("cigar=%s ", alignment.cigar));
        System.out.println();
    }
}

