% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vstran.R
\name{vstran}
\alias{vstran}
\title{Variance stablization transformation}
\usage{
vstran(d)
}
\arguments{
\item{d}{a matrix or data.frame that has two columns, each column is 
the Hi-C read counts data in a replicate.}
}
\value{
a matrix of two columns, each represents a transformed read 
counts of a replicate.
}
\description{
The function finds the rank of the data and rescale the ranks in the 
range of (0, 1).
}
\details{
In Hi-C data, the read counts for contacts with short interaction
distances have a much larger dynamic range than those with long interaction
distances. To mitigate this difference, we rank the contact counts in each
stratum separately, and then normalize the ranks by the total number of 
observations in each stratum, such that all strata share a similar dynamic 
range.
}
\examples{
data(HiCR1)
data(HiCR2)

#exact contact counts within 1Mb interaction distance
d1 <- d2 <- NULL
for (i in 1:nrow(HiCR1)){
d1 = c(d1, HiCR1[i, i+1])
d2 = c(d2, HiCR2[i, i+1])
 d = cbind(d1, d2)
}

HiC_R1_vs <- vstran(d)
head(HiC_R1_vs)
}
