% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSTF.R
\name{plotSTF}
\alias{plotSTF}
\title{Generating distance decay curves of correlations}
\usage{
plotSTF(mat1, mat2, resol, lbr = 0, ubr = 5e+06)
}
\arguments{
\item{mat1}{Replicate 1 - a n*n intrachromesome Hi-C contact map.}

\item{mat2}{Replicate 2 - a n*n intrachromesome Hi-C contact map.}

\item{resol}{An integer indicating the resolution of the Hi-C matrix.}

\item{lbr}{An integer indicating the minumum distance of interaction
that is considered. Default is 0.}

\item{ubr}{An integer indicating the maximum distance of interaction 
that is considered. Defalt is 5000000.}
}
\value{
A graph of correlation vesus distance.
}
\description{
Generating distance decay curves of correlations
}
\examples{
data(HiCR1)
data(HiCR2)
plotSTF(HiCR1, HiCR2, 1000000, 1000000, 5000000)
}
\references{
HiCRep: assessing the reproducibility of Hi-C data using 
a stratum-adjusted correlation coefficient. Tao Yang, Feipeng Zhang, 
Galip Gurkan Yardimci, Ross C Hardison, William Stafford Noble, Feng
Yue, Qunhua Li. bioRxiv 101386; doi: https://doi.org/10.1101/101386.
}
