% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.adj.R
\name{depth.adj}
\alias{depth.adj}
\title{Sequencing depth adjustment}
\usage{
depth.adj(d, size)
}
\arguments{
\item{d}{a N*N Hi-C matrix needed to be adjusted.}

\item{size}{the size the total number one wants to adjust to.}
}
\value{
a matrix which has the adjusted total number of reads.
}
\description{
Sequencing depth could be a confounding effect when measuring the 
reproducibility. This function will adjust sequencing depth of a 
given matrix to a specified total number of reads through random
sampling.
}
\examples{
data(HiCR1)
#total number of reads
sum(HiCR1)

#Adjust it to 200000 reads, output Hi-C matrix
HiC_R1_200k = depth.adj(HiCR1, 200000)
#check total number of reads after adjustment
sum(HiC_R1_200k)
}
\references{
HiCRep: assessing the reproducibility of Hi-C data using 
a stratum-adjusted correlation coefficient. Tao Yang, Feipeng Zhang, 
Galip Gurkan Yardimci, Ross C Hardison, William Stafford Noble, Feng
Yue, Qunhua Li. bioRxiv 101386; doi: https://doi.org/10.1101/101386.
}
