#' converting cooler format to Hi-C matrices
#'
#' @param file the cooler file to be converted. Default is "chr1".
#' @param chr specifiy which chr to be compared.
#' @return a hiC matrix that can be recongnized by get.scc.
#' @references HiCRep: assessing the reproducibility of Hi-C data using a 
#' stratum-adjusted correlation coefficient. Tao Yang, Feipeng Zhang, Galip
#' Gurkan Yardimci, Ross C Hardison, William Stafford Noble, Feng Yue, Qunhua 
#' Li. bioRxiv 101386; doi: https://doi.org/10.1101/101386.
#' @export
#' @examples


cool2matrix <- function(file, chr = 'chr1') {
    pixels <- h5read(file, c('pixels'));H5close()
    bins <- h5read(file, c('bins'));H5close()
    chrom.offset <- h5read(file, 'indexes/chrom_offset');H5close()
    chrom.index <- chr2index(chr)
    chrom.range <- chrom.offset[chrom.index:(chrom.index+1)] + c(0, -1) 
    n.rows <- chrom.range[2] - chrom.range[1] + 1 
    bin.range <- which(pixels$bin1_id >= chrom.range[1] & pixels$bin1_id <= chrom.range[2] & pixels$bin2_id >= chrom.range[1] & pixels$bin2_id <= chrom.range[2])
    n.bins <- length(bin.range) 
    mat <- matrix(0, n.rows, n.rows)
    for (i in 1:n.bins) {
        mat[pixels$bin1_id[bin.range[i]] - chrom.range[1] + 1, pixels$bin2_id[bin.range[i]] - chrom.range[1] + 1] <- pixels$count[bin.range[i]]
        mat[pixels$bin2_id[bin.range[i]] - chrom.range[1] + 1, pixels$bin1_id[bin.range[i]] - chrom.range[1] + 1] <- pixels$count[bin.range[i]]
    }
    chrom.ranges <- (chrom.range[1]+1):(chrom.range[2]+1)
    #coords <- data.frame(V1 = as.character(bins$chrom[chrom.ranges]), V2 = bins$start[chrom.ranges], V3 = bins$end[chrom.ranges])
    mat <- as.data.frame(mat)
    #colnames(mat) <- paste0('V', 4:(3+n.rows))
    return(mat)
}
