#' converting cooler format to Hi-C matrices
#'
#' @param chr specifiy which chr to be compared
#' @return chromosome index
#' @references HiCRep: assessing the reproducibility of Hi-C data using a 
#' stratum-adjusted correlation coefficient. Tao Yang, Feipeng Zhang, Galip
#' Gurkan Yardimci, Ross C Hardison, William Stafford Noble, Feng Yue, Qunhua 
#' Li. bioRxiv 101386; doi: https://doi.org/10.1101/101386.
#' @export
#' @examples
#' chr2index("chr22")


chr2index <- function(chr) {
    if (substr(chr, 1, 3) == 'chr') {
        chr = substr(chr, 4, nchar(chr))
    }
    if (chr == 'X') {
        index = 23
    }
    else if (chr == 'Y') {
        index = 24
    }
    else if (chr == 'M') {
        index = 25
    }
    else {
        index = as.integer(chr)
    }
    return(index)
}